#!/usr/local/bin/perl
#
#
# miffmixr v 1  (miffmixrq.cgi)
#
# part of the web based miffmixr product
# free for noncommercial use
#
# miff@9mm.com
#
# werd.
#
# miffmixrq.cgi:
# this baby produces the web page that forms the jukebox!
# accepts vars:  (currpage) which tell which page to start with!
# we'll start by showing 6 items per page (3 + 3)
#
# all we do here is display the playlist and 6 pages of songs
#
# the user can select songs to add to playlist. (links)
#
# 12/25/99 decided that this file should also do interpret!!
#
# 01/13/00 adding gfx and search fxn.  also buttons on top 
#  *and* bottom
# more adds:
#  -wrap last page to first
#  -goto random??
#  the above done 1/15/00 - a little at a time :)
#  -basic search also done 

use CGI;

my $masterfile = "/usr/local/miffmixr/conf/masterfile";
my $playlist = "/usr/local/miffmixr/playlist/list.txt";
my $nowplaying = "/usr/local/miffmixr/playlist/nowplaying";

#critical!!  make sure that the gfxurl points to where your
#  graphics can be found!!
my $GFXURL = "http://funhouse.9mm.com/miffgfx/";
my $back = $GFXURL . "back.jpg";
my $bg = $GFXURL . "bg.jpg";
my $forward = $GFXURL . "forward.jpg";
my $logo = $GFXURL . "logo.jpg";

#in order to do fancy things like wrapping and random, we need to 
# know what the max page number is.  therefore:
open MASTERFILE, $masterfile;
my $maxpage;  # will hold the top page number
my $tmprow;  #holds the row
my $dummy;  #nothing
while ($tmprow = <MASTERFILE>) {
	chomp $tmprow;
	($maxpage,$dummy,$dummy) = split /:/, $tmprow;
}


print "Content-type: text/html";
print "\n\n  \n\n "; 

my $query = new CGI;

#first, did we get a starting position?
my $current = $query->param('CURRENT'); #hidden val: cur page!
#my $current = $ENV{'CURRENT'};
$current = 1 unless $current;
my $prev = $query->param('PREV.x');
my $next = $query->param('NEXT.x');
my $random = $query->param('RANDOM');
my $search = $query->param('SEARCH');
my $searchme = $query->param('SEARCHME');
my $play = $query->param('PLAY');
my $page = $query->param('PAGE');
my $song = $query->param('SONG'); 

my @sresults;

#check the fwd/back motion:
if ($prev) {
	$current -= 6;
	if ($current < -4) {
		$current = $maxpage + $current;
	} elsif ($current < 1) {
		$current = 1;
	}
} elsif ($next) {
	$current += 6;
	if ($current > $maxpage) {
		#$current = $current - $maxpage;
		$current = 1;
	}
} elsif ($random) {
	# make current something random between 1 and max:
	srand(time ^ $$);
	$current = int(rand($maxpage));
} elsif ($search) {
	# YIKES!!  they did a search!!
	# we need to do a caseless grep of searchme to the conf list
	# if i wanted to be wicked i'd break it apart by spaces first
	# and do mutliple searches - but i dont.  simple will do.
	
	# NOTE!  security risk here!!  minimally we must shed the pipe
	$searchme =~ qr/\Q$searchme\E/;  #escape all special chars
	#now grep for it:
	my $val;
	open GREPPER, "grep -i $searchme $masterfile|";
	foreach $val (<GREPPER>) {
		chomp $val;
		push @sresults, $val;
	}        	
	close GREPPER;
} elsif ($play) {
	# now we got trouble - need to add to playlist!
	unless ($page && $song) {
		print "<h2> pick a song and page, silly</h2>\n";
	}
	#find page and song and add to playlist:
	open MASTERFILE, $masterfile;
	my $song2add;
	while ($input = <MASTERFILE>) {
		chomp $input;
		my ($a,$b,$c) = split /:/, $input;	
		if ($a == $page && $b eq "PAGE") {
			#get the dir!
			#$song2add = $c;
		}
		if ($a == $page && $b == $song) {
			#this is it
			#$song2add .= "/" . $c;
			$song2add = $c;
		}
	} #end of while
	close MASTERFILE;
	##IF SONG2ADD HAS QUOTEs, REPLACE THEM!!
	if ($song2add) {
		system ("echo \"$song2add\" >> $playlist");
	}
}

#now, given the master file, grab 6 pages (page -> page +5)A
# make a nice table out of it with links and then
# show the current playlist.  miffmixrq.cgi will interp.

print <<END;
<html>
<title> miffmixr web jukebox </title>
<BODY
BGCOLOR="white"
TEXT="darkblue"
VLINK="purple"
LINK="green"
ALINK="darkred"
background="$bg"
>
<center>
<br>
<img src="$logo">
<form action="miffmixrq.cgi" METHOD="POST">
<hr><br> 
<INPUT TYPE=image src="$back" border=0 name=PREV value="PREV">
&nbsp;&nbsp;&nbsp;&nbsp;
<INPUT TYPE=image src="$forward" border=0 name=NEXT value="NEXT">  
<br>
END

print "<INPUT TYPE=hidden NAME=CURRENT VALUE=$current> \n";

# HERES WHERE WE PUT IN THE SEARCH RESULTS IF THEY EXIST!
if ($search) {
	print "<table width=50% border=1 bgcolor=\"lightgreen\"><tr valign=top><td>\n";
	print "<b>SEARCH RESULTS:</b> \n";
	print "</td></tr><tr><td> \n";
	foreach $dummy (@sresults) {
		# page thru results:
		print "<br> \n";
		my ($a,$b,$c) = split /:/, $dummy;	
		my @shedpath = split /\//, $c;
		$c = $shedpath[$#shedpath];
		# trim out underscores from label:
		$c =~ s/_/ /g;
		# now take the mp3 off the end :)
		$c =~ s/.mp3//g;
		if ($b eq "PAGE") {
			#link to the page
			my $link = "miffmixrq.cgi?CURRENT=$a";
			print "PAGE $a: <a href=\"$link\">$c</a> \n";
		} else {
			#link to the song like normal:
			my $link = "miffmixrq.cgi?PLAY=1&PAGE=$a&SONG=$b&CURRENT=$current";
			my $plink = "miffmixrq.cgi?CURRENT=$a";
			print "<a href=\"$plink\">$a:$b</a> <a href=\"$link\">$c</a> \n";
		}
	}
	print "</td></tr></table> \n";
	print "<br> \n";
}

#here we must read the masterfile and make a table:
print "<table width=75% border=1 bgcolor=\"lightyellow\"><tr valign=top><td>\n";
print " mp3 jukebox </td><td> by miff";
open MASTERFILE, $masterfile;
my $input;
my $page;
my $pagecount;
my $loop = 1;  #for control;
my $lastdirection = "across";  #across or down (alternate)
while ($input = <MASTERFILE>) {
	chomp $input;
	my ($a,$b,$c) = split /:/, $input;	
	#FIRST see if we need to go down to a current:
	if ($a < $current) {
		next;
	}
	if ($b eq "PAGE") {
		#new page!
		$pagecount++;
		if ($pagecount > 6) {
			#exit this loop:
			$loop = 0;
			last;
		}
		if ($lastdirection eq "across") {
			#go down:
			print "</td></tr><tr valign=top><td>\n";
			$lastdirection = "down";
		} else {
			#go across:
			print "</td><td>\n";
			$lastdirection = "across";
		}
		# DITCH THE PATH FROM C!!
		$page = $a;
		my @shedpath = split /\//, $c;
		$c = $shedpath[$#shedpath];
		print "<b>PAGE: $a, $c </b><br>\n";
	} else {
		#current page:
		my $link = "miffmixrq.cgi?PLAY=1&PAGE=$page&SONG=$b&CURRENT=$current";
		my @shedpath = split /\//, $c;
		$c = $shedpath[$#shedpath];
		#print "$b: $c <br>\n";
		# trim out underscores from label:
		$c =~ s/_/ /g;
		# now take the mp3 off the end :)
		$c =~ s/.mp3//g;
		print "$b: <a href=\"$link\">$c</a> <br>\n";
	}

}
close MASTERFILE;
print "</table>\n";

#now some buttons (back, fwd, play me (#) )
print <<END;
<br>
<INPUT TYPE=image src="$back" border=0 name=PREV>
&nbsp;&nbsp;&nbsp;&nbsp;
<INPUT TYPE=image src="$forward" border=0 name=NEXT>  
<br><br>
<INPUT TYPE=text NAME=SEARCHME SIZE=20 MAXLENGTH=30> 
&nbsp;&nbsp;&nbsp;&nbsp;
<INPUT TYPE=submit name="SEARCH" value="ZEARCH!!">
&nbsp;&nbsp;&nbsp;&nbsp;
<INPUT TYPE=submit name="RANDOM" value="-???-">
END
open PLAYING, $nowplaying;
my $playing;
$playing = <PLAYING>;
my @shedpath = split /\//, $playing;
close PLAYING;
$playing = $shedpath[$#shedpath];
# trim out underscores from label:
$playing =~ s/_/ /g;
# now take the mp3 off the end :)
$playing =~ s/.mp3//g;
#now a little break and then the current playlist:

print "<br><hr><br><center> \n";
print "<table width=45% border=0 bgcolor=\"cyan\"><tr valign=top><td>\n";
print "<b><i>now playing:</i> &nbsp;&nbsp;&nbsp;$playing</b>\n";
print "</td></tr><tr><td> \n";
print "<b><i>current playlist:</i></b>\n";
print "</td></tr><tr><td> \n";
open PLAYLIST, $playlist;
my $song;
while ($song = <PLAYLIST>) {
	my @shedpath = split /\//, $song;
	$song = $shedpath[$#shedpath];
	# trim out underscores from label:
	$song =~ s/_/ /g;
	# now take the mp3 off the end :)
	$song =~ s/.mp3//g;
	print "$song </td></tr><tr><td> \n";
}
close PLAYLIST;
print "</td></tr></table> \n";

#now finish up the printing:
print <<END;
<br><br><br>
<a href="http://9mm.com">9mm / miff munitions</a>
</FORM>
 
</body>
</html>


END


