%{
	include "sys.m";
	sys: Sys;

	include "bufio.m";
	bufio: Bufio;
	Iobuf: import bufio;

	include "draw.m";
%}

#
# %module defines the implementation module for this file
# if y.tab.m is generated, it includes this module definition
# augmented with any defined token values.
#
# the user must define
#	type YYSTYPE
#	yylex: fn(): int
#	yyerror: fn(err: string);
#
# yacc will produce
#	yyparse: fn();
#
# any names beginning with yy or YY are reserved for yacc's use.
#
%module Calc{
	init:	fn(ctxt: ref Draw->Context, args: list of string);

	YYSTYPE: adt { v: real; };
	yylval:	YYSTYPE;
}

%left	'+' '-'
%left	'*' '/'

%type	<v>	exp uexp term
%token	<v>	REAL

%%
top	:
	| top '\n'
	| top exp '\n'
	{
		sys->print("%g\n", $2);
	}
	| top error '\n'
	;

exp	: uexp
	| exp '*' exp	{ $$ = $1 * $3; }
	| exp '/' exp	{ $$ = $1 / $3; }
	| exp '+' exp	{ $$ = $1 + $3; }
	| exp '-' exp	{ $$ = $1 - $3; }
	;

uexp	: term
	| '+' uexp	{ $$ = $2; }
	| '-' uexp	{ $$ = -$2; }
	;

term	: REAL
	| '(' exp ')'
	{
		$$ = $2;
	}
	;

%%

in: ref Iobuf;
stderr: ref Sys->FD;

init(nil: ref Draw->Context, nil: list of string)
{
	sys = load Sys Sys->PATH;
	bufio = load Bufio Bufio->PATH;
	in = bufio->fopen(sys->fildes(0), Bufio->OREAD);
	stderr = sys->fildes(2);
	yyparse();
}

yyerror(err: string)
{
	sys->fprint(stderr, "%s\n", err);
}

yylex(): int
{
	for(;;){
		c := in.getc();
		case c{
		' ' or '\t' =>
			;
		'-' or '+' or '*' or '/' or '\n' or '(' or ')' =>
			return c;
		'0' to '9' or '.' =>
			s := "";
			i := 0;
			s[i++] = c;
			while((c = in.getc()) >= '0' && c <= '9' || c == '.' || c == 'e' || c == 'E')
				s[i++] = c;
			in.ungetc();
			yylval.v = real s;
			return REAL;
		* =>
			return -1;
		}
	}
}
