/* cmpdump.c
 * $Id: cmpdump.c,v 1.1.1.1 2000/12/05 15:19:35 nap Exp $
 */

#include <math.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>

#include <pcap.h>

#include "util.h"


#define HELP_STRING \
"Usage: %s <original> <poked> [<deltas>]\n" \
"Parameters:\n" \
"    <original>     Original tcpdump file\n" \
"    <poked>        Captured etherpoke'ed packets\n" \
"    <deltas>       Time differences\n"


/* Global variables */

int swap_bytes;


/* Utility routines */

static void
help(char *program)
{
    fprintf(stderr, HELP_STRING, program);
    exit(1);
}


static void
error(char *msg)
{
    fprintf(stderr, "cmpdump error: %s\n", msg);
    exit(1);
}

static void
read_packet(FILE *fp, int *eof,
	    struct pcap_pkthdr *pkt_hdr, unsigned char *pkt_data,
	    unsigned int snaplen)
{
    char msg[2048];

    /* Read header. */
    if (fread(pkt_hdr, sizeof(struct pcap_pkthdr), 1, fp) != 1) {
	if (feof(fp)) {
	    *eof = 1;
	    return;
	} else if (ferror(fp)) {
	    sprintf(msg, "problem reading packet header (%s)", strerror(errno));
	    error(msg);
	} else
	    fprintf(stderr, "problem reading packet header\n");
    }
    if (swap_bytes)
	byteswap_pcap_packet_header(pkt_hdr);
    if (pkt_hdr->caplen > snaplen)
	pkt_hdr->caplen = snaplen;

    /* Read data. */
    if (fread(pkt_data, pkt_hdr->caplen, 1, fp) != 1) {
	if (feof(fp)) {
	    *eof = 1;
	    return;
	} else if (ferror(fp)) {
	    sprintf(msg, "problem reading packet data (%s)", strerror(errno));
	    error(msg);
	} else
	    fprintf(stderr, "problem reading packet data\n");
    }

    *eof = 0;
    return;
}

static int
packets_match(struct pcap_pkthdr *a_hdr, struct pcap_pkthdr *b_hdr,
	      unsigned char *a_data, unsigned char *b_data)
{
    return 1;
}

int
main(int argc, char **argv)
{
    char *orig_file, *poke_file, *delta_file, msg[2048];
    FILE *ofp, *pfp, *dfp;
    int   of_eof, pf_eof;

    struct pcap_file_header orig_file_hdr, poke_file_hdr;
    struct pcap_pkthdr      orig_pkt_hdr, poke_pkt_hdr;
    unsigned char           orig_pkt_data[2048], poke_pkt_data[2048];
    struct timeval          orig_start_time, poke_start_time;

    long   num_packets, num_error_packets;
    double sum_delta, sum_delta2;

    /* Init locals. */
    num_packets = 0;
    num_error_packets = 0;
    sum_delta = 0.0;
    sum_delta2 = 0.0;

    /* Parse command line. */
    if (argc < 3 || argc > 4)
	help(argv[0]);

    orig_file = argv[1];
    poke_file = argv[2];
    if (argc == 4)
	delta_file = argv[3];
    else
	delta_file = NULL;

    /* Open files. */
    ofp = fopen(orig_file, "rb");
    if (! ofp) {
	sprintf(msg, "problem opening %s (%s)", orig_file, strerror(errno));
	error(msg);
    }
    pfp = fopen(poke_file, "rb");
    if (! pfp) {
	sprintf(msg, "problem opening %s (%s)", poke_file, strerror(errno));
	error(msg);
    }
    if (delta_file) {
	dfp = fopen(delta_file, "wb");
	if (! dfp) {
	    sprintf(msg, "problem opening %s (%s)", delta_file, strerror(errno));
	    error(msg);
	}
    } else
	dfp = NULL;

    /* Compare input file headers. */

    /* Get the first packet from each input file. */
    read_packet(ofp, &of_eof, &orig_pkt_hdr, orig_pkt_data, orig_file_hdr.snaplen);
    read_packet(pfp, &pf_eof, &poke_pkt_hdr, poke_pkt_data, poke_file_hdr.snaplen);

    /* Note start times. */
    orig_start_time = orig_pkt_hdr.ts;

    /* Loop over poke file till we find a packet that matches the first origianl one. */
    while (1) {
    }

    /* Loop over original file. */
    while (1) {
	/* Loop over poke dump until matching packet found. */
	while (1) {
	    if (packets_match(&orig_pkt_hdr, orig_pkt_data,
			      &poke_pkt_hdr, poke_pkt_data)) {
	    } else {
	    }
		
	}

    }

    /* Close files. */
    if (fclose(ofp)) {
	sprintf(msg, "problem closing %s (%s)", orig_file, strerror(errno));
	error(msg);
    }
    if (fclose(pfp)) {
	sprintf(msg, "problem closing %s (%s)", poke_file, strerror(errno));
	error(msg);
    }
    if (dfp)
	if (fclose(dfp)) {
	    sprintf(msg, "problem closing %s (%s)", delta_file, strerror(errno));
	    error(msg);
	}


    /* Print stats. */
    printf("Duration\n");
    printf("%ld packets\n", num_packets);
    printf("%ld packets in error\n", num_error_packets);
    printf("%4.2f%% packets in error\n", 100.0 * num_error_packets / num_packets);
    printf("mean delta %f\n", sum_delta / num_packets);
    printf("stddev delta %f\n",
	   sqrt((sum_delta2 - sum_delta * sum_delta / num_packets)
		/ (num_packets - 1)));

    exit(1);
}
