.\" $Id: netpoke.1,v 1.1.1.1 2000/12/05 15:19:35 nap Exp $
.\"
.TH NETPOKE 1  "14 April 1999"
.SH NAME
netpoke \- replay packets from a tcpdump file to a network
.SH SYNOPSIS
.na
.B netpoke
[
.B \-hzntv
] [
.B \-d
.I device
] [
.B \-s
.I speedup
]
.I file
.br
.ad
.SH DESCRIPTION
.LP
\fINetpoke\fP replays network traffic previously captured by
.IR tcpdump (1).
It attempts to match the timing of the original traffic and can optionally speed
it up or slow it down.
.LP
\fINetpoke\fP optionally modifies the network hardware addresses
in the replayed traffic which is useful when the traffic is being
played back on the same network from which it was collected.
The new (false) addresses keep the machines from getting confused by the replayed packets.
The addresses can also be set to zero to make it easy for packet sniffers
to separate the replayed traffic from normal traffic.
.LP
\fINetpoke\fP requires write access to the network interface.
.SH OPTIONS
.TP
.B \-h
Print a help message.
.TP
.B \-z
Set source and destination hardware addresses to zero.
.TP
.B \-n
Negate (bitwise complement) the source and destination hardware addresses.
.TP
.B \-t
Insert timing packet at the beginning of replayed traffic.
Sends an extra TCP packet at the beginning of a run with the source
IP address set to the timestamp of the first packet, the destination
IP address set to the 32 bit floating point value of the \fIspeedup\fP parameter
and the source and destination TCP ports set to 0.
The TCP control bits are all set to one which trigers an IPProtocolViolation
event in ISS RealSecure.
.TP
.B \-v
Print a line to standard output for each packet transmitted.  The line
contains the size in bytes of the  packet and is intended to be piped
into a strip-chart utility (see example below.)
.TP
.B \-V
Turn on super verbose mode
.TP
.B \-T
Print local and original times
.TP
.B \-u
Show debugging messages
.TP
.B \-p
Don't send packets with source and destination IP in outside network
through the router
.TP
.B \-D
Specify the number of hours to add or subtract (for daylight savings)
.TP
.B \-r
Specify the number of times to retry if a packet is not sent successfully
.TP
.B \-d
Specify the device name to write packets to. Defaults to the first
non-loopback device found in \fBnetstat -i\fP.
.TP
.B \-i
Specify internal network device name (defaults to default device or
external device if set)
.TP
.B \-e
Specify external network device name (defaults to default device or
internal device if set)
.TP
.B \-N
Set internal network subnet *.*.*.* in decimal. Use * for wildcard (in
quotes)
.TP
.B \-I
Specify destination MAC address internal network router
.TP
.B \-E
Specify destination MAC address external network router
.TP
.B \-s
Adjust the timing of the replayed packets by a factor of \fIspeedup\fP.
Defaults to 1.0.  Values less than 1.0 slow the traffic.  A value
of 0 causes \fInetpoke\fP to push packets out as fast as it can.
.SH ARGUMENTS
.TP
.I file
.RS
Specify the \fItcpdump\fP file to be replayed.  A value of "\fB-\fP" causes
\fInetpoke\fP to use standard input.
.SH EXAMPLES
.LP
To replay
.B dmpfile
with MAC addresses set to zero:
.RS
.nf
\fBnetpoke \-z dmpfile\fP
.fi
.RE
.LP
To replay
.B dmpfile
in one tenth of the time it took to collect it:
.RS
.nf
\fBnetpoke \-s 10 dmpfile\fP
.fi
.RE
.LP
To replay
.B dmpfile
slowed down to take twice the time it took to collect it:
.RS
.nf
\fBnetpoke \-s 0.5 dmpfile\fP
.fi
.RE
.LP
To replay
.B dmpfile
and display a strip-chart showing number of packets per second:
.RS
.nf
\fBnetpoke \-v dmpfile | java StripChart\fP
.fi
.RE
.SH "SEE ALSO"
tcpdump(1), pcap(3), libnet(3), tcpslice(1)
.SH AUTHOR
Rob Steele, Brian Lin, Nick Plante of MIT Lincoln Laboratory
.RE
.SH BUGS
Please send bug reports to netpoke@sst.ll.mit.edu.
