/* util.c
 * $Id: util.c,v 1.1.1.1 2000/12/05 15:19:35 nap Exp $
 */

/* (c) Copyright 2000 M.I.T.
   Permission is hereby granted, without written agreement or
   royalty fee, to use, copy, modify, and distribute this
   software and its documentation for any purpose, provided that
   the above copyright notice and the following three paragraphs
   appear in all copies of this software.

   IN NO EVENT SHALL M.I.T. BE LIABLE TO ANY PARTY FOR DIRECT,
   INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
   ARISING OUT OF THE USE OF THIS SOFTARE AND ITS DOCUMENTATION,
   EVEN IF M.I.T. HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
   DAMAGE.

   M.I.T. SPECIFICALLY DISCLAIMS ANY WARRANTIES INCLUDING, BUT
   NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT.

   THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS AND M.I.T. HAS
   NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
   ENHANCEMENTS, OR MODIFICATIONS. */

#include <math.h>
#include <sys/time.h>
#include <pcap.h>
#include "util.h"



//typedef unsigned long int u_int32_t;
/* Byte swap stuff */

int
little_endian(void)
{
    int n;

    n = 1;
    return (* (char *) &n) == 1;
}


void
byteswap(void *p, size_t size)
{
    unsigned char *left, *right, tmp;

    left = p;
    right = left + size - 1;

    while (left < right) {
	tmp = *left;
	*left = *right;
	*right = tmp;
	left++;
	right--;
    }
}


void
byteswap_pcap_file_header(struct pcap_file_header *pfh)
{
    byteswap(&pfh->magic,         sizeof pfh->magic);
    byteswap(&pfh->version_major, sizeof pfh->version_major);
    byteswap(&pfh->version_minor, sizeof pfh->version_minor);
    byteswap(&pfh->thiszone,      sizeof pfh->thiszone);
    byteswap(&pfh->sigfigs,       sizeof pfh->sigfigs);
    byteswap(&pfh->snaplen,       sizeof pfh->snaplen);
    byteswap(&pfh->linktype,      sizeof pfh->linktype);
}


void
byteswap_pcap_packet_header(struct pcap_pkthdr *pph)
{
    byteswap(&pph->ts.tv_sec,  sizeof pph->ts.tv_sec);
    byteswap(&pph->ts.tv_usec, sizeof pph->ts.tv_usec);
    byteswap(&pph->caplen,     sizeof pph->caplen);
    byteswap(&pph->len,        sizeof pph->len);
}

/* Time stuff. */

/*
void
ts_print(register const struct timeval *tvp)
{
	register int s;

	if (tflag > 0) {
	// Default 
		s = (tvp->tv_sec + thiszone) % 86400;
		(void)printf("%02d:%02d:%02d.%06u ",
		    s / 3600, (s % 3600) / 60, s % 60, (u_int32_t)tvp->tv_usec);
	} else if (tflag < 0) {
		if (tflag < -1) {
			static unsigned b_sec;
			static unsigned b_usec;
			if (b_sec == 0) {
				printf("000000 ");
			} else {
				int d_usec = tvp->tv_usec - b_usec;
				int d_sec = tvp->tv_sec - b_sec;

				while (d_usec < 0) {
					d_usec += 1000000;
					d_sec--;
				}
				if (d_sec)
					printf("%d. ", d_sec);
				printf("%06d ", d_usec);
			}
			b_sec = tvp->tv_sec;
			b_usec = tvp->tv_usec;
		} else {
// Unix timeval style 
			(void)printf("%u.%06u ",
				     (u_int32_t)tvp->tv_sec, (u_int32_t)tvp->tv_usec);
		}
	}
}
*/

void
timeval_add(struct timeval *a, struct timeval b)
{
    a->tv_usec += b.tv_usec;
    a->tv_sec += b.tv_sec;
    if (a->tv_usec >= (long) 1e6) {
	a->tv_usec -= (long) 1e6;
	a->tv_sec++;
    }
}


void
timeval_sub(struct timeval *a, struct timeval b)
{
    a->tv_usec -= b.tv_usec;
    a->tv_sec -= b.tv_sec;
    if (a->tv_usec <= 0) {
	a->tv_usec += (long) 1e6;
	a->tv_sec--;
    }
}


void
timeval_mul(struct timeval *a, double factor)
{
    double usec;

    usec = (a->tv_sec * 1.0e6 + a->tv_usec) * factor;

    a->tv_usec = (int) fmod(usec, 1.0e6);
    a->tv_sec = (int) (usec / 1.0e6);
}


long
timeval_diff(struct timeval a, struct timeval b)
{
  struct timeval diff;

  diff = a;
  timeval_sub(&diff, b);
    
  return diff.tv_sec * (long) 1e6 + diff.tv_usec;
}


//Address stuff

u_int32_t
ip_string_to_addr(char *str)
{
  char *tmpstr;
  u_int32_t int_net;
  int i;
  tmpstr = str;
  int_net = atoi(tmpstr);
  for(i = 0;i< 3; i++){
    tmpstr = strpbrk(tmpstr, ".");
    int_net = int_net<<8;
    int_net += atoi((++tmpstr));
  }
  return int_net;
}

//miscellaneous
u_int32_t
hex_string_to_u_int32_t(char str[])
{
  u_int32_t value = 0;
  int i;
  for(i = 0; i< strlen(str); i++){
    value = value<<4;
    value+=
      (str[i]=='a') ? 10 : (str[i]=='b') ? 11 :
      (str[i]=='c') ? 12 : (str[i]=='d') ? 13 :
      (str[i]=='e') ? 14 : (str[i]=='f') ? 15 :
      (str[i]=='9') ? 9 : (str[i]=='8') ? 8 :
      (str[i]=='7') ? 7 : (str[i]=='6') ? 6 :
      (str[i]=='5') ? 5 : (str[i]=='4') ? 4 :
      (str[i]=='3') ? 3 : (str[i]=='2') ? 2 : 
      (str[i]=='1') ? 1 : 0;

  }
  return value;
}
  


string_to_MAC_address(u_char MAC_address[ETHER_ADDR_LEN], char *str)
{
  char *tmpstr, *p;
  u_int32_t int_net;
  int i;
  tmpstr = str;
  p = strtok(tmpstr,  ":");
  MAC_address[0] =  (u_char) hex_string_to_u_int32_t(p);
  for(i = 1;i< ETHER_ADDR_LEN; i++){
    p = strtok('\0', ":");
    MAC_address[i] = (u_char) hex_string_to_u_int32_t(p);
  }
}
  
char *
ip_addr_to_string(u_int32_t addr)
{
}


