/* util.h
 * $Id: util.h,v 1.1.1.1 2000/12/05 15:19:35 nap Exp $
 */

/* (c) Copyright 2000 M.I.T.
   Permission is hereby granted, without written agreement or
   royalty fee, to use, copy, modify, and distribute this
   software and its documentation for any purpose, provided that
   the above copyright notice and the following three paragraphs
   appear in all copies of this software.

   IN NO EVENT SHALL M.I.T. BE LIABLE TO ANY PARTY FOR DIRECT,
   INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
   ARISING OUT OF THE USE OF THIS SOFTARE AND ITS DOCUMENTATION,
   EVEN IF M.I.T. HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
   DAMAGE.

   M.I.T. SPECIFICALLY DISCLAIMS ANY WARRANTIES INCLUDING, BUT
   NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT.

   THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS AND M.I.T. HAS
   NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
   ENHANCEMENTS, OR MODIFICATIONS. */

#ifndef UTIL_H
#define UTIL_H
#include "util.c"

#if defined(__GNUC__)
#define UNUSED __attribute__ ((unused))
#else
#define UNUSED
#endif

#define PCAP_MAGIC_NUMBER 0xa1b2c3d4


int  little_endian(void);
void byteswap(void *p, size_t size);
void byteswap_pcap_file_header(struct pcap_file_header *pfh);
void byteswap_pcap_packet_header(struct pcap_pkthdr *pph);

void timeval_add(struct timeval *a, struct timeval b);
void timeval_sub(struct timeval *a, struct timeval b);
void timeval_mul(struct timeval *a, double factor);
long timeval_diff(struct timeval a, struct timeval b);

#endif
