/*

	http_ver.c
	
	query's a web server and trys to find the server type.
	
	for use with tcpip.c (high level socket functions)
	
	author: jjohnson@eagle.ptialaska.net
		presonic@irc
		
	compile: gcc -o http_ver http_ver.c
	
	this example makes use of:
	
		i_connect()  		(blocking i/o)
		i_disconnect()
		i_readline()
		i_nslookup()
		
*/

#include <stdio.h>
#include "tcpip.h"

#define PORT 80


main(int argc, char *argv[])
{
	char 	ip[30];
	int	sock;
	char 	*ptr;
	int 	server_found=0;
	
	if(argc != 2)
	{
		printf("usage: %s <ip|hostname>\n",argv[0]);
		exit(-1);
	}
	
	strcpy(ip,i_nslookup(argv[1],RETURN_IP));
	
	if(strcmp(ip,"ERROR") == 0)
	{
		printf("Error looking up %s\n",argv[1]);
		exit(-1);
	}
	
	if((sock = i_connect(ip,PORT,BLOCKING)) < 0)
	{
		printf("Error connecting to %s on port %d.\n",ip,PORT);
		exit(-1);
	}
	
	write(sock,"GET / HTTP 1.0\n\r\n\r",strlen("GET / HTTP 1.0\n\r\n\r"));
	
	while(1)
	{
		ptr = i_readline(sock);
		if(*ptr == '\0') break;	/* if the line is empty, (not even a \n), then we got disconnected */
		
		/* check for the "Server:" line, if found, print it out. */
		if(strncasecmp("Server:",ptr,7) == 0)
		{
			printf("%s",ptr);
			server_found = 1;
			break;
		}
	}
	
	/* if the server type wasn't detected... */
	if(server_found != 1)
		printf("Unable to detect server type.\n");
	
	i_disconnect(sock);
}
