//----------------------------------------------------------------------------
//   dib main header
//----------------------------------------------------------------------------

#include <ddraw.h>

#ifndef MAXPATH
#define MAXPATH 260
#endif

#define RGB_RED   2
#define RGB_GREEN 1
#define RGB_BLUE  0

#define TYPE_NONE 0
#define TYPE_BMP  1
#define TYPE_GIF  2
#define TYPE_JPG  3
#define TYPE_PCX  4
#define TYPE_TGA  5

#define COLOR_GREY 0
#define COLOR_1    1
#define COLOR_4    4
#define COLOR_8    8
#define COLOR_16   16
#define COLOR_24   24
#define COLOR_32   32
#define COLOR_OFF  64

#define GET_2B(array, offset)  ((unsigned int) ((unsigned char) array[offset]) + \
										 ((unsigned int) ((unsigned char) array[offset + 1]) << 8))
#define GET_4B(array, offset)  ((unsigned int) ((unsigned char) array[offset]) + \
										(((unsigned int) ((unsigned char) array[offset + 1])) << 8) + \
										(((unsigned int) ((unsigned char) array[offset + 2])) << 16) + \
										(((unsigned int) ((unsigned char) array[offset + 3])) << 24))

typedef struct tgahdr {
  unsigned char idLength;
  unsigned char colorMapType;
  unsigned char imageType;
  WORD firstEntryIdx;
  WORD colorMapLength;
  unsigned char colorMapEntrySize;
  WORD xOrigin;
  WORD yOrigin;
  WORD imageWidth;
  WORD imageHeight;
  unsigned char pixelDepth;
  unsigned char imageDescriptor;
} TGAHDR;

typedef struct gifhdr {
  unsigned char signature[3];
  unsigned char version[3];
  WORD width;
  WORD height;
  unsigned char packedFields;
  unsigned char backGroundColor;
  unsigned char pixelAspectRatio;
} GIFHDR;

typedef struct gifdesc {
  WORD leftPosition;
  WORD topPosition;
  WORD width;
  WORD height;
  unsigned char packedFields;
} GIFDESC;

typedef struct gifdesc1 {
  unsigned char separator;
  WORD leftPosition;
  WORD topPosition;
  WORD width;
  WORD height;
  unsigned char packedFields;
  unsigned char initCodeSize;
} GIFDESC1;

typedef struct pcxhdr {
  unsigned char manufacturer;	/*	10 == ZSoft */
  unsigned char version;		/*	0 = Paintbrush 2.5
									    ** 2 = 2.8 with palette
    									 ** 3 = 2.8 without palette
									    ** 4 = PC Paintbrush for Windows
									    ** 5 = Version 3.0+ and Publishers Paintbrush */
  unsigned char encode;			/* 1 = PCX RLE */
  unsigned char bitsPerPixel; /* 1, 2, 4, or 8 */
  WORD	minX;					   /* Window dimensions */
  WORD	minY;
  WORD	maxX;
  WORD	maxY;
  WORD	horzDpi;				   /* Horizontal dots per inch */
  WORD	vertDpi;				   /* Vertical dots per inch */
  unsigned char pal1[16][3];	/* palette */
  unsigned char junk;
  unsigned char planes;	      /* number of color planes */
  WORD	bytesPerLine;		   /* number of bytes per scanline */
  WORD	paltype;				   /* 1 = Color, 2 = GrayScale */
  WORD	hScreenSize;		   /* Horizontal Screen Size */
  WORD	vScreenSize;		   /* Vertical Screen Size */
  unsigned char filler[54];
} PCXHDR;

class TBaseDib : virtual public TDib
{
  public:
    BITMAPINFO *Info2;
    HANDLE Handle2;
	 int  xSize;
    int  xSize2;
	 char ErrStr[MAXPATH];
    int  W, H, W2, H2;
	 int  picWidth, picHeight;
	 int  xSizeNoPad;
    int  xSizeNoPad2;
	 long EndScan;
    int  picBitsPerPixel;
	 int  BitsPerPixel;
    int  BitsPerPixel2;
    long BitsAllocated;
    long BitsAllocated2;
    char *Bits2;
    int  NumClrs2;
    FILE *fpin;
    char fName[MAXPATH];
    int  fType;
    unsigned char bmpinfoheader[64];
    int32 biClrUsed;
    int32 GBLClrUsed;
    int32 LCLClrUsed;
    int32 biCompression;
    int BMPPlanes;
    int BMPHeaderSize;
    int  mapentrysize;
    DWORD redMask;
    DWORD greenMask;
    DWORD blueMask;
    #define ROW_BUF_SIZE 1024
    int  row_data_idx, count;
    unsigned char value;
    unsigned char row_data[ROW_BUF_SIZE];
    PCXHDR pcxHeader;
    TGAHDR tgaHeader;
    GIFHDR GIFHeader;
    GIFDESC GIFImgDescriptor;
	 RGBQUAD ColorMap[256];
    RGBQUAD GBLColorMap[256];
    bool GBLColorTable;
    bool LCLColorTable;
    unsigned char BackGroundClr;
    #define	MAX_LZW_BITS	12	/* maximum LZW code size */
    #define LZW_TABLE_SIZE	(1 << MAX_LZW_BITS) /* # of possible LZW symbols */
    unsigned short int GIFSymbolHead[LZW_TABLE_SIZE];
    unsigned char GIFSymbolTail[LZW_TABLE_SIZE];
    unsigned char GIFSymbolStack[LZW_TABLE_SIZE];
    int GIFCodeSize;
    int GIFLimitCode;
    int GIFMaxCode;
    unsigned char *GIFSp;
    int GIFLastByte;
    int GIFLastBit;
    int GIFCurBit;
    bool GIFOutOfBlocks;
    int GIFClearCode;
    int GIFEndCode;
    bool GIFFirstTime;
	 bool IsInterlaced;
    int GIFInputCodeSize;
    bool AnimatedGIF;
    int GIFDelayTime;
    bool TransparentGIF;
    unsigned char TransparentIdx;
    bool GIFUserInputFlag;
    unsigned char GIFDisposal;
    int GIFFrameNum;
    int GIFTotalFrames;
    int logWidth;
    int logHeight;
    int picLeft;
    int picTop;
	 unsigned short int GIFPass2Offset;
	 unsigned short int GIFPass3Offset;
	 unsigned short int GIFPass4Offset;
    unsigned char GIFCodeBuf[256+4];		/* current input data block */
    int GIFOldCode;			/* previous LZW symbol */
    int GIFFirstCode;		/* first byte of oldcode's expansion */
    fpos_t CurGIFPos;
    bool IsBottomUp;
    char TGAIDField[255];
    int  TGABlockCount;
    int  TGADupPixelCount;
    unsigned char TGAPixel[4];
    bool RLECompressed;
    jmp_buf SetJmpBuffer;
    int JPGColorSpace;

	 TBaseDib();
    void YieldTime();
	 virtual bool LoadFile(const char* name);
	 bool CreateDib(bool isBMP_BI_BITFIELDS);
    bool CreateDib2(int w, int h, int bitsPerPixel);
    bool CreateBlankDib(int w, int h);
    bool CopyFromDib(TBaseDib *dib);
    void CopyBaseVars(TBaseDib *dib);
    void SwitchDibs();
	 bool IsTarga();
	 bool IsJPEG();
	 bool ReadBMPHeader();
	 bool ReadPCXHeader();
    bool ReadPCXByte();
    int  GetCode();
    int  LZWReadByte();
    void ReInitLZW();
    void InitLZWCode();
    bool SkipDataBlocks();
    bool GetGIFImageHeader();
    bool CheckGIFAnim();
    bool ReadGIFHeader();
    bool ReadTGAPixel8();
    bool ReadTGAPixel16();
    bool ReadTGAPixel24();
    bool ReadTGAPixel32();
    bool ReadTGAHeader();
    bool ChangeDepth(int bitsPerPixel);
    void ScaleLine(unsigned char *sp, unsigned char *dp, int sw, int dw);
    bool Rescale(int w, int h, int realW, int realH);
    bool Crop(int x, int y, int w, int h);
    bool PadDib(int w, int h);
    void Deinterlace();
    bool Invert();

  private:
	 virtual bool LoadBMPFile();
	 virtual bool LoadPCXFile();
	 virtual bool LoadGIFFile();
	 virtual bool LoadTGAFile();
	 virtual bool LoadJPEGFile();
    bool To24Bits();
    bool To32Bits();
};


class TFullDib : virtual public TBaseDib
{
  public:
	 TFullDib(TWindow *parent);
    ~TFullDib();
    bool LoadNextGIFFile();
	 TWindow *Parent;
    bool LoadFromBMP(BITMAPINFO *bitmapInfo);
    bool LoadFromDD(DDSURFACEDESC ddsd);

  private:
    bool FirstTimeGIF;

    void DisposeGIF();
	 bool LoadBMPFile();
    bool LoadBMPRLEFile();
	 bool LoadPCXFile();
	 bool LoadGIFFile();
    bool ReadGIFFile();
	 bool LoadTGAFile();
    bool LoadTGARLEFile();
	 bool LoadJPEGFile();
};


class TPreviewDib : virtual public TBaseDib
{
  public:
	 TPreviewDib(TWindow *parent, TRect &rect, bool oneJPGPass = false);
	 ~TPreviewDib();
    bool LoadFile(const char* name);
    bool LoadFromDib(TFullDib *dib);
    bool LoadFromBMP(BITMAPINFO *bitmapInfo);
    bool LoadFromDD(DDSURFACEDESC ddsd);
    bool LoadNextGIFFile();
    void ClearDib();
    void DrawBorder();

    int xCount, yCount;
    int newWidth, newHeight;
    int xOffset, yOffset;
    int xLCount, yLCount;
    int newLWidth, newLHeight;
    int xLOffset, yLOffset;
    int xOffsetSave, yOffsetSave;
    int xCountSave, yCountSave;
    bool oneJPEGPass;

  private:
    TWindow *Parent;
    unsigned char huge *GIFSaveBuffer;
    TRect DrawRect;

    void ScalePic();
    void ScaleGIFLogical();
    void ScaleGIFImage();
    void SetPrevBKColor();
    void DisposeGIF();
	 bool LoadBMPFile();
    bool LoadBMPRLEFile();
	 bool LoadPCXFile();
	 bool LoadGIFFile();
    bool ReadGIFFile();
	 bool LoadTGAFile();
    bool LoadTGARLEFile();
	 bool LoadJPEGFile();
    void DisplayRow(int row);
};

int Round(float num);
