//----------------------------------------------------------------------------
//   AVI2MPG main header
//----------------------------------------------------------------------------

#define STRICT
#include <owl\applicat.h>
#include <owl\framewin.h>
#include <owl\gdiobjec.h>
#include <owl\window.h>

#ifndef OWLNEXT
#include <owl\owlpch.h>
#endif

#include <owl\dc.h>
#include <owl\scroller.h>
#include <owl\listbox.h>
#include <owl\checkbox.h>
#include <owl\groupbox.h>
#include <owl\radiobut.h>
#include <owl\button.h>
#include <owl\combobox.h>
#include <owl\scrollba.h>
#include <owl\static.h>
#include <owl\edit.h>
#include <owl\validate.h>
#include <owl\opensave.h>
#include <owl\slider.h>
#include <owl\updown.h>

#ifdef __BORLANDC__
#include <dir.h>
#else
#include <direct.h>
#endif

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <setjmp.h>
#include "avi2mpg1.h"
#include <owl\pch.h>
#include "dib.h"

#define OAFALSE 0

#include "bbmpgapi.h"

class TCancelDialog : public TDialog
{
  public:
    TCancelDialog(TWindow *parent, TResId resId, TModule* module = 0);
    void SetText(char *txt);
    void SetText2(char *txt);
    virtual void CmCancel();

    TStatic *Txt;
    TStatic *Txt2;

    DECLARE_RESPONSE_TABLE(TCancelDialog);    
};


class TMainWindow : public TDialog
{
  public:
    TMainWindow(TWindow *parent, TResId resId, TModule* module = 0);
    ~TMainWindow();
    void SetupWindow();
    void AddMessage(char *txt);
    void AddFilename(char *txt);
    int  DisplayMBox(char *txt, char *title);
    void CmStartConversion();
    void CmFileOpen();
    void CmFileRemove();
    void CmFileUp();
    void CmFileDown();
    void CmAbout();
    void CmExit();
    void CmVideoOpen();
    void CmAudioOpen();
    int  GetFrame(int cFile, unsigned int frame);
    int  GetSample(int cFile, unsigned int sample);
    bool AddAVI(char *name);
    bool OpenFile(int cFile);
    void CloseFile(int cFile);
    bool OpenAVI(int cFile);
    void CloseAVI(int cFile);
    void RemoveFile(int cFile);
    bool AddList(char *name);
    bool OpenList(int cFile);
    void CloseList(int cFile);
    void EvLoadProject();
    void EvSaveProject();
    bool SetRelPos();
    void DisplaySourceInfo();
    void DisplayOutputInfo();
    void CheckOutputAudio();
    void DisplayFileInfo();
    void UpDownButtons();
    void EvSourceChange();
    bool EvCropXBump(TNmUpDown& not);
    bool EvCropYBump(TNmUpDown& not);
    bool EvCropWBump(TNmUpDown& not);
    bool EvCropHBump(TNmUpDown& not);
    bool EvMPEGWBump(TNmUpDown& not);
    bool EvMPEGHBump(TNmUpDown& not);
    void EvHScroll(uint scrollCode, uint thumbPos, THandle hWndCtl);
    void EvVScroll(uint scrollCode, uint thumbPos, THandle hWndCtl);
    void EvRButtonUp(uint modKeys, TPoint& point);
    void EvRButtonDown(uint modKeys, TPoint& point);
    void PopMenu(TPoint &point);
    void EvPropCheck();
    void EvResizeCheck();
    void EvCropCheck();
    void EvDeInterlace();
    void EvInvert();
    void EvShowOutput();
    void EvStartFrame();
    void EvEndFrame();
    void EvStartKillFocus();
    void EvEndKillFocus();
    void EvICurrentKillFocus();
    void EvOCurrentKillFocus();
    void EvRepeatKillFocus();
    void EvCropXKillFocus();
    void EvCropYKillFocus();
    void EvCropWKillFocus();
    void EvCropHKillFocus();
    void EvMPEGWKillFocus();
    void EvMPEGHKillFocus();
    void EvKeyReturn();
    void EvIPreview();
    void EvOPreview();
    void EvBatch();
    void EvHelp();
    bool CreatePrevDibs();
    void EvPaint();
    void PaintIPreview();
    void PaintOPreview();
    void UpdateOPreview();
    void YieldTime();
    void TempDisp();
    void EvIPlay();
    void EvIPause();
    void EvIStop();
    void EvOPlay();
    void EvOPause();
    void EvOStop();
    void EvEditFilters();

    bool Previewing, gotRFirst;
    int LongestName, LongestMessage;
    TRect iprevRect, oprevRect;
    TPopupMenu PopupMenu;
    TPreviewDib *iprevDib;
    TPreviewDib *oprevDib;
    TFullDib *outputDib;
    TListBox *InputName;
    TEdit *VideoName;
    TEdit *ProjectName;
    TListBox *InputLBox;
    TButton *StartButton;
    TButton *MPEGOpenButton;
    TButton *RemoveButton;
    TButton *UpButton;
    TButton *DownButton;
    TButton *SaveButton;
    TCheckBox *BatchCheck;
    TCheckBox *FilterCheck;
    TEdit *StartText;
    TEdit *EndText;
    TEdit *RepeatText;
    TStatic *IFirstText;
    TStatic *OFirstText;
    TEdit *ICurrentText;
    TEdit *OCurrentText;
    TStatic *ILastText;
    TStatic *OLastText;
    TStatic *OFileText;
    TStatic *OFrameText;
    TStatic *IVideoRect;
    TStatic *OVideoRect;
    TStatic *AudioInfo;
    TScrollBar *IVideoScroll;
    TScrollBar *OVideoScroll;
    TUpDown *OFileScroll;
    TCheckBox *DeInterCheck;
    TCheckBox *Invert;
    TCheckBox *ShowOutput;
    TRadioButton *PropCheck;
    TRadioButton *ResizeCheck;
    TRadioButton *CropCheck;
    TEdit *CropXEdit;
    TEdit *CropYEdit;
    TEdit *CropWEdit;
    TEdit *CropHEdit;
    TUpDown *CropXScroll;
    TUpDown *CropYScroll;
    TUpDown *CropWScroll;
    TUpDown *CropHScroll;
    TEdit *MPEGWEdit;
    TEdit *MPEGHEdit;
    TUpDown *MPEGWScroll;
    TUpDown *MPEGHScroll;
    TButton *IPlay;
    TButton *IPause;
    TButton *IStop;
    TButton *OPlay;
    TButton *OPause;
    TButton *OStop;
    int AudioAvail;
    bool OutputAudio;
    char MPEGFilename[MAXPATH];

    HINSTANCE dllPtr;

    bbMPEGInitEntry bbInit;
    bbMPEGMakeMPEGEntry bbMakeMPEG;
    bbMPEGShutdownEntry bbShutdown;
    makeMPEGRecInfo makeMPEGInfo;

    DECLARE_RESPONSE_TABLE(TMainWindow);
};

class TMyFrameWindow : public TFrameWindow
{
  public:
    TMyFrameWindow::TMyFrameWindow(TWindow* parent, const char far *title, TWindow *clientWnd, bool shrinkToClient, TModule *module = 0);
    void EvSetFocus(HWND hWndLostFocus);
    bool CanClose();

    DECLARE_RESPONSE_TABLE(TMyFrameWindow);
};
