#if defined(__BORLANDC__)
#include <condefs.h>
USEUNIT("prevdib.cpp");
USEUNIT("fulldib.cpp");
USEUNIT("basedib.cpp");
USERC("..\res\avi2mpg2.rc");
USELIB("..\..\borbin\jpeglib.lib");
USELIB("..\..\borbin\bbmpeg.lib");
//---------------------------------------------------------------------------
#endif // defined(__BORLANDC__)
//----------------------------------------------------------------------------
//   AVI2MPG2 - a shell for bbMPEG to convert avi's to mpeg-2 movies
//----------------------------------------------------------------------------
#include "avi2mpg2.h"
#include <evcode.h>
#include <control.h>
#include <mmsystem.h>
#include <amstream.h>
#include <initguid.h>
#include <uuids.h>
#include <math.h>
#include <olectl.h>

#define MAX_OPEN_FILES 256

bool AbortLoading;
bool AbortDisplay;
bool AbortOperation;
bool AbortPreview;
bool ShowAnimGIF;
bool batch;

struct fileData {
char fileName[MAXPATH];
char mpegFilename[MAXPATH];
char defListDir[MAXPATH];
IDirectDraw *pDD;
IMultiMediaStream *pMMStream;
IMediaStream *pVidStream;
IMediaStream *pAudStream;
IDirectDrawMediaStream *pDDMStream;
IDirectDrawStreamSample *pDDSample;
IDirectDrawSurface *pDDSurface;
IAudioMediaStream *pAudMStream;
IAudioStreamSample *pAudSample;
IAudioData *pAudData;
DDSURFACEDESC ddsd;
WAVEFORMATEX audioFormat;
FILE *fileList;
bool AudioPresent;
bool aviFile;
bool deinterlace;
bool invert;
bool cropFrames, propSize, resize;
unsigned int cropX, cropY, cropW, cropH;
unsigned int startFrame, endFrame, firstFrame, lastFrame, repeatCount, startSample;
unsigned int currentFrame, numFrames, numFramesUsed, bitsPerPixel;
unsigned int numSamples, samplesPerFrame, numSamplesUsed, bytesPerSample, audioBufferSize;
unsigned int mpegWidth, mpegHeight;
double frameRate;
PBYTE audioBuffer;
CY frameLength, totalTime;
double sampleLength;
int samplesPerSec, audioBufferSize1;
unsigned short int *audioBuffer1;
};

bbMPEGSetFocusEntry dllSetFocus;
bbMPEGAppWindowEntry dllAppWindow;
char AppName[30];
char AppVersion[30];
fileData files[MAX_OPEN_FILES];
bool Encoding, OPreviewing, showOutput;
bool Playing, Stop, Pause, LoadingFrame, editFilters;
int AVIAvail;
TMainWindow *mainWindow = NULL;
TMyFrameWindow *frameWindow = NULL;
int fileCount, currentIFile, currentOFile;
int MPEGWidth, MPEGHeight;
int relOPos, currentOPos;
unsigned int totalFrames, totalSamples, curSample;
int samplesPerSec, audioBufferSize1;
unsigned short int *audioBuffer1;
char helpFile[MAXPATH];
char curFilename[MAXPATH];
TCancelDialog *cancelDialog;

class TFilterDialog : public TDialog
{
  public:
    TFilterDialog(TWindow *parent, TResId resId, TModule* module = 0);
    void SetupWindow();
    void EvProperties();
    TListBox *filterList;
    IGraphBuilder *pGB;

    DECLARE_RESPONSE_TABLE(TFilterDialog);
};

DEFINE_RESPONSE_TABLE1(TFilterDialog, TDialog)
  EV_COMMAND(IDC_PROPERTIES, EvProperties),
END_RESPONSE_TABLE;

TFilterDialog::TFilterDialog(TWindow *parent, TResId resId, TModule* module)
              :TDialog(parent, resId, module)
{
  filterList = new TListBox(this, IDC_FILTERLIST);
}

void TFilterDialog::SetupWindow()
{
  IEnumFilters *ppEnum = NULL;
  IBaseFilter *pifBF;
  ISpecifyPropertyPages *pisPP;
  char tmpStr[256];
  unsigned long fCount;
  bool found = false;
  bool errorFlag = false;
  FILTER_INFO fInfo;

  TDialog::SetupWindow();
  strcpy(tmpStr, AppName);
  strcat(tmpStr, " - filter properties");
  SetCaption(tmpStr);
  if (pGB->EnumFilters(&ppEnum) == S_OK)
  {
    if (ppEnum->Reset() == S_OK)
    {
      while (ppEnum->Next(1, &pifBF, &fCount) == S_OK)
      {
        if (pifBF->QueryFilterInfo(&fInfo) == S_OK)
        {
          WideCharToMultiByte(CP_ACP, 0, fInfo.achName, -1, tmpStr, MAXPATH, NULL, NULL);
          if (strlen(tmpStr))
          {
            if (pifBF->QueryInterface(IID_ISpecifyPropertyPages, (void **)&pisPP) == S_OK)
            {
              pisPP->Release();
              filterList->AddString(tmpStr);
              found = true;
            }
          }
          fInfo.pGraph->Release();
        }
        pifBF->Release();
      }
    }
    else
      errorFlag = true;
    ppEnum->Release();
  }
  else
    errorFlag = true;
  if (errorFlag || !found)
  {
    if (errorFlag)
      MessageBox("Error retreiving filter properties", AppName, MB_OK);
    PostMessage(WM_CLOSE);
  }
}

void TFilterDialog::EvProperties()
{
  IBaseFilter *pifBF;
  ISpecifyPropertyPages *pisPP;
  char tmpStr[256];
  WCHAR fName[MAX_PATH];
  CAUUID caGUID;

  filterList->GetString(tmpStr, filterList->GetCaretIndex());
  MultiByteToWideChar(CP_ACP, 0, tmpStr, -1, fName, sizeof(fName)/sizeof(fName[0]));
  if (pGB->FindFilterByName(fName, &pifBF) == S_OK)
  {
    if (pifBF->QueryInterface(IID_ISpecifyPropertyPages, (void **)&pisPP) == S_OK)
    {
      if (pisPP->GetPages(&caGUID) == S_OK)
        OleCreatePropertyFrame(HWindow, 0, 0, L"Filter", 1, (IUnknown **)&pifBF, 0, NULL, 0, 0, NULL);
      else
        MessageBox("Unable to get property pages", AppName, MB_OK);
      pisPP->Release();
    }
    else
      MessageBox("Unable to find filter properties", AppName, MB_OK);
    pifBF->Release();
  }
  else
    MessageBox("Unable to find specified filter", AppName, MB_OK);
}



DEFINE_RESPONSE_TABLE1(TCancelDialog, TDialog)
  EV_COMMAND(IDCANCEL, CmCancel),
END_RESPONSE_TABLE;

TCancelDialog::TCancelDialog(TWindow *parent, TResId resId, TModule* module)
              :TDialog(parent, resId, module)
{
  Txt = new TStatic(this, IDC_CANCELTEXT);
  Txt2 = new TStatic(this, IDC_CANCELTEXT2);
}

void TCancelDialog::SetText(char *txt)
{
  Txt->SetText(txt);
}

void TCancelDialog::SetText2(char *txt)
{
  Txt2->SetText(txt);
}

void TCancelDialog::CmCancel()
{
  AbortLoading = true;
  TDialog::CmCancel();
}


int getAudio(unsigned int sampleNum, unsigned int *numSamples, unsigned int *bufferSize, char **buffer)
{
  unsigned short int *srcPtr, lSample, rSample;
  unsigned int sampleCount, numBytes;
  int i, j, k, relSample, currentFile;
  bool stereo, bits16;

  mainWindow->YieldTime();
  currentFile = 0;
  relSample = (int)sampleNum;
  if (batch)
  {
    currentFile = currentOFile;
    relSample += files[currentFile].startSample;
  }
  else
  {
    while (relSample >= 0)
    {
      relSample -= files[currentFile].numSamplesUsed;
      currentFile++;
    }
    currentFile--;

    relSample += files[currentFile].numSamplesUsed + files[currentFile].startSample;
    if (currentFile != currentOFile)
    {
      if (currentOFile != currentIFile)
        mainWindow->CloseFile(currentOFile);
      currentOFile = currentFile;
      if (currentOFile != currentIFile)
        if (!mainWindow->OpenFile(currentOFile))
          return bbInternalError16;
    }
  }
  if (relSample == files[currentFile].startSample)
    curSample = 0;
  if (curSample + files[currentFile].samplesPerFrame < files[currentFile].numSamplesUsed)
    sampleCount = files[currentFile].samplesPerFrame;
  else
    sampleCount = files[currentFile].numSamplesUsed - curSample;
  curSample += files[currentFile].samplesPerFrame;
  numBytes = sampleCount * files[currentFile].bytesPerSample;
  *numSamples = sampleCount;

  if (!files[currentFile].AudioPresent)
  {
    memset(audioBuffer1, 0, audioBufferSize1);
    *bufferSize = numBytes;
    *buffer = (char*)audioBuffer1;
    return bbErrNone;
  }

  if (mainWindow->GetSample(currentFile, relSample))
    return bbInternalError17;

  if ((files[currentFile].audioFormat.nSamplesPerSec != 22050) &&
      (files[currentFile].audioFormat.wBitsPerSample == 16) &&
      (files[currentFile].audioFormat.nChannels == 2))
  {
    *bufferSize = numBytes;
    *buffer = (char*)files[currentFile].audioBuffer;
  }
  else
  {
    j = 0;
    k = files[currentFile].audioFormat.nChannels;
    stereo = k == 2;
    if (!stereo)
      numBytes <<= 1;
    bits16 = files[currentFile].audioFormat.wBitsPerSample == 16;
    if (bits16)
      srcPtr = (unsigned short int*)files[currentFile].audioBuffer;
    else
      numBytes <<= 1;
    for (i = 0; i < sampleCount; i++)
    {
      if (bits16)
      {
        lSample = srcPtr[i * k];
        if (stereo)
          rSample = srcPtr[i * k + 1];
        else
          rSample = lSample;
      }
      else
      {
        lSample = ((unsigned short int)((char)files[currentFile].audioBuffer[i * k] + 128)) << 8;
        if (stereo)
          rSample = ((unsigned short int)((char)files[currentFile].audioBuffer[i * k + 1] + 128)) << 8;
        else
          rSample = lSample;
      }
      if (files[currentFile].audioFormat.nSamplesPerSec == 22050)
      {
        if (batch)
        {
          files[currentFile].audioBuffer1[j++] = lSample;
          files[currentFile].audioBuffer1[j++] = rSample;
          files[currentFile].audioBuffer1[j++] = lSample;
          files[currentFile].audioBuffer1[j++] = rSample;
        }
        else
        {
          audioBuffer1[j++] = lSample;
          audioBuffer1[j++] = rSample;
          audioBuffer1[j++] = lSample;
          audioBuffer1[j++] = rSample;
        }
      }
      else
      {
        if (batch)
        {
          files[currentFile].audioBuffer1[j++] = lSample;
          files[currentFile].audioBuffer1[j++] = rSample;
        }
        else
        {
          audioBuffer1[j++] = lSample;
          audioBuffer1[j++] = rSample;
        }
      }
    }
    if (files[currentFile].audioFormat.nSamplesPerSec == 22050)
      *bufferSize = numBytes <<= 1;
    else
      *bufferSize = numBytes;
    if (batch)
      *buffer = (char*)files[currentFile].audioBuffer1;
    else
      *buffer = (char*)audioBuffer1;
  }
  return bbErrNone;
}

int getVideo(unsigned int frameNum, unsigned int *bytesInRow, char **buffer)
{
  bool ret;
  int i, x, y, w, h;
  double xRatio, yRatio;
  char tmpStr[MAXPATH], *tmpPtr;
  DDSURFACEDESC ddsd;

  mainWindow->YieldTime();
  currentOPos = (int)frameNum;
  if (!mainWindow->SetRelPos())
    return bbInternalError1;

//  sprintf(tmpStr, "frame = %d, OFile = %d, relOPos = %d", frameNum, currentOFile, relOPos);
//  mainWindow->AddMessage(tmpStr);

  if (batch)
    *bytesInRow = files[currentOFile].mpegWidth << 2;
  else
    *bytesInRow = MPEGWidth << 2;

  if (files[currentOFile].aviFile)
  {
    if (mainWindow->GetFrame(currentOFile, relOPos))
      return bbInternalError2;

    memset(&ddsd, 0, sizeof(ddsd));
    ddsd.dwSize = sizeof(ddsd);
    if (files[currentOFile].pDDSurface->Lock(NULL, &ddsd, 0, NULL) != DD_OK)
      return bbInternalError4;
    ret = mainWindow->outputDib->LoadFromDD(ddsd);

    if (files[currentOFile].pDDSurface->Unlock(NULL) != S_OK)
      return bbInternalError5;
    if (!ret)
      return bbInternalError6;
  }
  else
  {
    if (fseek(files[currentOFile].fileList, 0, SEEK_SET))
      return bbInternalError7;
    for (i = 0; i <= relOPos; i++)
    {
      if (!fgets(tmpStr, MAXPATH, files[currentOFile].fileList))
        return bbInternalError8;
    }
    tmpPtr = strstr(tmpStr, "\n");
    if (tmpPtr)
      tmpPtr[0] = 0;
    if (!strstr(tmpStr, "\\"))
    {
      char tmpStr1[MAXPATH];
      strcpy(tmpStr1, tmpStr);
      strcpy(tmpStr, files[currentOFile].defListDir);
      strcat(tmpStr, tmpStr1);
    }
    if (!mainWindow->outputDib->LoadFile(tmpStr))
      return bbInternalError9;
    if (mainWindow->outputDib->BitsPerPixel != 32)
      if (!mainWindow->outputDib->ChangeDepth(32))
        return bbInternalError10;
  }

  if (files[currentOFile].deinterlace)
    mainWindow->outputDib->Deinterlace();

  if (files[currentOFile].invert)
    if (!mainWindow->outputDib->Invert())
      return bbInternalError11;

  if (files[currentOFile].cropW && files[currentOFile].cropH)
  {
    if (!mainWindow->outputDib->Crop(files[currentOFile].cropX,
                                     files[currentOFile].cropY,
                                     files[currentOFile].cropW,
                                     files[currentOFile].cropH))
      return bbInternalError12;
  }

  if (batch)
  {
    w = files[currentOFile].mpegWidth;
    h = files[currentOFile].mpegHeight;
  }
  else
  {
    w = MPEGWidth;
    h = MPEGHeight;
  }
  if ((mainWindow->outputDib->W == w) && (mainWindow->outputDib->H == h))
  {
    *buffer = (char *) mainWindow->outputDib->GetBits();
    return bbErrNone;
  }

  if (files[currentOFile].resize)
  {
    if (!mainWindow->outputDib->Rescale(w, h, w, h))
      return bbInternalError13;
    *buffer = (char *) mainWindow->outputDib->GetBits();
    return bbErrNone;
  }

  if (files[currentOFile].cropFrames)
  {
    if (!mainWindow->outputDib->Crop(0, 0, w, h))
      return bbInternalError14;
    *buffer = (char *) mainWindow->outputDib->GetBits();
    return bbErrNone;
  }

  xRatio = (double) w / (double) mainWindow->outputDib->W;
  yRatio = (double) h / (double) mainWindow->outputDib->H;
  if (xRatio < yRatio)
  {
    x = (int)ceil((double)mainWindow->outputDib->W * xRatio);
    y = (int)ceil((double)mainWindow->outputDib->H * xRatio);
  }
  else
  {
    x = (int)ceil((double)mainWindow->outputDib->W * yRatio);
    y = (int)ceil((double)mainWindow->outputDib->H * yRatio);
  }
  if (x > w)
    x = w;
  if (y > h)
    y = h;
  if (!mainWindow->outputDib->Rescale(x, y, w, h))
    return bbInternalError15;
  *buffer = (char *) mainWindow->outputDib->GetBits();
  return bbErrNone;
}


DEFINE_RESPONSE_TABLE1(TMainWindow, TWindow)
  EV_WM_PAINT,
  EV_WM_HSCROLL,
  EV_WM_VSCROLL,
  EV_WM_RBUTTONUP,
  EV_WM_RBUTTONDOWN,
  EV_COMMAND(CM_STARTCONVERSION, CmStartConversion),
  EV_COMMAND(CM_FILEOPEN2, CmFileOpen),
  EV_COMMAND(CM_FILEREMOVE, CmFileRemove),
  EV_COMMAND(CM_FILEUP, CmFileUp),
  EV_COMMAND(CM_FILEDOWN, CmFileDown),
  EV_COMMAND(CM_ABOUT, CmAbout),
  EV_COMMAND(CM_EXITAPP, CmExit),
  EV_COMMAND(IDC_LOADPROJECT, EvLoadProject),
  EV_COMMAND(IDC_SAVEPROJECT, EvSaveProject),
  EV_COMMAND(IDC_HELPBUTTON, EvHelp),
  EV_COMMAND(IDC_VIDEOSELECT, CmVideoOpen),
  EV_COMMAND(IDC_IPREVIEW, EvIPreview),
  EV_COMMAND(IDC_OPREVIEW, EvOPreview),
  EV_COMMAND(IDC_CROP, EvCropCheck),
  EV_COMMAND(IDC_DEINTERLACE, EvDeInterlace),
  EV_COMMAND(IDC_INVERT, EvInvert),
  EV_COMMAND(IDC_SHOWOUTPUT, EvShowOutput),
  EV_COMMAND(IDC_PROPORTIONAL, EvPropCheck),
  EV_COMMAND(IDC_RESIZE, EvResizeCheck),
  EV_COMMAND(CM_KEYRETURN, EvKeyReturn),
  EV_COMMAND(CM_KEYT, EvStartFrame),
  EV_COMMAND(CM_KEYN, EvEndFrame),
  EV_COMMAND(IDC_IPLAY, EvIPlay),
  EV_COMMAND(IDC_IPAUSE, EvIPause),
  EV_COMMAND(IDC_ISTOP, EvIStop),
  EV_COMMAND(IDC_OPLAY, EvOPlay),
  EV_COMMAND(IDC_OPAUSE, EvOPause),
  EV_COMMAND(IDC_OSTOP, EvOStop),
  EV_COMMAND(IDC_BATCH, EvBatch),
  EV_COMMAND(IDC_EDITFILTERS, EvEditFilters),
  EV_LBN_SELCHANGE(IDC_SOURCENAME, EvSourceChange),
  EV_EN_KILLFOCUS(IDC_STARTTEXT, EvStartKillFocus),
  EV_EN_KILLFOCUS(IDC_ENDTEXT, EvEndKillFocus),
  EV_EN_KILLFOCUS(IDC_ICURRENTTEXT, EvICurrentKillFocus),
  EV_EN_KILLFOCUS(IDC_OCURRENTTEXT, EvOCurrentKillFocus),
  EV_EN_KILLFOCUS(IDC_REPEATCOUNT, EvRepeatKillFocus),
  EV_EN_KILLFOCUS(IDC_CROPX, EvCropXKillFocus),
  EV_EN_KILLFOCUS(IDC_CROPY, EvCropYKillFocus),
  EV_EN_KILLFOCUS(IDC_CROPW, EvCropWKillFocus),
  EV_EN_KILLFOCUS(IDC_CROPH, EvCropHKillFocus),
  EV_EN_KILLFOCUS(IDC_MPEGWIDTH, EvMPEGWKillFocus),
  EV_EN_KILLFOCUS(IDC_MPEGHEIGHT, EvMPEGHKillFocus),
  EV_UDN_DELTAPOS(IDC_CROPXSCROLL, EvCropXBump),
  EV_UDN_DELTAPOS(IDC_CROPYSCROLL, EvCropYBump),
  EV_UDN_DELTAPOS(IDC_CROPWSCROLL, EvCropWBump),
  EV_UDN_DELTAPOS(IDC_CROPHSCROLL, EvCropHBump),
  EV_UDN_DELTAPOS(IDC_MPEGWSCROLL, EvMPEGWBump),
  EV_UDN_DELTAPOS(IDC_MPEGHSCROLL, EvMPEGHBump),
END_RESPONSE_TABLE;

TMainWindow::TMainWindow(TWindow *parent, TResId resId, TModule* module):
             TDialog(parent, resId, module)
{
  TWindow::Attr.AccelTable = IDC_ACCELTABLE;
  InputName = new TListBox(this, IDC_SOURCENAME);
  VideoName = new TEdit(this, IDC_VIDEONAME);
  ProjectName = new TEdit(this, IDC_PROJECTNAME);
  InputLBox = new TListBox(this, IDC_SOURCELBOX);
  StartButton = new TButton(this, CM_STARTCONVERSION);
  MPEGOpenButton = new TButton(this, IDC_VIDEOSELECT);
  StartText = new TEdit(this, IDC_STARTTEXT);
  EndText = new TEdit(this, IDC_ENDTEXT);
  IFirstText = new TStatic(this, IDC_IFIRSTTEXT);
  ICurrentText = new TEdit(this, IDC_ICURRENTTEXT);
  ILastText = new TStatic(this, IDC_ILASTTEXT);
  IVideoRect = new TStatic(this, IDC_IVIDEORECT);
  OFirstText = new TStatic(this, IDC_OFIRSTTEXT);
  OCurrentText = new TEdit(this, IDC_OCURRENTTEXT);
  OLastText = new TStatic(this, IDC_OLASTTEXT);
  OFileText = new TStatic(this, IDC_OFILENUM);
  OFrameText = new TStatic(this, IDC_OFRAMENUM);
  OVideoRect = new TStatic(this, IDC_OVIDEORECT);
  IVideoScroll = new TScrollBar(this, IDC_IVIDEOSCROLL);
  OVideoScroll = new TScrollBar(this, IDC_OVIDEOSCROLL);
  OFileScroll = new TUpDown(this, IDC_OFILEUPDOWN);
  AudioInfo = new TStatic(this, IDC_AUDIOINFO);
  RepeatText = new TEdit(this, IDC_REPEATCOUNT);
  RemoveButton = new TButton(this, CM_FILEREMOVE);
  UpButton = new TButton(this, CM_FILEUP);
  DownButton = new TButton(this, CM_FILEDOWN);
  SaveButton = new TButton(this, IDC_SAVEPROJECT);
  DeInterCheck = new TCheckBox(this, IDC_DEINTERLACE);
  Invert = new TCheckBox(this, IDC_INVERT);
  ShowOutput = new TCheckBox(this, IDC_SHOWOUTPUT);
  PropCheck = new TRadioButton(this, IDC_PROPORTIONAL);
  ResizeCheck = new TRadioButton(this, IDC_RESIZE);
  CropCheck = new TRadioButton(this, IDC_CROP);
  BatchCheck = new TCheckBox(this, IDC_BATCH);
  FilterCheck = new TCheckBox(this, IDC_EDITFILTERS);
  CropXEdit = new TEdit(this, IDC_CROPX);
  CropXScroll = new TUpDown(this, IDC_CROPXSCROLL, CropXEdit);
  CropYEdit = new TEdit(this, IDC_CROPY);
  CropYScroll = new TUpDown(this, IDC_CROPYSCROLL, CropYEdit);
  CropWEdit = new TEdit(this, IDC_CROPW);
  CropWScroll = new TUpDown(this, IDC_CROPWSCROLL, CropWEdit);
  CropHEdit = new TEdit(this, IDC_CROPH);
  CropHScroll = new TUpDown(this, IDC_CROPHSCROLL, CropHEdit);
  MPEGWEdit = new TEdit(this, IDC_MPEGWIDTH);
  MPEGWScroll = new TUpDown(this, IDC_MPEGWSCROLL, MPEGWEdit);
  MPEGHEdit = new TEdit(this, IDC_MPEGHEIGHT);
  MPEGHScroll = new TUpDown(this, IDC_MPEGHSCROLL, MPEGHEdit);
  IPlay = new TButton(this, IDC_IPLAY);
  IPause = new TButton(this, IDC_IPAUSE);
  IStop = new TButton(this, IDC_ISTOP);
  OPlay = new TButton(this, IDC_OPLAY);
  OPause = new TButton(this, IDC_OPAUSE);
  OStop = new TButton(this, IDC_OSTOP);
}

TMainWindow::~TMainWindow()
{
  while (fileCount > 0)
  {
    if (files[fileCount - 1].aviFile)
      CloseAVI(fileCount - 1);
    else
      CloseList(fileCount - 1);
    fileCount--;
  }
  if (iprevDib)
    delete iprevDib;
  if (oprevDib)
    delete oprevDib;
  if (outputDib)
    delete outputDib;

  if (bbShutdown)
    bbShutdown();
  if (dllPtr)
    FreeLibrary(dllPtr);
}

void TMainWindow::SetupWindow()
{
  TDialog::SetupWindow();

  currentIFile = -1;
  currentOFile = -1;
  totalFrames = 0;
  totalSamples = 0;
  samplesPerSec = 0;
  currentOPos = -1;
  relOPos = 0;
  iprevDib = NULL;
  oprevDib = NULL;
  outputDib = NULL;
  bbInit = NULL;
  bbMakeMPEG = NULL;
  bbShutdown = NULL;
  dllPtr = NULL;
  audioBuffer1 = NULL;
  gotRFirst = false;
  AbortDisplay = false;
  AbortOperation = false;
  AbortPreview = false;
  ShowAnimGIF = false;
  AVIAvail = 0;
  AudioAvail = 0;
  Previewing = false;
  OPreviewing = false;
  Encoding = false;
  LoadingFrame = false;
  showOutput = true;
  Playing = false;
  cancelDialog = NULL;
  strcpy(MPEGFilename, "");
  strcpy(curFilename, "");
  InputName->ClearList();
  fileCount = 0;
  MPEGWidth = 0;
  MPEGHeight = 0;
  LongestName = 0;
  VideoName->Clear();
  InputLBox->ClearList();
  LongestMessage = 0;
  memset(files, 0, sizeof(files));
  mainWindow = this;
  iprevRect.Set(IVideoRect->Attr.X, IVideoRect->Attr.Y,
                IVideoRect->Attr.X + IVideoRect->Attr.W,
                IVideoRect->Attr.Y + IVideoRect->Attr.H);
  oprevRect.Set(OVideoRect->Attr.X, OVideoRect->Attr.Y,
                OVideoRect->Attr.X + OVideoRect->Attr.W,
                OVideoRect->Attr.Y + OVideoRect->Attr.H);
  if (!CreatePrevDibs())
  {
    DisplayMBox("Could not create preview dibs.", "startup preview error");
    PostMessage(WM_CLOSE);
    return;
  }

  dllPtr = LoadLibrary("bbmpeg.dll");
  if (dllPtr == NULL)
  {
    char *buffer;

    FormatMessage(
      FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
      NULL, GetLastError(),
      MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
      (LPTSTR) &buffer, 0, NULL);

    // Display the string.
    MessageBox(buffer, "startup bbMPEG.dll error", MB_OK | MB_ICONERROR);

    // Free the buffer.
    LocalFree(buffer);

    PostMessage(WM_CLOSE);
    return;
  }

  bbInit = (bbMPEGInitEntry) GetProcAddress(dllPtr, "bbMPEGInit");
  if (bbInit == NULL)
  {
    DisplayMBox("Could not get init function address from bbMPEG.dll.", "startup bbMPEG.dll error");
    PostMessage(WM_CLOSE);
    return;
  }
  bbMakeMPEG = (bbMPEGMakeMPEGEntry) GetProcAddress(dllPtr, "bbMPEGMakeMPEG");
  if (bbMakeMPEG == NULL)
  {
    DisplayMBox("Could not get makempeg function address from bbMPEG.dll.", "startup bbMPEG.dll error");
    PostMessage(WM_CLOSE);
    return;
  }
  bbShutdown = (bbMPEGShutdownEntry) GetProcAddress(dllPtr, "bbMPEGShutdown");
  if (bbShutdown == NULL)
  {
    DisplayMBox("Could not get shutdown function address from bbMPEG.dll.", "startup bbMPEG.dll error");
    PostMessage(WM_CLOSE);
    return;
  }
  makeMPEGInfo.getVideo = getVideo;
  makeMPEGInfo.getAudio = getAudio;

  dllSetFocus = (bbMPEGSetFocusEntry) GetProcAddress(dllPtr, "bbMPEGSetFocus");
  if (dllSetFocus == NULL)
  {
    DisplayMBox("Could not get setfocus function address from bbMPEG.dll.", "startup bbMPEG.dll error");
    PostMessage(WM_CLOSE);
    return;
  }

  dllAppWindow = (bbMPEGAppWindowEntry) GetProcAddress(dllPtr, "bbMPEGAppWnd");
  if (dllAppWindow == NULL)
  {
    DisplayMBox("Could not get appWindow function address from bbMPEG.dll.", "startup bbMPEG.dll error");
    PostMessage(WM_CLOSE);
    return;
  }

  if (bbInit() != bbErrNone)
  {
    DisplayMBox("Could not initialize bbMPEG.dll.", "startup bbMPEG.dll error");
    PostMessage(WM_CLOSE);
    return;
  }
  PopupMenu.AppendMenu(MF_STRING, CM_KEYT, "Mark current frame as s&tarting frame");
  PopupMenu.AppendMenu(MF_STRING, CM_KEYN, "Mark current frame as e&nding frame");
  ProjectName->SetText("");
  IPause->EnableWindow(false);
  IStop->EnableWindow(false);
  OPause->EnableWindow(false);
  OStop->EnableWindow(false);
  if (batch)
    BatchCheck->Check();
  if (editFilters)
    FilterCheck->Check();
  DisplaySourceInfo();
  DisplayOutputInfo();
}

void TMainWindow::YieldTime()
{
  MSG msg;

  while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
  {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }
}

void TMainWindow::EvBatch()
{
  batch = (BatchCheck->GetCheck() == BF_CHECKED);
}

void TMainWindow::EvEditFilters()
{
  editFilters = (FilterCheck->GetCheck() == BF_CHECKED);
}

void TMainWindow::UpdateOPreview()
{
  if (showOutput)
    EvOPreview();
}

bool TMainWindow::CreatePrevDibs()
{
  iprevDib = new TPreviewDib(this, iprevRect, false);
  if (iprevDib)
  {
    oprevDib = new TPreviewDib(this, oprevRect, false);
    if (oprevDib)
    {
      outputDib = new TFullDib(this);
      if (outputDib)
        return true;
    }
  }
  return false;
}

void TMainWindow::EvIPlay()
{
  char tmpStr[10];
  unsigned int msCount;

  if (Playing)
  {
    Pause = true;
    PostMessage(WM_COMMAND, IDC_IPLAY);
    return;
  }
  Pause = false;
  Stop = false;
  Playing = true;
  DisplaySourceInfo();
  DisplayOutputInfo();
  IPause->EnableWindow(true);
  IStop->EnableWindow(true);
  StartButton->EnableWindow(false);
  while ((files[currentIFile].currentFrame <= files[currentIFile].lastFrame) &&
         (!Stop) && (!Pause))
  {
    msCount = GetTickCount() + (int)(1000.0 / files[currentIFile].frameRate);
    EvIPreview();
    files[currentIFile].currentFrame++;
    if (files[currentIFile].currentFrame <= files[currentIFile].lastFrame)
    {
      IVideoScroll->SetPosition(files[currentIFile].currentFrame);
      sprintf(tmpStr, "%d", files[currentIFile].currentFrame);
      ICurrentText->SetText(tmpStr);
    }
    YieldTime();
    while (msCount > GetTickCount())
      YieldTime();
  }
  if (!Pause)
  {
    files[currentIFile].currentFrame = files[currentIFile].firstFrame;
    IVideoScroll->SetPosition(files[currentIFile].currentFrame);
    sprintf(tmpStr, "%d", files[currentIFile].currentFrame);
    ICurrentText->SetText(tmpStr);
    EvIPreview();
  }
  else
    if (files[currentIFile].currentFrame > files[currentIFile].lastFrame)
      files[currentIFile].currentFrame = files[currentIFile].lastFrame;
  StartButton->EnableWindow(true);
  IPause->EnableWindow(false);
  IStop->EnableWindow(false);
  Playing = false;
  DisplaySourceInfo();
  DisplayOutputInfo();
}

void TMainWindow::EvIPause()
{
  Pause = true;
}

void TMainWindow::EvIStop()
{
  Stop = true;
}

void TMainWindow::EvOPlay()
{
  char tmpStr[10];
  unsigned int msCount;

  if (Playing)
  {
    Pause = true;
    PostMessage(WM_COMMAND, IDC_OPLAY);
    return;
  }
  Pause = false;
  Stop = false;
  Playing = true;
  DisplaySourceInfo();
  DisplayOutputInfo();
  OPause->EnableWindow(true);
  OStop->EnableWindow(true);
  StartButton->EnableWindow(false);
  while ((currentOPos < totalFrames) &&
         (!Stop) && (!Pause))
  {
    msCount = GetTickCount() + (int)(1000.0 / files[currentOFile].frameRate);
    EvOPreview();
    currentOPos++;
    if (currentOPos < totalFrames)
    {
      if (!SetRelPos())
      {
        Stop = true;
        break;
      }
      OVideoScroll->SetPosition(currentOPos);
      sprintf(tmpStr, "%d", currentOFile + 1);
      OFileText->SetText(tmpStr);
      sprintf(tmpStr, "%d", relOPos);
      OFrameText->SetText(tmpStr);
      sprintf(tmpStr, "%d", currentOPos);
      OCurrentText->SetText(tmpStr);
    }
    YieldTime();
    while (msCount > GetTickCount())
      YieldTime();
  }
  if (!Pause)
  {
    currentOPos = 0;
    SetRelPos();
    OVideoScroll->SetPosition(currentOPos);
    sprintf(tmpStr, "%d", currentOFile + 1);
    OFileText->SetText(tmpStr);
    sprintf(tmpStr, "%d", relOPos);
    OFrameText->SetText(tmpStr);
    sprintf(tmpStr, "%d", currentOPos);
    OCurrentText->SetText(tmpStr);
    EvOPreview();
  }
  else
    if (currentOPos >= totalFrames)
      currentOPos = totalFrames - 1;
  StartButton->EnableWindow(true);
  OPause->EnableWindow(false);
  OStop->EnableWindow(false);
  Playing = false;
  DisplaySourceInfo();
  DisplayOutputInfo();
}

void TMainWindow::EvOPause()
{
  Pause = true;
}

void TMainWindow::EvOStop()
{
  Stop = true;
}

void TMainWindow::EvIPreview()
{
  bool ret;
  int i, frameNum;
  char tmpStr[MAXPATH], *tmpPtr;
  DDSURFACEDESC ddsd;

  if (fileCount)
  {
    if (Previewing || LoadingFrame)
      return;
    Previewing = true;
    frameNum = IVideoScroll->GetPosition();
    if (files[currentIFile].aviFile)
    {
      i = GetFrame(currentIFile, frameNum);
      if (i)
      {
        if (i == 2)
          DisplayMBox("Unable to seek IMultiMediaStream", "IPreview display error");
        if (i > 2)
          DisplayMBox("Unable to update IDirectDrawSample", "IPreview display error");
        Previewing = false;
        RemoveFile(currentIFile);
        return;
      }
      memset(&ddsd, 0, sizeof(ddsd));
      ddsd.dwSize = sizeof(ddsd);
      if (files[currentIFile].pDDSurface->Lock(NULL, &ddsd, 0, NULL) != DD_OK)
      {
        DisplayMBox("Unable to lock IDirectDrawSurface", "IPreview display error");
        Previewing = false;
        RemoveFile(currentIFile);
        return;
      }
      ret = iprevDib->LoadFromDD(ddsd);
      if (files[currentIFile].pDDSurface->Unlock(NULL) != S_OK)
      {
        DisplayMBox("Unable to unlock IDirectDrawSurface", "IPreview display error");
        Previewing = false;
        RemoveFile(currentIFile);
        return;
      }
      if (!ret)
      {
        DisplayMBox(iprevDib->ErrStr, "display error");
        RemoveFile(currentIFile);
      }
      Previewing = false;
    }
    else
    {
      if (fseek(files[currentIFile].fileList, 0, SEEK_SET))
      {
        sprintf(tmpStr, "Could not find beginning of file %s.", files[currentIFile].fileName);
        DisplayMBox(tmpStr, "IPreview file list error");
        Previewing = false;
        RemoveFile(currentIFile);
        return;
      }
      for (i = 0; i <= frameNum; i++)
      {
        if (!fgets(tmpStr, MAXPATH, files[currentIFile].fileList))
        {
          sprintf(tmpStr, "Could not get frame # %d from file %s.", frameNum, files[currentIFile].fileName);
          DisplayMBox(tmpStr, "IPreview file list error");
          Previewing = false;
          RemoveFile(currentIFile);
          return;
        }
      }
      tmpPtr = strstr(tmpStr, "\n");
      if (tmpPtr)
        tmpPtr[0] = 0;
      if (!strstr(tmpStr, "\\"))
      {
        char tmpStr1[MAXPATH];
        strcpy(tmpStr1, tmpStr);
        strcpy(tmpStr, files[currentIFile].defListDir);
        strcat(tmpStr, tmpStr1);
      }
      if (!iprevDib->LoadFile(tmpStr))
      {
        DisplayMBox(iprevDib->ErrStr, "IPreview file list error");
        Previewing = false;
        RemoveFile(currentIFile);
        return;
      }
      files[currentIFile].bitsPerPixel = iprevDib->picBitsPerPixel;
      files[currentIFile].ddsd.dwWidth = iprevDib->picWidth;
      files[currentIFile].ddsd.dwHeight = iprevDib->picHeight;
      strcpy(curFilename, tmpStr);
      strlwr(curFilename);
      DisplayFileInfo();
      Previewing = false;
    }
  }
  else
  {
    iprevDib->ClearDib();
    PaintIPreview();
  }
}

void TMainWindow::EvOPreview()
{
  bool ret;
  int i, x, y, w, h;
  double xRatio, yRatio;
  char tmpStr[MAXPATH], *tmpPtr;
  DDSURFACEDESC ddsd;

  if (fileCount)
  {
    if (OPreviewing || LoadingFrame)
      return;
    OPreviewing = true;
    if (files[currentOFile].aviFile)
    {
      i = GetFrame(currentOFile, relOPos);
      if (i)
      {
        if (i == 2)
          DisplayMBox("Unable to seek IMultiMediaStream", "OPreview display error");
        if (i > 2)
          DisplayMBox("Unable to update IDirectDrawSample", "OPreview display error");
        OPreviewing = false;
        RemoveFile(currentOFile);
        return;
      }

      memset(&ddsd, 0, sizeof(ddsd));
      ddsd.dwSize = sizeof(ddsd);
      if (files[currentOFile].pDDSurface->Lock(NULL, &ddsd, 0, NULL) != DD_OK)
      {
        DisplayMBox("Unable to lock IDirectDrawSurface", "OPreview display error");
        OPreviewing = false;
        RemoveFile(currentOFile);
        return;
      }
      if (showOutput)
        ret = outputDib->LoadFromDD(ddsd);
      else
        ret = oprevDib->LoadFromDD(ddsd);
      if (files[currentOFile].pDDSurface->Unlock(NULL) != S_OK)
      {
        DisplayMBox("Unable to unlock IDirectDrawSurface", "OPreview display error");
        OPreviewing = false;
        RemoveFile(currentOFile);
        return;
      }
      if (!ret)
      {
        if (showOutput)
          DisplayMBox(outputDib->ErrStr, "OPreview display error");
        else
          DisplayMBox(oprevDib->ErrStr, "OPreview display error");
        OPreviewing = false;
        RemoveFile(currentOFile);
        return;
      }
    }
    else
    {
      if (fseek(files[currentOFile].fileList, 0, SEEK_SET))
      {
        sprintf(tmpStr, "Could not find beginning of file %s.", files[currentOFile].fileName);
        DisplayMBox(tmpStr, "OPreview file list error");
        OPreviewing = false;
        RemoveFile(currentOFile);
        return;
      }
      for (i = 0; i <= relOPos; i++)
      {
        if (!fgets(tmpStr, MAXPATH, files[currentOFile].fileList))
        {
          sprintf(tmpStr, "Could not get frame # %d from file %s.", relOPos, files[currentOFile].fileName);
          DisplayMBox(tmpStr, "OPreview file list error");
          OPreviewing = false;
          RemoveFile(currentOFile);
          return;
        }
      }
      tmpPtr = strstr(tmpStr, "\n");
      if (tmpPtr)
        tmpPtr[0] = 0;
      if (!strstr(tmpStr, "\\"))
      {
        char tmpStr1[MAXPATH];
        strcpy(tmpStr1, tmpStr);
        strcpy(tmpStr, files[currentOFile].defListDir);
        strcat(tmpStr, tmpStr1);
      }
      if (showOutput)
      {
        if (!outputDib->LoadFile(tmpStr))
        {
          DisplayMBox(outputDib->ErrStr, "OPreview file list error");
          OPreviewing = false;
          RemoveFile(currentOFile);
          return;
        }
      }
      else
      {
        if (!oprevDib->LoadFile(tmpStr))
        {
          DisplayMBox(oprevDib->ErrStr, "OPreview file list error");
          OPreviewing = false;
          RemoveFile(currentOFile);
          return;
        }
      }
    }
    if (showOutput)
    {
      if (outputDib->BitsPerPixel != 32)
        if (!outputDib->ChangeDepth(32))
        {
          DisplayMBox(outputDib->ErrStr, "OPreview change color depth error");
          OPreviewing = false;
          RemoveFile(currentOFile);
          return;
        }

      if (files[currentOFile].deinterlace)
        outputDib->Deinterlace();

      if (files[currentOFile].invert)
        if (!outputDib->Invert())
        {
          DisplayMBox(outputDib->ErrStr, "OPreview invert error");
          OPreviewing = false;
          RemoveFile(currentOFile);
          return;
        }

      if (files[currentOFile].cropW && files[currentOFile].cropH)
      {
        if (!outputDib->Crop(files[currentOFile].cropX,
                             files[currentOFile].cropY,
                             files[currentOFile].cropW,
                             files[currentOFile].cropH))
        {
          DisplayMBox(outputDib->ErrStr, "OPreview crop error");
          OPreviewing = false;
          RemoveFile(currentOFile);
          return;
        }
      }

      if (batch)
      {
        w = files[currentOFile].mpegWidth;
        h = files[currentOFile].mpegHeight;
      }
      else
      {
        w = MPEGWidth;
        h = MPEGHeight;
      }
      if ((outputDib->W != w) || (outputDib->H != h))
      {
        if (files[currentOFile].resize)
        {
          if (!outputDib->Rescale(w, h, w, h))
          {
            DisplayMBox(outputDib->ErrStr, "OPreview rescale error");
            OPreviewing = false;
            RemoveFile(currentOFile);
          }
        }
        else
          if (files[currentOFile].cropFrames)
          {
            if (!outputDib->Crop(0, 0, w, h))
            {
              DisplayMBox(outputDib->ErrStr, "OPreview crop error");
              OPreviewing = false;
              RemoveFile(currentOFile);
            }
          }
          else
          {
            xRatio = (double) w / (double) outputDib->W;
            yRatio = (double) h / (double) outputDib->H;
            if (xRatio < yRatio)
            {
              x = (int)(outputDib->W * xRatio);
              y = (int)(outputDib->H * xRatio);
            }
            else
            {
              x = (int)(outputDib->W * yRatio);
              y = (int)(outputDib->H * yRatio);
            }
            if (x > w)
              x = w;
            if (y > h)
              y = h;
            if (!outputDib->Rescale(x, y, w, h))
            {
              DisplayMBox(outputDib->ErrStr, "OPreview rescale error");
              OPreviewing = false;
              RemoveFile(currentOFile);
            }
          }
      }
      if (!oprevDib->LoadFromDib(outputDib))
      {
        DisplayMBox(oprevDib->ErrStr, "OPreview preview error");
        OPreviewing = false;
        RemoveFile(currentOFile);
        return;
      }
      if (!Playing)
      {
        oprevDib->DrawBorder();
        PaintOPreview();
      }
    }
    OPreviewing = false;
  }
  else
  {
    oprevDib->ClearDib();
    PaintOPreview();
  }
}

void TMainWindow::EvPaint()
{
  TDialog::EvPaint();
  PaintIPreview();
  PaintOPreview();
}

void TMainWindow::PaintIPreview()
{
  TClientDC dc(HWindow);

  ::SetDIBitsToDevice(dc.GetHDC(), iprevRect.left, iprevRect.top,
                      iprevRect.Width(), iprevRect.Height(),
                      0, 0, 0, iprevRect.Height(),
                      (void *) iprevDib->GetBits(),
                      (BITMAPINFO far*) iprevDib->GetInfo(),
                      iprevDib->Usage());
}

void TMainWindow::PaintOPreview()
{
  TClientDC dc(HWindow);

  ::SetDIBitsToDevice(dc.GetHDC(), oprevRect.left, oprevRect.top,
                      oprevRect.Width(), oprevRect.Height(),
                      0, 0, 0, oprevRect.Height(),
                      (void *) oprevDib->GetBits(),
                      (BITMAPINFO far*) oprevDib->GetInfo(),
                      oprevDib->Usage());
}


void TMainWindow::EvCropXKillFocus()
{
  char tmpStr[80];
  int i;

  CropXEdit->GetText(tmpStr, 80);
  if ((sscanf(tmpStr, "%d", &i) != 1) || (i < 0) || (i > 9999))
  {
    DisplayMBox("Left crop value range is (0 .. 9999).", "invalid entry");
    sprintf(tmpStr, "%d", files[currentIFile].cropX);
    CropXEdit->SetText(tmpStr);
  }
  else
  {
    if (i != files[currentIFile].cropX)
    {
      if (i > files[currentIFile].ddsd.dwWidth)
        DisplayMBox("Warning, crop left value is greater than width of frame!", "crop left warning");
      files[currentIFile].cropX = i;
      UpdateOPreview();
    }
  }
}

void TMainWindow::EvCropYKillFocus()
{
  char tmpStr[80];
  int i;

  CropYEdit->GetText(tmpStr, 80);
  if ((sscanf(tmpStr, "%d", &i) != 1) || (i < 0) || (i > 9999))
  {
    DisplayMBox("Top crop value range is (0 .. 9999).", "invalid entry");
    sprintf(tmpStr, "%d", files[currentIFile].cropY);
    CropYEdit->SetText(tmpStr);
  }
  else
  {
    if (i != files[currentIFile].cropY)
    {
      if (i > files[currentIFile].ddsd.dwHeight)
        DisplayMBox("Warning, crop top value is greater than height of frame!", "crop top warning");
      files[currentIFile].cropY = i;
      UpdateOPreview();
    }
  }
}

void TMainWindow::EvCropWKillFocus()
{
  char tmpStr[80];
  int i;

  CropWEdit->GetText(tmpStr, 80);
  if ((sscanf(tmpStr, "%d", &i) != 1) || (i < 0) || (i > 9999))
  {
    DisplayMBox("Crop width value range is (0 .. 9999).", "invalid entry");
    sprintf(tmpStr, "%d", files[currentIFile].cropW);
    CropWEdit->SetText(tmpStr);
  }
  else
  {
    if (i != files[currentIFile].cropW)
    {
      if (files[currentIFile].cropX + i > files[currentIFile].ddsd.dwWidth)
        DisplayMBox("Warning, crop left plus width is greater than width of frame!", "crop width warning");
      files[currentIFile].cropW = i;
      UpdateOPreview();
    }
  }
}

void TMainWindow::EvCropHKillFocus()
{
  char tmpStr[80];
  int i;

  CropHEdit->GetText(tmpStr, 80);
  if ((sscanf(tmpStr, "%d", &i) != 1) || (i < 0) || (i > 9999))
  {
    DisplayMBox("Crop height value range is (0 .. 9999).", "invalid entry");
    sprintf(tmpStr, "%d", files[currentIFile].cropH);
    CropHEdit->SetText(tmpStr);
  }
  else
  {
    if (i != files[currentIFile].cropH)
    {
      if (files[currentIFile].cropY + i > files[currentIFile].ddsd.dwHeight)
        DisplayMBox("Warning, crop top plus height is greater than height of frame!", "crop top warning");
      files[currentIFile].cropH = i;
      UpdateOPreview();
    }
  }
}

void TMainWindow::EvMPEGWKillFocus()
{
  char tmpStr[80];
  int i;

  MPEGWEdit->GetText(tmpStr, 80);
  if ((sscanf(tmpStr, "%d", &i) != 1) || (i < 2) || (i > 1920))
  {
    DisplayMBox("MPEG width range is (2 .. 1920).", "invalid entry");
    if (batch)
      sprintf(tmpStr, "%d", files[currentOFile].mpegWidth);
    else
      sprintf(tmpStr, "%d", MPEGWidth);
    MPEGWEdit->SetText(tmpStr);
  }
  else
  {
    if (batch)
      files[currentOFile].mpegWidth = i;
    else
      MPEGWidth = i;
    oprevDib->ClearDib();
    EvOPreview();
  }
}

void TMainWindow::EvMPEGHKillFocus()
{
  char tmpStr[80];
  int i;

  MPEGHEdit->GetText(tmpStr, 80);
  if ((sscanf(tmpStr, "%d", &i) != 1) || (i < 2) || (i > 1152))
  {
    DisplayMBox("MPEG height range is (2 .. 1152).", "invalid entry");
    sprintf(tmpStr, "%d", MPEGHeight);
    MPEGHEdit->SetText(tmpStr);
  }
  else
  {
    if (batch)
      files[currentOFile].mpegHeight = i;
    else
      MPEGHeight = i;
    oprevDib->ClearDib();
    EvOPreview();
  }
}

bool TMainWindow::EvCropXBump(TNmUpDown& not)
{
  int i, j, k;

  k = not.iPos + not.iDelta;
  CropXScroll->GetRange(i, j);
  if ((k >= i) && (k <= j))
  {
    files[currentIFile].cropX = k;
    UpdateOPreview();
  }
  return false;
}

bool TMainWindow::EvCropYBump(TNmUpDown& not)
{
  int i, j, k;

  k = not.iPos + not.iDelta;
  CropYScroll->GetRange(i, j);
  if ((k >= i) && (k <= j))
  {
    files[currentIFile].cropY = k;
    UpdateOPreview();
  }
  return false;
}

bool TMainWindow::EvCropWBump(TNmUpDown& not)
{
  int i, j, k;

  k = not.iPos + not.iDelta;
  CropWScroll->GetRange(i, j);
  if ((k >= i) && (k <= j))
  {
    files[currentIFile].cropW = k;
    UpdateOPreview();
  }
  return false;
}

bool TMainWindow::EvCropHBump(TNmUpDown& not)
{
  int i, j, k;

  k = not.iPos + not.iDelta;
  CropHScroll->GetRange(i, j);
  if ((k >= i) && (k <= j))
  {
    files[currentIFile].cropH = k;
    UpdateOPreview();
  }
  return false;
}

bool TMainWindow::EvMPEGWBump(TNmUpDown& not)
{
  int i, j, k;

  k = not.iPos + not.iDelta;
  MPEGWScroll->GetRange(i, j);
  if ((k >= i) && (k <= j))
  {
    if (batch)
      files[currentOFile].mpegWidth = k;
    else
      MPEGWidth = k;
    oprevDib->ClearDib();
    EvOPreview();
  }
  return false;
}

bool TMainWindow::EvMPEGHBump(TNmUpDown& not)
{
  int i, j, k;

  k = not.iPos + not.iDelta;
  MPEGHScroll->GetRange(i, j);
  if ((k >= i) && (k <= j))
  {
    if (batch)
      files[currentOFile].mpegHeight = k;
    else
      MPEGHeight = k;
    oprevDib->ClearDib();
    EvOPreview();
  }
  return false;
}

void TMainWindow::EvCropCheck()
{
  files[currentIFile].cropFrames = CropCheck->GetCheck() == BF_CHECKED;
  if (files[currentIFile].cropFrames)
  {
    files[currentIFile].resize = false;
    files[currentIFile].propSize = false;
  }
  DisplaySourceInfo();
  UpdateOPreview();
}

void TMainWindow::EvPropCheck()
{
  files[currentIFile].propSize = PropCheck->GetCheck() == BF_CHECKED;
  if (files[currentIFile].propSize)
  {
    files[currentIFile].cropFrames = false;
    files[currentIFile].resize = false;
  }
  DisplaySourceInfo();
  UpdateOPreview();
}

void TMainWindow::EvResizeCheck()
{
  files[currentIFile].resize = ResizeCheck->GetCheck() == BF_CHECKED;
  if (files[currentIFile].resize)
  {
    files[currentIFile].cropFrames = false;
    files[currentIFile].propSize = false;
  }
  DisplaySourceInfo();
  UpdateOPreview();
}

void TMainWindow::EvDeInterlace()
{
  files[currentIFile].deinterlace = DeInterCheck->GetCheck() == BF_CHECKED;
  UpdateOPreview();
}

void TMainWindow::EvInvert()
{
  files[currentIFile].invert = Invert->GetCheck() == BF_CHECKED;
  UpdateOPreview();
}

void TMainWindow::EvShowOutput()
{
  showOutput = ShowOutput->GetCheck() == BF_CHECKED;
  oprevDib->ClearDib();
  EvOPreview();
}

void TMainWindow::EvSourceChange()
{
  int currentFile;

  if (fileCount)
  {
    files[currentIFile].currentFrame = IVideoScroll->GetPosition();
    currentFile = InputName->GetSelIndex();
    if (currentFile == currentIFile)
      return;
    if (batch)
    {
      CloseFile(currentIFile);
      if (!OpenFile(currentFile))
      {
        RemoveFile(currentFile);
        DisplayOutputInfo();
        DisplaySourceInfo();
        DisplayFileInfo();
        return;
      }
      currentOFile = currentFile;
      DisplayOutputInfo();
    }
    else
    {
      if (currentFile != currentOFile)
      {
        if (!OpenFile(currentFile))
        {
          RemoveFile(currentFile);
          DisplayOutputInfo();
          DisplaySourceInfo();
          DisplayFileInfo();
          return;
        }
      }
      if (currentIFile != currentOFile)
        CloseFile(currentIFile);
    }
    currentIFile = currentFile;
    DisplaySourceInfo();
    DisplayFileInfo();
  }
}

void TMainWindow::DisplaySourceInfo()
{
  char tmpStr[10];
  int i;
  bool gotFiles = fileCount && !Playing;

  if (fileCount)
  {
    sprintf(tmpStr, "%d", files[currentIFile].firstFrame);
    IFirstText->SetText(tmpStr);
    sprintf(tmpStr, "%d", files[currentIFile].currentFrame);
    ICurrentText->SetText(tmpStr);
    sprintf(tmpStr, "%d", files[currentIFile].lastFrame);
    ILastText->SetText(tmpStr);

    sprintf(tmpStr, "%d", files[currentIFile].startFrame);
    StartText->SetText(tmpStr);
    sprintf(tmpStr, "%d", files[currentIFile].endFrame);
    EndText->SetText(tmpStr);
    sprintf(tmpStr, "%d", files[currentIFile].repeatCount - 1);
    RepeatText->SetText(tmpStr);

    i = files[currentIFile].numFrames / 20;
    if (!i)
      i = 1;

    IVideoScroll->SetRange(files[currentIFile].firstFrame, files[currentIFile].lastFrame + i - 1);
    IVideoScroll->SetLineMagnitude(1);
    IVideoScroll->SetPageMagnitude(i);
    IVideoScroll->SetPosition(files[currentIFile].currentFrame);

    sprintf(tmpStr, "%d", files[currentIFile].cropX);
    CropXEdit->SetText(tmpStr);
    CropXScroll->SetRange(0, 9999);
    CropXScroll->SetPos(files[currentIFile].cropX);
    sprintf(tmpStr, "%d", files[currentIFile].cropY);
    CropYEdit->SetText(tmpStr);
    CropYScroll->SetRange(0, 9999);
    CropYScroll->SetPos(files[currentIFile].cropY);

    sprintf(tmpStr, "%d", files[currentIFile].cropW);
    CropWEdit->SetText(tmpStr);
    CropWScroll->SetRange(0, 9999);
    CropWScroll->SetPos(files[currentIFile].cropW);
    sprintf(tmpStr, "%d", files[currentIFile].cropH);
    CropHEdit->SetText(tmpStr);
    CropHScroll->SetRange(0, 9999);
    CropHScroll->SetPos(files[currentIFile].cropH);

    if (files[currentIFile].cropFrames)
      CropCheck->Check();
    else
      CropCheck->Uncheck();

    if (files[currentIFile].resize)
      ResizeCheck->Check();
    else
      ResizeCheck->Uncheck();

    if (files[currentIFile].propSize)
      PropCheck->Check();
    else
      PropCheck->Uncheck();

    if (files[currentIFile].deinterlace)
      DeInterCheck->Check();
    else
      DeInterCheck->Uncheck();

    if (files[currentIFile].invert)
      Invert->Check();
    else
      Invert->Uncheck();
    BatchCheck->EnableWindow(false);
  }
  else
  {
    BatchCheck->EnableWindow(true);
    IFirstText->SetText("0");
    ICurrentText->SetText("0");
    StartText->SetText("0");
    EndText->SetText("0");
    ILastText->SetText("0");
    RepeatText->SetText("0");

    CropXEdit->SetText("0");
    CropXScroll->SetRange(0, 0);
    CropXScroll->SetPos(0);
    CropYEdit->SetText("0");
    CropYScroll->SetRange(0, 0);
    CropYScroll->SetPos(0);
    CropWEdit->SetText("0");
    CropWScroll->SetRange(0, 0);
    CropWScroll->SetPos(0);
    CropHEdit->SetText("0");
    CropHScroll->SetRange(0, 0);
    CropHScroll->SetPos(0);
    CropCheck->Uncheck();
    ResizeCheck->Uncheck();
    PropCheck->Uncheck();

    IVideoScroll->SetRange(0, 0);
    IVideoScroll->SetPosition(0);

    InputLBox->ClearList();
    LongestMessage = 0;
    DeInterCheck->Uncheck();
    Invert->Uncheck();
  }
  SaveButton->EnableWindow(gotFiles);
  RemoveButton->EnableWindow(gotFiles);
  UpDownButtons();
  IVideoScroll->EnableWindow(gotFiles);
  EndText->EnableWindow(gotFiles);
  StartText->EnableWindow(gotFiles);
  IFirstText->EnableWindow(gotFiles);
  ICurrentText->EnableWindow(gotFiles);
  ILastText->EnableWindow(gotFiles);
  RepeatText->EnableWindow(gotFiles);
  DeInterCheck->EnableWindow(gotFiles);
  Invert->EnableWindow(gotFiles);
  CropXEdit->EnableWindow(gotFiles);
  CropXScroll->EnableWindow(gotFiles);
  CropYEdit->EnableWindow(gotFiles);
  CropYScroll->EnableWindow(gotFiles);
  CropWEdit->EnableWindow(gotFiles);
  CropWScroll->EnableWindow(gotFiles);
  CropHEdit->EnableWindow(gotFiles);
  CropHScroll->EnableWindow(gotFiles);
  CropCheck->EnableWindow(gotFiles);
  ResizeCheck->EnableWindow(gotFiles);
  PropCheck->EnableWindow(gotFiles);
  IPlay->EnableWindow(gotFiles);
  if (!Playing)
    EvIPreview();
}

void TMainWindow::UpDownButtons()
{
  if (batch)
  {
    UpButton->EnableWindow(false);
    DownButton->EnableWindow(false);
    return;
  }
  if (!Playing)
  {
    UpButton->EnableWindow((fileCount > 1) && (currentIFile != 0));
    DownButton->EnableWindow((fileCount > 1) && (currentIFile != InputName->GetCount() - 1));
  }
  else
  {
    UpButton->EnableWindow(false);
    DownButton->EnableWindow(false);
  }
}

void TMainWindow::DisplayOutputInfo()
{
  int i, w, h;
  char tmpStr[80];
  bool enable;

  if (!Playing)
  {
    totalFrames = 0;
    totalSamples = 0;
    CheckOutputAudio();
    if (OutputAudio)
    {
      sprintf(tmpStr, "Audio: %.01f kHz, 16 bit, stereo", (double)samplesPerSec / 1000.0);
      AudioInfo->SetText(tmpStr);
    }
    else
      AudioInfo->SetText("Audio: none");
    if (fileCount)
    {
      if (batch)
      {
        totalFrames = files[currentOFile].numFramesUsed;
        totalSamples = files[currentOFile].numSamplesUsed;
      }
      else
      {
        for (i = 0; i < fileCount; i++)
        {
          totalFrames += files[i].numFramesUsed;
          totalSamples += files[i].numSamplesUsed;
        }
      }
      if (!SetRelPos())
        return;
      sprintf(tmpStr, "%d", currentOFile + 1);
      OFileText->SetText(tmpStr);
      sprintf(tmpStr, "%d", relOPos);
      OFrameText->SetText(tmpStr);
      sprintf(tmpStr, "%d", currentOPos);
      OCurrentText->SetText(tmpStr);
      sprintf(tmpStr, "%d", totalFrames - 1);
      OLastText->SetText(tmpStr);
      if (showOutput)
        ShowOutput->Check();
      else
        ShowOutput->Uncheck();

      i = totalFrames / 20;
      if (!i)
        i = 1;
      OVideoScroll->SetRange(0, totalFrames - 1 + i - 1);
      OVideoScroll->SetLineMagnitude(1);
      OVideoScroll->SetPageMagnitude(i);
      OVideoScroll->SetPosition(currentOPos);
      OFileScroll->SetRange(0, fileCount - 1);
      OFileScroll->SetPos(currentOFile);

      if (batch)
      {
        w = files[currentOFile].mpegWidth;
        h = files[currentOFile].mpegHeight;
      }
      else
      {
        w = MPEGWidth;
        h = MPEGHeight;
      }
      sprintf(tmpStr, "%d", w);
      MPEGWEdit->SetText(tmpStr);
      MPEGWScroll->SetRange(2, 1920);
      MPEGWScroll->SetPos(w);
      sprintf(tmpStr, "%d", h);
      MPEGHEdit->SetText(tmpStr);
      MPEGHScroll->SetRange(2, 1152);
      MPEGHScroll->SetPos(h);
    }
    else
    {
      OCurrentText->SetText("0");
      OLastText->SetText("0");
      OFileText->SetText("0");
      OFrameText->SetText("0");
      ShowOutput->Uncheck();

      OVideoScroll->SetRange(0, 0);
      OVideoScroll->SetPosition(0);

      OFileScroll->SetRange(0, 0);
      OFileScroll->SetPos(0);

      MPEGWEdit->SetText("0");
      MPEGWScroll->SetRange(0, 0);
      MPEGWScroll->SetPos(0);
      MPEGHEdit->SetText("0");
      MPEGHScroll->SetRange(0, 0);
      MPEGHScroll->SetPos(0);
    }
  }

  if ((fileCount) && (!Playing))
  {
    MPEGOpenButton->EnableWindow(true);
    if (batch)
      VideoName->SetText(files[currentOFile].mpegFilename);
    else
      VideoName->SetText(MPEGFilename);
    VideoName->EnableWindow(true);
  }
  else
  {
    MPEGOpenButton->EnableWindow(false);
    if (!Playing)
      VideoName->SetText("");
    VideoName->EnableWindow(false);
  }

  enable = (fileCount) && (!Playing);
  OVideoScroll->EnableWindow(enable);
  OFirstText->EnableWindow(enable);
  OCurrentText->EnableWindow(enable);
  OLastText->EnableWindow(enable);
  OFileText->EnableWindow(enable);
  OFrameText->EnableWindow(enable);
  if (batch)
    OFileScroll->EnableWindow(false);
  else
    OFileScroll->EnableWindow(enable && (fileCount > 1));
  ShowOutput->EnableWindow(enable);
  MPEGWEdit->EnableWindow(enable);
  MPEGWScroll->EnableWindow(enable);
  MPEGHEdit->EnableWindow(enable);
  MPEGHScroll->EnableWindow(enable);
  OPlay->EnableWindow(enable);
  if (!Playing)
    EvOPreview();
}

void TMainWindow::CheckOutputAudio()
{
  int i;

  OutputAudio = false;
  if (!fileCount || !AudioAvail)
    return;
  if (batch)
  {
    if (!files[currentOFile].AudioPresent)
      return;
    samplesPerSec = files[currentOFile].samplesPerSec;
    if ((samplesPerSec != 32000) && (samplesPerSec != 44100) && (samplesPerSec != 48000))
      return;
    OutputAudio = true;
    return;
  }

  if ((samplesPerSec != 32000) && (samplesPerSec != 44100) && (samplesPerSec != 48000))
    return;
  for (i = 0; i < fileCount; i++)
  {
    if (files[i].AudioPresent)
    {
      if (samplesPerSec != files[i].audioFormat.nSamplesPerSec)
      {
        if (samplesPerSec != 44100)
          return;
        if (files[i].audioFormat.nSamplesPerSec != 22050)
          return;
      }
    }
  }
  OutputAudio = true;
}

void TMainWindow::EvHScroll(uint scrollCode, uint thumbPos, THandle hWndCtl)
{
  int i;
  char tmpStr[20];

  TDialog::EvHScroll(scrollCode, thumbPos, hWndCtl);

  if ((scrollCode == SB_ENDSCROLL) && (!Playing))
  {
    if (hWndCtl == IVideoScroll->HWindow)
    {
      i = IVideoScroll->GetPosition();
      sprintf(tmpStr, "%d", i);
      ICurrentText->SetText(tmpStr);
      files[currentIFile].currentFrame = i;
      EvIPreview();
    }
    else
      if (hWndCtl == OVideoScroll->HWindow)
      {
        i = OVideoScroll->GetPosition();
        currentOPos = i;
        if (!SetRelPos())
          return;
        sprintf(tmpStr, "%d", i);
        OCurrentText->SetText(tmpStr);
        sprintf(tmpStr, "%d", currentOFile + 1);
        OFileText->SetText(tmpStr);
        sprintf(tmpStr, "%d", relOPos);
        OFrameText->SetText(tmpStr);
        EvOPreview();
      }
  }
}

void TMainWindow::EvVScroll(uint scrollCode, uint thumbPos, THandle hWndCtl)
{
  int i, pos;

  TDialog::EvVScroll(scrollCode, thumbPos, hWndCtl);
  if (scrollCode == SB_ENDSCROLL)
  {
    if (hWndCtl == OFileScroll->HWindow)
    {
      pos = OFileScroll->GetPos();
      if ((pos != currentOFile) && (pos < fileCount))
      {
        currentOPos = 0;
        i = 0;
        while (i < pos)
        {
          currentOPos += files[i].numFramesUsed;
          i++;
        }
        DisplayOutputInfo();
      }
    }
  }
}


bool TMainWindow::SetRelPos()
{
  int currentFile;

  if (currentOPos < 0)
    currentOPos = 0;
  else
  {
    if (batch)
      currentFile = files[currentOFile].numFramesUsed;
    else
      currentFile = totalFrames;
    if (currentOPos >= currentFile)
      currentOPos = currentFile - 1;
  }
  relOPos = currentOPos;
  if (batch)
  {
    relOPos = relOPos / files[currentOFile].repeatCount + files[currentOFile].startFrame;
    return true;
  }
  currentFile = 0;
  while (relOPos >= 0)
  {
    relOPos -= files[currentFile].numFramesUsed;
    currentFile++;
  }
  currentFile--;
  relOPos += files[currentFile].numFramesUsed;
  if (currentFile != currentOFile)
  {
    if (currentOFile != currentIFile)
      CloseFile(currentOFile);
    currentOFile = currentFile;
    if (currentOFile != currentIFile)
      if (!OpenFile(currentOFile))
      {
        RemoveFile(currentOFile);
        return false;
      }
  }
  relOPos = relOPos / files[currentOFile].repeatCount + files[currentOFile].startFrame;
  return true;
}

void TMainWindow::EvRButtonUp(uint modKeys, TPoint& point)
{
  TDialog::EvRButtonUp(modKeys, point);
  if (Playing)
    return;
  if (iprevRect.Contains(point))
  {
    if (gotRFirst)
    {
      gotRFirst = false;
      PopMenu(point);
    }
    else
      gotRFirst = true;
  }
}

void TMainWindow::EvRButtonDown(uint modKeys, TPoint& point)
{
  TDialog::EvRButtonDown(modKeys, point);
  if (Playing)
    return;
  if (iprevRect.Contains(point))
  {
    if (gotRFirst)
    {
      gotRFirst = false;
      PopMenu(point);
    }
    else
      gotRFirst = true;
  }
}

void TMainWindow::PopMenu(TPoint &point)
{
  if (fileCount)
  {
    TPoint spoint(point);
    ClientToScreen(spoint);
    PopupMenu.TrackPopupMenu(TPM_RIGHTBUTTON, spoint, 0, HWindow);
  }
}

void TMainWindow::EvStartFrame()
{
  char tmpStr[10];

  if (fileCount)
  {
    sprintf(tmpStr, "%d", IVideoScroll->GetPosition());
    StartText->SetText(tmpStr);
    EvStartKillFocus();
  }
}

void TMainWindow::EvEndFrame()
{
  char tmpStr[10];

  if (fileCount)
  {
    sprintf(tmpStr, "%d", IVideoScroll->GetPosition());
    EndText->SetText(tmpStr);
    EvEndKillFocus();
  }
}

void TMainWindow::EvStartKillFocus()
{
  char tmpStr[80];
  int i;
  double sampPerFrame;

  StartText->GetText(tmpStr, 80);
  if ((sscanf(tmpStr, "%d", &i) != 1) ||
      (i < files[currentIFile].firstFrame) ||
      (i > files[currentIFile].lastFrame))
  {
    sprintf(tmpStr, "Invalid start frame number (%d .. %d).", files[currentIFile].firstFrame, files[currentIFile].lastFrame);
    DisplayMBox(tmpStr, "invalid entry");
    sprintf(tmpStr, "%d", files[currentIFile].startFrame);
    StartText->SetText(tmpStr);
  }
  else
  {
    if (i != files[currentIFile].startFrame)
    {
      files[currentIFile].startFrame = i;
      if (i > files[currentIFile].endFrame)
      {
        files[currentIFile].endFrame = i;
        EndText->SetText(tmpStr);
      }
      files[currentIFile].numFramesUsed = (files[currentIFile].endFrame - i + 1) *
                                           files[currentIFile].repeatCount;
      if ((!batch && samplesPerSec) || (batch && files[currentIFile].samplesPerSec))
      {
        sampPerFrame = (double)samplesPerSec / files[currentIFile].frameRate;
        if (files[currentIFile].aviFile && (files[currentIFile].repeatCount > 1))
        {
          files[currentIFile].startSample = (files[currentIFile].startFrame / files[currentIFile].repeatCount) * sampPerFrame;
          files[currentIFile].numSamplesUsed = (files[currentIFile].numFramesUsed / files[currentIFile].repeatCount) * sampPerFrame;
        }
        else
        {
          files[currentIFile].startSample = files[currentIFile].startFrame * sampPerFrame;
          files[currentIFile].numSamplesUsed = files[currentIFile].numFramesUsed * sampPerFrame;
        }
        if (files[currentIFile].startSample + files[currentIFile].numSamplesUsed > files[currentIFile].numSamples)
          files[currentIFile].numSamplesUsed = files[currentIFile].numSamples - files[currentIFile].startSample;
      }
      DisplayOutputInfo();
      DisplayFileInfo();
    }
  }
}

void TMainWindow::EvEndKillFocus()
{
  char tmpStr[80];
  int i;
  double sampPerFrame;

  EndText->GetText(tmpStr, 80);
  if ((sscanf(tmpStr, "%d", &i) != 1) ||
      (i < files[currentIFile].firstFrame) ||
      (i > files[currentIFile].lastFrame))
  {
    sprintf(tmpStr, "Invalid end frame number (%d .. %d).", files[currentIFile].firstFrame, files[currentIFile].lastFrame);
    DisplayMBox(tmpStr, "invalid entry");
    sprintf(tmpStr, "%d", files[currentIFile].endFrame);
    EndText->SetText(tmpStr);
  }
  else
  {
    if (i != files[currentIFile].endFrame)
    {
      files[currentIFile].endFrame = i;
      if (i < files[currentIFile].startFrame)
      {
        files[currentIFile].startFrame = i;
        StartText->SetText(tmpStr);
      }
      files[currentIFile].numFramesUsed = (i - files[currentIFile].startFrame + 1) *
                                           files[currentIFile].repeatCount;
      if ((!batch && samplesPerSec) || (batch && files[currentIFile].samplesPerSec))
      {
        sampPerFrame = (double)samplesPerSec / files[currentIFile].frameRate;
        if (files[currentIFile].aviFile && (files[currentIFile].repeatCount > 1))
        {
          files[currentIFile].startSample = (files[currentIFile].startFrame / files[currentIFile].repeatCount) * sampPerFrame;
          files[currentIFile].numSamplesUsed = (files[currentIFile].numFramesUsed / files[currentIFile].repeatCount) * sampPerFrame;
        }
        else
        {
          files[currentIFile].startSample = files[currentIFile].startFrame * sampPerFrame;
          files[currentIFile].numSamplesUsed = files[currentIFile].numFramesUsed * sampPerFrame;
        }
        if (files[currentIFile].startSample + files[currentIFile].numSamplesUsed > files[currentIFile].numSamples)
          files[currentIFile].numSamplesUsed = files[currentIFile].numSamples - files[currentIFile].startSample;
      }
      DisplayOutputInfo();
      DisplayFileInfo();
    }
  }
}

void TMainWindow::EvICurrentKillFocus()
{
  char tmpStr[80];
  int i;

  ICurrentText->GetText(tmpStr, 80);
  if ((sscanf(tmpStr, "%d", &i) != 1) ||
      (i < files[currentIFile].firstFrame) ||
      (i > files[currentIFile].lastFrame))
  {
    sprintf(tmpStr, "Invalid frame number (%d .. %d).", files[currentIFile].firstFrame, files[currentIFile].lastFrame);
    DisplayMBox(tmpStr, "invalid entry");
    sprintf(tmpStr, "%d", files[currentIFile].currentFrame);
    ICurrentText->SetText(tmpStr);
  }
  else
  {
    if (i != files[currentIFile].currentFrame)
    {
      files[currentIFile].currentFrame = i;
      IVideoScroll->SetPosition(i);
      EvIPreview();
    }
  }
}

void TMainWindow::EvOCurrentKillFocus()
{
  char tmpStr[80];
  int i;

  OCurrentText->GetText(tmpStr, 45);
  if ((sscanf(tmpStr, "%d", &i) != 1) ||
      (i < 0) || (i > totalFrames - 1))
  {
    sprintf(tmpStr, "Invalid frame number (0 .. %d).", totalFrames - 1);
    DisplayMBox(tmpStr, "invalid entry");
    sprintf(tmpStr, "%d", currentOPos);
    OCurrentText->SetText(tmpStr);
  }
  else
  {
    if (i != currentOPos)
    {
      currentOPos = i;
      if (!SetRelPos())
        return;
      OVideoScroll->SetPosition(i);
      sprintf(tmpStr, "%d", currentOFile + 1);
      OFileText->SetText(tmpStr);
      sprintf(tmpStr, "%d", relOPos);
      OFrameText->SetText(tmpStr);
      EvOPreview();
    }
  }
}

void TMainWindow::EvRepeatKillFocus()
{
  char tmpStr[20];
  int i;

  RepeatText->GetText(tmpStr, 20);
  if ((sscanf(tmpStr, "%d", &i) != 1) ||
      (i < 0) || (i > 32767))
  {
    DisplayMBox("Invalid repeat value (0 .. 32767).", "invalid entry");
    sprintf(tmpStr, "%d", files[currentIFile].repeatCount - 1);
    RepeatText->SetText(tmpStr);
  }
  else
  {
    if (i + 1 != files[currentIFile].repeatCount)
    {
      files[currentIFile].repeatCount = i + 1;
      files[currentIFile].numFramesUsed = (files[currentIFile].endFrame - files[currentIFile].startFrame + 1) * (i + 1);
      currentOFile = currentIFile;
      currentOPos = 0;
      if (!batch)
      {
        for (i = 0; i < currentOFile; i++)
          currentOPos += files[i].numFramesUsed;
        if (!files[currentIFile].aviFile && samplesPerSec)
          files[currentIFile].numSamplesUsed = files[currentIFile].numFramesUsed * files[currentIFile].samplesPerFrame;
      }
      DisplayOutputInfo();
      DisplayFileInfo();
    }
  }
}

void TMainWindow::EvKeyReturn()
{
  HWND focusWnd;

  if (Playing)
  {
    Pause = true;
    return;
  }
  focusWnd = GetFocus();
  if (focusWnd == StartText->HWindow)
    EvStartKillFocus();
  else
    if (focusWnd == EndText->HWindow)
      EvEndKillFocus();
    else
      if (focusWnd == ICurrentText->HWindow)
        EvICurrentKillFocus();
      else
        if (focusWnd == OCurrentText->HWindow)
          EvOCurrentKillFocus();
        else
          if (focusWnd == RepeatText->HWindow)
            EvRepeatKillFocus();
          else
            PostMessage(WM_COMMAND, CM_STARTCONVERSION);
}

void TMainWindow::AddMessage(char *txt)
{
  TClientDC dc(HWindow);
  TSize size;
  HFONT hfont = (HFONT)SendMessage(WM_GETFONT);
  TFont font(hfont, NoAutoDelete);
  TEXTMETRIC metrics;

//  InputLBox->SetCaretIndex(InputLBox->AddString(txt), true);
  InputLBox->AddString(txt);
  dc.SelectObject(font);
  dc.GetTextExtent(txt, strlen(txt), size);
  dc.GetTextMetrics(metrics);
  size.cx += metrics.tmAveCharWidth;
  if (size.cx > LongestMessage)
  {
    LongestMessage = size.cx;
    if (LongestMessage > InputLBox->GetHorizontalExtent())
      InputLBox->SetHorizontalExtent(LongestMessage);
  }
}


void TMainWindow::AddFilename(char *txt)
{
  TClientDC dc(HWindow);
  TSize size;
  HFONT hfont = (HFONT)SendMessage(WM_GETFONT);
  TFont font(hfont, NoAutoDelete);
  TEXTMETRIC metrics;

  InputName->SetCaretIndex(InputName->AddString(txt), true);
  fileCount++;
  dc.SelectObject(font);
  dc.GetTextExtent(txt, strlen(txt), size);
  dc.GetTextMetrics(metrics);
  size.cx += metrics.tmAveCharWidth;
  if (size.cx > LongestName)
  {
    LongestName = size.cx;
    if (LongestName > InputName->GetHorizontalExtent())
      InputName->SetHorizontalExtent(LongestName);
  }
}

void TMainWindow::CmVideoOpen()
{
  char tmpStr[MAXPATH];

  static TOpenSaveDialog::TData data (
         OFN_PATHMUSTEXIST|OFN_NOREADONLYRETURN|OFN_OVERWRITEPROMPT,
         "MPEG Program Streams (*.MPG,*.M2P,*.VOB)|*.mpg;*.m2p;*.vob|MPEG-2 Program Streams (*.M2P)|*.m2p|MPEG Program Streams (*.MPG)|*.mpg|Video Object Units (*.VOB)|*.vob|All Files (*.*)|*.*|",
         0, "", "");

  sprintf(tmpStr, "%s - output MPEG program stream", AppName);
  if ((new TFileSaveDialog(this, data, 0, tmpStr))->Execute() == IDOK)
  {
    if (batch)
    {
      strcpy(files[currentIFile].mpegFilename, data.FileName);
      VideoName->SetText(files[currentIFile].mpegFilename);
    }
    else
    {
      strcpy(MPEGFilename, data.FileName);
      VideoName->SetText(MPEGFilename);
    }
  }
}

void TMainWindow::CmStartConversion()
{
  int currentPos, currentFile;

  currentPos = currentOPos;
  currentFile = currentOFile;

  if (batch)
  {
    CloseFile(currentFile);
    currentOFile = 0;
    AbortOperation = false;
    while ((currentOFile < fileCount) && !AbortOperation)
    {
      if (!OpenFile(currentOFile))
        return;
      makeMPEGInfo.doVideo = 1;
      makeMPEGInfo.width = files[currentOFile].mpegWidth;
      makeMPEGInfo.height = files[currentOFile].mpegHeight;
      makeMPEGInfo.startFrame = 0;
      makeMPEGInfo.endFrame = files[currentOFile].numFramesUsed - 1;

      if (files[currentOFile].AudioPresent)
      {
        makeMPEGInfo.doAudio = 1;
        makeMPEGInfo.audioRate = files[currentOFile].samplesPerSec;
        makeMPEGInfo.stereo = 1;
        makeMPEGInfo.sampleSize = 16;
        makeMPEGInfo.startSample = 0;
        makeMPEGInfo.endSample = files[currentOFile].numSamplesUsed - 1;
      }
      else
        makeMPEGInfo.doAudio = 0;

      dllAppWindow(frameWindow->HWindow);
      makeMPEGInfo.outputFilename = files[currentOFile].mpegFilename;
      Encoding = true;
      AbortOperation = (bbMakeMPEG(&makeMPEGInfo) != bbMakeDone);
      Encoding = false;
      currentOFile++;
    }
    CloseFile(currentOFile - 1);
    currentOFile = currentFile;
    currentOPos = 0;
    OpenFile(currentOFile);
  }
  else
  {
    if (fileCount)
    {
      makeMPEGInfo.doVideo = 1;
      makeMPEGInfo.width = MPEGWidth;
      makeMPEGInfo.height = MPEGHeight;
      makeMPEGInfo.startFrame = 0;
      makeMPEGInfo.endFrame = totalFrames - 1;
    }
    else
      makeMPEGInfo.doVideo = 0;

    if (OutputAudio)
    {
      makeMPEGInfo.doAudio = 1;
      makeMPEGInfo.audioRate = samplesPerSec;
      makeMPEGInfo.stereo = 1;
      makeMPEGInfo.sampleSize = 16;
      makeMPEGInfo.startSample = 0;
      makeMPEGInfo.endSample = totalSamples - 1;
    }
    else
      makeMPEGInfo.doAudio = 0;

    dllAppWindow(frameWindow->HWindow);
    makeMPEGInfo.outputFilename = MPEGFilename;
    Encoding = true;
    currentPos = currentOPos;
    bbMakeMPEG(&makeMPEGInfo);
    Encoding = false;
  }
  currentOPos = currentPos;
  if (fileCount)
    SetRelPos();
}

void TMainWindow::EvLoadProject()
{
  char tmpStr[MAXPATH];
  int i, fCount, cIFile, cOPos;
  fileData tmpFiles[MAX_OPEN_FILES];
  FILE *fin;
  bool result, cOutput, batchSave = batch;
  int cWidth, cHeight;
  static TOpenSaveDialog::TData data (
         OFN_PATHMUSTEXIST|OFN_FILEMUSTEXIST,
         "AVI2MPG2 project files (*.A2M)|*.a2m|All Files (*.*)|*.*|",
         0, "", "");

  if (Playing)
    return;

  sprintf(tmpStr, "%s - open project file", AppName);
  if ((new TFileOpenDialog(this, data, 0, tmpStr))->Execute() == IDOK)
  {
    if ((fin = fopen(data.FileName, "rb")) == NULL)
    {
      sprintf(tmpStr, "Unable to open project file %s.", data.FileName);
      DisplayMBox(tmpStr, "Project open error");
      return;
    }
    if (fread(&batch, sizeof(int), 1, fin) != 1 ||
        fread(&fCount, sizeof(int), 1, fin) != 1 ||
        fread(&cIFile, sizeof(int), 1, fin) != 1 ||
        fread(&cOPos, sizeof(int), 1, fin) != 1 ||
        fread(tmpStr, sizeof(char), MAXPATH, fin) != MAXPATH ||
        fread(&cWidth, sizeof(int), 1, fin) != 1 ||
        fread(&cHeight, sizeof(int), 1, fin) != 1 ||
        fread(&cOutput, sizeof(bool), 1, fin) != 1)
    {
      sprintf(tmpStr, "Unable to read from project file %s.", data.FileName);
      DisplayMBox(tmpStr, "Project open error");
      fclose(fin);
      return;
    }

    while (fileCount)
      RemoveFile(fileCount - 1);
    iprevDib->ClearDib();

    for (i = 0; i < fCount; i++)
    {
      if (fread(&tmpFiles[i], sizeof(fileData), 1, fin) != 1)
      {
        sprintf(tmpStr, "Unable to read from project file %s.", data.FileName);
        DisplayMBox(tmpStr, "Project open error");
        fclose(fin);
        return;
      }
      if (strstr(tmpFiles[i].fileName, ".lst"))
        result = AddList(tmpFiles[i].fileName);
      else
        result = AddAVI(tmpFiles[i].fileName);
      if (!result)
        goto errexit;
      CloseFile(i);
      AddFilename(tmpFiles[i].fileName);
    }
    for (i = 0; i < fileCount; i++)
    {
      files[i].currentFrame = tmpFiles[i].currentFrame;
      files[i].startFrame = tmpFiles[i].startFrame;
      files[i].endFrame = tmpFiles[i].endFrame;
      files[i].repeatCount = tmpFiles[i].repeatCount;
      files[i].numFramesUsed = tmpFiles[i].numFramesUsed;
      files[i].numSamplesUsed = tmpFiles[i].numSamplesUsed;
      files[i].startSample = tmpFiles[i].startSample;
      files[i].deinterlace = tmpFiles[i].deinterlace;
      files[i].invert = tmpFiles[i].invert;
      files[i].propSize = tmpFiles[i].propSize;
      files[i].resize = tmpFiles[i].resize;
      files[i].cropFrames = tmpFiles[i].cropFrames;
      files[i].cropX = tmpFiles[i].cropX;
      files[i].cropY = tmpFiles[i].cropY;
      files[i].cropW = tmpFiles[i].cropW;
      files[i].cropH = tmpFiles[i].cropH;
    }
    ProjectName->SetText(data.FileName);
    if (!batch)
    {
      strcpy(MPEGFilename, tmpStr);
      MPEGWidth = cWidth;
      MPEGHeight = cHeight;
    }
    showOutput = cOutput;
    InputName->SetSelIndex(cIFile);
    currentIFile = InputName->GetSelIndex();
    if (!OpenFile(currentIFile))
      goto errexit;
    currentOPos = cOPos;
    if (currentOFile != currentIFile)
      if (!OpenFile(currentOFile))
        goto errexit;
    DisplaySourceInfo();
    DisplayFileInfo();
    DisplayOutputInfo();
    PostMessage(WM_PAINT);
    fclose(fin);
  }
  return;

errexit:
  while (fileCount)
    RemoveFile(fileCount - 1);
  fclose(fin);
  batch = batchSave;
  return;
}

void TMainWindow::EvSaveProject()
{
  char tmpStr[MAXPATH];
  int i;
  FILE *fout;
  static TOpenSaveDialog::TData data (
         OFN_PATHMUSTEXIST|OFN_OVERWRITEPROMPT|OFN_HIDEREADONLY|OFN_NOREADONLYRETURN,
         "AVI2MPG2 project files (*.A2M)|*.a2m|All Files (*.*)|*.*|",
         0, "", "");

  sprintf(tmpStr, "%s - save project file", AppName);
  if ((new TFileSaveDialog(this, data, 0, tmpStr))->Execute() == IDOK)
  {
    if ((fout = fopen(data.FileName, "wb")) == NULL)
    {
      sprintf(tmpStr, "Unable to save project to file %s.", data.FileName);
      DisplayMBox(tmpStr, "Project save error");
    }
    else
    {
      if (fwrite(&batch, sizeof(int), 1, fout) != 1 ||
          fwrite(&fileCount, sizeof(int), 1, fout) != 1 ||
          fwrite(&currentIFile, sizeof(int), 1, fout) != 1 ||
          fwrite(&currentOPos, sizeof(int), 1, fout) != 1 ||
          fwrite(MPEGFilename, sizeof(char), MAXPATH, fout) != MAXPATH ||
          fwrite(&MPEGWidth, sizeof(int), 1, fout) != 1 ||
          fwrite(&MPEGHeight, sizeof(int), 1, fout) != 1 ||
          fwrite(&showOutput, sizeof(bool), 1, fout) != 1)
      {
        sprintf(tmpStr, "Unable to write to project file %s.", data.FileName);
        DisplayMBox(tmpStr, "Project save error");
        fclose(fout);
        return;
      }
      for (i = 0; i < fileCount; i++)
      {
        if (fwrite(&files[i], sizeof(fileData), 1, fout) != 1)
        {
          sprintf(tmpStr, "Unable to write to project file %s.", data.FileName);
          DisplayMBox(tmpStr, "Project save error");
          fclose(fout);
          return;
        }
      }
      fclose(fout);
      ProjectName->SetText(data.FileName);
    }
  }
}

void TMainWindow::CmFileOpen()
{
  char tmpStr[MAXPATH], *strPtr;
  bool result;

  static TOpenSaveDialog::TData data (
         OFN_PATHMUSTEXIST|OFN_FILEMUSTEXIST,
         "Supported Types(*.AVI;*.AVS;*.MPG;*.M2P;*.M1V;*.M2V;*.VOB;*.LST)|*.avi;*.avs;*.mpg;*.m2p;*.m1v;*.m2v;*.vob;*.lst|AVI Files (*.AVI)|*.avi|AVS Files (*.AVS)|*.avs|MPEG1 Files (*.MPG,*.M1V)|*.mpg;*.m1v|MPEG2 Files (*.M2P,*.M2V)|*.m2p;*.m2v|Video Object Units (*.VOB)|*.vob|List of images (*.LST)|*.lst|All Files (*.*)|*.*|",
         0, "", "");

  if (Playing)
    return;

  sprintf(tmpStr, "%s - open media file or list of images", AppName);
  if ((new TFileOpenDialog(this, data, 0, tmpStr))->Execute() == IDOK)
  {
    strlwr(data.FileName);
    if (strstr(data.FileName, ".lst"))
      result = AddList(data.FileName);
    else
      result = AddAVI(data.FileName);
    if (result)
    {
      iprevDib->ClearDib();
      AddFilename(data.FileName);
      strcpy(tmpStr, data.FileName);
      strPtr = strrchr(tmpStr, '.');
      if (strPtr)
        strPtr[0] = 0;
      if (batch)
      {
        strcpy(files[currentOFile].mpegFilename, tmpStr);
        strcat(files[currentOFile].mpegFilename, ".mpg");
      }
      else
      {
        if (!strlen(MPEGFilename))
        {
          strcpy(MPEGFilename, tmpStr);
          strcat(MPEGFilename, ".mpg");
        }
      }
      DisplaySourceInfo();
      if (batch)
        currentOPos = 0;
      else
        currentOPos = totalFrames;
      DisplayOutputInfo();
    }
    PostMessage(WM_PAINT);
  }
}

void TMainWindow::CmAbout()
{
  char tempStr[132];

  strcpy(tempStr, AppName);
  strcat(tempStr, " - ");
  strcat(tempStr, AppVersion);
  strcat(tempStr, "\n\nby: Brent Beyeler (beyeler@home.com)");
  strcat(tempStr, "\n\nhttp://members.home.net/beyeler/bbmpeg.html");
  MessageBox(tempStr, AppName, MB_OK);
}

int TMainWindow::DisplayMBox(char *txt, char *title)
{
  char tempStr[80];

  if (strlen(title))
    sprintf(tempStr, "%s - %s", AppName, title);
  else
    strcpy(tempStr, AppName);
  return MessageBox(txt, tempStr, MB_OK);
}

int TMainWindow::GetFrame(int cFile, unsigned int frame)
{
  HCURSOR savCursor;
  HRESULT res;
  int i;
  char tmpStr[MAXPATH];
  bool cancelPresent = (cancelDialog != NULL);

  if (!Encoding)
    savCursor = ::SetCursor(LoadCursor(NULL, IDC_WAIT));
  LoadingFrame = true;
  if (cancelDialog)
    cancelDialog->SetText2("Seeking for frame ...");
  res = files[cFile].pMMStream->Seek(frame * files[cFile].frameLength.int64);
  if (res != S_OK)
  {
    i = 2;
    goto gfexit;
  }
  if (cancelDialog)
    cancelDialog->SetText2("Updating DirectDraw sample ...");
  res = files[cFile].pDDSample->Update(SSUPDATE_ASYNC, NULL, NULL, 0);
  if (res == S_OK)
  {
    i = 0;
    goto gfexit;
  }

  i = 0;
  while (res == MS_S_PENDING)
  {
    YieldTime();
    if (AbortLoading)
    {
      i = 1;
      goto gfexit;
    }
    if (i > 5)
    {
      if (!cancelDialog)
      {
        cancelDialog = new TCancelDialog(this, IDD_CANCELDIALOG);
        if (!cancelDialog)
        {
          DisplayMBox("Unable to create a cancel dialog", "frame loading error");
          i = 6;
          goto gfexit;
        }
        if (!cancelDialog->Create())
        {
          DisplayMBox("Unable to execute cancel dialog", "frame loading error");
          i = 6;
          goto gfexit;
        }
        cancelDialog->SetText("Waiting for video frame update");
        EnableWindow(false);
      }
      sprintf(tmpStr, "frame %u, elapsed time = %d seconds", frame, i);
      cancelDialog->SetText2(tmpStr);
    }
    if (cancelDialog)
    {
      sprintf(tmpStr, "Checking DirectDraw sample update completion status, time = %d seconds ...", i);
      cancelDialog->SetText2(tmpStr);
    }
    res = files[cFile].pDDSample->CompletionStatus(COMPSTAT_WAIT, 1000);
    i++;
  }
  if (res == S_OK)
  {
    i = 0;
    goto gfexit;
  }

  if (res == MS_S_PENDING)
  {
    if (cancelDialog)
      cancelDialog->SetText2("Aborting video frame update ...");
    res = files[cFile].pDDSample->CompletionStatus(COMPSTAT_ABORT | COMPSTAT_WAIT, 1000);
  }
  if (res == MS_S_PENDING)
    i = 4;
  else
    i = 3;

gfexit:
  if (cancelDialog && !cancelPresent)
  {
    EnableWindow(true);
    if (!AbortLoading)
      cancelDialog->Destroy(IDOK);
    cancelDialog = NULL;
  }
  LoadingFrame = false;
  if (!Encoding)
    ::SetCursor(savCursor);
  return i;
}

int TMainWindow::GetSample(int cFile, unsigned int sample)
{
  HRESULT res;
  int i;
  char tmpStr[MAXPATH];
  bool cancelPresent = (cancelDialog != NULL);

  LoadingFrame = true;

  if (cancelDialog)
    cancelDialog->SetText2("Seeking for sample ...");
  res = files[cFile].pMMStream->Seek((STREAM_TIME)ceil((double)sample * files[cFile].sampleLength));
  if (res != S_OK)
  {
    i = 2;
    goto gsexit;
  }

  if (cancelDialog)
    cancelDialog->SetText2("Updating audio sample ...");
  res = files[cFile].pAudSample->Update(SSUPDATE_ASYNC, NULL, NULL, 0);
  if (res == S_OK)
  {
    i = 0;
    goto gsexit;
  }

  i = 0;
  while (res == MS_S_PENDING)
  {
    YieldTime();
    if (AbortLoading)
    {
      i = 1;
      goto gsexit;
    }
    if (i > 5)
    {
      if (!cancelDialog)
      {
        cancelDialog = new TCancelDialog(this, IDD_CANCELDIALOG);
        if (!cancelDialog)
        {
          DisplayMBox("Unable to create a cancel dialog", "sample loading error");
          i = 6;
          goto gsexit;
        }
        if (!cancelDialog->Create())
        {
          DisplayMBox("Unable to execute cancel dialog", "sample loading error");
          i = 6;
          goto gsexit;
        }
        cancelDialog->SetText("Waiting for audio sample update");
        EnableWindow(false);
      }
      sprintf(tmpStr, "sample %u, elapsed time = %d seconds ...", sample, i);
      cancelDialog->SetText2(tmpStr);
    }
    if (cancelDialog)
    {
      sprintf(tmpStr, "checking update status, time = %d seconds ...", i);
      cancelDialog->SetText2(tmpStr);
    }
    res = files[cFile].pAudSample->CompletionStatus(COMPSTAT_WAIT, 1000);
    i++;
  }
  if (res == S_OK)
  {
    i = 0;
    goto gsexit;
  }

  if (res == MS_S_PENDING)
  {
    if (cancelDialog)
      cancelDialog->SetText2("Aborting sample update ...");
    res = files[cFile].pAudSample->CompletionStatus(COMPSTAT_ABORT | COMPSTAT_WAIT, 1000);
  }
  if (res == MS_S_PENDING)
    i = 4;
  else
    i = 3;

gsexit:
  if (cancelDialog && !cancelPresent)
  {
    EnableWindow(true);
    if (!AbortLoading)
      cancelDialog->Destroy(IDOK);
    cancelDialog = NULL;
  }
  LoadingFrame = false;
  return i;
}

bool TMainWindow::AddAVI(char *name)
{
  char tmpStr[MAXPATH];
  bool found, result;
  int cFile, i, j;

  if (fileCount >= MAX_OPEN_FILES)
  {
    sprintf(tmpStr, "The maximum number (%d) of files has been opened.", MAX_OPEN_FILES);
    DisplayMBox(tmpStr, "open file error");
    return false;
  }

  cFile = fileCount;
  strcpy(files[cFile].fileName, name);
  files[cFile].deinterlace = false;
  files[cFile].invert = false;
  AbortLoading = false;
  result = false;
  cancelDialog = new TCancelDialog(this, IDD_CANCELDIALOG);
  if (!cancelDialog)
  {
    DisplayMBox("Unable to create a cancel dialog", "frame loading error");
    return false;
  }
  if (!cancelDialog->Create())
  {
    DisplayMBox("Unable to execute cancel dialog", "frame loading error");
    return false;
  }
  cancelDialog->SetCaption("AVI2MPG2 - loading status");
  sprintf(tmpStr, "Opening file %s", name);
  cancelDialog->SetText(tmpStr);
  EnableWindow(false);

  if (!OpenAVI(cFile))
  {
    CloseAVI(cFile);
    goto aviend;
  }
  AVIAvail++;

  /* check exactly how many video frames there are */
  found = false;
  j = files[cFile].lastFrame;
  while (!found && (j >= 0))
  {
    sprintf(tmpStr, "Searching for actual last video frame %u", j);
    cancelDialog->SetText(tmpStr);
    switch (GetFrame(cFile, j))
    {
      case 0:
        found = true;
        break;
      case 1:
        CloseAVI(cFile);
        goto aviend;
      case 2:
      case 3:
        j--;
        break;
      default:
        CloseAVI(cFile);
        DisplayMBox("Could not find last frame in video stream", "open file error");
        goto aviend;
    }
  }
  if (j < 0)
  {
    CloseAVI(cFile);
    DisplayMBox("Could not find last frame in video stream", "open file error");
    goto aviend;
  }
  files[cFile].lastFrame = j;

  files[cFile].numFrames = files[cFile].lastFrame + 1;
  files[cFile].startFrame = files[cFile].firstFrame;
  files[cFile].endFrame = files[cFile].lastFrame;
  files[cFile].numFramesUsed = files[cFile].lastFrame + 1;
  files[cFile].currentFrame = files[cFile].firstFrame;
  files[cFile].repeatCount = 1;
  files[cFile].cropFrames = false;
  files[cFile].resize = false;
  files[cFile].propSize = true;
  files[cFile].cropX = 0;
  files[cFile].cropY = 0;
  files[cFile].cropW = 0;
  files[cFile].cropH = 0;
  if (batch)
  {
    files[cFile].mpegWidth = files[cFile].ddsd.dwWidth;
    files[cFile].mpegHeight = files[cFile].ddsd.dwHeight;
  }
  else
  {
    if (!MPEGWidth || !MPEGHeight)
    {
      MPEGWidth = files[cFile].ddsd.dwWidth;
      MPEGHeight = files[cFile].ddsd.dwHeight;
    }
  }

  if (files[cFile].AudioPresent)
  {
    /* need to check exactly how many audio samples there are */
    found = false;
    j = files[cFile].numSamples;
    i = 3;
    while (!found && (j >= 0))
    {
      sprintf(tmpStr, "Searching for actual last audio sample %u", j);
      cancelDialog->SetText(tmpStr);
      switch (GetSample(cFile, j))
      {
        case 0:
          switch (i)
          {
            case 0:
              found = true;
              break;
            case 1:
              j += 10;
              i = 0;
              break;
            case 2:
              j += 100;
              i = 1;
              break;
            case 3:
              if (j == files[cFile].numSamples)
                found = true;
              else
              {
                j += 1000;
                i = 2;
              }
              break;
          }
          break;
        case 1:
          files[cFile].AudioPresent = false;
          break;
        case 2:
        case 3:
          switch (i)
          {
            case 0:
              j--;
              break;
            case 1:
              if (j - 10 >= 0)
                j -= 10;
              else
              {
                i = 0;
                j--;
              }
              break;
            case 2:
              if (j - 100 >= 0)
                j -= 100;
              else
                if (j - 10 >= 0)
                {
                  i = 1;
                  j -= 10;
                }
                else
                {
                  i = 0;
                  j--;
                }
              break;
            case 3:
              if (j - 1000 >= 0)
                j -= 1000;
              else
                if (j - 100 >= 0)
                {
                  i = 2;
                  j -= 100;
                }
                else
                  if (j - 10 >= 0)
                  {
                    i = 1;
                    j -= 10;
                  }
                  else
                  {
                    i = 0;
                    j--;
                  }
              break;
          }
          break;
        default:
          DisplayMBox("Could not find last sample in audio stream, not using audio", "open file warning");
          files[cFile].AudioPresent = false;
      }
    }
    if (files[cFile].AudioPresent && (j < 0))
    {
      DisplayMBox("Could not find last sample in audio stream, not using audio", "open file warning");
      files[cFile].AudioPresent = false;
    }

    if (files[cFile].AudioPresent)
    {
      files[cFile].numSamples = j;

      files[cFile].numSamplesUsed = files[cFile].numSamples;
      files[cFile].startSample = 0;
      if (batch)
      {
        files[cFile].samplesPerSec = files[cFile].audioFormat.nSamplesPerSec;
        if (files[cFile].samplesPerSec == 22050)
          files[cFile].samplesPerSec <<= 1;

        if (files[cFile].audioFormat.nSamplesPerSec == 22050)
          files[cFile].audioBufferSize1 = files[cFile].samplesPerFrame << 3;
        else
          files[cFile].audioBufferSize1 = files[cFile].samplesPerFrame << 2;
        files[cFile].audioBuffer1 = (unsigned short int*) malloc(files[cFile].audioBufferSize1);
        if (files[cFile].audioBuffer1 == NULL)
        {
          DisplayMBox("Could not get memory for secondary audio buffer.", "open file warning");
          files[cFile].AudioPresent = false;
        }
      }
      else
      {
        if (!samplesPerSec)
        {
          samplesPerSec = files[cFile].audioFormat.nSamplesPerSec;
          if (samplesPerSec == 22050)
            samplesPerSec <<= 1;
          if (!audioBuffer1)
          {
            if (files[cFile].audioFormat.nSamplesPerSec == 22050)
              audioBufferSize1 = files[cFile].samplesPerFrame << 3;
            else
              audioBufferSize1 = files[cFile].samplesPerFrame << 2;
            audioBuffer1 = (unsigned short int*) malloc(audioBufferSize1);
            if (audioBuffer1 == NULL)
            {
              DisplayMBox("Could not get memory for secondary audio buffer.", "open file warning");
              files[cFile].AudioPresent = false;
            }
            else
            {
              for (i = 0; i < fileCount; i++)
                if (!files[i].AudioPresent)
                {
                  files[i].samplesPerFrame = audioBufferSize1 >> 2;
                  files[i].numSamples = files[i].numFrames * files[i].samplesPerFrame;
                  files[i].numSamplesUsed = files[i].numFramesUsed * files[i].samplesPerFrame;
                  files[i].startSample = files[i].startFrame * files[i].samplesPerFrame;
                  files[i].bytesPerSample = 4;
                }
            }
          }
        }
      }
    }
  }
  if (currentIFile != cFile)
    CloseFile(currentIFile);
  currentIFile = cFile;
  if (currentOFile != cFile)
    CloseFile(currentOFile);
  currentOFile = cFile;
  if (files[cFile].AudioPresent)
    AudioAvail++;
  files[cFile].aviFile = true;
  DisplayFileInfo();
  result = true;

aviend:
  EnableWindow(true);
  if (!AbortLoading)
    cancelDialog->Destroy(IDOK);
  cancelDialog = NULL;
  return result;
}

void TMainWindow::DisplayFileInfo()
{
  double seconds;
  int hours, min;
  char tmpStr[MAXPATH];

  InputLBox->ClearList();
  LongestMessage = 0;
  if (files[currentIFile].aviFile)
    sprintf(tmpStr, "Media file: %s", files[currentIFile].fileName);
  else
    sprintf(tmpStr, "Image list: %s", files[currentIFile].fileName);
  AddMessage(tmpStr);
  AddMessage(" ");

  AddMessage("Video:");
  if (!files[currentIFile].aviFile)
  {
    sprintf(tmpStr, "  Filename: %s", curFilename);
    AddMessage(tmpStr);
  }
  sprintf(tmpStr, "  Resolution: %d x %d", files[currentIFile].ddsd.dwWidth,
                                             files[currentIFile].ddsd.dwHeight);
  AddMessage(tmpStr);
  if (files[currentIFile].aviFile)
  {
    sprintf(tmpStr, "  Frame Rate: %02.2f", files[currentIFile].frameRate);
    AddMessage(tmpStr);
  }
  sprintf(tmpStr, "  Total Frames: %u", files[currentIFile].numFrames);
  AddMessage(tmpStr);
  if (files[currentIFile].aviFile)
  {
    seconds = ((double) files[currentIFile].totalTime.int64) / 10000000.0;
    hours = (int) (seconds / 3600.0);
    if (hours)
      seconds = seconds - hours * 3600.0;
    min = (int) (seconds / 60.0);
    if (min)
      seconds = seconds - min * 60.0;
    sprintf(tmpStr, "  Total Time: %02d:%02d:%02.2f", hours, min, seconds);
    AddMessage(tmpStr);
  }
  sprintf(tmpStr, "  Selected Frames: %u", files[currentIFile].numFramesUsed);
  AddMessage(tmpStr);
  AddMessage(" ");

  if (files[currentIFile].AudioPresent)
  {
    AddMessage("Audio:");
    if (files[currentIFile].audioFormat.nChannels == 2)
      AddMessage("  Channels: Stereo");
    else
      AddMessage("  Channels: Mono (will be converted to stereo)");
    if (files[currentIFile].audioFormat.nSamplesPerSec == 22050)
      sprintf(tmpStr, "  Sample Rate: 22.05 kHz (will be converted to 44.1 kHz)");
    else
      sprintf(tmpStr, "  Sample Rate: %.01f kHz", ((double) files[currentIFile].audioFormat.nSamplesPerSec) / 1000.0);
    AddMessage(tmpStr);
    if (files[currentIFile].audioFormat.wBitsPerSample == 8)
      sprintf(tmpStr, "  Bits per Sample: 8 (will be converted to 16)");
    else
      sprintf(tmpStr, "  Bits per Sample: %d", files[currentIFile].audioFormat.wBitsPerSample);
    AddMessage(tmpStr);
    sprintf(tmpStr, "  Total samples: %u", files[currentIFile].numSamples);
    AddMessage(tmpStr);
    sprintf(tmpStr, "  Selected samples: %u", files[currentIFile].numSamplesUsed);
    AddMessage(tmpStr);
  }
  else
    AddMessage(" Audio: none");
}

bool TMainWindow::OpenFile(int cFile)
{
  HCURSOR hcursave;
  bool ret;

  hcursave = ::SetCursor(::LoadCursor(NULL, IDC_WAIT));
  if (files[cFile].aviFile)
    ret = OpenAVI(cFile);
  else
    ret = OpenList(cFile);
  ::SetCursor(hcursave);
  return ret;
}

void TMainWindow::CloseFile(int cFile)
{
  HCURSOR hcursave;

  if (fileCount && (cFile < fileCount))
  {
    hcursave = ::SetCursor(::LoadCursor(NULL, IDC_WAIT));
    if (files[cFile].aviFile)
      CloseAVI(cFile);
    else
      CloseList(cFile);
    ::SetCursor(hcursave);
  }
}

bool TMainWindow::OpenAVI(int cFile)
{
  char tmpStr[MAXPATH];
  WCHAR wPath[MAX_PATH];
  int width, height;
  DWORD pdwFlags;
  IAMMultiMediaStream *pAMStream = NULL;
  IAudioData *pAudioData = NULL;

  YieldTime();
  if (AbortLoading)
    return false;
  MultiByteToWideChar(CP_ACP, 0, files[cFile].fileName, -1, wPath, sizeof(wPath)/sizeof(wPath[0]));

  files[cFile].AudioPresent = false;
  if (cancelDialog)
    cancelDialog->SetText2("Creating IAMMultiMediaStream ...");
  if (CoCreateInstance(CLSID_AMMultiMediaStream, NULL, CLSCTX_INPROC_SERVER,
                       IID_IAMMultiMediaStream, (void **)&pAMStream) != S_OK)
  {
    DisplayMBox("Could not create IAMMMultiMediaStream", "open file error");
    return false;
  }

  if (cancelDialog)
    cancelDialog->SetText2("Initializing IAMMultiMediaStream ...");

  if (pAMStream->Initialize(STREAMTYPE_READ, 0, NULL) != S_OK)
  {
    DisplayMBox("Could not initialize IAMMMultiMediaStream", "open file error");
    pAMStream->Release();
    return false;
  }

  if (cancelDialog)
    cancelDialog->SetText2("Adding primary video stream to IAMMultiMediaStream ...");
  if (pAMStream->AddMediaStream(NULL, &MSPID_PrimaryVideo, 0, NULL) != S_OK)
  {
    DisplayMBox("Could not add PrimaryVideo to IAMMMultiMediaStream", "open file error");
    pAMStream->Release();
    return false;
  }

  if (cancelDialog)
    cancelDialog->SetText2("Adding primary audio stream to IAMMultiMediaStream ...");
  if (pAMStream->AddMediaStream(NULL, &MSPID_PrimaryAudio, 0, NULL) != S_OK)
  {
    DisplayMBox("Could not add PrimaryAudio to IAMMMultiMediaStream", "open file error");
    pAMStream->Release();
    return false;
  }

  if (cancelDialog)
    cancelDialog->SetText2("Building graph ...");
  if (pAMStream->OpenFile(wPath, AMMSF_NOCLOCK) != S_OK)
  {
    sprintf(tmpStr, "Could not open %s.", files[cFile].fileName);
    DisplayMBox(tmpStr, "open file error");
    pAMStream->Release();
    return false;
  }

  YieldTime();
  if (AbortLoading)
    return false;
  if (editFilters)
  {
    IGraphBuilder *pGB = NULL;

    if (pAMStream->GetFilterGraph(&pGB) == S_OK)
    {
      TFilterDialog *filterDlg = new TFilterDialog(this, IDD_EDITFILTERS);
      filterDlg->pGB = pGB;
      filterDlg->Execute();
      pGB->Release();
    }
    else
      MessageBox("Unable to get filter graph", AppName, MB_OK);
  }

  files[cFile].pMMStream = pAMStream;
  if (cancelDialog)
    cancelDialog->SetText2("Adding reference to IAMMultiMediaStream ...");
  pAMStream->AddRef();

  if (cancelDialog)
    cancelDialog->SetText2("Releasing IAMMultiMediaStream ...");
  pAMStream->Release();

  if (cancelDialog)
    cancelDialog->SetText2("Getting seek info from IMultiMediaStream ...");
  if (files[cFile].pMMStream->GetInformation(&pdwFlags, NULL) != S_OK)
  {
    DisplayMBox("Could not get seek information from IMultiMediaStream", "open file error");
    return false;
  }

  if (!(pdwFlags & MMSSF_SUPPORTSEEK))
  {
    if (MessageBox("File indicates it does not support seeking, try anyway?", "open file warning", MB_YESNO | MB_ICONWARNING) == IDNO)
      return false;
  }

  if (cancelDialog)
    cancelDialog->SetText2("Getting video media stream from IMultiMediaStream ...");
  if (files[cFile].pMMStream->GetMediaStream(MSPID_PrimaryVideo, &files[cFile].pVidStream) != S_OK)
  {
    DisplayMBox("Could not get IMediaStream from IMultiMediaStream", "open file error");
    return false;
  }

  if (cancelDialog)
    cancelDialog->SetText2("Getting IDirectDrawMediaStream from IMultiMediaStream ...");
  if (files[cFile].pVidStream->QueryInterface(IID_IDirectDrawMediaStream, (void **)&files[cFile].pDDMStream) != S_OK)
  {
    DisplayMBox("Could not get IDirectDrawMediaStream from PrimaryVideo", "open file error");
    return false;
  }

  if (cancelDialog)
    cancelDialog->SetText2("Getting time per frame from IDirectDrawMediaStream ...");
  if (files[cFile].pDDMStream->GetTimePerFrame(&files[cFile].frameLength.int64) != S_OK)
  {
    DisplayMBox("Could not get time per frame from IDirectDrawStream", "open file error");
    return false;
  }

  if (cancelDialog)
    cancelDialog->SetText2("Getting duration from IMultiMediaStream ...");
  if (files[cFile].pMMStream->GetDuration(&files[cFile].totalTime.int64) != S_OK)
  {
    DisplayMBox("Could not get Duration from IMultiMediaStream", "open file error");
    return false;
  }

  files[cFile].bitsPerPixel = 32;
  files[cFile].firstFrame = 0;
  files[cFile].lastFrame = ((long)(files[cFile].totalTime.int64 / files[cFile].frameLength.int64)) - 1;
  files[cFile].frameRate = 10000000.0 / ((double)files[cFile].frameLength.int64);
  memset(&files[cFile].ddsd, 0, sizeof(files[cFile].ddsd));
  files[cFile].ddsd.dwSize = sizeof(files[cFile].ddsd);
  files[cFile].ddsd.ddpfPixelFormat.dwSize = sizeof(files[cFile].ddsd.ddpfPixelFormat);

  if (cancelDialog)
    cancelDialog->SetText2("Getting format from IDirectDrawMediaStream ...");
  if (files[cFile].pDDMStream->GetFormat(&files[cFile].ddsd, NULL, NULL, NULL) != S_OK)
  {
    DisplayMBox("Could not get video width and height", "open file error");
    return false;
  }

  if (!(files[cFile].ddsd.dwFlags & DDSD_WIDTH) || !(files[cFile].ddsd.dwFlags & DDSD_HEIGHT))
  {
    DisplayMBox("Could not get video width and height 1", "open file error");
    return false;
  }
  width = files[cFile].ddsd.dwWidth;
  height = files[cFile].ddsd.dwHeight;

  memset(&files[cFile].ddsd, 0, sizeof(files[cFile].ddsd));
  files[cFile].ddsd.dwSize = sizeof(files[cFile].ddsd);
  files[cFile].ddsd.dwWidth = width;
  files[cFile].ddsd.dwHeight = height;
  files[cFile].ddsd.ddpfPixelFormat.dwSize = sizeof(files[cFile].ddsd.ddpfPixelFormat);
  files[cFile].ddsd.ddpfPixelFormat.dwFlags = DDPF_RGB;
  files[cFile].ddsd.ddpfPixelFormat.dwRGBBitCount = 32;
  files[cFile].ddsd.ddpfPixelFormat.dwRBitMask = 0x00FF0000;
  files[cFile].ddsd.ddpfPixelFormat.dwGBitMask = 0x0000FF00;
  files[cFile].ddsd.ddpfPixelFormat.dwBBitMask = 0x000000FF;
  files[cFile].ddsd.dwFlags = DDSD_CAPS | DDSD_WIDTH | DDSD_HEIGHT | DDSD_PIXELFORMAT;
  files[cFile].ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_SYSTEMMEMORY;

  if (cancelDialog)
    cancelDialog->SetText2("Creating DirectDraw instance ...");
  if (DirectDrawCreate(NULL, &files[cFile].pDD, NULL) != DD_OK)
  {
    DisplayMBox("Could not create a DirectDraw instance", "open file error");
    return false;
  }

  if (cancelDialog)
    cancelDialog->SetText2("Setting DirectDraw CooperativeLevel ...");
  if (files[cFile].pDD->SetCooperativeLevel(GetDesktopWindow(), DDSCL_NORMAL) != DD_OK)
  {
    DisplayMBox("Could not set the DirectDraw Cooperative level", "open file error");
    return false;
  }

  if (cancelDialog)
    cancelDialog->SetText2("Getting DirectDraw surface ...");
  if (files[cFile].pDD->CreateSurface(&files[cFile].ddsd, &files[cFile].pDDSurface, NULL) != DD_OK)
  {
    DisplayMBox("Could not create a DirectDraw surface", "open file error");
    return false;
  }

  if (cancelDialog)
    cancelDialog->SetText2("Setting DirectDraw in IDirectDrawMediaStream ...");
  if (files[cFile].pDDMStream->SetDirectDraw(files[cFile].pDD) != S_OK)
  {
    DisplayMBox("Could not set the DirectDraw surface", "open file error");
    return false;
  }

  if (cancelDialog)
    cancelDialog->SetText2("Creating IDirectDrawMediaStream sample ...");
  if (files[cFile].pDDMStream->CreateSample(files[cFile].pDDSurface, NULL, 0, &files[cFile].pDDSample) != S_OK)
  {
    DisplayMBox("Could not create a DirectDraw sample", "open file error");
    return false;
  }

  if (cancelDialog)
    cancelDialog->SetText2("Getting audio media stream from IMultiMediaStream ...");
  if (files[cFile].pMMStream->GetMediaStream(MSPID_PrimaryAudio, &files[cFile].pAudStream) != S_OK)
  {
    DisplayMBox("Could not get IMediaStream from IMultiMediaStream", "open file error");
    return false;
  }

  if (cancelDialog)
    cancelDialog->SetText2("Getting IAudioMediaStream from audio media stream ...");
  if (files[cFile].pAudStream->QueryInterface(IID_IAudioMediaStream, (void**)&files[cFile].pAudMStream) != S_OK)
  {
    DisplayMBox("Could not get IAudioMediaStream from PrimaryAudio", "open file error");
    return false;
  }

  if (cancelDialog)
    cancelDialog->SetText2("Getting format from IAudioMediaStream ...");
  if (files[cFile].pAudMStream->GetFormat(&files[cFile].audioFormat) != S_OK)
    goto noaudio;

  if (files[cFile].audioFormat.wFormatTag != WAVE_FORMAT_PCM)
  {
    DisplayMBox("Audio data type is not supported", "open file warning");
    goto noaudio;
  }

  if (cancelDialog)
    cancelDialog->SetText2("Creating IAudioData instance ...");
  if (CoCreateInstance(CLSID_AMAudioData, NULL, CLSCTX_INPROC_SERVER,
                       IID_IAudioData, (void **)&pAudioData) != S_OK)
  {
    DisplayMBox("Could not create IAudioData", "open file warning");
    goto noaudio;
  }

  files[cFile].pAudData = pAudioData;
  if (cancelDialog)
    cancelDialog->SetText2("Adding reference to IAudioData ...");
  pAudioData->AddRef();

  if (cancelDialog)
    cancelDialog->SetText2("Releasing IAudioData ...");
  pAudioData->Release();

  files[cFile].sampleLength = 10000000.0 / (double)files[cFile].audioFormat.nSamplesPerSec;
  files[cFile].numSamples = floor(((double)files[cFile].totalTime.int64 / 10000000.0) * (double)files[cFile].audioFormat.nSamplesPerSec);
  files[cFile].samplesPerFrame = ceil((double) files[cFile].audioFormat.nSamplesPerSec / (double) files[cFile].frameRate);
  files[cFile].bytesPerSample = 1;
  if (files[cFile].audioFormat.nChannels == 2)
    files[cFile].bytesPerSample *= 2;
  if (files[cFile].audioFormat.wBitsPerSample == 16)
    files[cFile].bytesPerSample *= 2;
  files[cFile].audioBufferSize = files[cFile].samplesPerFrame * files[cFile].bytesPerSample;
  files[cFile].audioBuffer = (PBYTE)malloc(files[cFile].audioBufferSize);
  if (!files[cFile].audioBuffer)
  {
    DisplayMBox("Could not create an audio buffer", "open file warning");
    goto noaudio;
  }

  if (cancelDialog)
    cancelDialog->SetText2("Setting audio buffer in IAudioData ...");
  if (files[cFile].pAudData->SetBuffer(files[cFile].audioBufferSize, files[cFile].audioBuffer, 0) != S_OK)
  {
    DisplayMBox("Could not set the audio buffer in IAudioData", "open file warning");
    goto noaudio;
  }

  if (cancelDialog)
    cancelDialog->SetText2("Setting format in IAudioData ...");
  if (files[cFile].pAudData->SetFormat(&files[cFile].audioFormat) != S_OK)
  {
    DisplayMBox("Could not set the format in IAudioData", "open file warning");
    goto noaudio;
  }

  if (cancelDialog)
    cancelDialog->SetText2("Creating IAudioStreamSample ...");
  if (files[cFile].pAudMStream->CreateSample(files[cFile].pAudData, 0, &files[cFile].pAudSample) != S_OK)
  {
    DisplayMBox("Could not create IAudioStreamSample", "open file warning");
    goto noaudio;
  }
  files[cFile].AudioPresent = true;
noaudio:
  if (cancelDialog)
    cancelDialog->SetText2("Starting stream ...");
  if (files[cFile].pMMStream->SetState(STREAMSTATE_RUN) != S_OK)
  {
    DisplayMBox("Could not start stream running", "open file error");
    return false;
  }
  return true;
}

void TMainWindow::CloseAVI(int cFile)
{
  if (files[cFile].pAudSample)
    files[cFile].pAudSample->Release();
  if (files[cFile].pAudData)
    files[cFile].pAudData->Release();
  if (files[cFile].pAudMStream)
    files[cFile].pAudMStream->Release();
  if (files[cFile].pAudStream)
    files[cFile].pAudStream->Release();
  if (files[cFile].audioBuffer)
    free(files[cFile].audioBuffer);

  if (files[cFile].pDDSample)
    files[cFile].pDDSample->Release();
  if (files[cFile].pDDSurface)
    files[cFile].pDDSurface->Release();
  if (files[cFile].pDD)
    files[cFile].pDD->Release();
  if (files[cFile].pDDMStream)
    files[cFile].pDDMStream->Release();
  if (files[cFile].pVidStream)
    files[cFile].pVidStream->Release();
  if (files[cFile].pMMStream)
    files[cFile].pMMStream->Release();

  files[cFile].pAudSample = NULL;
  files[cFile].pAudData = NULL;
  files[cFile].pDDMStream = NULL;
  files[cFile].pAudMStream = NULL;
  files[cFile].pAudStream = NULL;
  files[cFile].audioBuffer = NULL;
  files[cFile].pVidStream = NULL;
  files[cFile].pMMStream = NULL;
  files[cFile].pDDSurface = NULL;
  files[cFile].pDD = NULL;
  files[cFile].pDDSample = NULL;
}


void TMainWindow::CmFileUp()
{
  fileData tempData;
  int i;

  InputName->DeleteString(currentIFile);
  InputName->InsertString(files[currentIFile].fileName, currentIFile - 1);
  if (currentOFile != currentIFile)
    CloseFile(currentOFile);
  tempData = files[currentIFile];
  files[currentIFile] = files[currentIFile - 1];
  currentIFile--;
  files[currentIFile] = tempData;
  currentOFile = currentIFile;
  currentOPos = 0;
  for (i = 0; i < currentOFile; i++)
    currentOPos += files[i].numFramesUsed;
  InputName->SetSelIndex(currentIFile);
  DisplaySourceInfo();
  DisplayOutputInfo();
}

void TMainWindow::CmFileDown()
{
  fileData tempData;
  int i;

  InputName->DeleteString(currentIFile);
  InputName->InsertString(files[currentIFile].fileName, currentIFile + 1);
  if (currentOFile != currentIFile)
    CloseFile(currentOFile);
  tempData = files[currentIFile];
  files[currentIFile] = files[currentIFile + 1];
  currentIFile++;
  files[currentIFile] = tempData;
  currentOFile = currentIFile;
  currentOPos = 0;
  for (i = 0; i < currentOFile; i++)
    currentOPos += files[i].numFramesUsed;
  InputName->SetSelIndex(currentIFile);
  DisplaySourceInfo();
  DisplayOutputInfo();
}

void TMainWindow::CmFileRemove()
{
  RemoveFile(currentIFile);
}

void TMainWindow::RemoveFile(int cFile)
{
  int i;

  if (files[cFile].AudioPresent)
    AudioAvail--;
  if (files[cFile].aviFile)
    AVIAvail--;

  CloseFile(cFile);
  if (batch)
  {
    if (files[cFile].audioBuffer1)
      free(files[cFile].audioBuffer1);
    files[cFile].audioBuffer1 = NULL;
  }
  CloseFile(currentIFile);
  if (batch)
  {
    if (files[currentIFile].audioBuffer1)
      free(files[currentIFile].audioBuffer1);
    files[currentIFile].audioBuffer1 = NULL;
  }

  CloseFile(currentOFile);
  if (batch)
  {
    if (files[currentOFile].audioBuffer1)
      free(files[currentOFile].audioBuffer1);
    files[currentOFile].audioBuffer1 = NULL;
  }

  if (cFile < fileCount - 1)
  {
    i = cFile;
    while (i < fileCount - 1)
    {
      files[i] = files[i + 1];
      i++;
    }
  }

  InputName->DeleteString(cFile);
  fileCount--;
  if (!fileCount)
  {
    LongestName = 0;
    currentIFile = -1;
    currentOFile = -1;
    strcpy(MPEGFilename, "");
    InputName->ClearList();
    MPEGWidth = 0;
    MPEGHeight = 0;
  }
  else
  {
    if (currentIFile > fileCount - 1)
      currentIFile--;
    if (!OpenFile(currentIFile))
    {
      PostMessage(WM_COMMAND, CM_FILEREMOVE);
      return;
    }
    if (batch)
    {
      currentOFile = currentIFile;
      currentOPos = 0;
    }
    else
    {
      if (currentOFile > fileCount - 1)
        currentOFile--;
      currentOPos = 0;
      for (i = 0; i < currentOFile; i++)
        currentOPos += files[i].numFramesUsed;
      if (currentOFile != currentIFile)
        if (!OpenFile(currentOFile))
        {
          PostMessage(WM_COMMAND, CM_FILEREMOVE);
          return;
        }
    }
  }
  DisplayFileInfo();
  DisplaySourceInfo();
  DisplayOutputInfo();

  if (!AudioAvail && !batch)
  {
    samplesPerSec = 0;
    if (audioBuffer1)
      free(audioBuffer1);
    audioBuffer1 = NULL;
  }
}

bool TMainWindow::OpenList(int cFile)
{
  char tmpStr[MAXPATH];

  if (!files[cFile].fileList)
    if ((files[cFile].fileList = fopen(files[cFile].fileName, "rt")) == NULL)
    {
      sprintf(tmpStr,"Could not open file list %s.", files[cFile].fileName);
      DisplayMBox(tmpStr, "open file list error");
      return false;
    }
  return true;
}

bool TMainWindow::AddList(char *name)
{
  char filetext[MAXPATH];
  char tmpStr[MAXPATH];
  char *tmpPtr;
  int cFile;
  long i;

  if (fileCount >= MAX_OPEN_FILES)
  {
    sprintf(tmpStr, "The maximum number (%d) of files has been opened.", MAX_OPEN_FILES);
    DisplayMBox(tmpStr, "open file list error");
    return false;
  }

  cFile = fileCount;
  strcpy(files[cFile].fileName, name);
  files[cFile].AudioPresent = false;
  files[cFile].deinterlace = false;
  files[cFile].invert = false;
  if (!OpenList(cFile))
    return false;

  if (strrchr(name, '\\'))
  {
    strcpy(files[cFile].defListDir, name);
    tmpPtr = strrchr(files[cFile].defListDir, '\\');
    tmpPtr[1] = 0;
  }
  else
    files[cFile].defListDir[0]= 0;

  if (fgets(filetext, MAXPATH, files[cFile].fileList) == NULL)
  {
    sprintf(tmpStr,"Error reading first file name from file list %s.", name);
    DisplayMBox(tmpStr, "open file list error");
    CloseList(cFile);
    return false;
  }

  tmpPtr = strstr(filetext, "\n");
  if (tmpPtr)
    tmpPtr[0] = 0;

  if (!outputDib->LoadFile(filetext))
  {
    DisplayMBox(outputDib->ErrStr, "open file list error");
    CloseList(cFile);
    return false;
  }

  i = 1;
  while (fgets(filetext, MAXPATH, files[cFile].fileList))
    i++;

  if (fseek(files[cFile].fileList, 0, SEEK_SET))
  {
    sprintf(tmpStr,"Could not seek beginning of file %s.", name);
    DisplayMBox(tmpStr, "open file list error");
    CloseList(cFile);
    return false;
  }

  files[cFile].bitsPerPixel = outputDib->picBitsPerPixel;
  files[cFile].startFrame = 0;
  files[cFile].endFrame = i - 1;
  files[cFile].firstFrame = 0;
  files[cFile].lastFrame = i - 1;
  files[cFile].numFrames = files[cFile].numFramesUsed = i;
  if (!batch && samplesPerSec)
  {
    files[cFile].bytesPerSample = 4;
    files[cFile].samplesPerFrame = audioBufferSize1 >> 2;
    files[cFile].numSamples = files[cFile].numFrames * files[cFile].samplesPerFrame;
  }
  else
  {
    files[cFile].bytesPerSample = 0;
    files[cFile].samplesPerFrame = 0;
    files[cFile].numSamples = 0;
  }
  files[cFile].startSample = 0;
  files[cFile].numSamplesUsed = files[cFile].numSamples;
  files[cFile].currentFrame = 0;
  files[cFile].repeatCount = 1;
  files[cFile].cropFrames = false;
  files[cFile].resize = false;
  files[cFile].propSize = true;
  files[cFile].cropX = 0;
  files[cFile].cropY = 0;
  files[cFile].cropW = 0;
  files[cFile].cropH = 0;
  files[cFile].ddsd.dwWidth = outputDib->W;
  files[cFile].ddsd.dwHeight = outputDib->H;
  files[cFile].frameRate = 1; // 1 frame per second
  if (batch)
  {
    files[cFile].mpegWidth = outputDib->W;
    files[cFile].mpegHeight = outputDib->H;
  }
  else
  {
    if (!MPEGWidth || !MPEGHeight)
    {
      MPEGWidth = outputDib->W;
      MPEGHeight = outputDib->H;
    }
  }
  if (currentIFile != cFile)
    CloseFile(currentIFile);
  currentIFile = cFile;
  if (currentOFile != cFile)
    CloseFile(currentOFile);
  currentOFile = cFile;
  files[cFile].aviFile = false;
  DisplayFileInfo();

  return true;
}

void TMainWindow::CloseList(int cFile)
{
  if (files[cFile].fileList)
    fclose(files[cFile].fileList);

  files[cFile].fileList = NULL;
}

void TMainWindow::CmExit()
{
  if (Playing)
    Pause = true;
  else
    PostMessage(WM_CLOSE);
}


void TMainWindow::EvHelp()
{
  WinHelp(helpFile, HELP_CONTEXT, 0);
}



DEFINE_RESPONSE_TABLE1(TMyFrameWindow, TFrameWindow)
  EV_WM_SETFOCUS,
END_RESPONSE_TABLE;

TMyFrameWindow::TMyFrameWindow(TWindow* parent, const char far *title, TWindow *clientWnd, bool shrinkToClient, TModule *module)
                 : TFrameWindow(parent, title, clientWnd, shrinkToClient, module)
{
  Attr.Style ^= (WS_MAXIMIZEBOX | WS_THICKFRAME);
  Attr.X = GetProfileInt(AppName, "left", 100);
  Attr.Y = GetProfileInt(AppName, "top", 50);
  batch = GetProfileInt(AppName, "batch", 0);
  editFilters = GetProfileInt(AppName, "editFilters", 0);
  SetIcon(GetApplication(), IDI_BBICON);
  SetIconSm(GetApplication(), IDI_SMBBICON);
  Encoding = false;
}

void TMyFrameWindow::EvSetFocus(HWND hWndLostFocus)
{
  if (Encoding)
  {
    dllSetFocus();
    return;
  }
  TFrameWindow::EvSetFocus(hWndLostFocus);
}

bool TMyFrameWindow::CanClose()
{
  char tmpStr[15];

  if (Playing)
  {
    Pause = true;
    return false;
  }

//  if (mainWindow)
//  {
//    while (fileCount > 0)
//    {
//      if (files[fileCount - 1].aviFile)
//        mainWindow->CloseAVI(fileCount - 1);
//      else
//        mainWindow->CloseList(fileCount - 1);
//      if (files[fileCount - 1].audioBuffer1)
//        free(files[fileCount - 1].audioBuffer1);
//      fileCount--;
//    }
//  }

  sprintf(tmpStr, "%d", Attr.X);
  WriteProfileString(AppName, "left", tmpStr);
  sprintf(tmpStr, "%d", Attr.Y);
  WriteProfileString(AppName, "top", tmpStr);
  sprintf(tmpStr, "%d", batch);
  WriteProfileString(AppName, "batch", tmpStr);
  sprintf(tmpStr, "%d", editFilters);
  WriteProfileString(AppName, "editFilters", tmpStr);
  return true;
}



class TAVI2MPGApp : public TApplication
{
  public:
	 TAVI2MPGApp() : TApplication() {}

    void InitMainWindow()
    {
      char tmpStr[MAXPATH];

      strcpy(tmpStr, AppName);
      strcat(tmpStr, " - ");
      strcat(tmpStr, AppVersion);
      frameWindow = new TMyFrameWindow(0, tmpStr, new TMainWindow(0, IDD_MAINDIALOG), true);
      SetMainWindow(frameWindow);
    }
};

int OwlMain(int argc, char* argv[])
{
  int retval;
  TAVI2MPGApp *MainApp;

  strcpy(AppName, "AVI2MPG2");
  strcpy(AppVersion, "v1.24 beta 13");
  if (getcwd(helpFile, MAXPATH) == NULL)
    strcpy(helpFile, "");
  strcat(helpFile, "\\avi2mpg2.hlp");

  retval = 1;
  if (CoInitialize(NULL) == S_OK)
  {
    MainApp = new TAVI2MPGApp();
    retval = MainApp->Run();
    delete MainApp;
    CoUninitialize();
  }
  else
    MessageBox(NULL, "Unable to initialize the COM library", AppName, MB_OK | MB_ICONERROR);
  return retval;
}

#define WinMain
