#if defined(__BORLANDC__)
#include <condefs.h>
USEUNIT("prevdib.cpp");
USEUNIT("fulldib.cpp");
USEUNIT("basedib.cpp");
USEFILE("..\..\borbin\bbmpeg.dll");
USELIB("..\..\borbin\jpeglib.lib");
USERC("..\res\avi2mpg2.rc");
//---------------------------------------------------------------------------
#endif // defined(__BORLANDC__)
//----------------------------------------------------------------------------
//   AVI2MPG2_VFW - a shell for bbMPEG to convert avi's to mpeg-2 movies
//----------------------------------------------------------------------------
#include "avi2mpg2.h"
#include <vfw.h>
#include <math.h>

#include "prTypes.h"
#include "prCompile.h"
#include "prWinEnv.h"

typedef PREMPLUGENTRY (* CompileEntry) (int selector, compStdParms *stdParms,
                                    long param1, long param2);

#define MAX_OPEN_FILES 256

CompileEntry dllEntry;
compStdParms stdParms;
compInfoRec infoRec;
compGetFilePrefsRec filePrefsRec;
compDoCompileInfo doCompileInfo;
compOutputRec outputRec;
compCallbackFuncs callbackFuncs;
compVideoFuncs videoFuncs;
compAudioFuncs audioFuncs;
compFileInfoRec fileInfoRec;
compAudioInfoRec audioInfoRec;

bool AbortDisplay;
bool AbortOperation;
bool AbortPreview;
bool ShowAnimGIF;
bool batch;

struct fileData {
char fileName[MAXPATH];
char mpegFilename[MAXPATH];
char defListDir[MAXPATH];
PAVIFILE pfile;
PAVISTREAM pavi_video;
PAVISTREAM pavi_audio;
PGETFRAME pgf;
WAVEFORMATEX audioFormat;
AVISTREAMINFO audioInfo;
AVISTREAMINFO videoInfo;
AVIFILEINFO fileInfo;
FILE *fileList;
bool VideoPresent;
bool AudioPresent;
bool aviFile;
bool deinterlace;
bool invert;
bool cropFrames, propSize, resize;
unsigned int cropX, cropY, cropW, cropH, previewRate;
unsigned int startFrame, endFrame, firstFrame, lastFrame, repeatCount;
unsigned int currentFrame, numFrames, numFramesUsed, bitsPerPixel;
unsigned int mpegWidth, mpegHeight;
int samplesPerSec, audioBufferSize;
unsigned char *audioBuffer;
unsigned short int *audioBuffer1, *audioBuffer2;
int audioChannels, audioBitsPerSample;
int audioSampleSize, samplesPerFrame;
};

bbMPEGSetFocusEntry dllSetFocus;
bbMPEGAppWindowEntry dllAppWindow;
char AppName[30];
char AppVersion[30];
fileData files[MAX_OPEN_FILES];
compGetFrameReturnRec getFrameReturnRec;
bool Encoding, OPreviewing, showOutput, Playing, Stop, Pause;
int AVIAvail, VideoAvail;
unsigned char *audioBuffer;
unsigned short int *audioBuffer1, *audioBuffer2;
unsigned int audioBufferSize;
int audioChannels, audioBitsPerSample;
TMainWindow *mainWindow;
TMyFrameWindow *frameWindow;
int currentIFile, currentOFile, fileCount;
int audioSampleSize, MPEGWidth, MPEGHeight;
int samplesPerFrame, samplesPerSec, relOPos, currentOPos;
unsigned int totalFrames;
char helpFile[MAXPATH];
char curFilename[MAXPATH];

int round(float num)
{
  if (num - floor(num) >= 0.50)
    return ceil(num);
  else
    return floor(num);
}

long getBlipMax(long compileSeqID)
{
  return audioBufferSize;
}

int getAudio(long frame, long *frameCount, long *size, long offset,
             BufferReturnType theBuffer, long compileSeqID)
{
  long startSample, numBytes, numSamples;
  unsigned short int *srcPtr;
  int i, j, k;

  mainWindow->YieldTime();
  currentOPos = frame;
  mainWindow->SetRelPos();
  if (batch)
    startSample = relOPos * files[currentOFile].samplesPerFrame;
  else
    startSample = relOPos * samplesPerFrame;

  if (batch)
  {
    if (files[currentOFile].AudioPresent)
    {
      if (AVIStreamRead(files[currentOFile].pavi_audio, startSample, files[currentOFile].samplesPerFrame,
                       (void *) files[currentOFile].audioBuffer, files[currentOFile].audioBufferSize, &numBytes, &numSamples))
        return comp_InternalError;
      *frameCount = 1;
      if ((files[currentOFile].samplesPerSec != 22050) && (files[currentOFile].audioBitsPerSample != 8))
      {
        *size = numBytes;
        **theBuffer = (char*)files[currentOFile].audioBuffer;
      }
      else
      {
        if (files[currentOFile].audioBitsPerSample == 8)
        {
          for (i = 0; i < numBytes; i++)
            files[currentOFile].audioBuffer2[i] = ((unsigned short int) files[currentOFile].audioBuffer[i] + 128) << 8;
          *size = numBytes << 1;
          **theBuffer = (char*)files[currentOFile].audioBuffer2;
        }
        if (files[currentOFile].samplesPerSec == 22050)
        {
          if (files[currentOFile].audioBitsPerSample == 8)
          {
            srcPtr = files[currentOFile].audioBuffer2;
            *size = numBytes << 2;
          }
          else
          {
            srcPtr = (unsigned short *)files[currentOFile].audioBuffer;
            *size = numBytes << 1;
          }
          **theBuffer = (char*)files[currentOFile].audioBuffer1;
          if (files[currentOFile].audioChannels == 2)
          {
            j = 0;
            k = 0;
            for (i = 0; i < files[currentOFile].samplesPerFrame; i++)
            {
              files[currentOFile].audioBuffer1[j++] = srcPtr[k];
              files[currentOFile].audioBuffer1[j++] = srcPtr[k+1];
              files[currentOFile].audioBuffer1[j++] = srcPtr[k++];
              files[currentOFile].audioBuffer1[j++] = srcPtr[k++];
            }
          }
          else
          {
            j = 0;
            for (i = 0; i < files[currentOFile].samplesPerFrame; i++)
            {
              files[currentOFile].audioBuffer1[j++] = srcPtr[i];
              files[currentOFile].audioBuffer1[j++] = srcPtr[i];
            }
          }
        }
      }
    }
    else
    {
      if ((files[currentOFile].samplesPerSec != 22050) && (files[currentOFile].audioBitsPerSample != 8))
      {
        memset(files[currentOFile].audioBuffer, 0, files[currentOFile].audioBufferSize);
        *size = files[currentOFile].audioBufferSize;
        **theBuffer = (char*)files[currentOFile].audioBuffer;
      }
      else
      {
        i = files[currentOFile].audioBufferSize << 1;
        if (files[currentOFile].samplesPerSec == 22050)
        {
          if (files[currentOFile].audioBitsPerSample == 8)
            i = i << 1;
          memset(files[currentOFile].audioBuffer2, 0, i);
          **theBuffer = (char*)files[currentOFile].audioBuffer2;
        }
        else
        {
          memset(files[currentOFile].audioBuffer1, 0, i);
          **theBuffer = (char*)files[currentOFile].audioBuffer1;
        }
        *size = i;
      }
    }
  }
  else
  {
    if (files[currentOFile].AudioPresent)
    {
      if (AVIStreamRead(files[currentOFile].pavi_audio, startSample, samplesPerFrame, (void *) audioBuffer,
                        audioBufferSize, &numBytes, &numSamples))
        return comp_InternalError;
      *frameCount = 1;
      if ((samplesPerSec != 22050) && (audioBitsPerSample != 8))
      {
        *size = numBytes;
        **theBuffer = (char*)audioBuffer;
      }
      else
      {
        if (audioBitsPerSample == 8)
        {
          for (i = 0; i < numBytes; i++)
            audioBuffer2[i] = ((unsigned short int) audioBuffer[i] + 128) << 8;
          *size = numBytes << 1;
          **theBuffer = (char*)audioBuffer2;
        }
        if (samplesPerSec == 22050)
        {
          if (audioBitsPerSample == 8)
          {
            srcPtr = audioBuffer2;
            *size = numBytes << 2;
          }
          else
          {
            srcPtr = (unsigned short *)audioBuffer;
            *size = numBytes << 1;
          }
          **theBuffer = (char*)audioBuffer1;
          if (audioChannels == 2)
          {
            j = 0;
            k = 0;
            for (i = 0; i < samplesPerFrame; i++)
            {
              audioBuffer1[j++] = srcPtr[k];
              audioBuffer1[j++] = srcPtr[k+1];
              audioBuffer1[j++] = srcPtr[k++];
              audioBuffer1[j++] = srcPtr[k++];
            }
          }
          else
          {
            j = 0;
            for (i = 0; i < samplesPerFrame; i++)
            {
              audioBuffer1[j++] = srcPtr[i];
              audioBuffer1[j++] = srcPtr[i];
            }
          }
        }
      }
    }
    else
    {
      if ((samplesPerSec != 22050) && (audioBitsPerSample != 8))
      {
        memset(audioBuffer, 0, audioBufferSize);
        *size = audioBufferSize;
        **theBuffer = (char*)audioBuffer;
      }
      else
      {
        i = audioBufferSize << 1;
        if (samplesPerSec == 22050)
        {
          if (audioBitsPerSample == 8)
            i = i << 1;
          memset(audioBuffer2, 0, i);
          **theBuffer = (char*)audioBuffer2;
        }
        else
        {
          memset(audioBuffer1, 0, i);
          **theBuffer = (char*)audioBuffer1;
        }
        *size = i;
      }
    }
  }
  *frameCount = 1;
  return comp_ErrNone;
}

int getFrame(long frame, void **buffer, long *rowbytes,
             compGetFrameReturnRec *frameReturnRec,
             char getCompressed, long getFrameData)
{
  BITMAPINFO *bitmapInfo;
  int i, x, y, w, h;
  double xRatio, yRatio;
  char tmpStr[MAXPATH], *tmpPtr;

  mainWindow->YieldTime();
  frameReturnRec->repeatCount = 0;
  currentOPos = frame;
  mainWindow->SetRelPos();
  if (batch)
  {
    w = files[currentOFile].mpegWidth;
    h = files[currentOFile].mpegHeight;
  }
  else
  {
    w = MPEGWidth;
    h = MPEGHeight;
  }
  *rowbytes = w << 2;

  if (files[currentOFile].VideoPresent)
  {
    if (files[currentOFile].aviFile)
    {
      bitmapInfo = (BITMAPINFO *) AVIStreamGetFrame(files[currentOFile].pgf, relOPos);
      if (bitmapInfo == NULL)
      {
        frameReturnRec->returnVal = comp_InternalError;
        return comp_InternalError;
      }

      if (!mainWindow->outputDib->LoadFromBMP(bitmapInfo))
      {
        frameReturnRec->returnVal = comp_InternalError;
        return comp_InternalError;
      }
    }
    else
    {
      if (fseek(files[currentOFile].fileList, 0, SEEK_SET))
      {
        frameReturnRec->returnVal = comp_InternalError;
        return comp_InternalError;
      }
      for (i = 0; i <= relOPos; i++)
      {
        if (!fgets(tmpStr, MAXPATH, files[currentOFile].fileList))
        {
          frameReturnRec->returnVal = comp_InternalError;
          return comp_InternalError;
        }
      }
      tmpPtr = strstr(tmpStr, "\n");
      if (tmpPtr)
        tmpPtr[0] = 0;
      if (!strstr(tmpStr, "\\"))
      {
        char tmpStr1[MAXPATH];
        strcpy(tmpStr1, tmpStr);
        strcpy(tmpStr, files[currentOFile].defListDir);
        strcat(tmpStr, tmpStr1);
      }
      if (!mainWindow->outputDib->LoadFile(tmpStr))
      {
        frameReturnRec->returnVal = comp_InternalError;
        return comp_InternalError;
      }
      if (mainWindow->outputDib->BitsPerPixel != 32)
        if (!mainWindow->outputDib->ChangeDepth(32))
        {
          frameReturnRec->returnVal = comp_InternalError;
          return comp_InternalError;
        }
    }

    if (files[currentOFile].deinterlace)
      mainWindow->outputDib->Deinterlace();

    if (files[currentOFile].invert)
      if (!mainWindow->outputDib->Invert())
        return comp_InternalError;

    if (files[currentOFile].cropW && files[currentOFile].cropH)
    {
      if (!mainWindow->outputDib->Crop(files[currentOFile].cropX,
                                       files[currentOFile].cropY,
                                       files[currentOFile].cropW,
                                       files[currentOFile].cropH))
      {
        frameReturnRec->returnVal = comp_InternalError;
        return comp_InternalError;
      }
    }

    if ((mainWindow->outputDib->W == w) && (mainWindow->outputDib->H == h))
    {
      *buffer = (unsigned char *) mainWindow->outputDib->GetBits();
      frameReturnRec->returnVal = comp_ErrNone;
      return comp_ErrNone;
    }

    if (files[currentOFile].resize)
    {
      if (!mainWindow->outputDib->Rescale(w, h, w, h))
      {
        frameReturnRec->returnVal = comp_InternalError;
        return comp_InternalError;
      }
      *buffer = (unsigned char *) mainWindow->outputDib->GetBits();
      frameReturnRec->returnVal = comp_ErrNone;
      return comp_ErrNone;
    }

    if (files[currentOFile].cropFrames)
    {
      if (!mainWindow->outputDib->Crop(0, 0, w, h))
      {
        frameReturnRec->returnVal = comp_InternalError;
        return comp_InternalError;
      }
      *buffer = (unsigned char *) mainWindow->outputDib->GetBits();
      frameReturnRec->returnVal = comp_ErrNone;
      return comp_ErrNone;
    }

    xRatio = (double) w / (double) mainWindow->outputDib->W;
    yRatio = (double) h / (double) mainWindow->outputDib->H;
    if (xRatio < yRatio)
    {
      x = (int)ceil((double)mainWindow->outputDib->W * xRatio);
      y = (int)ceil((double)mainWindow->outputDib->H * xRatio);
    }
    else
    {
      x = (int)ceil((double)mainWindow->outputDib->W * yRatio);
      y = (int)ceil((double)mainWindow->outputDib->H * yRatio);
    }
    if (x > w)
      x = w;
    if (y > h)
      y = h;
    if (!mainWindow->outputDib->Rescale(x, y, w, h))
    {
      frameReturnRec->returnVal = comp_InternalError;
      return comp_InternalError;
    }
    *buffer = (unsigned char *) mainWindow->outputDib->GetBits();
    frameReturnRec->returnVal = comp_ErrNone;
    return comp_ErrNone;
  }

  if (!mainWindow->outputDib->CreateBlankDib(w, h))
  {
    frameReturnRec->returnVal = comp_InternalError;
    return comp_InternalError;
  }
  *buffer = (unsigned char *) mainWindow->outputDib->GetBits();
  frameReturnRec->returnVal = comp_ErrNone;
  return comp_ErrNone;
}

DEFINE_RESPONSE_TABLE1(TMainWindow, TWindow)
  EV_WM_PAINT,
  EV_WM_HSCROLL,
  EV_WM_VSCROLL,
  EV_WM_RBUTTONUP,
  EV_WM_RBUTTONDOWN,
  EV_COMMAND(CM_STARTCONVERSION, CmStartConversion),
  EV_COMMAND(CM_FILEOPEN2, CmFileOpen),
  EV_COMMAND(CM_FILEREMOVE, CmFileRemove),
  EV_COMMAND(CM_FILEUP, CmFileUp),
  EV_COMMAND(CM_FILEDOWN, CmFileDown),
  EV_COMMAND(CM_ABOUT, CmAbout),
  EV_COMMAND(CM_EXITAPP, CmExit),
  EV_COMMAND(IDC_LOADPROJECT, EvLoadProject),
  EV_COMMAND(IDC_SAVEPROJECT, EvSaveProject),
  EV_COMMAND(IDC_HELPBUTTON, EvHelp),
  EV_COMMAND(IDC_VIDEOSELECT, CmVideoOpen),
  EV_COMMAND(IDC_IPREVIEW, EvIPreview),
  EV_COMMAND(IDC_OPREVIEW, EvOPreview),
  EV_COMMAND(IDC_CROP, EvCropCheck),
  EV_COMMAND(IDC_DEINTERLACE, EvDeInterlace),
  EV_COMMAND(IDC_INVERT, EvInvert),
  EV_COMMAND(IDC_SHOWOUTPUT, EvShowOutput),
  EV_COMMAND(IDC_PROPORTIONAL, EvPropCheck),
  EV_COMMAND(IDC_RESIZE, EvResizeCheck),
  EV_COMMAND(CM_KEYRETURN, EvKeyReturn),
  EV_COMMAND(CM_KEYT, EvStartFrame),
  EV_COMMAND(CM_KEYN, EvEndFrame),
  EV_COMMAND(IDC_IPLAY, EvIPlay),
  EV_COMMAND(IDC_IPAUSE, EvIPause),
  EV_COMMAND(IDC_ISTOP, EvIStop),
  EV_COMMAND(IDC_OPLAY, EvOPlay),
  EV_COMMAND(IDC_OPAUSE, EvOPause),
  EV_COMMAND(IDC_OSTOP, EvOStop),
  EV_COMMAND(IDC_BATCH, EvBatch),
  EV_LBN_SELCHANGE(IDC_SOURCENAME, EvSourceChange),
  EV_EN_KILLFOCUS(IDC_STARTTEXT, EvStartKillFocus),
  EV_EN_KILLFOCUS(IDC_ENDTEXT, EvEndKillFocus),
  EV_EN_KILLFOCUS(IDC_ICURRENTTEXT, EvICurrentKillFocus),
  EV_EN_KILLFOCUS(IDC_OCURRENTTEXT, EvOCurrentKillFocus),
  EV_EN_KILLFOCUS(IDC_REPEATCOUNT, EvRepeatKillFocus),
  EV_EN_KILLFOCUS(IDC_CROPX, EvCropXKillFocus),
  EV_EN_KILLFOCUS(IDC_CROPY, EvCropYKillFocus),
  EV_EN_KILLFOCUS(IDC_CROPW, EvCropWKillFocus),
  EV_EN_KILLFOCUS(IDC_CROPH, EvCropHKillFocus),
  EV_EN_KILLFOCUS(IDC_MPEGWIDTH, EvMPEGWKillFocus),
  EV_EN_KILLFOCUS(IDC_MPEGHEIGHT, EvMPEGHKillFocus),
  EV_UDN_DELTAPOS(IDC_CROPXSCROLL, EvCropXBump),
  EV_UDN_DELTAPOS(IDC_CROPYSCROLL, EvCropYBump),
  EV_UDN_DELTAPOS(IDC_CROPWSCROLL, EvCropWBump),
  EV_UDN_DELTAPOS(IDC_CROPHSCROLL, EvCropHBump),
  EV_UDN_DELTAPOS(IDC_MPEGWSCROLL, EvMPEGWBump),
  EV_UDN_DELTAPOS(IDC_MPEGHSCROLL, EvMPEGHBump),
END_RESPONSE_TABLE;

TMainWindow::TMainWindow(TWindow *parent, TResId resId, TModule* module):
             TDialog(parent, resId, module)
{
  TWindow::Attr.AccelTable = IDC_ACCELTABLE;
  InputName = new TListBox(this, IDC_SOURCENAME);
  VideoName = new TEdit(this, IDC_VIDEONAME);
  ProjectName = new TEdit(this, IDC_PROJECTNAME);
  InputLBox = new TListBox(this, IDC_SOURCELBOX);
  StartButton = new TButton(this, CM_STARTCONVERSION);
  MPEGOpenButton = new TButton(this, IDC_VIDEOSELECT);
  StartText = new TEdit(this, IDC_STARTTEXT);
  EndText = new TEdit(this, IDC_ENDTEXT);
  IFirstText = new TStatic(this, IDC_IFIRSTTEXT);
  ICurrentText = new TEdit(this, IDC_ICURRENTTEXT);
  ILastText = new TStatic(this, IDC_ILASTTEXT);
  IVideoRect = new TStatic(this, IDC_IVIDEORECT);
  OFirstText = new TStatic(this, IDC_OFIRSTTEXT);
  OCurrentText = new TEdit(this, IDC_OCURRENTTEXT);
  OLastText = new TStatic(this, IDC_OLASTTEXT);
  OFileText = new TStatic(this, IDC_OFILENUM);
  OFrameText = new TStatic(this, IDC_OFRAMENUM);
  OVideoRect = new TStatic(this, IDC_OVIDEORECT);
  IVideoScroll = new TScrollBar(this, IDC_IVIDEOSCROLL);
  OVideoScroll = new TScrollBar(this, IDC_OVIDEOSCROLL);
  OFileScroll = new TUpDown(this, IDC_OFILEUPDOWN);
  RepeatText = new TEdit(this, IDC_REPEATCOUNT);
  RemoveButton = new TButton(this, CM_FILEREMOVE);
  UpButton = new TButton(this, CM_FILEUP);
  DownButton = new TButton(this, CM_FILEDOWN);
  SaveButton = new TButton(this, IDC_SAVEPROJECT);
  DeInterCheck = new TCheckBox(this, IDC_DEINTERLACE);
  Invert = new TCheckBox(this, IDC_INVERT);
  ShowOutput = new TCheckBox(this, IDC_SHOWOUTPUT);
  BatchCheck = new TCheckBox(this, IDC_BATCH);
  PropCheck = new TRadioButton(this, IDC_PROPORTIONAL);
  ResizeCheck = new TRadioButton(this, IDC_RESIZE);
  FilterCheck = new TCheckBox(this, IDC_EDITFILTERS);
  CropCheck = new TRadioButton(this, IDC_CROP);
  CropXEdit = new TEdit(this, IDC_CROPX);
  CropXScroll = new TUpDown(this, IDC_CROPXSCROLL, CropXEdit);
  CropYEdit = new TEdit(this, IDC_CROPY);
  CropYScroll = new TUpDown(this, IDC_CROPYSCROLL, CropYEdit);
  CropWEdit = new TEdit(this, IDC_CROPW);
  CropWScroll = new TUpDown(this, IDC_CROPWSCROLL, CropWEdit);
  CropHEdit = new TEdit(this, IDC_CROPH);
  CropHScroll = new TUpDown(this, IDC_CROPHSCROLL, CropHEdit);
  MPEGWEdit = new TEdit(this, IDC_MPEGWIDTH);
  MPEGWScroll = new TUpDown(this, IDC_MPEGWSCROLL, MPEGWEdit);
  MPEGHEdit = new TEdit(this, IDC_MPEGHEIGHT);
  MPEGHScroll = new TUpDown(this, IDC_MPEGHSCROLL, MPEGHEdit);
  IPlay = new TButton(this, IDC_IPLAY);
  IPause = new TButton(this, IDC_IPAUSE);
  IStop = new TButton(this, IDC_ISTOP);
  OPlay = new TButton(this, IDC_OPLAY);
  OPause = new TButton(this, IDC_OPAUSE);
  OStop = new TButton(this, IDC_OSTOP);
  AudioInfo = new TStatic(this, IDC_AUDIOINFO);
}

TMainWindow::~TMainWindow()
{
  if (dllEntry)
    dllEntry(compDoShutdown, &stdParms, (long) 0, (long) 0);
  if (dllPtr)
    FreeLibrary(dllPtr);
  while (fileCount > 0)
  {
    if (files[fileCount - 1].aviFile)
      CloseAVI(fileCount - 1);
    else
      CloseList(fileCount - 1);
    if (files[fileCount - 1].audioBuffer)
      free(files[fileCount - 1].audioBuffer);
    if (files[fileCount - 1].audioBuffer1)
      free(files[fileCount - 1].audioBuffer1);
    if (files[fileCount - 1].audioBuffer2)
      free(files[fileCount - 1].audioBuffer2);
    fileCount--;
  }
  AVIFileExit();
  if (iprevDib)
    delete iprevDib;
  if (oprevDib)
    delete oprevDib;
  if (outputDib)
    delete outputDib;
}

void TMainWindow::SetupWindow()
{
  int i;

  TDialog::SetupWindow();

  currentIFile = -1;
  currentOFile = -1;
  totalFrames = 0;
  currentOPos = -1;
  relOPos = 0;
  iprevDib = NULL;
  oprevDib = NULL;
  outputDib = NULL;
  dllEntry = NULL;
  dllPtr = NULL;
  gotRFirst = false;
  AbortDisplay = false;
  AbortOperation = false;
  AbortPreview = false;
  ShowAnimGIF = false;
  AVIAvail = 0;
  VideoAvail = 0;
  AudioAvail = 0;
  Previewing = false;
  OPreviewing = false;
  Encoding = false;
  showOutput = true;
  Playing = false;
  strcpy(MPEGFilename, "");
  strcpy(curFilename, "");
  InputName->ClearList();
  fileCount = 0;
  MPEGWidth = 0;
  MPEGHeight = 0;
  LongestName = 0;
  VideoName->Clear();
  InputLBox->ClearList();
  LongestMessage = 0;
  mainWindow = this;
  audioBuffer = NULL;
  audioBuffer1 = NULL;
  audioBuffer2 = NULL;
  memset(files, 0, sizeof(files));
  iprevRect.Set(IVideoRect->Attr.X, IVideoRect->Attr.Y,
                IVideoRect->Attr.X + IVideoRect->Attr.W,
                IVideoRect->Attr.Y + IVideoRect->Attr.H);
  oprevRect.Set(OVideoRect->Attr.X, OVideoRect->Attr.Y,
                OVideoRect->Attr.X + OVideoRect->Attr.W,
                OVideoRect->Attr.Y + OVideoRect->Attr.H);
  if (!CreatePrevDibs())
  {
    DisplayMBox("Could not create preview dibs.", "startup preview error");
    PostMessage(WM_CLOSE);
    return;
  }

  dllPtr = LoadLibrary("bbmpeg.dll");
  if (dllPtr == NULL)
  {
    char *buffer;

    FormatMessage(
      FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
      NULL, GetLastError(),
      MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
      (LPTSTR) &buffer, 0, NULL);

    // Display the string.
    MessageBox(buffer, "startup bbMPEG.dll error", MB_OK | MB_ICONERROR);

    // Free the buffer.
    LocalFree(buffer);

    PostMessage(WM_CLOSE);
    return;
  }

  getFrameReturnRec.repeatCount = 0;
  getFrameReturnRec.makeKeyFrame = 0;
  getFrameReturnRec.frameIsCompressed = 0;
  getFrameReturnRec.startframe = 0;
  videoFuncs.getFrame = getFrame;
  callbackFuncs.videoFuncs = &videoFuncs;
  audioFuncs.getAudio = getAudio;
  audioFuncs.getBlipMax = getBlipMax;
  callbackFuncs.audioFuncs = &audioFuncs;
  stdParms.funcs = &callbackFuncs;
  dllEntry = (CompileEntry) GetProcAddress(dllPtr, "xCompileEntry");
  if (dllEntry == NULL)
  {
    DisplayMBox("Could not get compile function address from bbMPEG.dll.", "startup bbMPEG.dll error");
    PostMessage(WM_CLOSE);
    return;
  }

  dllSetFocus = (bbMPEGSetFocusEntry) GetProcAddress(dllPtr, "bbMPEGSetFocus");
  if (dllSetFocus == NULL)
  {
    DisplayMBox("Could not get setfocus function address from bbMPEG.dll.", "startup bbMPEG.dll error");
    PostMessage(WM_CLOSE);
    return;
  }

  dllAppWindow = (bbMPEGAppWindowEntry) GetProcAddress(dllPtr, "bbMPEGAppWnd");
  if (dllAppWindow == NULL)
  {
    DisplayMBox("Could not get appWindow function address from bbMPEG.dll.", "startup bbMPEG.dll error");
    PostMessage(WM_CLOSE);
    return;
  }

  if (dllEntry(compStartup, &stdParms, (long) &infoRec, (long) 0) != comp_ErrNone)
  {
    DisplayMBox("Could not initialize bbMPEG.dll.", "startup bbMPEG.dll error");
    PostMessage(WM_CLOSE);
    return;
  }

  i = 0;
  while (dllEntry(compGetIndFormat, &stdParms, (long) &fileInfoRec, i) != comp_BadFormatIndex)
  {
    i++;
  }
  PopupMenu.AppendMenu(MF_STRING, CM_KEYT, "Mark current frame as s&tarting frame");
  PopupMenu.AppendMenu(MF_STRING, CM_KEYN, "Mark current frame as e&nding frame");
  AVIFileInit();
  ProjectName->SetText("");
  IPause->EnableWindow(false);
  IStop->EnableWindow(false);
  OPause->EnableWindow(false);
  OStop->EnableWindow(false);
  if (batch)
    BatchCheck->Check();
  DisplaySourceInfo();
  DisplayOutputInfo();
  AudioInfo->ShowWindow(SW_HIDE);
  FilterCheck->ShowWindow(SW_HIDE);
}

void TMainWindow::YieldTime()
{
  MSG msg;

  while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
  {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }
}

void TMainWindow::EvBatch()
{
  batch = (BatchCheck->GetCheck() == BF_CHECKED);
}

void TMainWindow::UpdateOPreview()
{
  if (showOutput)
    PostMessage(WM_COMMAND, IDC_OPREVIEW);
}

bool TMainWindow::CreatePrevDibs()
{
  iprevDib = new TPreviewDib(this, iprevRect, false);
  if (iprevDib)
  {
    oprevDib = new TPreviewDib(this, oprevRect, false);
    if (oprevDib)
    {
      outputDib = new TFullDib(this);
      if (outputDib)
        return true;
    }
  }
  return false;
}

void TMainWindow::EvIPlay()
{
  char tmpStr[10];
  unsigned int msCount;

  if (Playing)
  {
    Pause = true;
    PostMessage(WM_COMMAND, IDC_IPLAY);
    return;
  }
  Pause = false;
  Stop = false;
  Playing = true;
  DisplaySourceInfo();
  DisplayOutputInfo();
  IPause->EnableWindow(true);
  IStop->EnableWindow(true);
  StartButton->EnableWindow(false);
  while ((files[currentIFile].currentFrame <= files[currentIFile].lastFrame) &&
         (!Stop) && (!Pause))
  {
    msCount = GetTickCount() + files[currentIFile].previewRate;
    EvIPreview();
    files[currentIFile].currentFrame++;
    if (files[currentIFile].currentFrame <= files[currentIFile].lastFrame)
    {
      IVideoScroll->SetPosition(files[currentIFile].currentFrame);
      sprintf(tmpStr, "%d", files[currentIFile].currentFrame);
      ICurrentText->SetText(tmpStr);
    }
    YieldTime();
    while (msCount > GetTickCount())
      YieldTime();
  }
  if (!Pause)
  {
    files[currentIFile].currentFrame = files[currentIFile].firstFrame;
    IVideoScroll->SetPosition(files[currentIFile].currentFrame);
    sprintf(tmpStr, "%d", files[currentIFile].currentFrame);
    ICurrentText->SetText(tmpStr);
    EvIPreview();
  }
  else
    if (files[currentIFile].currentFrame > files[currentIFile].lastFrame)
      files[currentIFile].currentFrame = files[currentIFile].lastFrame;
  StartButton->EnableWindow(true);
  IPause->EnableWindow(false);
  IStop->EnableWindow(false);
  Playing = false;
  DisplaySourceInfo();
  DisplayOutputInfo();
}

void TMainWindow::EvIPause()
{
  Pause = true;
}

void TMainWindow::EvIStop()
{
  Stop = true;
}

void TMainWindow::EvOPlay()
{
  char tmpStr[10];
  unsigned int msCount;

  if (Playing)
  {
    Pause = true;
    PostMessage(WM_COMMAND, IDC_OPLAY);
    return;
  }
  Pause = false;
  Stop = false;
  Playing = true;
  DisplaySourceInfo();
  DisplayOutputInfo();
  OPause->EnableWindow(true);
  OStop->EnableWindow(true);
  StartButton->EnableWindow(false);
  while ((currentOPos < totalFrames) &&
         (!Stop) && (!Pause))
  {
    msCount = GetTickCount() + files[currentOFile].previewRate;
    EvOPreview();
    currentOPos++;
    if (currentOPos < totalFrames)
    {
      SetRelPos();
      OVideoScroll->SetPosition(currentOPos);
      sprintf(tmpStr, "%d", currentOFile + 1);
      OFileText->SetText(tmpStr);
      sprintf(tmpStr, "%d", relOPos);
      OFrameText->SetText(tmpStr);
      sprintf(tmpStr, "%d", currentOPos);
      OCurrentText->SetText(tmpStr);
    }
    YieldTime();
    while (msCount > GetTickCount())
      YieldTime();
  }
  if (!Pause)
  {
    currentOPos = 0;
    SetRelPos();
    OVideoScroll->SetPosition(currentOPos);
    sprintf(tmpStr, "%d", currentOFile + 1);
    OFileText->SetText(tmpStr);
    sprintf(tmpStr, "%d", relOPos);
    OFrameText->SetText(tmpStr);
    sprintf(tmpStr, "%d", currentOPos);
    OCurrentText->SetText(tmpStr);
    EvOPreview();
  }
  else
    if (currentOPos >= totalFrames)
      currentOPos = totalFrames - 1;
  StartButton->EnableWindow(true);
  OPause->EnableWindow(false);
  OStop->EnableWindow(false);
  Playing = false;
  DisplaySourceInfo();
  DisplayOutputInfo();
}

void TMainWindow::EvOPause()
{
  Pause = true;
}

void TMainWindow::EvOStop()
{
  Stop = true;
}

void TMainWindow::EvIPreview()
{
  BITMAPINFO *bitmapInfo;
  int i, frameNum;
  char tmpStr[MAXPATH], *tmpPtr;

  if (fileCount && files[currentIFile].VideoPresent)
  {
    if (Previewing)
      return;
    Previewing = true;
    frameNum = IVideoScroll->GetPosition();
    if (files[currentIFile].aviFile)
    {
      bitmapInfo = (BITMAPINFO *) AVIStreamGetFrame(files[currentIFile].pgf, frameNum);
      if (bitmapInfo == NULL)
      {
        sprintf(tmpStr, "Could not get frame # %d from file %s.", frameNum, files[currentIFile].fileName);
        DisplayMBox(tmpStr, "AVI error");
        Previewing = false;
        RemoveFile(currentIFile);
        return;
      }
      if (!iprevDib->LoadFromBMP(bitmapInfo))
      {
        DisplayMBox(iprevDib->ErrStr, "avi error");
        Previewing = false;
        RemoveFile(currentIFile);
        return;
      }
      Previewing = false;
    }
    else
    {
      if (fseek(files[currentIFile].fileList, 0, SEEK_SET))
      {
        sprintf(tmpStr, "Could not find beginning of file %s.", files[currentIFile].fileName);
        DisplayMBox(tmpStr, "file list error");
        Previewing = false;
        RemoveFile(currentIFile);
        return;
      }
      for (i = 0; i <= frameNum; i++)
      {
        if (!fgets(tmpStr, MAXPATH, files[currentIFile].fileList))
        {
          sprintf(tmpStr, "Could not get frame # %d from file %s.", frameNum, files[currentIFile].fileName);
          DisplayMBox(tmpStr, "file list error");
          Previewing = false;
          RemoveFile(currentIFile);
          return;
        }
      }
      tmpPtr = strstr(tmpStr, "\n");
      if (tmpPtr)
        tmpPtr[0] = 0;
      if (!strstr(tmpStr, "\\"))
      {
        char tmpStr1[MAXPATH];
        strcpy(tmpStr1, tmpStr);
        strcpy(tmpStr, files[currentIFile].defListDir);
        strcat(tmpStr, tmpStr1);
      }
      if (!iprevDib->LoadFile(tmpStr))
      {
        DisplayMBox(iprevDib->ErrStr, "file list error");
        Previewing = false;
        RemoveFile(currentIFile);
        return;
      }
      files[currentIFile].bitsPerPixel = iprevDib->picBitsPerPixel;
      files[currentIFile].fileInfo.dwWidth = iprevDib->picWidth;
      files[currentIFile].fileInfo.dwHeight = iprevDib->picHeight;
      strcpy(curFilename, tmpStr);
      strlwr(curFilename);
      DisplayFileInfo();
    }
    Previewing = false;
  }
  else
  {
    iprevDib->ClearDib();
    PaintIPreview();
  }
}

void TMainWindow::EvOPreview()
{
  BITMAPINFO *bitmapInfo;
  int i, x, y, w, h;
  double xRatio, yRatio;
  char tmpStr[MAXPATH], *tmpPtr;

  if (VideoAvail)
  {
    if (OPreviewing)
      return;
    OPreviewing = true;
    if (files[currentOFile].aviFile)
    {
      bitmapInfo = (BITMAPINFO *) AVIStreamGetFrame(files[currentOFile].pgf, relOPos);
      if (bitmapInfo == NULL)
      {
        sprintf(tmpStr, "Could not get frame # %d from file %s.", relOPos, files[currentOFile].fileName);
        DisplayMBox(tmpStr, "AVI error");
        OPreviewing = false;
        RemoveFile(currentOFile);
        return;
      }
      if (showOutput)
      {
        if (!outputDib->LoadFromBMP(bitmapInfo))
        {
          DisplayMBox(outputDib->ErrStr, "avi error");
          OPreviewing = false;
          RemoveFile(currentOFile);
          return;
        }
      }
      else
      {
        if (!oprevDib->LoadFromBMP(bitmapInfo))
        {
          DisplayMBox(oprevDib->ErrStr, "avi error");
          OPreviewing = false;
          RemoveFile(currentOFile);
          return;
        }
      }
    }
    else
    {
      if (fseek(files[currentOFile].fileList, 0, SEEK_SET))
      {
        sprintf(tmpStr, "Could not find beginning of file %s.", files[currentOFile].fileName);
        DisplayMBox(tmpStr, "file list error");
        OPreviewing = false;
        RemoveFile(currentOFile);
        return;
      }
      for (i = 0; i <= relOPos; i++)
      {
        if (!fgets(tmpStr, MAXPATH, files[currentOFile].fileList))
        {
          sprintf(tmpStr, "Could not get frame # %d from file %s.", relOPos, files[currentOFile].fileName);
          DisplayMBox(tmpStr, "file list error");
          OPreviewing = false;
          RemoveFile(currentOFile);
          return;
        }
      }
      tmpPtr = strstr(tmpStr, "\n");
      if (tmpPtr)
        tmpPtr[0] = 0;
      if (!strstr(tmpStr, "\\"))
      {
        char tmpStr1[MAXPATH];
        strcpy(tmpStr1, tmpStr);
        strcpy(tmpStr, files[currentOFile].defListDir);
        strcat(tmpStr, tmpStr1);
      }
      if (showOutput)
      {
        if (!outputDib->LoadFile(tmpStr))
        {
          DisplayMBox(outputDib->ErrStr, "file list error");
          OPreviewing = false;
          RemoveFile(currentOFile);
          return;
        }
      }
      else
      {
        if (!oprevDib->LoadFile(tmpStr))
        {
          DisplayMBox(oprevDib->ErrStr, "file list error");
          OPreviewing = false;
          RemoveFile(currentOFile);
          return;
        }
      }
    }
    if (showOutput)
    {
      if (outputDib->BitsPerPixel != 32)
        if (!outputDib->ChangeDepth(32))
        {
          DisplayMBox(outputDib->ErrStr, "change color depth error");
          OPreviewing = false;
          RemoveFile(currentOFile);
          return;
        }

      if (files[currentOFile].deinterlace)
        outputDib->Deinterlace();

      if (files[currentOFile].invert)
        if (!outputDib->Invert())
        {
          DisplayMBox(outputDib->ErrStr, "invert error");
          OPreviewing = false;
          RemoveFile(currentOFile);
          return;
        }

      if (files[currentOFile].cropW && files[currentOFile].cropH)
      {
        if (!outputDib->Crop(files[currentOFile].cropX,
                             files[currentOFile].cropY,
                             files[currentOFile].cropW,
                             files[currentOFile].cropH))
        {
          DisplayMBox(outputDib->ErrStr, "crop error");
          OPreviewing = false;
          RemoveFile(currentOFile);
          return;
        }
      }

      if (batch)
      {
        w = files[currentOFile].mpegWidth;
        h = files[currentOFile].mpegHeight;
      }
      else
      {
        w = MPEGWidth;
        h = MPEGHeight;
      }
      if ((outputDib->W != w) || (outputDib->H != h))
      {
        if (files[currentOFile].resize)
        {
          if (!outputDib->Rescale(w, h, w, h))
          {
            DisplayMBox(outputDib->ErrStr, "rescale error");
            OPreviewing = false;
            RemoveFile(currentOFile);
          }
        }
        else
          if (files[currentOFile].cropFrames)
          {
            if (!outputDib->Crop(0, 0, w, h))
            {
              DisplayMBox(outputDib->ErrStr, "crop error");
              OPreviewing = false;
              RemoveFile(currentOFile);
            }
          }
          else
          {
            xRatio = (double) w / (double) outputDib->W;
            yRatio = (double) h / (double) outputDib->H;
            if (xRatio < yRatio)
            {
              x = (int)(outputDib->W * xRatio);
              y = (int)(outputDib->H * xRatio);
            }
            else
            {
              x = (int)(outputDib->W * yRatio);
              y = (int)(outputDib->H * yRatio);
            }
            if (x > w)
              x = w;
            if (y > h)
              y = h;
            if (!outputDib->Rescale(x, y, w, h))
            {
              DisplayMBox(outputDib->ErrStr, "rescale error");
              OPreviewing = false;
              RemoveFile(currentOFile);
            }
          }
      }
      if (!oprevDib->LoadFromDib(outputDib))
      {
        DisplayMBox(oprevDib->ErrStr, "preview error");
        OPreviewing = false;
        RemoveFile(currentOFile);
        return;
      }
      if (!Playing)
      {
        oprevDib->DrawBorder();
        PaintOPreview();
      }
    }
    OPreviewing = false;
  }
  else
  {
    oprevDib->ClearDib();
    PaintOPreview();
  }
}

void TMainWindow::TempDisp()
{
  oprevDib->LoadFromDib(outputDib);
}

void TMainWindow::EvPaint()
{
  TDialog::EvPaint();
  PaintIPreview();
  PaintOPreview();
}

void TMainWindow::PaintIPreview()
{
  TClientDC dc(HWindow);

  ::SetDIBitsToDevice(dc.GetHDC(), iprevRect.left, iprevRect.top,
                      iprevRect.Width(), iprevRect.Height(),
                      0, 0, 0, iprevRect.Height(),
                      (void *) iprevDib->GetBits(),
                      (BITMAPINFO far*) iprevDib->GetInfo(),
                      iprevDib->Usage());
}

void TMainWindow::PaintOPreview()
{
  TClientDC dc(HWindow);

  ::SetDIBitsToDevice(dc.GetHDC(), oprevRect.left, oprevRect.top,
                      oprevRect.Width(), oprevRect.Height(),
                      0, 0, 0, oprevRect.Height(),
                      (void *) oprevDib->GetBits(),
                      (BITMAPINFO far*) oprevDib->GetInfo(),
                      oprevDib->Usage());
}


void TMainWindow::EvCropXKillFocus()
{
  char tmpStr[80];
  int i;

  CropXEdit->GetText(tmpStr, 80);
  if ((sscanf(tmpStr, "%d", &i) != 1) || (i < 0) || (i > 9999))
  {
    DisplayMBox("Left crop value range is (0 .. 9999).", "invalid entry");
    sprintf(tmpStr, "%d", files[currentIFile].cropX);
    CropXEdit->SetText(tmpStr);
  }
  else
  {
    if (i != files[currentIFile].cropX)
    {
      if (i > files[currentIFile].fileInfo.dwWidth)
        DisplayMBox("Warning, crop left value is greater than width of frame!", "crop left warning");
      files[currentIFile].cropX = i;
      UpdateOPreview();
    }
  }
}

void TMainWindow::EvCropYKillFocus()
{
  char tmpStr[80];
  int i;

  CropYEdit->GetText(tmpStr, 80);
  if ((sscanf(tmpStr, "%d", &i) != 1) || (i < 0) || (i > 9999))
  {
    DisplayMBox("Top crop value range is (0 .. 9999).", "invalid entry");
    sprintf(tmpStr, "%d", files[currentIFile].cropY);
    CropYEdit->SetText(tmpStr);
  }
  else
  {
    if (i != files[currentIFile].cropY)
    {
      if (i > files[currentIFile].fileInfo.dwHeight)
        DisplayMBox("Warning, crop top value is greater than height of frame!", "crop top warning");
      files[currentIFile].cropY = i;
      UpdateOPreview();
    }
  }
}

void TMainWindow::EvCropWKillFocus()
{
  char tmpStr[80];
  int i;

  CropWEdit->GetText(tmpStr, 80);
  if ((sscanf(tmpStr, "%d", &i) != 1) || (i < 0) || (i > 9999))
  {
    DisplayMBox("Crop width value range is (0 .. 9999).", "invalid entry");
    sprintf(tmpStr, "%d", files[currentIFile].cropW);
    CropWEdit->SetText(tmpStr);
  }
  else
  {
    if (i != files[currentIFile].cropW)
    {
      if (files[currentIFile].cropX + i > files[currentIFile].fileInfo.dwWidth)
        DisplayMBox("Warning, crop left plus width is greater than width of frame!", "crop width warning");
      files[currentIFile].cropW = i;
      UpdateOPreview();
    }
  }
}

void TMainWindow::EvCropHKillFocus()
{
  char tmpStr[80];
  int i;

  CropHEdit->GetText(tmpStr, 80);
  if ((sscanf(tmpStr, "%d", &i) != 1) || (i < 0) || (i > 9999))
  {
    DisplayMBox("Crop height value range is (0 .. 9999).", "invalid entry");
    sprintf(tmpStr, "%d", files[currentIFile].cropH);
    CropHEdit->SetText(tmpStr);
  }
  else
  {
    if (i != files[currentIFile].cropH)
    {
      if (files[currentIFile].cropY + i > files[currentIFile].fileInfo.dwHeight)
        DisplayMBox("Warning, crop top plus height is greater than height of frame!", "crop top warning");
      files[currentIFile].cropH = i;
      UpdateOPreview();
    }
  }
}

void TMainWindow::EvMPEGWKillFocus()
{
  char tmpStr[80];
  int i;

  MPEGWEdit->GetText(tmpStr, 80);
  if ((sscanf(tmpStr, "%d", &i) != 1) || (i < 2) || (i > 1920))
  {
    DisplayMBox("MPEG width range is (2 .. 1920).", "invalid entry");
    if (batch)
      sprintf(tmpStr, "%d", files[currentOFile].mpegWidth);
    else
      sprintf(tmpStr, "%d", MPEGWidth);
    MPEGWEdit->SetText(tmpStr);
  }
  else
  {
    if (batch)
      files[currentOFile].mpegWidth = i;
    else
      MPEGWidth = i;
    oprevDib->ClearDib();
    PostMessage(WM_COMMAND, IDC_OPREVIEW);
  }
}

void TMainWindow::EvMPEGHKillFocus()
{
  char tmpStr[80];
  int i;

  MPEGHEdit->GetText(tmpStr, 80);
  if ((sscanf(tmpStr, "%d", &i) != 1) || (i < 2) || (i > 1152))
  {
    DisplayMBox("MPEG height range is (2 .. 1152).", "invalid entry");
    if (batch)
      sprintf(tmpStr, "%d", files[currentOFile].mpegHeight);
    else
      sprintf(tmpStr, "%d", MPEGHeight);
    MPEGHEdit->SetText(tmpStr);
  }
  else
  {
    if (batch)
      files[currentOFile].mpegHeight = i;
    else
      MPEGHeight = i;
    oprevDib->ClearDib();
    PostMessage(WM_COMMAND, IDC_OPREVIEW);
  }
}

bool TMainWindow::EvCropXBump(TNmUpDown& not)
{
  int i, j, k;

  k = not.iPos + not.iDelta;
  CropXScroll->GetRange(i, j);
  if ((k >= i) && (k <= j))
  {
    files[currentIFile].cropX = k;
    UpdateOPreview();
  }
  return false;
}

bool TMainWindow::EvCropYBump(TNmUpDown& not)
{
  int i, j, k;

  k = not.iPos + not.iDelta;
  CropYScroll->GetRange(i, j);
  if ((k >= i) && (k <= j))
  {
    files[currentIFile].cropY = k;
    UpdateOPreview();
  }
  return false;
}

bool TMainWindow::EvCropWBump(TNmUpDown& not)
{
  int i, j, k;

  k = not.iPos + not.iDelta;
  CropWScroll->GetRange(i, j);
  if ((k >= i) && (k <= j))
  {
    files[currentIFile].cropW = k;
    UpdateOPreview();
  }
  return false;
}

bool TMainWindow::EvCropHBump(TNmUpDown& not)
{
  int i, j, k;

  k = not.iPos + not.iDelta;
  CropHScroll->GetRange(i, j);
  if ((k >= i) && (k <= j))
  {
    files[currentIFile].cropH = k;
    UpdateOPreview();
  }
  return false;
}

bool TMainWindow::EvMPEGWBump(TNmUpDown& not)
{
  int i, j, k;

  k = not.iPos + not.iDelta;
  MPEGWScroll->GetRange(i, j);
  if ((k >= i) && (k <= j))
  {
    if (batch)
      files[currentOFile].mpegWidth = k;
    else
      MPEGWidth = k;
    oprevDib->ClearDib();
    PostMessage(WM_COMMAND, IDC_OPREVIEW);
  }
  return false;
}

bool TMainWindow::EvMPEGHBump(TNmUpDown& not)
{
  int i, j, k;

  k = not.iPos + not.iDelta;
  MPEGHScroll->GetRange(i, j);
  if ((k >= i) && (k <= j))
  {
    if (batch)
      files[currentOFile].mpegHeight = k;
    else
      MPEGHeight = k;
    oprevDib->ClearDib();
    PostMessage(WM_COMMAND, IDC_OPREVIEW);
  }
  return false;
}

void TMainWindow::EvCropCheck()
{
  files[currentIFile].cropFrames = CropCheck->GetCheck() == BF_CHECKED;
  if (files[currentIFile].cropFrames)
  {
    files[currentIFile].resize = false;
    files[currentIFile].propSize = false;
  }
  DisplaySourceInfo();
  UpdateOPreview();
}

void TMainWindow::EvPropCheck()
{
  files[currentIFile].propSize = PropCheck->GetCheck() == BF_CHECKED;
  if (files[currentIFile].propSize)
  {
    files[currentIFile].cropFrames = false;
    files[currentIFile].resize = false;
  }
  DisplaySourceInfo();
  UpdateOPreview();
}

void TMainWindow::EvResizeCheck()
{
  files[currentIFile].resize = ResizeCheck->GetCheck() == BF_CHECKED;
  if (files[currentIFile].resize)
  {
    files[currentIFile].cropFrames = false;
    files[currentIFile].propSize = false;
  }
  DisplaySourceInfo();
  UpdateOPreview();
}

void TMainWindow::EvDeInterlace()
{
  files[currentIFile].deinterlace = DeInterCheck->GetCheck() == BF_CHECKED;
  UpdateOPreview();
}

void TMainWindow::EvInvert()
{
  files[currentIFile].invert = Invert->GetCheck() == BF_CHECKED;
  UpdateOPreview();
}

void TMainWindow::EvShowOutput()
{
  showOutput = ShowOutput->GetCheck() == BF_CHECKED;
  oprevDib->ClearDib();
  PostMessage(WM_COMMAND, IDC_OPREVIEW);
}

void TMainWindow::EvSourceChange()
{
  int currentFile;

  if (fileCount)
  {
    files[currentIFile].currentFrame = IVideoScroll->GetPosition();
    currentFile = InputName->GetSelIndex();
    if (currentFile == currentIFile)
      return;
    if (batch)
    {
      CloseFile(currentIFile);
      if (!OpenFile(currentFile))
      {
        RemoveFile(currentFile);
        DisplayOutputInfo();
        DisplaySourceInfo();
        DisplayFileInfo();
        return;
      }
      currentOFile = currentFile;
      DisplayOutputInfo();
    }
    else
    {
      if (currentFile != currentOFile)
      {
        if (!OpenFile(currentFile))
        {
          RemoveFile(currentFile);
          DisplayOutputInfo();
          DisplaySourceInfo();
          DisplayFileInfo();
          return;
        }
      }
      if (currentIFile != currentOFile)
        CloseFile(currentIFile);
    }
    currentIFile = currentFile;
    DisplaySourceInfo();
    DisplayFileInfo();
  }
}

void TMainWindow::DisplaySourceInfo()
{
  char tmpStr[10];
  int i;
  bool gotVideo = fileCount && files[currentIFile].VideoPresent && !Playing;

  if (!Playing)
  {
    if (gotVideo)
    {
      sprintf(tmpStr, "%d", files[currentIFile].firstFrame);
      IFirstText->SetText(tmpStr);
      sprintf(tmpStr, "%d", files[currentIFile].currentFrame);
      ICurrentText->SetText(tmpStr);
      sprintf(tmpStr, "%d", files[currentIFile].lastFrame);
      ILastText->SetText(tmpStr);

      sprintf(tmpStr, "%d", files[currentIFile].startFrame);
      StartText->SetText(tmpStr);
      sprintf(tmpStr, "%d", files[currentIFile].endFrame);
      EndText->SetText(tmpStr);
      sprintf(tmpStr, "%d", files[currentIFile].repeatCount - 1);
      RepeatText->SetText(tmpStr);

      i = files[currentIFile].numFrames / 20;
      if (!i)
        i = 1;

      IVideoScroll->SetRange(files[currentIFile].firstFrame, files[currentIFile].lastFrame + i - 1);
      IVideoScroll->SetLineMagnitude(1);
      IVideoScroll->SetPageMagnitude(i);
      IVideoScroll->SetPosition(files[currentIFile].currentFrame);

      sprintf(tmpStr, "%d", files[currentIFile].cropX);
      CropXEdit->SetText(tmpStr);
      CropXScroll->SetRange(0, 9999);
      CropXScroll->SetPos(files[currentIFile].cropX);
      sprintf(tmpStr, "%d", files[currentIFile].cropY);
      CropYEdit->SetText(tmpStr);
      CropYScroll->SetRange(0, 9999);
      CropYScroll->SetPos(files[currentIFile].cropY);

      sprintf(tmpStr, "%d", files[currentIFile].cropW);
      CropWEdit->SetText(tmpStr);
      CropWScroll->SetRange(0, 9999);
      CropWScroll->SetPos(files[currentIFile].cropW);
      sprintf(tmpStr, "%d", files[currentIFile].cropH);
      CropHEdit->SetText(tmpStr);
      CropHScroll->SetRange(0, 9999);
      CropHScroll->SetPos(files[currentIFile].cropH);

      if (files[currentIFile].cropFrames)
        CropCheck->Check();
      else
        CropCheck->Uncheck();

      if (files[currentIFile].resize)
        ResizeCheck->Check();
      else
        ResizeCheck->Uncheck();

      if (files[currentIFile].propSize)
        PropCheck->Check();
      else
        PropCheck->Uncheck();

      if (files[currentIFile].deinterlace)
        DeInterCheck->Check();
      else
        DeInterCheck->Uncheck();

      if (files[currentIFile].invert)
        Invert->Check();
      else
        Invert->Uncheck();
      BatchCheck->EnableWindow(false);
    }
    else
    {
      BatchCheck->EnableWindow(true);
      IFirstText->SetText("0");
      ICurrentText->SetText("0");
      StartText->SetText("0");
      EndText->SetText("0");
      ILastText->SetText("0");
      RepeatText->SetText("0");

      CropXEdit->SetText("0");
      CropXScroll->SetRange(0, 0);
      CropXScroll->SetPos(0);
      CropYEdit->SetText("0");
      CropYScroll->SetRange(0, 0);
      CropYScroll->SetPos(0);
      CropWEdit->SetText("0");
      CropWScroll->SetRange(0, 0);
      CropWScroll->SetPos(0);
      CropHEdit->SetText("0");
      CropHScroll->SetRange(0, 0);
      CropHScroll->SetPos(0);
      CropCheck->Uncheck();
      ResizeCheck->Uncheck();
      PropCheck->Uncheck();

      IVideoScroll->SetRange(0, 0);
      IVideoScroll->SetPosition(0);

      InputLBox->ClearList();
      LongestMessage = 0;
      DeInterCheck->Uncheck();
      Invert->Uncheck();
    }
  }
  SaveButton->EnableWindow(gotVideo);
  RemoveButton->EnableWindow(gotVideo);
  UpDownButtons();
  IVideoScroll->EnableWindow(gotVideo);
  EndText->EnableWindow(gotVideo);
  StartText->EnableWindow(gotVideo);
  IFirstText->EnableWindow(gotVideo);
  ICurrentText->EnableWindow(gotVideo);
  ILastText->EnableWindow(gotVideo);
  RepeatText->EnableWindow(gotVideo);
  DeInterCheck->EnableWindow(gotVideo);
  Invert->EnableWindow(gotVideo);
  CropXEdit->EnableWindow(gotVideo);
  CropXScroll->EnableWindow(gotVideo);
  CropYEdit->EnableWindow(gotVideo);
  CropYScroll->EnableWindow(gotVideo);
  CropWEdit->EnableWindow(gotVideo);
  CropWScroll->EnableWindow(gotVideo);
  CropHEdit->EnableWindow(gotVideo);
  CropHScroll->EnableWindow(gotVideo);
  CropCheck->EnableWindow(gotVideo);
  ResizeCheck->EnableWindow(gotVideo);
  PropCheck->EnableWindow(gotVideo);
  IPlay->EnableWindow(gotVideo);
  if (!Playing)
    PostMessage(WM_COMMAND, IDC_IPREVIEW);
}

void TMainWindow::UpDownButtons()
{
  if (batch)
  {
    UpButton->EnableWindow(false);
    DownButton->EnableWindow(false);
    return;
  }
  if (!Playing)
  {
    UpButton->EnableWindow((fileCount > 1) && (currentIFile != 0));
    DownButton->EnableWindow((fileCount > 1) && (currentIFile != InputName->GetCount() - 1));
  }
  else
  {
    UpButton->EnableWindow(false);
    DownButton->EnableWindow(false);
  }
}

void TMainWindow::DisplayOutputInfo()
{
  int i, w, h;
  char tmpStr[10];
  bool enable;

  if (!Playing)
  {
    totalFrames = 0;
    if (VideoAvail)
    {
      if (batch)
        totalFrames = files[currentOFile].numFramesUsed;
      else
      {
        for (i = 0; i < fileCount; i++)
          if (files[i].VideoPresent)
            totalFrames += files[i].numFramesUsed;
      }

      if (!SetRelPos())
        return;
      sprintf(tmpStr, "%d", currentOFile + 1);
      OFileText->SetText(tmpStr);
      sprintf(tmpStr, "%d", relOPos);
      OFrameText->SetText(tmpStr);
      sprintf(tmpStr, "%d", currentOPos);
      OCurrentText->SetText(tmpStr);
      sprintf(tmpStr, "%d", totalFrames - 1);
      OLastText->SetText(tmpStr);
      if (showOutput)
        ShowOutput->Check();
      else
        ShowOutput->Uncheck();

      i = totalFrames / 20;
      if (!i)
        i = 1;
      OVideoScroll->SetRange(0, totalFrames - 1 + i - 1);
      OVideoScroll->SetLineMagnitude(1);
      OVideoScroll->SetPageMagnitude(i);
      OVideoScroll->SetPosition(currentOPos);
      OFileScroll->SetRange(0, fileCount - 1);
      OFileScroll->SetPos(currentOFile);

      if (batch)
      {
        w = files[currentOFile].mpegWidth;
        h = files[currentOFile].mpegHeight;
      }
      else
      {
        w = MPEGWidth;
        h = MPEGHeight;
      }
      sprintf(tmpStr, "%d", w);
      MPEGWEdit->SetText(tmpStr);
      MPEGWScroll->SetRange(2, 1920);
      MPEGWScroll->SetPos(w);
      sprintf(tmpStr, "%d", h);
      MPEGHEdit->SetText(tmpStr);
      MPEGHScroll->SetRange(2, 1152);
      MPEGHScroll->SetPos(h);
    }
    else
    {
      currentOPos = -1;
      currentIFile = -1;
      relOPos = -1;
      OCurrentText->SetText("0");
      OLastText->SetText("0");
      OFileText->SetText("0");
      OFrameText->SetText("0");
      ShowOutput->Uncheck();

      OVideoScroll->SetRange(0, 0);
      OVideoScroll->SetPosition(0);

      OFileScroll->SetRange(0, 0);
      OFileScroll->SetPos(0);

      MPEGWEdit->SetText("0");
      MPEGWScroll->SetRange(0, 0);
      MPEGWScroll->SetPos(0);
      MPEGHEdit->SetText("0");
      MPEGHScroll->SetRange(0, 0);
      MPEGHScroll->SetPos(0);
    }
  }

  if ((fileCount) && (!Playing))
  {
    MPEGOpenButton->EnableWindow(true);
    if (batch)
      VideoName->SetText(files[currentOFile].mpegFilename);
    else
      VideoName->SetText(MPEGFilename);
    VideoName->EnableWindow(true);
  }
  else
  {
    MPEGOpenButton->EnableWindow(false);
    if (!Playing)
      VideoName->SetText("");
    VideoName->EnableWindow(false);
  }

  enable = (VideoAvail != 0) && (!Playing);
  OVideoScroll->EnableWindow(enable);
  OFirstText->EnableWindow(enable);
  OCurrentText->EnableWindow(enable);
  OLastText->EnableWindow(enable);
  OFileText->EnableWindow(enable);
  OFrameText->EnableWindow(enable);
  if (batch)
    OFileScroll->EnableWindow(false);
  else
    OFileScroll->EnableWindow(enable && (fileCount > 1));
  ShowOutput->EnableWindow(enable);
  MPEGWEdit->EnableWindow(enable);
  MPEGWScroll->EnableWindow(enable);
  MPEGHEdit->EnableWindow(enable);
  MPEGHScroll->EnableWindow(enable);
  OPlay->EnableWindow(enable);
  if (!Playing)
    PostMessage(WM_COMMAND, IDC_OPREVIEW);
}

void TMainWindow::EvHScroll(uint scrollCode, uint thumbPos, THandle hWndCtl)
{
  int i;
  char tmpStr[20];

  TDialog::EvHScroll(scrollCode, thumbPos, hWndCtl);

  if ((scrollCode == SB_ENDSCROLL) && (!Playing))
  {
    if (hWndCtl == IVideoScroll->HWindow)
    {
      i = IVideoScroll->GetPosition();
      sprintf(tmpStr, "%d", i);
      ICurrentText->SetText(tmpStr);
      files[currentIFile].currentFrame = i;
      PostMessage(WM_COMMAND, IDC_IPREVIEW);
    }
    else
      if (hWndCtl == OVideoScroll->HWindow)
      {
        i = OVideoScroll->GetPosition();
        currentOPos = i;
        sprintf(tmpStr, "%d", i);
        OCurrentText->SetText(tmpStr);
        if (!SetRelPos())
          return;
        sprintf(tmpStr, "%d", currentOFile + 1);
        OFileText->SetText(tmpStr);
        sprintf(tmpStr, "%d", relOPos);
        OFrameText->SetText(tmpStr);
        PostMessage(WM_COMMAND, IDC_OPREVIEW);
      }
  }
}

void TMainWindow::EvVScroll(uint scrollCode, uint thumbPos, THandle hWndCtl)
{
  int i, pos;

  TDialog::EvVScroll(scrollCode, thumbPos, hWndCtl);
  if (scrollCode == SB_ENDSCROLL)
  {
    if (hWndCtl == OFileScroll->HWindow)
    {
      pos = OFileScroll->GetPos();
      if ((pos != currentOFile) && (pos < fileCount))
      {
        currentOPos = 0;
        i = 0;
        while (i < pos)
        {
          if (files[i].VideoPresent)
            currentOPos += files[i].numFramesUsed;
          i++;
        }
        DisplayOutputInfo();
      }
    }
  }
}


bool TMainWindow::SetRelPos()
{
  int currentFile;

  if (currentOPos < 0)
    currentOPos = 0;
  else
  {
    if (batch)
      currentFile = files[currentOFile].numFramesUsed;
    else
      currentFile = totalFrames;
    if (currentOPos >= currentFile)
      currentOPos = currentFile - 1;
  }
  relOPos = currentOPos;
  if (batch)
  {
    relOPos = relOPos / files[currentOFile].repeatCount + files[currentOFile].startFrame;
    return true;
  }
  currentFile = 0;
  while (relOPos >= 0)
  {
    if (files[currentFile].VideoPresent)
      relOPos -= files[currentFile].numFramesUsed;
    currentFile++;
  }
  currentFile--;
  if (currentFile != currentOFile)
  {
    if (currentIFile != currentOFile)
      CloseFile(currentOFile);
    currentOFile = currentFile;
    OpenFile(currentOFile);
  }
  relOPos += files[currentOFile].numFramesUsed;
  relOPos = relOPos / files[currentOFile].repeatCount + files[currentOFile].startFrame;
  return true;
}

void TMainWindow::EvRButtonUp(uint modKeys, TPoint& point)
{
  TDialog::EvRButtonUp(modKeys, point);
  if (Playing)
    return;
  if (iprevRect.Contains(point))
  {
    if (gotRFirst)
    {
      gotRFirst = false;
      PopMenu(point);
    }
    else
      gotRFirst = true;
  }
}

void TMainWindow::EvRButtonDown(uint modKeys, TPoint& point)
{
  TDialog::EvRButtonDown(modKeys, point);
  if (Playing)
    return;
  if (iprevRect.Contains(point))
  {
    if (gotRFirst)
    {
      gotRFirst = false;
      PopMenu(point);
    }
    else
      gotRFirst = true;
  }
}

void TMainWindow::PopMenu(TPoint &point)
{
  if (fileCount && files[currentIFile].VideoPresent)
  {
    TPoint spoint(point);
    ClientToScreen(spoint);
    PopupMenu.TrackPopupMenu(TPM_RIGHTBUTTON, spoint, 0, HWindow);
  }
}

void TMainWindow::EvStartFrame()
{
  char tmpStr[10];

  if (fileCount && files[currentIFile].VideoPresent)
  {
    sprintf(tmpStr, "%d", IVideoScroll->GetPosition());
    StartText->SetText(tmpStr);
    EvStartKillFocus();
  }
}

void TMainWindow::EvEndFrame()
{
  char tmpStr[10];

  if (fileCount && files[currentIFile].VideoPresent)
  {
    sprintf(tmpStr, "%d", IVideoScroll->GetPosition());
    EndText->SetText(tmpStr);
    EvEndKillFocus();
  }
}

void TMainWindow::EvStartKillFocus()
{
  char tmpStr[80];
  int i;

  StartText->GetText(tmpStr, 80);
  if ((sscanf(tmpStr, "%d", &i) != 1) ||
      (i < files[currentIFile].firstFrame) ||
      (i > files[currentIFile].lastFrame))
  {
    sprintf(tmpStr, "Invalid start frame number (%d .. %d).", files[currentIFile].firstFrame, files[currentIFile].lastFrame);
    DisplayMBox(tmpStr, "invalid entry");
    sprintf(tmpStr, "%d", files[currentIFile].startFrame);
    StartText->SetText(tmpStr);
  }
  else
  {
    if (i != files[currentIFile].startFrame)
    {
      files[currentIFile].startFrame = i;
      if (i > files[currentIFile].endFrame)
      {
        files[currentIFile].endFrame = i;
        EndText->SetText(tmpStr);
      }
      files[currentIFile].numFramesUsed = (files[currentIFile].endFrame - i + 1) *
                                           files[currentIFile].repeatCount;
      DisplayOutputInfo();
      DisplayFileInfo();
    }
  }
}

void TMainWindow::EvEndKillFocus()
{
  char tmpStr[80];
  int i;

  EndText->GetText(tmpStr, 80);
  if ((sscanf(tmpStr, "%d", &i) != 1) ||
      (i < files[currentIFile].firstFrame) ||
      (i > files[currentIFile].lastFrame))
  {
    sprintf(tmpStr, "Invalid end frame number (%d .. %d).", files[currentIFile].firstFrame, files[currentIFile].lastFrame);
    DisplayMBox(tmpStr, "invalid entry");
    sprintf(tmpStr, "%d", files[currentIFile].endFrame);
    EndText->SetText(tmpStr);
  }
  else
  {
    if (i != files[currentIFile].endFrame)
    {
      files[currentIFile].endFrame = i;
      if (i < files[currentIFile].startFrame)
      {
        files[currentIFile].startFrame = i;
        StartText->SetText(tmpStr);
      }
      files[currentIFile].numFramesUsed = (i - files[currentIFile].startFrame + 1) *
                                           files[currentIFile].repeatCount;
      DisplayOutputInfo();
      DisplayFileInfo();
    }
  }
}

void TMainWindow::EvICurrentKillFocus()
{
  char tmpStr[80];
  int i;

  ICurrentText->GetText(tmpStr, 80);
  if ((sscanf(tmpStr, "%d", &i) != 1) ||
      (i < files[currentIFile].firstFrame) ||
      (i > files[currentIFile].lastFrame))
  {
    sprintf(tmpStr, "Invalid frame number (%d .. %d).", files[currentIFile].firstFrame, files[currentIFile].lastFrame);
    DisplayMBox(tmpStr, "invalid entry");
    sprintf(tmpStr, "%d", files[currentIFile].currentFrame);
    ICurrentText->SetText(tmpStr);
  }
  else
  {
    if (i != files[currentIFile].currentFrame)
    {
      files[currentIFile].currentFrame = i;
      IVideoScroll->SetPosition(i);
      PostMessage(WM_COMMAND, IDC_IPREVIEW);
    }
  }
}

void TMainWindow::EvOCurrentKillFocus()
{
  char tmpStr[80];
  int i;

  OCurrentText->GetText(tmpStr, 45);
  if ((sscanf(tmpStr, "%d", &i) != 1) ||
      (i < 0) || (i > totalFrames - 1))
  {
    sprintf(tmpStr, "Invalid frame number (0 .. %d).", totalFrames - 1);
    DisplayMBox(tmpStr, "invalid entry");
    sprintf(tmpStr, "%d", currentOPos);
    OCurrentText->SetText(tmpStr);
  }
  else
  {
    if (i != currentOPos)
    {
      currentOPos = i;
      OVideoScroll->SetPosition(i);
      if (!SetRelPos())
        return;
      sprintf(tmpStr, "%d", currentOFile + 1);
      OFileText->SetText(tmpStr);
      sprintf(tmpStr, "%d", relOPos);
      OFrameText->SetText(tmpStr);
      PostMessage(WM_COMMAND, IDC_OPREVIEW);
    }
  }
}

void TMainWindow::EvRepeatKillFocus()
{
  char tmpStr[20];
  int i;

  RepeatText->GetText(tmpStr, 20);
  if ((sscanf(tmpStr, "%d", &i) != 1) ||
      (i < 0) || (i > 32767))
  {
    DisplayMBox("Invalid repeat value (0 .. 32767).", "invalid entry");
    sprintf(tmpStr, "%d", files[currentIFile].repeatCount - 1);
    RepeatText->SetText(tmpStr);
  }
  else
  {
    if (i + 1 != files[currentIFile].repeatCount)
    {
      files[currentIFile].repeatCount = i + 1;
      files[currentIFile].numFramesUsed = (files[currentIFile].endFrame - files[currentIFile].startFrame + 1) * (i + 1);
      if (currentOFile != currentIFile)
        CloseFile(currentOFile);
      currentOFile = currentIFile;
      currentOPos = 0;
      if (!batch)
      {
        for (i = 0; i < currentOFile; i++)
          if (files[i].VideoPresent)
            currentOPos += files[i].numFramesUsed;
      }
      DisplayOutputInfo();
      DisplayFileInfo();
    }
  }
}

void TMainWindow::EvKeyReturn()
{
  HWND focusWnd;

  if (Playing)
  {
    Pause = true;
    return;
  }
  focusWnd = GetFocus();
  if (focusWnd == StartText->HWindow)
    EvStartKillFocus();
  else
    if (focusWnd == EndText->HWindow)
      EvEndKillFocus();
    else
      if (focusWnd == ICurrentText->HWindow)
        EvICurrentKillFocus();
      else
        if (focusWnd == OCurrentText->HWindow)
          EvOCurrentKillFocus();
        else
          if (focusWnd == RepeatText->HWindow)
            EvRepeatKillFocus();
          else
            PostMessage(WM_COMMAND, CM_STARTCONVERSION);
}


void TMainWindow::AddMessage(char *txt)
{
  TClientDC dc(HWindow);
  TSize size;
  HFONT hfont = (HFONT)SendMessage(WM_GETFONT);
  TFont font(hfont, NoAutoDelete);
  TEXTMETRIC metrics;

//  InputLBox->SetCaretIndex(InputLBox->AddString(txt), true);
  InputLBox->AddString(txt);
  dc.SelectObject(font);
  dc.GetTextExtent(txt, strlen(txt), size);
  dc.GetTextMetrics(metrics);
  size.cx += metrics.tmAveCharWidth;
  if (size.cx > LongestMessage)
  {
    LongestMessage = size.cx;
    if (LongestMessage > InputLBox->GetHorizontalExtent())
      InputLBox->SetHorizontalExtent(LongestMessage);
  }
}


void TMainWindow::AddFilename(char *txt)
{
  TClientDC dc(HWindow);
  TSize size;
  HFONT hfont = (HFONT)SendMessage(WM_GETFONT);
  TFont font(hfont, NoAutoDelete);
  TEXTMETRIC metrics;

  InputName->SetCaretIndex(InputName->AddString(txt), true);
  fileCount++;
  dc.SelectObject(font);
  dc.GetTextExtent(txt, strlen(txt), size);
  dc.GetTextMetrics(metrics);
  size.cx += metrics.tmAveCharWidth;
  if (size.cx > LongestName)
  {
    LongestName = size.cx;
    if (LongestName > InputName->GetHorizontalExtent())
      InputName->SetHorizontalExtent(LongestName);
  }
}

void TMainWindow::CmVideoOpen()
{
  char tmpStr[50];

  static TOpenSaveDialog::TData data (
         OFN_PATHMUSTEXIST|OFN_NOREADONLYRETURN|OFN_OVERWRITEPROMPT,
         "MPEG Program Streams (*.MPG,*.M2P,*.VOB)|*.mpg;*.m2p;*.vob|MPEG-2 Program Streams (*.M2P)|*.m2p|MPEG Program Streams (*.MPG)|*.mpg|Video Object Units (*.VOB)|*.vob|All Files (*.*)|*.*|",
         0, "", "");

  sprintf(tmpStr, "%s - output MPEG program stream", AppName);
  if ((new TFileSaveDialog(this, data, 0, tmpStr))->Execute() == IDOK)
  {
    if (batch)
    {
      strcpy(files[currentIFile].mpegFilename, data.FileName);
      VideoName->SetText(files[currentIFile].mpegFilename);
    }
    else
    {
      strcpy(MPEGFilename, data.FileName);
      VideoName->SetText(MPEGFilename);
    }
  }
}

void TMainWindow::CmStartConversion()
{
  int currentPos, currentFile;

  currentPos = currentOPos;
  currentFile = currentOFile;

  if (batch)
  {
    CloseFile(currentFile);
    currentOFile = 0;
    AbortOperation = false;
    while ((currentOFile < fileCount) && !AbortOperation)
    {
      if (!OpenFile(currentOFile))
        return;
      if (VideoAvail)
      {
        outputRec.doVideo = 1;
        outputRec.width = files[currentOFile].mpegWidth;
        outputRec.height = files[currentOFile].mpegHeight;
        doCompileInfo.startFrame = 0;
        doCompileInfo.endFrame = files[currentOFile].numFramesUsed - 1;
      }
      else
        outputRec.doVideo = 0;

      if (AudioAvail)
      {
        outputRec.doAudio = 1;
        if (files[currentOFile].samplesPerSec == 22050)
          outputRec.audrate = 44100;
        else
          outputRec.audrate = files[currentOFile].samplesPerSec;
        if (files[currentOFile].audioChannels == 2)
          outputRec.stereo = 1;
        else
          outputRec.stereo = 0;
        if (files[currentOFile].audioBitsPerSample == 8)
          outputRec.audsamplesize = 16;
        else
          outputRec.audsamplesize = files[currentOFile].audioBitsPerSample;
      }
      else
        outputRec.doAudio = 0;

      strcpy(doCompileInfo.outputFile.name, files[currentOFile].mpegFilename);
      doCompileInfo.outputFileRef = NULL;

      dllAppWindow(frameWindow->HWindow);
      doCompileInfo.outputRec = outputRec;
      Encoding = true;
      AbortOperation = (dllEntry(compDoCompile, &stdParms, (long) &doCompileInfo, (long) 0) != comp_CompileDone);
      Encoding = false;
      currentOFile++;
    }
    CloseFile(currentOFile - 1);
    currentOFile = currentFile;
    currentOPos = 0;
    OpenFile(currentOFile);
  }
  else
  {
    if (VideoAvail)
    {
      outputRec.doVideo = 1;
      outputRec.width = MPEGWidth;
      outputRec.height = MPEGHeight;
      doCompileInfo.startFrame = 0;
      doCompileInfo.endFrame = totalFrames - 1;
    }
    else
      outputRec.doVideo = 0;

    if (AudioAvail)
    {
      outputRec.doAudio = 1;
      if (samplesPerSec == 22050)
        outputRec.audrate = 44100;
      else
        outputRec.audrate = samplesPerSec;
      if (audioChannels == 2)
        outputRec.stereo = 1;
      else
        outputRec.stereo = 0;
      if (audioBitsPerSample == 8)
        outputRec.audsamplesize = 16;
      else
        outputRec.audsamplesize = audioBitsPerSample;
    }
    else
      outputRec.doAudio = 0;

    strcpy(doCompileInfo.outputFile.name, MPEGFilename);
    doCompileInfo.outputFileRef = NULL;

	dllAppWindow(frameWindow->HWindow);
    doCompileInfo.outputRec = outputRec;
    Encoding = true;
    dllEntry(compDoCompile, &stdParms, (long) &doCompileInfo, (long) 0);
    Encoding = false;
  }
  currentOPos = currentPos;
  if (fileCount)
    SetRelPos();
}

void TMainWindow::EvLoadProject()
{
  char tmpStr[MAXPATH];
  int i, fCount, cIFile, cOPos;
  fileData tmpFiles[MAX_OPEN_FILES];
  FILE *fin;
  bool result, cOutput, batchSave = batch;
  int cWidth, cHeight;
  HCURSOR hcurSave;
  static TOpenSaveDialog::TData data (
         OFN_PATHMUSTEXIST|OFN_FILEMUSTEXIST,
         "AVI2MPG2_VFW project files (*.vfw)|*.vfw|All Files (*.*)|*.*|",
         0, "", "");

  if (Playing)
    return;

  sprintf(tmpStr, "%s - open project file", AppName);
  if ((new TFileOpenDialog(this, data, 0, tmpStr))->Execute() == IDOK)
  {
    if ((fin = fopen(data.FileName, "rb")) == NULL)
    {
      sprintf(tmpStr, "Unable to open project file %s.", data.FileName);
      DisplayMBox(tmpStr, "Project open error");
      return;
    }

    hcurSave = ::SetCursor(LoadCursor(NULL, IDC_WAIT));
    if (fread(&batch, sizeof(int), 1, fin) != 1 ||
        fread(&fCount, sizeof(int), 1, fin) != 1 ||
        fread(&cIFile, sizeof(int), 1, fin) != 1 ||
        fread(&cOPos, sizeof(int), 1, fin) != 1 ||
        fread(tmpStr, sizeof(char), MAXPATH, fin) != MAXPATH ||
        fread(&cWidth, sizeof(int), 1, fin) != 1 ||
        fread(&cHeight, sizeof(int), 1, fin) != 1 ||
        fread(&cOutput, sizeof(bool), 1, fin) != 1)
    {
      sprintf(tmpStr, "Unable to read from project file %s.", data.FileName);
      DisplayMBox(tmpStr, "Project open error");
      fclose(fin);
      return;
    }

    while (fileCount)
      RemoveFile(fileCount - 1);
    iprevDib->ClearDib();

    for (i = 0; i < fCount; i++)
    {
      if (fread(&tmpFiles[i], sizeof(fileData), 1, fin) != 1)
      {
        ::SetCursor(hcurSave);
        sprintf(tmpStr, "Unable to read from project file %s.", data.FileName);
        DisplayMBox(tmpStr, "Project open error");
        fclose(fin);
        return;
      }
      if (strstr(tmpFiles[i].fileName, ".lst"))
        result = AddList(tmpFiles[i].fileName);
      else
        result = AddAVI(tmpFiles[i].fileName);
      if (!result)
        goto errexit;
      CloseFile(i);
      AddFilename(tmpFiles[i].fileName);
    }
    ProjectName->SetText(data.FileName);
    InputName->SetSelIndex(cIFile);
    if (currentIFile != currentOFile)
      CloseFile(currentIFile);
    currentIFile = InputName->GetSelIndex();
    for (i = 0; i < fileCount; i++)
    {
      files[i].currentFrame = tmpFiles[i].currentFrame;
      files[i].startFrame = tmpFiles[i].startFrame;
      files[i].endFrame = tmpFiles[i].endFrame;
      files[i].repeatCount = tmpFiles[i].repeatCount;
      files[i].numFramesUsed = tmpFiles[i].numFramesUsed;
      files[i].deinterlace = tmpFiles[i].deinterlace;
      files[i].invert = tmpFiles[i].invert;
      files[i].propSize = tmpFiles[i].propSize;
      files[i].resize = tmpFiles[i].resize;
      files[i].cropFrames = tmpFiles[i].cropFrames;
      files[i].cropX = tmpFiles[i].cropX;
      files[i].cropY = tmpFiles[i].cropY;
      files[i].cropW = tmpFiles[i].cropW;
      files[i].cropH = tmpFiles[i].cropH;
      files[i].previewRate = tmpFiles[i].previewRate;
    }
   if (!batch)
    {
      strcpy(MPEGFilename, tmpStr);
      MPEGWidth = cWidth;
      MPEGHeight = cHeight;
    }
    showOutput = cOutput;
    if (!OpenFile(currentIFile))
      goto errexit;
    DisplaySourceInfo();
    DisplayFileInfo();
    currentOPos = cOPos;
    if (currentOFile != currentIFile)
      if (!OpenFile(currentOFile))
        goto errexit;
    DisplayOutputInfo();
    PostMessage(WM_PAINT);
    ::SetCursor(hcurSave);
    fclose(fin);
  }
  return;

errexit:
  while (fileCount)
    RemoveFile(fileCount - 1);
  fclose(fin);
  batch = batchSave;
  return;
}

void TMainWindow::EvSaveProject()
{
  char tmpStr[MAXPATH];
  int i;
  FILE *fout;
  static TOpenSaveDialog::TData data (
         OFN_PATHMUSTEXIST|OFN_OVERWRITEPROMPT|OFN_HIDEREADONLY|OFN_NOREADONLYRETURN,
         "AVI2MPG2 project files (*.VFW)|*.vfw|All Files (*.*)|*.*|",
         0, "", "");

  sprintf(tmpStr, "%s - save project file", AppName);
  if ((new TFileSaveDialog(this, data, 0, tmpStr))->Execute() == IDOK)
  {
    if ((fout = fopen(data.FileName, "wb")) == NULL)
    {
      sprintf(tmpStr, "Unable to save project to file %s.", data.FileName);
      DisplayMBox(tmpStr, "Project save error");
    }
    else
    {
      if (fwrite(&batch, sizeof(int), 1, fout) != 1 ||
          fwrite(&fileCount, sizeof(int), 1, fout) != 1 ||
          fwrite(&currentIFile, sizeof(int), 1, fout) != 1 ||
          fwrite(&currentOPos, sizeof(int), 1, fout) != 1 ||
          fwrite(MPEGFilename, sizeof(char), MAXPATH, fout) != MAXPATH ||
          fwrite(&MPEGWidth, sizeof(int), 1, fout) != 1 ||
          fwrite(&MPEGHeight, sizeof(int), 1, fout) != 1 ||
          fwrite(&showOutput, sizeof(bool), 1, fout) != 1)
      {
        sprintf(tmpStr, "Unable to write to project file %s.", data.FileName);
        DisplayMBox(tmpStr, "Project save error");
        fclose(fout);
        return;
      }
      for (i = 0; i < fileCount; i++)
      {
        if (fwrite(&files[i], sizeof(fileData), 1, fout) != 1)
        {
          sprintf(tmpStr, "Unable to write to project file %s.", data.FileName);
          DisplayMBox(tmpStr, "Project save error");
          fclose(fout);
          return;
        }
      }
      fclose(fout);
      ProjectName->SetText(data.FileName);
    }
  }
}

void TMainWindow::CmFileOpen()
{
  char tmpStr[MAXPATH], *strPtr;
  HCURSOR hcurSave;
  bool result;

  static TOpenSaveDialog::TData data (
         OFN_PATHMUSTEXIST|OFN_FILEMUSTEXIST,
         "Supported types (*.AVI, *.AVS, *.LST)|*.avi;*.avs;*.lst|AVI Files (*.AVI)|*.avi|AVS Files (*.AVS)|*.avs|List of images (*.LST)|*.lst|All Files (*.*)|*.*|",
         0, "", "AVI");

  if (Playing)
    return;

  sprintf(tmpStr, "%s - open AVI file or list of images", AppName);
  if ((new TFileOpenDialog(this, data, 0, tmpStr))->Execute() == IDOK)
  {
    hcurSave = ::SetCursor(LoadCursor(NULL, IDC_WAIT));
    strlwr(data.FileName);
    if (strstr(data.FileName, ".lst"))
      result = AddList(data.FileName);
    else
      result = AddAVI(data.FileName);
    if (result)
    {
      iprevDib->ClearDib();
      AddFilename(data.FileName);
      strcpy(tmpStr, data.FileName);
      strPtr = strrchr(tmpStr, '.');
      if (strPtr)
        strPtr[0] = 0;
      if (batch)
      {
        strcpy(files[currentOFile].mpegFilename, tmpStr);
        strcat(files[currentOFile].mpegFilename, ".mpg");
      }
      else
      {
        if (!strlen(MPEGFilename))
        {
          strcpy(MPEGFilename, tmpStr);
          strcat(MPEGFilename, ".mpg");
        }
      }
      DisplayFileInfo();
      DisplaySourceInfo();
      if (batch)
        currentOPos = 0;
      else
        currentOPos = totalFrames;
      DisplayOutputInfo();
    }
    PostMessage(WM_PAINT);
    ::SetCursor(hcurSave);
  }
}

void TMainWindow::CmAbout()
{
  char tempStr[132];

  strcpy(tempStr, AppName);
  strcat(tempStr, " - ");
  strcat(tempStr, AppVersion);
  strcat(tempStr, "\n\nby: Brent Beyeler (beyeler@home.com)");
  strcat(tempStr, "\n\nhttp://members.home.net/beyeler/bbmpeg.html");
  MessageBox(tempStr, AppName, MB_OK);
}

int TMainWindow::DisplayMBox(char *txt, char *title)
{
  char tempStr[80];

  if (strlen(title))
    sprintf(tempStr, "%s - %s", AppName, title);
  else
    strcpy(tempStr, AppName);
  return MessageBox(txt, tempStr, MB_OK);
}

bool TMainWindow::AddAVI(char *name)
{
  char errortext[MAXPATH];
  int cFile;
  long i;
  BITMAPINFO *bitmapInfo;
  unsigned char buffer[256];

  if (fileCount >= MAX_OPEN_FILES)
  {
    sprintf(errortext, "The maximum number (%d) of files has been opened.", MAX_OPEN_FILES);
    DisplayMBox(errortext, "open AVI error");
    return false;
  }

  cFile = currentIFile + 1;
  strcpy(files[cFile].fileName, name);
  files[cFile].VideoPresent = false;
  files[cFile].AudioPresent = false;
  files[cFile].deinterlace = false;
  files[cFile].invert = false;
  if (!OpenAVI(cFile))
  {
    CloseAVI(cFile);
    return false;
  }

  if (AVIFileInfo(files[cFile].pfile, &files[cFile].fileInfo, sizeof(files[cFile].fileInfo)))
  {
    CloseAVI(cFile);
    sprintf(errortext,"Could not get file info from %s.", name);
    DisplayMBox(errortext, "open AVI error");
    return false;
  }

  if (files[cFile].pavi_video)
  {
    if (AVIStreamInfo(files[cFile].pavi_video, &files[cFile].videoInfo, sizeof(files[cFile].videoInfo)))
    {
      CloseAVI(cFile);
      sprintf(errortext,"Could not get video stream info from %s.", name);
      DisplayMBox(errortext, "open AVI error");
      return false;
    }

    bitmapInfo = (BITMAPINFO *) AVIStreamGetFrame(files[cFile].pgf, files[cFile].videoInfo.dwStart);
    if (bitmapInfo == NULL)
    {
      sprintf(errortext,"Could not get frame %d from %s.", files[cFile].videoInfo.dwStart, name);
      DisplayMBox(errortext, "open AVI error");
      CloseAVI(cFile);
      return false;
    }

    i = bitmapInfo->bmiHeader.biBitCount;
    if ((i != 8) && (i != 16) && (i != 24) && (i != 32))
    {
      CloseAVI(cFile);
      DisplayMBox("Only 8, 16, 24 and 32 bit AVI formats are supported", "open AVI error");
      return false;
    }

    if (bitmapInfo->bmiHeader.biCompression != BI_RGB)
    {
      CloseAVI(cFile);
      DisplayMBox("Only uncompressed bitmaps are supported", "open AVI error");
      return false;
    }

    files[cFile].bitsPerPixel = i;
    files[cFile].startFrame = files[cFile].videoInfo.dwStart;
    files[cFile].endFrame = files[cFile].startFrame + files[cFile].fileInfo.dwLength - 1;
    /* find the real last frame */
    bitmapInfo = NULL;
    while ((bitmapInfo == NULL) && files[cFile].endFrame)
    {
      bitmapInfo = (BITMAPINFO *) AVIStreamGetFrame(files[cFile].pgf, files[cFile].endFrame);
      if (bitmapInfo == NULL)
        files[cFile].endFrame--;
    }
    if (!files[cFile].endFrame)
    {
      CloseAVI(cFile);
      DisplayMBox("Unable to find the last frame in the file", "open AVI error");
      return false;
    }
    files[cFile].firstFrame = files[cFile].startFrame;
    files[cFile].lastFrame = files[cFile].endFrame;
    files[cFile].numFrames = files[cFile].numFramesUsed = files[cFile].fileInfo.dwLength;
    files[cFile].currentFrame = files[cFile].startFrame;
    files[cFile].repeatCount = 1;
    files[cFile].cropFrames = false;
    files[cFile].resize = false;
    files[cFile].propSize = true;
    files[cFile].cropX = 0;
    files[cFile].cropY = 0;
    files[cFile].cropW = 0;
    files[cFile].cropH = 0;
    files[cFile].previewRate = (int) (1000.0 / (((double) files[cFile].videoInfo.dwRate) / ((double) files[cFile].videoInfo.dwScale)));
    if (batch)
    {
      files[cFile].mpegWidth = files[cFile].fileInfo.dwWidth;
      files[cFile].mpegHeight = files[cFile].fileInfo.dwHeight;
    }
    else
    {
      if (!MPEGWidth || !MPEGHeight)
      {
        MPEGWidth = files[cFile].fileInfo.dwWidth;
        MPEGHeight = files[cFile].fileInfo.dwHeight;
      }
    }
    files[cFile].VideoPresent = true;
  }

  if (files[cFile].pavi_audio)
  {
    if (AVIStreamInfo(files[cFile].pavi_audio, &files[cFile].audioInfo, sizeof(files[cFile].audioInfo)))
    {
      sprintf(errortext, "Could not get audio stream info from %s.", name);
      DisplayMBox(errortext, "open AVI warning");
      goto openexit;
    }

    i = 0;
    if (AVIStreamReadFormat(files[cFile].pavi_audio, files[cFile].audioInfo.dwStart, NULL, &i))
    {
      sprintf(errortext, "Could not get audio stream format size from %s.", name);
      DisplayMBox(errortext, "open AVI warning");
      goto openexit;
    }

    if (i > sizeof(buffer))
    {
      sprintf(errortext, "Could not handle get audio stream format size in %s.", name);
      DisplayMBox(errortext, "open AVI warning");
      goto openexit;
    }

    if (AVIStreamReadFormat(files[cFile].pavi_audio, files[cFile].audioInfo.dwStart, buffer, &i))
    {
      sprintf(errortext, "Could not get audio stream format from %s.", name);
      DisplayMBox(errortext, "open AVI warning");
      goto openexit;
    }

    files[cFile].audioFormat.wFormatTag = (WORD) (buffer[0] | (buffer[1] << 8));
    files[cFile].audioFormat.nChannels = (WORD) (buffer[2] | (buffer[3] << 8));
    files[cFile].audioFormat.nSamplesPerSec = (WORD) (buffer[4] | (buffer[5] << 8) | (buffer[6] << 16) | (buffer[7] << 24));
    files[cFile].audioFormat.nAvgBytesPerSec = (WORD) (buffer[8] | (buffer[9] << 8) | (buffer[10] << 16) | (buffer[11] << 24));
    files[cFile].audioFormat.nBlockAlign = (WORD) (buffer[12] | (buffer[13] << 8));
    if (i > 14)
    {
      files[cFile].audioFormat.wBitsPerSample = (WORD) (buffer[14] | (buffer[15] << 8));
      if (i > 16)
        files[cFile].audioFormat.cbSize = (WORD) (buffer[16] | (buffer[17] << 8));
    }

    if (files[cFile].audioFormat.wFormatTag != WAVE_FORMAT_PCM)
    {
      DisplayMBox("Audio data type is not supported", "open AVI warning");
      goto openexit;
    }

    if (batch)
    {
      files[cFile].audioChannels = files[cFile].audioFormat.nChannels;
      files[cFile].audioBitsPerSample = files[cFile].audioFormat.wBitsPerSample;
      files[cFile].samplesPerSec = files[cFile].audioFormat.nSamplesPerSec;

      files[cFile].audioSampleSize = files[cFile].audioChannels * files[cFile].audioBitsPerSample;
      files[cFile].samplesPerFrame = floor(((double) files[cFile].samplesPerSec) / (((double) files[cFile].fileInfo.dwRate) / ((double) files[cFile].fileInfo.dwScale)));

      files[cFile].audioBufferSize = files[cFile].samplesPerFrame;
      if (files[cFile].audioFormat.nChannels == 2)
        files[cFile].audioBufferSize = files[cFile].audioBufferSize << 1;
      if (files[cFile].audioFormat.wBitsPerSample == 16)
        files[cFile].audioBufferSize = files[cFile].audioBufferSize << 1;

      files[cFile].audioBuffer = (unsigned char*) malloc(files[cFile].audioBufferSize);
      if (files[cFile].audioBuffer == NULL)
      {
        DisplayMBox("Could not get memory for first audio buffer.", "open AVI warning");
        goto openexit;
      }
      if (files[cFile].samplesPerSec == 22050)
      {
        if (files[cFile].audioBitsPerSample == 8)
          files[cFile].audioBuffer1 = (unsigned short int*) malloc(files[cFile].audioBufferSize << 2);
        else
          files[cFile].audioBuffer1 = (unsigned short int*) malloc(files[cFile].audioBufferSize << 1);
        if (files[cFile].audioBuffer1 == NULL)
        {
          free(files[cFile].audioBuffer);
          DisplayMBox("Could not get memory for second audio buffer.", "open AVI warning");
          goto openexit;
        }
      }
      if (files[cFile].audioBitsPerSample == 8)
      {
        files[cFile].audioBuffer2 = (unsigned short int*) malloc(files[cFile].audioBufferSize << 1);
        if (files[cFile].audioBuffer2 == NULL)
        {
          if (files[cFile].audioBuffer1)
            free(files[cFile].audioBuffer1);
          free(files[cFile].audioBuffer);
          DisplayMBox("Could not get memory for third audio buffer.", "open AVI warning");
          goto openexit;
        }
      }
    }
    else
    {
      if ((cFile == 0) || (!AVIAvail))
      {
        audioChannels = files[cFile].audioFormat.nChannels;
        audioBitsPerSample = files[cFile].audioFormat.wBitsPerSample;
        samplesPerSec = files[cFile].audioFormat.nSamplesPerSec;

        audioSampleSize = audioChannels * audioBitsPerSample;
        samplesPerFrame = floor(((double) samplesPerSec) / (((double) files[cFile].fileInfo.dwRate) / ((double) files[cFile].fileInfo.dwScale)));

        audioBufferSize = samplesPerFrame;
        if (files[cFile].audioFormat.nChannels == 2)
          audioBufferSize = audioBufferSize << 1;
        if (files[cFile].audioFormat.wBitsPerSample == 16)
          audioBufferSize = audioBufferSize << 1;

        audioBuffer = (unsigned char*) malloc(audioBufferSize);
        if (audioBuffer == NULL)
        {
          DisplayMBox("Could not get memory for first audio buffer.", "open AVI warning");
          goto openexit;
        }
        if (samplesPerSec == 22050)
        {
          if (audioBitsPerSample == 8)
            audioBuffer1 = (unsigned short int*) malloc(audioBufferSize << 2);
          else
            audioBuffer1 = (unsigned short int*) malloc(audioBufferSize << 1);
          if (audioBuffer1 == NULL)
          {
            free(audioBuffer);
            DisplayMBox("Could not get memory for second audio buffer.", "open AVI warning");
            goto openexit;
          }
        }
        if (audioBitsPerSample == 8)
        {
          audioBuffer2 = (unsigned short int*) malloc(audioBufferSize << 1);
          if (audioBuffer2 == NULL)
          {
            if (audioBuffer1)
              free(audioBuffer1);
            free(audioBuffer);
            DisplayMBox("Could not get memory for third audio buffer.", "open AVI warning");
            goto openexit;
          }
        }
      }
      else
        if ((audioChannels != files[cFile].audioFormat.nChannels) ||
            (audioBitsPerSample != files[cFile].audioFormat.wBitsPerSample) ||
            ((samplesPerSec != files[cFile].audioFormat.nSamplesPerSec) &&
            ((samplesPerSec != 44100) || (files[cFile].audioFormat.nSamplesPerSec != 22050) ||
                                         (files[cFile].audioFormat.nSamplesPerSec != 44100))))
        {
          DisplayMBox("Added files must have the same audio type as the first file.", "open AVI warning");
          goto openexit;
        }
    }

    files[cFile].AudioPresent = true;
  }
openexit:
  CloseFile(currentIFile);
  CloseFile(currentOFile);
  currentIFile = cFile;
  currentOFile = cFile;
  if (files[cFile].VideoPresent)
    VideoAvail++;
  if (files[cFile].AudioPresent)
    AudioAvail++;
  files[cFile].aviFile = true;
  AVIAvail++;

  return true;
}

void TMainWindow::DisplayFileInfo()
{
  double rate, seconds;
  int hours, min;
  char tmpStr[MAXPATH];

  InputLBox->ClearList();
  LongestMessage = 0;
  if (fileCount)
  {
    if (files[currentIFile].aviFile)
      sprintf(tmpStr, "AVI file: %s", files[currentIFile].fileName);
    else
      sprintf(tmpStr, "Image list: %s", files[currentIFile].fileName);
    AddMessage(tmpStr);
    AddMessage(" ");

    if (files[currentIFile].VideoPresent)
    {
      AddMessage("Video:");
      if (!files[currentIFile].aviFile)
      {
        sprintf(tmpStr, "  Filename: %s", curFilename);
        AddMessage(tmpStr);
      }
      sprintf(tmpStr, "  Compressor: %c%c%c%c", (char) (files[currentIFile].videoInfo.fccHandler & 0x000000ff),
                                                (char) ((files[currentIFile].videoInfo.fccHandler & 0x0000ff00) >> 8),
                                                (char) ((files[currentIFile].videoInfo.fccHandler & 0x00ff0000) >> 16),
                                                (char) ((files[currentIFile].videoInfo.fccHandler & 0xff000000) >> 24));
      AddMessage(tmpStr);
      sprintf(tmpStr, "  Resolution: %d x %d", files[currentIFile].fileInfo.dwWidth,
                                                 files[currentIFile].fileInfo.dwHeight);
      AddMessage(tmpStr);
      sprintf(tmpStr, "  Bits per pixel: %d", files[currentIFile].bitsPerPixel);
      AddMessage(tmpStr);
      if (files[currentIFile].aviFile)
      {
        rate = ((double) files[currentIFile].videoInfo.dwRate) / ((double) files[currentIFile].videoInfo.dwScale);
        sprintf(tmpStr, "  Frame Rate: %02.2f", rate);
        AddMessage(tmpStr);
      }
      sprintf(tmpStr, "  Total Frames: %d", files[currentIFile].numFrames);
      AddMessage(tmpStr);
      if (files[currentIFile].aviFile)
      {
        seconds = ((double) files[currentIFile].fileInfo.dwLength) / rate;
        hours = (int) (seconds / 3600.0);
        if (hours)
          seconds = seconds - hours * 3600.0;
        min = (int) (seconds / 60.0);
        if (min)
          seconds = seconds - min * 60.0;
        sprintf(tmpStr, "  Total Time: %02d:%02d:%02.2f", hours, min, seconds);
        AddMessage(tmpStr);
      }
      sprintf(tmpStr, "  Selected Frames: %d", files[currentIFile].numFramesUsed);
      AddMessage(tmpStr);
    }
    else
      AddMessage("Video: none");

    AddMessage(" ");

    if (files[currentIFile].AudioPresent)
    {
      AddMessage("Audio:");
      if (files[currentIFile].audioFormat.nChannels == 2)
        AddMessage("  Channels: Stereo");
      else
        AddMessage("  Channels: Mono");
      if (files[currentIFile].audioFormat.nSamplesPerSec == 22050)
        sprintf(tmpStr, "  Sample Rate: 22.05 kHz (will be converted to 44.1 kHz)");
      else
        sprintf(tmpStr, "  Sample Rate: %.01f kHz", ((double) files[currentIFile].audioFormat.nSamplesPerSec) / 1000.0);
      AddMessage(tmpStr);
      if (files[currentIFile].audioFormat.wBitsPerSample == 8)
        sprintf(tmpStr, "  Bits per Sample: 8 (will be converted to 16)");
      else
        sprintf(tmpStr, "  Bits per Sample: %d", files[currentIFile].audioFormat.wBitsPerSample);
      AddMessage(tmpStr);
    }
    else
      AddMessage(" Audio: none");
  }
}

bool TMainWindow::OpenFile(int cFile)
{
  if (files[cFile].aviFile)
    return OpenAVI(cFile);
  else
    return OpenList(cFile);
}

void TMainWindow::CloseFile(int cFile)
{
  if (fileCount)
    if (files[cFile].aviFile)
      CloseAVI(cFile);
    else
      CloseList(cFile);
}

bool TMainWindow::OpenAVI(int cFile)
{
  char errortext[MAXPATH];

  if (!files[cFile].pfile)
  {
    if (AVIFileOpen(&files[cFile].pfile, files[cFile].fileName, OF_READ, NULL))
    {
      files[cFile].pfile = NULL;
      sprintf(errortext,"Could not open %s.", files[cFile].fileName);
      DisplayMBox(errortext, "open AVI error");
      return false;
    }

    if (!AVIFileGetStream(files[cFile].pfile, &files[cFile].pavi_video, streamtypeVIDEO, 0))
    {
      if (AVIStreamInfo(files[cFile].pavi_video, &files[cFile].videoInfo, sizeof(files[cFile].videoInfo)))
      {
        sprintf(errortext,"Could not get video stream info from %s.", files[cFile].fileName);
        DisplayMBox(errortext, "open AVI error");
        return false;
      }
      files[cFile].pgf = AVIStreamGetFrameOpen(files[cFile].pavi_video, NULL);
      if (files[cFile].pgf == NULL)
      {
        sprintf(errortext,"Could not open getframe from %s, compressor = %c%c%c%c.", files[cFile].fileName,
                                                  (char) (files[cFile].videoInfo.fccHandler & 0x000000ff),
                                                  (char) ((files[cFile].videoInfo.fccHandler & 0x0000ff00) >> 8),
                                                  (char) ((files[cFile].videoInfo.fccHandler & 0x00ff0000) >> 16),
                                                  (char) ((files[cFile].videoInfo.fccHandler & 0xff000000) >> 24));
        DisplayMBox(errortext, "open AVI error");
        return false;
      }
    }
    else
      files[cFile].pavi_video = NULL;

    if (AVIFileGetStream(files[cFile].pfile, &files[cFile].pavi_audio, streamtypeAUDIO, 0))
      files[cFile].pavi_audio = NULL;

    if ((!files[cFile].pavi_video) && (!files[cFile].pavi_audio))
    {
      sprintf(errortext, "%s does not contain any supported streams", files[cFile].fileName);
      DisplayMBox(errortext, "open AVI error");
      return false;
    }
  }
  return true;
}

void TMainWindow::CloseAVI(int cFile)
{
  if (files[cFile].pgf)
    AVIStreamGetFrameClose(files[cFile].pgf);
  if (files[cFile].pavi_video)
    AVIStreamRelease(files[cFile].pavi_video);
  if (files[cFile].pavi_audio)
    AVIStreamRelease(files[cFile].pavi_audio);
  if (files[cFile].pfile)
    AVIFileRelease(files[cFile].pfile);

  files[cFile].pgf = NULL;
  files[cFile].pavi_video = NULL;
  files[cFile].pavi_audio = NULL;
  files[cFile].pfile = NULL;
}


void TMainWindow::CmFileUp()
{
  fileData tempData;
  int i;

  if (currentOFile != currentIFile)
    CloseFile(currentOFile);
  InputName->DeleteString(currentIFile);
  InputName->InsertString(files[currentIFile].fileName, currentIFile - 1);
  tempData = files[currentIFile];
  files[currentIFile] = files[currentIFile - 1];
  currentIFile--;
  files[currentIFile] = tempData;
  currentOFile = currentIFile;
  currentOPos = 0;
  for (i = 0; i < currentOFile; i++)
    if (files[i].VideoPresent)
      currentOPos += files[i].numFramesUsed;
  InputName->SetSelIndex(currentIFile);
  DisplaySourceInfo();
  DisplayOutputInfo();
}

void TMainWindow::CmFileDown()
{
  fileData tempData;
  int i;

  if (currentOFile != currentIFile)
    CloseFile(currentOFile);
  InputName->DeleteString(currentIFile);
  InputName->InsertString(files[currentIFile].fileName, currentIFile + 1);
  tempData = files[currentIFile];
  files[currentIFile] = files[currentIFile + 1];
  currentIFile++;
  files[currentIFile] = tempData;
  currentOFile = currentIFile;
  currentOPos = 0;
  for (i = 0; i < currentOFile; i++)
    if (files[i].VideoPresent)
      currentOPos += files[i].numFramesUsed;
  InputName->SetSelIndex(currentIFile);
  DisplaySourceInfo();
  DisplayOutputInfo();
}

void TMainWindow::CmFileRemove()
{
  RemoveFile(currentIFile);
}

void TMainWindow::RemoveFile(int cFile)
{
  int i;

  if (files[cFile].VideoPresent)
    VideoAvail--;
  if (files[cFile].AudioPresent)
    AudioAvail--;
  if (files[cFile].aviFile)
  {
    CloseAVI(cFile);
    if (batch)
    {
      if (files[cFile].audioBuffer1)
        free(files[cFile].audioBuffer1);
      files[cFile].audioBuffer1 = NULL;
      if (files[cFile].audioBuffer2)
        free(files[cFile].audioBuffer2);
      files[cFile].audioBuffer2 = NULL;
    }

    AVIAvail--;
  }
  else
    CloseList(cFile);

  if (currentOFile != cFile)
  {
    CloseFile(currentOFile);
    if (batch)
    {
      if (files[cFile].audioBuffer1)
        free(files[cFile].audioBuffer1);
      files[cFile].audioBuffer1 = NULL;
      if (files[cFile].audioBuffer2)
        free(files[cFile].audioBuffer2);
      files[cFile].audioBuffer2 = NULL;
    }
  }

  files[cFile].VideoPresent = false;
  files[cFile].AudioPresent = false;

  if (fileCount - 1 > currentIFile)
  {
    i = currentIFile;
    while (i <= fileCount - 2)
    {
      files[i] = files[i + 1];
      i++;
    }
  }

  InputName->DeleteString(cFile);
  fileCount--;
  if (!fileCount)
  {
    LongestName = 0;
    currentIFile = -1;
    currentOFile = -1;
    strcpy(MPEGFilename, "");
    InputName->ClearList();
    MPEGWidth = 0;
    MPEGHeight = 0;
  }
  else
  {
    if (currentIFile > fileCount - 1)
      currentIFile--;
    OpenFile(currentIFile);
    currentOFile = currentIFile;
    currentOPos = 0;
    if (!batch)
    {
      for (i = 0; i < currentOFile; i++)
        if (files[i].VideoPresent)
          currentOPos += files[i].numFramesUsed;
    }
  }
  DisplayFileInfo();
  DisplaySourceInfo();
  DisplayOutputInfo();

  if (!AudioAvail && !batch)
  {
    if (audioBuffer)
      free(audioBuffer);
    audioBuffer = NULL;
    if (audioBuffer1)
      free(audioBuffer1);
    audioBuffer1 = NULL;
    if (audioBuffer2)
      free(audioBuffer2);
    audioBuffer2 = NULL;
  }
}

bool TMainWindow::OpenList(int cFile)
{
  char errortext[MAXPATH];

  if (!files[cFile].fileList)
    if ((files[cFile].fileList = fopen(files[cFile].fileName, "rt")) == NULL)
    {
      sprintf(errortext,"Could not open file list %s.", files[cFile].fileName);
      DisplayMBox(errortext, "open file list error");
      return false;
    }
  return true;
}

bool TMainWindow::AddList(char *name)
{
  char filetext[MAXPATH];
  char errortext[MAXPATH];
  char *tmpPtr;
  int cFile;
  long i;

  if (fileCount >= MAX_OPEN_FILES)
  {
    sprintf(errortext, "The maximum number (%d) of files has been opened.", MAX_OPEN_FILES);
    DisplayMBox(errortext, "open file list error");
    return false;
  }

  cFile = currentIFile + 1;
  strcpy(files[cFile].fileName, name);
  files[cFile].VideoPresent = false;
  files[cFile].AudioPresent = false;
  files[cFile].deinterlace = false;
  files[cFile].invert = false;
  if (!OpenList(cFile))
    return false;

  if (strrchr(name, '\\'))
  {
    strcpy(files[cFile].defListDir, name);
    tmpPtr = strrchr(files[cFile].defListDir, '\\');
    tmpPtr[1] = 0;
  }
  else
    files[cFile].defListDir[0]= 0;

  if (fgets(filetext, MAXPATH, files[cFile].fileList) == NULL)
  {
    sprintf(errortext,"Error reading first file name from file list %s.", name);
    DisplayMBox(errortext, "open file list error");
    CloseList(cFile);
    return false;
  }

  tmpPtr = strstr(filetext, "\n");
  if (tmpPtr)
    tmpPtr[0] = 0;

  if (!outputDib->LoadFile(filetext))
  {
    DisplayMBox(outputDib->ErrStr, "open file list error");
    CloseList(cFile);
    return false;
  }

  i = 1;
  while (fgets(filetext, MAXPATH, files[cFile].fileList))
    i++;

  if (fseek(files[cFile].fileList, 0, SEEK_SET))
  {
    sprintf(errortext,"Could not seek beginning of file %s.", name);
    DisplayMBox(errortext, "open file list error");
    CloseList(cFile);
    return false;
  }

  files[cFile].bitsPerPixel = outputDib->picBitsPerPixel;
  files[cFile].startFrame = 0;
  files[cFile].endFrame = i - 1;
  files[cFile].firstFrame = 0;
  files[cFile].lastFrame = i - 1;
  files[cFile].numFrames = files[cFile].numFramesUsed = i;
  files[cFile].currentFrame = 0;
  files[cFile].repeatCount = 1;
  files[cFile].cropFrames = false;
  files[cFile].resize = false;
  files[cFile].propSize = true;
  files[cFile].cropX = 0;
  files[cFile].cropY = 0;
  files[cFile].cropW = 0;
  files[cFile].cropH = 0;
  files[cFile].fileInfo.dwWidth = outputDib->W;
  files[cFile].fileInfo.dwHeight = outputDib->H;
  files[cFile].previewRate = 500; // delay up to 500 ms between pictures
  if (batch)
  {
    files[cFile].mpegWidth = outputDib->W;
    files[cFile].mpegHeight = outputDib->H;
  }
  else
  {
    if (!MPEGWidth || !MPEGHeight)
    {
      MPEGWidth = outputDib->W;
      MPEGHeight = outputDib->H;
    }
  }
  files[cFile].VideoPresent = true;

  CloseFile(currentIFile);
  CloseFile(currentOFile);
  currentIFile = cFile;
  currentOFile = cFile;
  VideoAvail++;
  files[cFile].aviFile = false;
  DisplayFileInfo();

  return true;
}

void TMainWindow::CloseList(int cFile)
{
  if (files[cFile].fileList)
    fclose(files[cFile].fileList);

  files[cFile].fileList = NULL;
}

void TMainWindow::CmExit()
{
  if (Playing)
    Pause = true;
  else
    PostMessage(WM_CLOSE);
}


void TMainWindow::EvHelp()
{
  WinHelp(helpFile, HELP_CONTEXT, 1);
}



DEFINE_RESPONSE_TABLE1(TMyFrameWindow, TFrameWindow)
  EV_WM_SETFOCUS,
END_RESPONSE_TABLE;

TMyFrameWindow::TMyFrameWindow(TWindow* parent, const char far *title, TWindow *clientWnd, bool shrinkToClient, TModule *module)
                 : TFrameWindow(parent, title, clientWnd, shrinkToClient, module)
{
  Attr.Style ^= (WS_MAXIMIZEBOX | WS_THICKFRAME);
  Attr.X = GetProfileInt(AppName, "left", 100);
  Attr.Y = GetProfileInt(AppName, "top", 50);
  batch = GetProfileInt(AppName, "batch", 50);
  SetIcon(GetApplication(), IDI_BBICON);
  SetIconSm(GetApplication(), IDI_SMBBICON);
  Encoding = false;
}

void TMyFrameWindow::EvSetFocus(HWND hWndLostFocus)
{
  if (Encoding)
  {
    dllSetFocus();
    return;
  }
  TFrameWindow::EvSetFocus(hWndLostFocus);
}

bool TMyFrameWindow::CanClose()
{
  char tmpStr[15];

  if (Playing)
  {
    Pause = true;
    return false;
  }
  sprintf(tmpStr, "%d", Attr.X);
  WriteProfileString(AppName, "left", tmpStr);
  sprintf(tmpStr, "%d", Attr.Y);
  WriteProfileString(AppName, "top", tmpStr);
  sprintf(tmpStr, "%d", batch);
  WriteProfileString(AppName, "batch", tmpStr);
  return true;
}


class TAVI2MPGApp : public TApplication
{
  public:
	 TAVI2MPGApp() : TApplication() {}

    void InitMainWindow()
    {
      char tmpStr[MAXPATH];

      strcpy(tmpStr, AppName);
      strcat(tmpStr, " - ");
      strcat(tmpStr, AppVersion);
      frameWindow = new TMyFrameWindow(0, tmpStr, new TMainWindow(0, IDD_MAINDIALOG), true);
      SetMainWindow(frameWindow);
    }
};

int OwlMain(int argc, char* argv[])
{
  int retval;
  TAVI2MPGApp *MainApp;

  strcpy(AppName, "AVI2MPG2_VFW");
  strcpy(AppVersion, "v1.24 beta 13");
  if (getcwd(helpFile, MAXPATH) == NULL)
    strcpy(helpFile, "");
  strcat(helpFile, "\\avi2mpg2_vfw.hlp");

  MainApp = new TAVI2MPGApp();
  retval = MainApp->Run();
  delete MainApp;
  return retval;
}

#define WinMain
