//----------------------------------------------------------------------------
//   Implementation of TPreviewDib class
//----------------------------------------------------------------------------
#include "avi2mpg2.h"
#include <math.h>
#include "jpeglib.h"

extern bool ShowAnimGIF;
extern bool AbortPreview;
extern char EOF_STR[];
extern char INV_HDR[];
extern char INV_CDEP[];
extern char INV_BPLAN[];
extern char NO_MEM[];
extern char NO_COMPB[];
extern unsigned char	LowMasks[];
extern RGBQUAD DefaultPalette[];

struct dib_error_mgr {
  struct jpeg_error_mgr pub;	/* "public" fields */
  jmp_buf setjmp_buffer;	/* for return to caller */
};

typedef struct dib_error_mgr *dib_error_ptr;

/*
 * Here's the routine that will replace the standard error_exit method:
 */

METHODDEF void dib_error_exit (j_common_ptr cinfo)
{
  dib_error_ptr diberr;

  /* cinfo->err really points to a view_error_mgr struct, so coerce pointer */
  diberr = (dib_error_ptr) cinfo->err;

  /* Return control to the setjmp point */
  longjmp(diberr->setjmp_buffer, 1);
}


//
// size of scan in bytes =
//   Pixel Width * bits per pixel rounded up to a DWORD boundary
//
long ScanBytes(int pixWidth, int bitsPixel)
{
  return (((long) pixWidth * bitsPixel + 31) / 32) * 4;
}

int Round(float num)
{
  if (num - floor(num) >= 0.50)
    return ceil(num);
  else
    return floor(num);
}

TPreviewDib::TPreviewDib(TWindow *parent, TRect &rect, bool oneJPGPass)
              :TBaseDib()
{
  W = rect.Width();
  H = rect.Height();
  BitsPerPixel = 24;
  Parent = parent;
  CreateDib(false);
  ClearDib();
  GIFSaveBuffer = new unsigned char[Info->bmiHeader.biSizeImage];
  DrawRect.Set(rect.left, rect.top,
               rect.right, rect.bottom);
  oneJPEGPass = oneJPGPass;
}

TPreviewDib::~TPreviewDib()
{
  delete[] GIFSaveBuffer;
}

void TPreviewDib::ScalePic()
{
  float xpercent, ypercent;
  int WLim, HLim;

  WLim = W - 1;
  HLim = H - 1;
  if ((picWidth > WLim) || (picHeight > HLim))
  {
	 xpercent = (float) WLim / picWidth;
	 ypercent = (float) HLim / picHeight;
	 if (xpercent < ypercent)
		ypercent = xpercent;
	 else
		xpercent = ypercent;
	 newWidth = max(Round(picWidth * xpercent), 1);
	 newHeight = max(Round(picHeight * ypercent), 1);
	 xCount = max(Round((float) picWidth / newWidth), 1);
	 yCount = max(Round((float) picHeight / newHeight), 1);
    if (Round((float) picWidth / xCount) > newWidth)
    {
		xCount++;
	   newWidth = max(Round((float) picWidth / xCount), 1);
		yCount++;
	   newHeight = max(Round((float) picHeight / yCount), 1);
    }
    else
	   newWidth = max(Round((float) picWidth / xCount), 1);
    if (Round((float) picHeight / yCount) > newHeight)
    {
		yCount++;
	   newHeight = max(Round((float) picHeight / yCount), 1);
		xCount++;
	   newWidth = max(Round((float) picWidth / xCount), 1);
    }
    else
	   newHeight = max(Round((float) picHeight / yCount), 1);
    xpercent = (float) picWidth / picHeight;
    ypercent = (float) newWidth / newHeight;
    if (fabs(xpercent - ypercent) > 0.10)
    {
      if (xpercent < ypercent)
      {
        xCount++;
        newWidth = max(Round((float) picWidth / xCount), 1);
      }
      else
      {
        yCount++;
        newHeight = max(Round((float) picHeight / yCount), 1);
      }
    }
  }
  else
  {
	 xCount = 1;
	 yCount = 1;
	 newWidth = picWidth;
	 newHeight = picHeight;
  }
  if (newWidth < W)
	 xOffset = (W - newWidth) >> 1;
  else
	 xOffset = 0;
  if (newHeight < H)
	 yOffset = (H - newHeight) >> 1;
  else
	 yOffset = 0;
  xOffsetSave = xOffset;
  yOffsetSave = yOffset;
  xCountSave = xCount;
  yCountSave = yCount;
}

void TPreviewDib::DrawBorder()
{
  unsigned char *bits, *prow, *prow1;
  int i;

  bits = (unsigned char*) GetBits();
  prow = bits + (yOffset * xSize) + xOffset;
  prow1 = bits + ((yOffset + newHeight - 1) * xSize) + xOffset;
  for (i = 0; i < newWidth; i++)
  {
    *prow++ = 255;
    *prow++ = 255;
    *prow++ = 255;
    *prow1++ = 255;
    *prow1++ = 255;
    *prow1++ = 255;
  }
  prow = bits + (yOffset * xSize) + xOffset;
  prow1 = prow + (newWidth - 1) * 3;
  for (i = 0; i < newHeight; i++)
  {
    prow[0] = 255;
    prow[1] = 255;
    prow[2] = 255;
    prow1[0] = 255;
    prow1[1] = 255;
    prow1[2] = 255;
    prow += xSize;
    prow1 += xSize;
  }
}

bool TPreviewDib::LoadFromDD(DDSURFACEDESC ddsd)
{
  int i, j, k, col, picCol, xsize;
  unsigned char *pcntr, *pcntr1;
  unsigned char *pbase, *pbase1;

  picWidth = ddsd.dwWidth;
  picHeight = ddsd.dwHeight;
  picBitsPerPixel = 32;
  biClrUsed = 0;
  BitsPerPixel = picBitsPerPixel;
  NumClrs = biClrUsed;
  pbase1 = (unsigned char *) ddsd.lpSurface;
  pbase = (unsigned char *) GetBits();

  ScalePic();
  xsize = ddsd.lPitch;
  xOffset = xOffset * 3;
  xCount = xCount * 4;
  memset(pbase, 0, H * xSize);
  for (i = 0; i < yOffset; i++);
    DisplayRow(i);
  k = yOffset;
  j = picHeight - 1;
  while ((k < yOffset + newHeight) && (!AbortPreview))
  {
    pcntr = pbase + (k * xSize) + xOffset;
    pcntr1 = pbase1 + (j * xsize);
    j -= yCount;
    col = 0;
    for (picCol = 0; picCol < xsize; picCol += xCount)
    {
      pcntr[col++] = pcntr1[picCol];
      pcntr[col++] = pcntr1[picCol + 1];
      pcntr[col++] = pcntr1[picCol + 2];
    }

    YieldTime();
    DisplayRow(k++);
  }
  for (i = yOffset + newHeight; i < H - 1; i++);
    DisplayRow(i);
  return true;
}

//
// Read the passed bitmap into a previewDib
//

bool TPreviewDib::LoadFromBMP(BITMAPINFO *bitmapInfo)
{
  int i, j, k, col, picCol, xsizenopad, xsize; //, endAdder, endScan;
  unsigned char *pcntr, *pcntr1;
  unsigned char *pbase, *pbase1;

  picWidth = bitmapInfo->bmiHeader.biWidth;
  picHeight = bitmapInfo->bmiHeader.biHeight;
  picBitsPerPixel = bitmapInfo->bmiHeader.biBitCount;
  biClrUsed = bitmapInfo->bmiHeader.biClrUsed;
  BitsPerPixel = picBitsPerPixel;
  NumClrs = biClrUsed;
  pbase1 = (unsigned char *) bitmapInfo + bitmapInfo->bmiHeader.biSize;
  if (NumClrs)
  {
    memcpy(&ColorMap, pbase1, sizeof(RGBQUAD) * NumClrs);
    pbase1 += sizeof(RGBQUAD) * NumClrs;
  }

  if (picHeight < 0)
  {
    picHeight = -picHeight;
    IsBottomUp = true;
//    endAdder = -1;
//    endScan = yOffset + newHeight - 1;
  }
  else
  {
    IsBottomUp = false;
//    endAdder = 1;
//    endScan = yOffset;
  }

  switch (picBitsPerPixel)
  {
    case 1 :
      xsizenopad = picWidth >> 3;
      if (picWidth % 8 != 0)
	xsizenopad++;
      break;
    case 4 :
      xsizenopad = picWidth >> 1;
      if (picWidth % 2 != 0)
	xsizenopad++;
      break;
    case 8 :
      xsizenopad = picWidth;
      break;
    case 15:
    case 16:
      xsizenopad = picWidth << 1;
      break;
    case 24:
      xsizenopad = picWidth * 3;
      break;
    case 32:
      xsizenopad = picWidth << 2;
      break;
  }
  xsize = xsizenopad;
  while ((xsize & 3) != 0)
    xsize++;

  pbase = (unsigned char *) GetBits();


  ScalePic();
  k = yOffset;
  xOffset = xOffset * 3;
  EndScan = yOffset;
  switch (BitsPerPixel)
  {
	 case 1:
      j = 0;
		while ((k < yOffset + newHeight) && (!AbortPreview))
		{
		  pcntr = pbase + (EndScan * xSize) + xOffset;
        pcntr1 = pbase1 + (j * xsize);
        j += yCount;
		  col = 0;
		  for (picCol = 0; picCol < picWidth; picCol += xCount)
		  {
			 i = pcntr1[picCol >> 3];
			 i = i >> (7 - (picCol % 8));
			 i = i & 1;
			 pcntr[col++] = ColorMap[i].rgbBlue;
			 pcntr[col++] = ColorMap[i].rgbGreen;
			 pcntr[col++] = ColorMap[i].rgbRed;
		  }

		  YieldTime();
        DisplayRow(EndScan++);
        k++;
		}
		break;

	 case 4:
      j = 0;
		while ((k < yOffset + newHeight) && (!AbortPreview))
		{
		  pcntr = pbase + (EndScan * xSize) + xOffset;
        pcntr1 = pbase1 + (j * xsize);
        j += yCount;
		  col = 0;
		  for (picCol = 0; picCol < picWidth; picCol += xCount)
		  {
			 i = pcntr1[picCol >> 1];
			 if (picCol % 2 == 0)
				i = i >> 4;
			 else
            i = i & 0xF;
			 pcntr[col++] = ColorMap[i].rgbBlue;
			 pcntr[col++] = ColorMap[i].rgbGreen;
			 pcntr[col++] = ColorMap[i].rgbRed;
		  }

		  YieldTime();
        DisplayRow(EndScan++);
        k++;
		}
		break;

	 case 8:
      j = 0;
		while ((k < yOffset + newHeight) && (!AbortPreview))
		{
		  pcntr = pbase + (EndScan * xSize) + xOffset;
        pcntr1 = pbase1 + (j * xsize);
        j += yCount;
		  col = 0;
		  for (picCol = 0; picCol < picWidth; picCol += xCount)
		  {
			 i = pcntr1[picCol];
			 pcntr[col++] = ColorMap[i].rgbBlue;
			 pcntr[col++] = ColorMap[i].rgbGreen;
			 pcntr[col++] = ColorMap[i].rgbRed;
		  }

		  YieldTime();
        DisplayRow(EndScan++);
        k++;
		}
		break;

	 case 16:
		xCount = xCount * 2;
      j = 0;
		while ((k < yOffset + newHeight) && (!AbortPreview))
		{
		  pcntr = pbase + (EndScan * xSize) + xOffset;
        pcntr1 = pbase1 + (j * xsize);
        j += yCount;
		  col = 0;
		  for (picCol = 0; picCol < xsize; picCol += xCount)
		  {
          i = pcntr1[picCol] | (pcntr1[picCol + 1] << 8);
          pcntr[col++] = (unsigned char) ((i & 0x001F) << 3);
          pcntr[col++] = (unsigned char) ((i & 0x03E0) >> 2);
			 pcntr[col++] = (unsigned char) ((i & 0x7C00) >> 7);
		  }
		  YieldTime();
        DisplayRow(EndScan++);
        k++;
		}
		break;

	 case 24:
		xCount = xCount * 3;
      j = 0;
		while ((k < yOffset + newHeight) && (!AbortPreview))
		{
		  pcntr = pbase + (EndScan * xSize) + xOffset;
        pcntr1 = pbase1 + (j * xsize);
        j += yCount;
		  col = 0;
		  for (picCol = 0; picCol < xsize; picCol += xCount)
		  {
			 pcntr[col++] = pcntr1[picCol];
			 pcntr[col++] = pcntr1[picCol + 1];
			 pcntr[col++] = pcntr1[picCol + 2];
		  }

		  YieldTime();
        DisplayRow(EndScan++);
        k++;
		}
		break;

	 case 32:
		xCount = xCount * 4;
      j = 0;
		while ((k < yOffset + newHeight) && (!AbortPreview))
		{
		  pcntr = pbase + (EndScan * xSize) + xOffset;
        pcntr1 = pbase1 + (j * xsize);
        j += yCount;
		  col = 0;
		  for (picCol = 0; picCol < xsize; picCol += xCount)
		  {
          pcntr[col++] = pcntr1[picCol];
          pcntr[col++] = pcntr1[picCol + 1];
			 pcntr[col++] = pcntr1[picCol + 2];
		  }

		  YieldTime();
        DisplayRow(EndScan++);
        k++;
		}
		break;
  }
  return true;
}

//
// Read the passed fullDib into a previewDib
//

bool TPreviewDib::LoadFromDib(TFullDib *dib)
{
  int i, j, k, col, picCol;
  unsigned char *pcntr, *pcntr1;
  unsigned char *pbase, *pbase1;

  CopyBaseVars(dib);
  picWidth = dib->W;
  picHeight = dib->H;
  BitsPerPixel = dib->BitsPerPixel;
  NumClrs = dib->NumColors();
  if (NumClrs)
    memcpy(&ColorMap, dib->GetInfo()->bmiColors, sizeof(RGBQUAD) * NumClrs);

  pbase = (unsigned char *) GetBits();

  pbase1 = (unsigned char *) dib->GetBits();

  ScalePic();
  k = yOffset;
  xOffset = xOffset * 3;
  EndScan = yOffset;
  switch (BitsPerPixel)
  {
	 case 1:
      j = 0;
		while ((k < yOffset + newHeight) && (!AbortPreview))
		{
		  pcntr = pbase + (EndScan * xSize) + xOffset;
        pcntr1 = pbase1 + (j * dib->xSize);
        j += yCount;
		  col = 0;
		  for (picCol = 0; picCol < picWidth; picCol += xCount)
		  {
			 i = pcntr1[picCol >> 3];
			 i = i >> (7 - (picCol % 8));
			 i = i & 1;
			 pcntr[col++] = ColorMap[i].rgbBlue;
			 pcntr[col++] = ColorMap[i].rgbGreen;
			 pcntr[col++] = ColorMap[i].rgbRed;
		  }

		  YieldTime();
        DisplayRow(EndScan++);
        k++;
		}
		break;

	 case 4:
      j = 0;
		while ((k < yOffset + newHeight) && (!AbortPreview))
		{
		  pcntr = pbase + (EndScan * xSize) + xOffset;
        pcntr1 = pbase1 + (j * dib->xSize);
        j += yCount;
		  col = 0;
		  for (picCol = 0; picCol < picWidth; picCol += xCount)
		  {
			 i = pcntr1[picCol >> 1];
			 if (picCol % 2 == 0)
				i = i >> 4;
			 else
            i = i & 0xF;
			 pcntr[col++] = ColorMap[i].rgbBlue;
			 pcntr[col++] = ColorMap[i].rgbGreen;
			 pcntr[col++] = ColorMap[i].rgbRed;
		  }

		  YieldTime();
        DisplayRow(EndScan++);
        k++;
		}
		break;

	 case 8:
      j = 0;
		while ((k < yOffset + newHeight) && (!AbortPreview))
		{
		  pcntr = pbase + (EndScan * xSize) + xOffset;
        pcntr1 = pbase1 + (j * dib->xSize);
        j += yCount;
		  col = 0;
		  for (picCol = 0; picCol < picWidth; picCol += xCount)
		  {
			 i = pcntr1[picCol];
			 pcntr[col++] = ColorMap[i].rgbBlue;
			 pcntr[col++] = ColorMap[i].rgbGreen;
			 pcntr[col++] = ColorMap[i].rgbRed;
		  }

		  YieldTime();
        DisplayRow(EndScan++);
        k++;
		}
		break;

	 case 16:
		xCount = xCount * 2;
      j = 0;
		while ((k < yOffset + newHeight) && (!AbortPreview))
		{
		  pcntr = pbase + (EndScan * xSize) + xOffset;
        pcntr1 = pbase1 + (j * dib->xSize);
        j += yCount;
		  col = 0;
		  for (picCol = 0; picCol < dib->xSize; picCol += xCount)
		  {
          i = pcntr1[picCol] | (pcntr1[picCol + 1] << 8);
          pcntr[col++] = (unsigned char) ((i & 0x001F) << 3);
          pcntr[col++] = (unsigned char) ((i & 0x03E0) >> 2);
			 pcntr[col++] = (unsigned char) ((i & 0x7C00) >> 7);
		  }
		  YieldTime();
        DisplayRow(EndScan++);
        k++;
		}
		break;

	 case 24:
		xCount = xCount * 3;
      j = 0;
		while ((k < yOffset + newHeight) && (!AbortPreview))
		{
		  pcntr = pbase + (EndScan * xSize) + xOffset;
        pcntr1 = pbase1 + (j * dib->xSize);
        j += yCount;
		  col = 0;
		  for (picCol = 0; picCol < dib->xSize; picCol += xCount)
		  {
			 pcntr[col++] = pcntr1[picCol];
			 pcntr[col++] = pcntr1[picCol + 1];
			 pcntr[col++] = pcntr1[picCol + 2];
		  }

		  YieldTime();
        DisplayRow(EndScan++);
        k++;
		}
		break;

	 case 32:
		xCount = xCount * 4;
      j = 0;
		while ((k < yOffset + newHeight) && (!AbortPreview))
		{
		  pcntr = pbase + (EndScan * xSize) + xOffset;
        pcntr1 = pbase1 + (j * dib->xSize);
        j += yCount;
		  col = 0;
		  for (picCol = 0; picCol < dib->xSize; picCol += xCount)
		  {
          pcntr[col++] = pcntr1[picCol];
          pcntr[col++] = pcntr1[picCol + 1];
			 pcntr[col++] = pcntr1[picCol + 2];
		  }

		  YieldTime();
        DisplayRow(EndScan++);
        k++;
		}
		break;
  }
  return true;
}


void TPreviewDib::SetPrevBKColor()
{
  memset(GetBits(), 0, Info->bmiHeader.biSizeImage);
}

void TPreviewDib::ClearDib()
{
  fType = TYPE_NONE;
  SetPrevBKColor();
  TClientDC dc(Parent->HWindow);
  dc.SetDIBitsToDevice(DrawRect, TPoint(0, 0), 0, H, GetBits(), *Info, DIB_RGB_COLORS);
}

//
// Select a read file routine based on file type
//

bool TPreviewDib::LoadFile(const char* name)
{
  ClearDib();
  EndScan = 0;

  return TBaseDib::LoadFile(name);

}

//
// Read the passed JPEG file into a Windows DIB
//
bool TPreviewDib::LoadJPEGFile()
{
  long j;
  struct jpeg_decompress_struct cinfo;
  struct dib_error_mgr jerr;
  unsigned char huge *pcntr;
  unsigned char FAR *pbuf;
  int row_stride, picXSize;
  JSAMPARRAY buffer;
  void huge *pdib;
  int col, picCol;
  unsigned char huge *pbase;
  bool started;

  cinfo.err = jpeg_std_error(&jerr.pub);

  jerr.pub.error_exit = dib_error_exit;
  started = false;

  /* Establish the setjmp return context for dib_error_exit to use. */
  if (setjmp(jerr.setjmp_buffer))
  {
	 /* If we get here, the JPEG library code has signaled an error.
	  * We need to clean up the JPEG object, close the input file, and return.
	  */
	 jpeg_destroy_decompress(&cinfo);
    if (started)
      return EndScan != yOffset + newHeight - 1;
    else
      return false;
  }

  jpeg_create_decompress(&cinfo);
  cinfo.preview_mode = true;
  jpeg_stdio_src(&cinfo, fpin);
  (void) jpeg_read_header(&cinfo, true);
  cinfo.quantize_colors = false;
  cinfo.do_fancy_upsampling = false;
  cinfo.dct_method = JDCT_FASTEST;
  IsInterlaced = jpeg_has_multiple_scans(&cinfo);
  if (IsInterlaced)
    cinfo.buffered_image = true;
  if ((cinfo.out_color_space != JCS_GRAYSCALE) && (cinfo.out_color_space != JCS_RGB))
    cinfo.out_color_space = JCS_RGB;
  JPGColorSpace = cinfo.jpeg_color_space;
  jpeg_start_decompress(&cinfo);

  picWidth = cinfo.output_width;
  picHeight = cinfo.output_height;
  if (cinfo.out_color_space == JCS_GRAYSCALE)
    BitsPerPixel = 8;
  else
    BitsPerPixel = 24;
  picBitsPerPixel = BitsPerPixel;

  pdib = GetBits();
  pbase = (unsigned char huge *)pdib;

  /* Process data */
  ScalePic();
  picXSize = picWidth * 3;
  xOffset = xOffset * 3;
  EndScan = yOffset + newHeight - 1;
  started = true;
  xCount = xCount * 3;

  row_stride = cinfo.output_width * cinfo.output_components;
  buffer = (*cinfo.mem->alloc_sarray)
			 ((j_common_ptr) &cinfo, JPOOL_IMAGE, row_stride, 1);
  j = 0;
  if (IsInterlaced)
  {
    while ((!jpeg_input_complete(&cinfo)) && (!AbortPreview))
    {
      jpeg_start_output(&cinfo, cinfo.input_scan_number);
      j = 0;
      EndScan = yOffset + newHeight - 1;
      while ((j < picHeight) && (!AbortPreview))
      {
	     (void) jpeg_read_scanlines(&cinfo, buffer, 1);
	     if ((j % yCount == 0) && (EndScan >= 0))
	     {
		    pcntr = pbase + (EndScan * xSize) + xOffset;
		    pbuf = buffer[0];

		    col = 0;
		    for (picCol = 0; picCol < picXSize; picCol+=xCount)
		    {
		      pcntr[col++] = pbuf[picCol];
		      pcntr[col++] = pbuf[picCol + 1];
		      pcntr[col++] = pbuf[picCol + 2];
		    }
          DisplayRow(EndScan);
		    EndScan--;
	     }
	     YieldTime();
	     j++;
      }
      jpeg_finish_output(&cinfo);
    }
  }
  else
  {
    while ((j < picHeight) && (!AbortPreview))
    {
	   (void) jpeg_read_scanlines(&cinfo, buffer, 1);
	   if ((j % yCount == 0) && (EndScan >= 0))
	   {
		  pcntr = pbase + (EndScan * xSize) + xOffset;
		  pbuf = buffer[0];

		  col = 0;
		  for (picCol = 0; picCol < picXSize; picCol+=xCount)
		  {
		    pcntr[col++] = pbuf[picCol];
		    pcntr[col++] = pbuf[picCol + 1];
		    pcntr[col++] = pbuf[picCol + 2];
		  }
        DisplayRow(EndScan);
		  EndScan--;
	   }
	   YieldTime();
	   j++;
    }
  }
  jpeg_destroy_decompress(&cinfo);
  return true;
}

bool TPreviewDib::LoadBMPRLEFile()
{
  int i, j, k, col, row, byte1, byte2;
  unsigned char *pcntr;
  unsigned char *pbase;
  bool newLine;

  /* Read the colormap, if any */
  if (biClrUsed)
  {
	 switch (mapentrysize)
	 {
		case 3:
		  /* BGR format (occurs in OS/2 files) */
		  for (i = 0; i < biClrUsed; i++)
		  {
          if (fread(&ColorMap[i], 1, sizeof(RGBTRIPLE), fpin) != sizeof(RGBTRIPLE))
            return false;
			 ColorMap[i].rgbReserved = 0;
		  }
		  break;
		case 4:
		  /* BGR0 format (occurs in MS Windows files) */
		  if (fread(ColorMap, 1, sizeof(RGBQUAD) * biClrUsed, fpin) != sizeof(RGBQUAD) * biClrUsed)
			 return false;
		  break;
	 }
  }

  pbase = (unsigned char *) GetBits();;

  ScalePic();
  k = yOffset;
  xOffset = xOffset * 3;
  EndScan = yOffset;
  switch (BitsPerPixel)
  {
	 case 4:
      col = 0;
      row = 0;
      newLine = false;
	   pcntr = pbase + (EndScan * xSize) + xOffset;
		while ((k < yOffset + newHeight) && (!AbortPreview))
		{
        if ((byte1 = getc(fpin)) == EOF)
        {
		    strcpy(ErrStr, EOF_STR);
		    return EndScan != yOffset;
        }
        if ((byte2 = getc(fpin)) == EOF)
        {
		    strcpy(ErrStr, EOF_STR);
		    return EndScan != yOffset;
        }
        if (newLine)
        {
          if ((byte1) || (byte2))
          {
            col = 0;
            row++;
            if (row % yCount == 0)
            {
              YieldTime();
              DisplayRow(EndScan);
              k++;
              EndScan++;
              pcntr = pbase + (EndScan * xSize) + xOffset;
            }
          }
          newLine = false;
        }
        if (byte1)
        {
          if (row % yCount == 0)
          {
            for (i = 0; i < byte1; i++)
            {
              if (col % xCount == 0)
              {
                if (col % 2)
                  j = byte2 & 0x0F;
                else
                  j = (byte2 & 0xF0) >> 4;
                *pcntr++ = ColorMap[j].rgbBlue;
                *pcntr++ = ColorMap[j].rgbGreen;
                *pcntr++ = ColorMap[j].rgbRed;
              }
              col++;
              if (col >= picWidth)
              {
                if (i < byte1 - 1)
                {
                  col = 0;
                  row++;
                  if (row % yCount == 0)
                  {
                    YieldTime();
                    DisplayRow(EndScan);
                    k++;
                    EndScan++;
                    pcntr = pbase + (EndScan * xSize) + xOffset;
                  }
                }
                else
                  newLine = true;
              }
            }
          }
          else
          {
            col += byte1;
            if (col >= picWidth)
              newLine = true;
          }
        }
        else
        {
          if (byte2 < 3)
          {
            switch (byte2)
            {
              case 0:
                col = 0;
                row++;
                if (row % yCount == 0)
                {
                  YieldTime();
                  DisplayRow(EndScan);
                  k++;
                  EndScan++;
                  pcntr = pbase + (EndScan * xSize) + xOffset;
                }
                break;

              case 1:
                DisplayRow(EndScan);
                k = yOffset + newHeight;
                row = picHeight;
                break;

              case 2:
                if ((byte1 = getc(fpin)) == EOF)
                {
                  strcpy(ErrStr, EOF_STR);
                  return EndScan != yOffset;
                }
                if ((byte2 = getc(fpin)) == EOF)
                {
                  strcpy(ErrStr, EOF_STR);
                  return EndScan != yOffset;
                }
                col += byte1;
                if (col >= picWidth)
                  col = picWidth - col;
                for (i = 0; i < byte2; i++)
                {
                  if (row % yCount == 0)
                  {
                    YieldTime();
                    DisplayRow(EndScan);
                    k++;
                    EndScan++;
                  }
                  row++;
                }
                pcntr = pbase + (EndScan * xSize) + xOffset + (col * 3);
                break;
            }
          }
          else
          {
            for (i = 0; i < byte2; i++)
            {
              if (i % 2 == 0)
              {
                if ((byte1 = getc(fpin)) == EOF)
                {
                  strcpy(ErrStr, EOF_STR);
                  return EndScan != yOffset;
                }
              }
              if (row % yCount == 0)
              {
                if (col % xCount == 0)
                {
                  if (col % 2)
                    j = byte1 & 0x0F;
                  else
                    j = (byte1 & 0xF0) >> 4;
                  *pcntr++ = ColorMap[j].rgbBlue;
                  *pcntr++ = ColorMap[j].rgbGreen;
                  *pcntr++ = ColorMap[j].rgbRed;
                }
              }
              col++;
              if (col >= picWidth)
              {
                if (i < byte2 - 1)
                {
                  col = 0;
                  row++;
                  if (row % yCount == 0)
                  {
                    YieldTime();
                    DisplayRow(EndScan);
                    k++;
                    EndScan++;
                    pcntr = pbase + (EndScan * xSize) + xOffset;
                  }
                }
                else
                  newLine = true;
              }
            }
            if (byte2 % 2)
              byte2++;
            if ((byte2 >> 1) % 2)
            {
              if ((byte1 = getc(fpin)) == EOF)
              {
                strcpy(ErrStr, EOF_STR);
                return EndScan != yOffset;
              }
            }
          }
        }
		}
		break;

	 case 8:
      col = 0;
      row = 0;
      newLine = false;
	   pcntr = pbase + (EndScan * xSize) + xOffset;
		while ((k < yOffset + newHeight) && (!AbortPreview))
		{
        if ((byte1 = getc(fpin)) == EOF)
        {
		    strcpy(ErrStr, EOF_STR);
		    return EndScan != yOffset;
        }
        if ((byte2 = getc(fpin)) == EOF)
        {
		    strcpy(ErrStr, EOF_STR);
		    return EndScan != yOffset;
        }
        if (newLine)
        {
          if ((byte1) || (byte2))
          {
            col = 0;
            row++;
            if (row % yCount == 0)
            {
              YieldTime();
              DisplayRow(EndScan);
              k++;
              EndScan++;
              pcntr = pbase + (EndScan * xSize) + xOffset;
            }
          }
          newLine = false;
        }
        if (byte1)
        {
          if (row % yCount == 0)
          {
            for (i = 0; i < byte1; i++)
            {
              if (col % xCount == 0)
              {
                *pcntr++ = ColorMap[byte2].rgbBlue;
                *pcntr++ = ColorMap[byte2].rgbGreen;
                *pcntr++ = ColorMap[byte2].rgbRed;
              }
              col++;
              if (col >= picWidth)
              {
                if (i < byte1 - 1)
                {
                  col = 0;
                  row++;
                  if (row % yCount == 0)
                  {
                    YieldTime();
                    DisplayRow(EndScan);
                    k++;
                    EndScan++;
                    pcntr = pbase + (EndScan * xSize) + xOffset;
                  }
                }
                else
                  newLine = true;
              }
            }
          }
          else
          {
            col += byte1;
            if (col >= picWidth)
              newLine = true;
          }
        }
        else
        {
          if (byte2 < 3)
          {
            switch (byte2)
            {
              case 0:
                col = 0;
                row++;
                if (row % yCount == 0)
                {
                  YieldTime();
                  DisplayRow(EndScan);
                  k++;
                  EndScan++;
                  pcntr = pbase + (EndScan * xSize) + xOffset;
                }
                break;

              case 1:
                DisplayRow(EndScan);
                k = yOffset + newHeight;
                row = picHeight;
                break;

              case 2:
                if ((byte1 = getc(fpin)) == EOF)
                {
                  strcpy(ErrStr, EOF_STR);
                  return EndScan != yOffset;
                }
                if ((byte2 = getc(fpin)) == EOF)
                {
                  strcpy(ErrStr, EOF_STR);
                  return EndScan != yOffset;
                }
                col += byte1;
                if (col >= picWidth)
                  col = picWidth - col;
                for (i = 0; i < byte2; i++)
                {
                  if (row % yCount == 0)
                  {
                    YieldTime();
                    DisplayRow(EndScan);
                    k++;
                    EndScan++;
                  }
                  row++;
                }
                pcntr = pbase + (EndScan * xSize) + xOffset + (col * 3);
                break;
            }
          }
          else
          {
            for (i = 0; i < byte2; i++)
            {
              if ((byte1 = getc(fpin)) == EOF)
              {
                strcpy(ErrStr, EOF_STR);
                return EndScan != yOffset;
              }
              if (row % yCount == 0)
              {
                if (col % xCount == 0)
                {
                  *pcntr++ = ColorMap[byte1].rgbBlue;
                  *pcntr++ = ColorMap[byte1].rgbGreen;
                  *pcntr++ = ColorMap[byte1].rgbRed;
                }
              }
              col++;
              if (col >= picWidth)
              {
                if (i < byte2 - 1)
                {
                 col = 0;
                  row++;
                  if (row % yCount == 0)
                  {
                    YieldTime();
                    DisplayRow(EndScan);
                    k++;
                    EndScan++;
                    pcntr = pbase + (EndScan * xSize) + xOffset;
                  }
                }
                else
                  newLine = true;
              }
            }
            if (byte2 % 2)
            {
              if ((byte1 = getc(fpin)) == EOF)
              {
                strcpy(ErrStr, EOF_STR);
                return EndScan != yOffset;
              }
            }
          }
        }
		}
		break;
  }
  return true;
}

//
// Read the passed BMP file into a Windows DI bitmap
//

bool TPreviewDib::LoadBMPFile()
{
  unsigned char *buff;
  int i, j, k, endAdder, col, picCol, picXSize;
  unsigned char huge *pcntr;
  void huge *pdib;
  unsigned char huge *pbase;
  DWORD redShift, greenShift, blueShift;
  int redScaleShift, greenScaleShift, blueScaleShift;

  if (ReadBMPHeader())

  {
    if (RLECompressed)
      return LoadBMPRLEFile();

    if (((BitsPerPixel == 16) || (BitsPerPixel == 32)) && (biCompression == BI_BITFIELDS))
    {
      if (fread(&redMask, 1, sizeof(redMask), fpin) != sizeof(redMask))
        return false;
      redShift = 0;
      while (((redMask >> redShift) & 0x0001) == 0)
        redShift++;
      i = redShift;
      redScaleShift = 0;
      while ((i < BitsPerPixel) && ((redMask >> i) & 0x0001))
      {
        i++;
        redScaleShift++;
      }
      redScaleShift = 8 - redScaleShift;

      if (fread(&greenMask, 1, sizeof(greenMask), fpin) != sizeof(greenMask))
        return false;
      greenShift = 0;
      while (((greenMask >> greenShift) & 0x0001) == 0)
        greenShift++;
      i = greenShift;
      greenScaleShift = 0;
      while ((i < BitsPerPixel) && ((greenMask >> i) & 0x0001))
      {
        i++;
        greenScaleShift++;
      }
      greenScaleShift = 8 - greenScaleShift;

      if (fread(&blueMask, 1, sizeof(blueMask), fpin) != sizeof(blueMask))
        return false;
      blueShift = 0;
      while (((blueMask >> blueShift) & 0x0001) == 0)
        blueShift++;
      i = blueShift;
      blueScaleShift = 0;
      while ((i < BitsPerPixel) && ((blueMask >> i) & 0x0001))
      {
        i++;
        blueScaleShift++;
      }
      blueScaleShift = 8 - blueScaleShift;
    }
    else
    {
      if (BitsPerPixel == 16)
      {
        redMask = 0x7C00;
        redShift = 10;
        redScaleShift = 3;
        greenMask = 0x03E0;
        greenShift = 5;
        greenScaleShift = 3;
        blueMask = 0x001F;
        blueShift = 0;
        blueScaleShift = 3;
      }
      else
      {
        redMask = 0x00FF0000;
        redShift = 16;
        redScaleShift = 0;
        greenMask = 0x0000FF00;
        greenShift = 8;
        greenScaleShift = 0;
        blueMask = 0x000000FF;
        blueShift = 0;
        blueScaleShift = 0;
      }
    }
	 /* Read the colormap, if any */
    if (biClrUsed)
	 {
		switch (mapentrysize)
		{
		  case 3:
			 /* BGR format (occurs in OS/2 files) */
			 for (i = 0; i < biClrUsed; i++)
			 {
            if (fread(&ColorMap[i], 1, sizeof(RGBTRIPLE), fpin) != sizeof(RGBTRIPLE))
              return false;
				ColorMap[i].rgbReserved = 0;
			 }
			 break;
		  case 4:
			 /* BGR0 format (occurs in MS Windows files) */
			 if (fread(ColorMap, 1, sizeof(RGBQUAD) * biClrUsed, fpin) != sizeof(RGBQUAD) * biClrUsed)
				return false;
			 break;
		}
	 }

	 pdib = GetBits();
	 pbase = (unsigned char huge *)pdib;

    ScalePic();
    k = yOffset;
    xOffset = xOffset * 3;
    if (IsBottomUp)
    {
      endAdder = 1;
      EndScan = yOffset;
    }
    else
    {
      endAdder = -1;
      EndScan = yOffset + newHeight - 1;
    }
	 switch (BitsPerPixel)
	 {
		case 1:
		  picXSize = picWidth >> 3;
		  if (picWidth % 8 != 0)
			 picXSize++;
		  while ((picXSize & 3) != 0)
			 picXSize++;
		  yCount = picXSize * --yCount;
		  buff = new unsigned char[picXSize];
		  while ((k < yOffset + newHeight) && (!AbortPreview))
		  {
			 pcntr = pbase + (EndScan * xSize) + xOffset;

			 if (fread(buff, 1, picXSize, fpin) != picXSize)
            goto bmperrexit;

			 if (fseek(fpin, yCount, SEEK_CUR))
            goto bmperrexit;

			 col = 0;
			 for (picCol = 0; picCol < picWidth; picCol += xCount)
			 {
				i = buff[picCol >> 3];
				i = i >> (7 - (picCol % 8));
				i = i & 1;
				pcntr[col++] = ColorMap[i].rgbBlue;
				pcntr[col++] = ColorMap[i].rgbGreen;
				pcntr[col++] = ColorMap[i].rgbRed;
			 }

			 YieldTime();
          DisplayRow(EndScan);
          k++;
			 EndScan += endAdder;
		  }
		  delete[] buff;
		  break;

		case 4:
		  picXSize = picWidth >> 1;
		  if (picWidth % 2 != 0)
			 picXSize++;
		  while ((picXSize & 3) != 0)
			 picXSize++;
		  yCount = picXSize * --yCount;
		  buff = new unsigned char[picXSize];
		  while ((k < yOffset + newHeight) && (!AbortPreview))
		  {
			 pcntr = pbase + (EndScan * xSize) + xOffset;

			 if (fread(buff, 1, picXSize, fpin) != picXSize)
            goto bmperrexit;

			 if (fseek(fpin, yCount, SEEK_CUR))
            goto bmperrexit;

			 col = 0;
			 for (picCol = 0; picCol < picWidth; picCol += xCount)
			 {
				i = buff[picCol >> 1];
				if (picCol % 2 == 0)
				  i = i >> 4;
				else
              i = i & 0xF;
				pcntr[col++] = ColorMap[i].rgbBlue;
				pcntr[col++] = ColorMap[i].rgbGreen;
				pcntr[col++] = ColorMap[i].rgbRed;
			 }

			 YieldTime();
          DisplayRow(EndScan);
          k++;
			 EndScan += endAdder;
		  }
		  delete[] buff;
		  break;

		case 8:
		  picXSize = picWidth;
		  while ((picXSize & 3) != 0)
			 picXSize++;
		  yCount = picXSize * --yCount;
		  buff = new unsigned char[picXSize];
		  while ((k < yOffset + newHeight) && (!AbortPreview))
		  {
			 pcntr = pbase + (EndScan * xSize) + xOffset;

			 if (fread(buff, 1, picXSize, fpin) != picXSize)
            goto bmperrexit;

			 if (fseek(fpin, yCount, SEEK_CUR))
            goto bmperrexit;

			 col = 0;
			 for (picCol = 0; picCol < picWidth; picCol += xCount)
			 {
				i = buff[picCol];
				pcntr[col++] = ColorMap[i].rgbBlue;
				pcntr[col++] = ColorMap[i].rgbGreen;
				pcntr[col++] = ColorMap[i].rgbRed;
			 }

			 YieldTime();
          DisplayRow(EndScan);
          k++;
			 EndScan += endAdder;
		  }
		  delete[] buff;
		  break;

		case 16:
		  picXSize = picWidth * 2;
		  while ((picXSize & 3) != 0)
			 picXSize++;
		  xCount = xCount * 2;
		  yCount = picXSize * --yCount;
		  buff = new unsigned char[picXSize];
		  while ((k < yOffset + newHeight) && (!AbortPreview))
		  {
			 pcntr = pbase + (EndScan * xSize) + xOffset;

			 if (fread(buff, 1, picXSize, fpin) != picXSize)
            goto bmperrexit;

			 if (fseek(fpin, yCount, SEEK_CUR))
            goto bmperrexit;

			 col = 0;
			 for (picCol = 0; picCol < picXSize; picCol += xCount)
			 {
            j = buff[picCol] | (buff[picCol + 1] << 8);
				i = (j & blueMask) >> blueShift;
            if (blueScaleShift > 0)
              pcntr[col++] = (unsigned char) i << blueScaleShift;
            else
              pcntr[col++] = (unsigned char) i >> abs(blueScaleShift);
            i = (j & greenMask) >> greenShift;
            if (greenScaleShift > 0)
				  pcntr[col++] = (unsigned char) i << greenScaleShift;
            else
				  pcntr[col++] = (unsigned char) i >> abs(greenScaleShift);
            i = (j & redMask) >> redShift;
            if (redScaleShift > 0)
				  pcntr[col++] = (unsigned char) i << redScaleShift;
            else
				  pcntr[col++] = (unsigned char) i >> abs(redScaleShift);
			 }
			 YieldTime();
          DisplayRow(EndScan);
          k++;
			 EndScan += endAdder;
		  }
		  delete[] buff;
		  break;

		case 24:
		  picXSize = picWidth * 3;
        j = picXSize;
		  while ((picXSize & 3) != 0)
			 picXSize++;
		  xCount = xCount * 3;
		  yCount = picXSize * --yCount;
		  buff = new unsigned char[picXSize];
		  while ((k < yOffset + newHeight) && (!AbortPreview))
		  {
			 pcntr = pbase + (EndScan * xSize) + xOffset;

			 if (fread(buff, 1, picXSize, fpin) != picXSize)
            goto bmperrexit;

			 if (fseek(fpin, yCount, SEEK_CUR))
            goto bmperrexit;

			 col = 0;
			 for (picCol = 0; picCol < j; picCol += xCount)
			 {
				pcntr[col++] = buff[picCol];
				pcntr[col++] = buff[picCol + 1];
				pcntr[col++] = buff[picCol + 2];
			 }

			 YieldTime();
          DisplayRow(EndScan);
          k++;
			 EndScan += endAdder;
		  }
		  delete[] buff;
		  break;

		case 32:
		  picXSize = picWidth * 4;
		  while ((picXSize & 3) != 0)
			 picXSize++;
		  xCount = xCount * 4;
		  yCount = picXSize * --yCount;
		  buff = new unsigned char[picXSize];
		  while ((k < yOffset + newHeight) && (!AbortPreview))
		  {
			 pcntr = pbase + (EndScan * xSize) + xOffset;

			 if (fread(buff, 1, picXSize, fpin) != picXSize)
            goto bmperrexit;

			 if (fseek(fpin, yCount, SEEK_CUR))
            goto bmperrexit;

			 col = 0;
			 for (picCol = 0; picCol < picXSize; picCol += xCount)
			 {
            j = buff[picCol] | (buff[picCol + 1] << 8) | (buff[picCol + 2] << 16) | (buff[picCol + 3] << 24);
				i = (j & blueMask) >> blueShift;
            if (blueScaleShift > 0)
              pcntr[col++] = (unsigned char) i << blueScaleShift;
            else
              pcntr[col++] = (unsigned char) i >> abs(blueScaleShift);
            i = (j & greenMask) >> greenShift;
            if (greenScaleShift > 0)
				  pcntr[col++] = (unsigned char) i << greenScaleShift;
            else
				  pcntr[col++] = (unsigned char) i >> abs(greenScaleShift);
            i = (j & redMask) >> redShift;
            if (redScaleShift > 0)
				  pcntr[col++] = (unsigned char) i << redScaleShift;
            else
				  pcntr[col++] = (unsigned char) i >> abs(redScaleShift);
			 }

			 YieldTime();
          DisplayRow(EndScan);
          k++;
			 EndScan += endAdder;
		  }
		  delete[] buff;
		  break;
	 }
  }
  return true;

bmperrexit:
  delete[] buff;
  if (IsBottomUp)
    return EndScan != yOffset;
  else
    return EndScan != yOffset + newHeight - 1;
}

//
// Read a PCX file into a Windows DIB

bool TPreviewDib::LoadPCXFile()
{
  int	i, j, k, col, row, maxrow, maxcol, plane;
  unsigned char bit, mask;
  long bytesPerScanLine;
  unsigned char huge *pcntr;
  void huge *pdib;
  unsigned char huge *pbase;
  unsigned char buffer[3];

  if (!ReadPCXHeader())
    return false;

  switch (BitsPerPixel)
  {
    case 1:
    case 4:
      /* Not all PCX files have a valid palette */
      for (i = 0 ; i < biClrUsed ; ++i)
        if (pcxHeader.pal1[i][RGB_RED] != 0 ||
            pcxHeader.pal1[i][RGB_GREEN] != 0 ||
            pcxHeader.pal1[i][RGB_BLUE] != 0)
          break;
      if (i == biClrUsed)
        if (biClrUsed == 16)
          /* Use default 16 color palette */
          for (i = 0; i < biClrUsed; i++)
          {
            ColorMap[i].rgbRed = (unsigned char) DefaultPalette[i].rgbBlue;
            ColorMap[i].rgbGreen = (unsigned char) DefaultPalette[i].rgbGreen;
            ColorMap[i].rgbBlue = (unsigned char) DefaultPalette[i].rgbRed;
          }
        else
        {
          ColorMap[0].rgbRed = (unsigned char) DefaultPalette[0].rgbBlue;
          ColorMap[0].rgbGreen = (unsigned char) DefaultPalette[0].rgbGreen;
          ColorMap[0].rgbBlue = (unsigned char) DefaultPalette[0].rgbRed;
          ColorMap[1].rgbRed = (unsigned char) DefaultPalette[15].rgbBlue;
          ColorMap[1].rgbGreen = (unsigned char) DefaultPalette[15].rgbGreen;
          ColorMap[1].rgbBlue = (unsigned char) DefaultPalette[15].rgbRed;
        }
      else
        for (i = 0; i < biClrUsed; i++)
        {
          ColorMap[i].rgbRed = (unsigned char) pcxHeader.pal1[i][RGB_BLUE];
          ColorMap[i].rgbGreen = (unsigned char) pcxHeader.pal1[i][RGB_GREEN];
          ColorMap[i].rgbBlue = (unsigned char) pcxHeader.pal1[i][RGB_RED];
        }
      break;
    case 8:
      if (fseek(fpin, -769L, SEEK_END))
        return false;
      i = getc(fpin);
      value = i;
      if (i == EOF)
        return false;
      if (value == 12)
        for (i = 0; i < biClrUsed; i++)
        {
          if (fread(&buffer[0], 1, 3, fpin) != 3)
            return false;
          ColorMap[i].rgbRed = buffer[0];
          ColorMap[i].rgbGreen = buffer[1];
          ColorMap[i].rgbBlue = buffer[2];
        }
      else
      {
      }
      break;
  }
  pdib = GetBits();
  pbase = (unsigned char huge *)pdib;
  ScalePic();

  EndScan = 0;
  xOffset = xOffset * 3;
  fseek(fpin, (long) sizeof(pcxHeader), SEEK_SET);
  bytesPerScanLine = (long) pcxHeader.bytesPerLine * (long) pcxHeader.planes;
  col = 0;
  row = 0;
  plane = 0;
  switch (BitsPerPixel)
  {
    case 1:
      maxcol = bytesPerScanLine * 8;
      break;
    case 4:
      maxcol = bytesPerScanLine * 2;
      break;
    case 24:
      maxcol = bytesPerScanLine / 3;
      if (pcxHeader.planes > 1)
        plane = 2;
  }
  maxrow = yOffset + newHeight - 1;
  row_data_idx = ROW_BUF_SIZE;
  count = 0;
  pcntr = pbase + ((long) maxrow * xSize) + xOffset;
  switch (BitsPerPixel)
  {
    case 1:
      while ((EndScan < newHeight) && (!AbortPreview))
      {
        if (!ReadPCXByte())
          return EndScan != 0;
        for (k = 0; k < 8; k++)
        {
          if ((row % yCount == 0) && (col % xCount == 0) && (col < picWidth))
          {
            *pcntr++ = ColorMap[(value >> (7 - k)) & 0x01].rgbBlue;
            *pcntr++ = ColorMap[(value >> (7 - k)) & 0x01].rgbGreen;
            *pcntr++ = ColorMap[(value >> (7 - k)) & 0x01].rgbRed;
          }
          col++;
          if (col >= maxcol)
          {
            col = 0;
            row++;
            if (row % yCount == 0)
            {
              DisplayRow(maxrow - EndScan);
              EndScan++;
              pcntr = pbase + (long) (maxrow - EndScan) * xSize + xOffset;
            }
            YieldTime();
          }
        }
      }
      break;
    case 4:
      if (pcxHeader.planes > 1)
      {
        while ((EndScan < newHeight) && (!AbortPreview))
        {
          if (!ReadPCXByte())
            return EndScan != 0;
          if (row % yCount == 0)
          {
            for (j = 0; j < 8; j++)
            {
              if ((col % xCount == 0) && (col <= picWidth))
              {
                bit = LowMasks[plane];
                mask = (unsigned char) (0x80 >> j);
                if (value & mask)
                  *pcntr |= bit;
                pcntr += 3;
              }
              col++;
            }
          }
          else
            col += 8;
          if (col >= maxcol)
          {
            col = 0;
            plane++;
            if (plane > 3)
            {
              if (row % yCount == 0)
              {
                pcntr = pbase + (maxrow - EndScan) * xSize + xOffset;
                for (j = 0; j < newWidth; j++)
                {
                  k = *pcntr;
                  *pcntr++ = ColorMap[k].rgbBlue;
                  *pcntr++ = ColorMap[k].rgbGreen;
                  *pcntr++ = ColorMap[k].rgbRed;
                }
                DisplayRow(maxrow - EndScan);
                EndScan++;
              }
              row++;
              YieldTime();
              plane = 0;
            }
            pcntr = pbase + (maxrow - EndScan) * xSize + xOffset;
          }
        }
      }
      else
      {
        while ((EndScan < newHeight) && (!AbortPreview))
        {
          if (!ReadPCXByte())
            return EndScan != 0;
          for (k = 0; k < 2; k++)
          {
            if ((row % yCount == 0) && (col % xCount == 0) && (col < picWidth))
            {
              *pcntr++ = ColorMap[(value >> (4 - k * 4)) & 0x0F].rgbBlue;
              *pcntr++ = ColorMap[(value >> (4 - k * 4)) & 0x0F].rgbGreen;
              *pcntr++ = ColorMap[(value >> (4 - k * 4)) & 0x0F].rgbRed;
            }
            col++;
            if (col >= maxcol)
            {
              col = 0;
              row++;
              if (row % yCount == 0)
              {
                DisplayRow(maxrow - EndScan);
                EndScan++;
                pcntr = pbase + (long) (maxrow - EndScan) * xSize + xOffset;
              }
              YieldTime();
            }
          }
        }
      }
      break;
    case 8:
      while ((EndScan < newHeight) && (!AbortPreview))
      {
        if (!ReadPCXByte())
          return EndScan != 0;
        if ((row % yCount == 0) && (col % xCount == 0) && (col < picWidth))
        {
          *pcntr++ = ColorMap[value].rgbBlue;
          *pcntr++ = ColorMap[value].rgbGreen;
          *pcntr++ = ColorMap[value].rgbRed;
        }
        col++;
        if (col >= bytesPerScanLine)
        {
          col = 0;
          row++;
          if (row % yCount == 0)
          {
            DisplayRow(maxrow - EndScan);
            EndScan++;
            pcntr = pbase + (long) (maxrow - EndScan) * xSize + xOffset;
          }
          YieldTime();
        }
      }
      break;
    case 24:
      if (pcxHeader.planes > 1)
      {
        while ((EndScan < newHeight) && (!AbortPreview))
        {
          if (!ReadPCXByte())
            return EndScan != 0;
          if ((row % yCount == 0) && (col % xCount == 0) && (col < picWidth))
          {
            pcntr[plane] = value;
            pcntr += 3;
          }
          col++;
          if (col >= maxcol)
          {
            col = 0;
            plane--;
            if (plane < 0)
            {
              row++;
              if (row % yCount == 0)
              {
                DisplayRow(maxrow - EndScan);
                EndScan++;
              }
              YieldTime();
              plane = 2;
            }
            pcntr = pbase + (maxrow - EndScan) * xSize + xOffset;
          }
        }
      }
      else
      {
        while ((EndScan < newHeight) && (!AbortPreview))
        {
          if (!ReadPCXByte())
            return EndScan != 0;
          if ((row % yCount == 0) && (col % xCount == 0))
            pcntr[plane] = value;
          plane++;
          if (plane > 2)
          {
            if ((row % yCount == 0) && (col % xCount == 0))
              pcntr += 3;
            plane = 0;
            col++;
            if (col >= maxcol)
            {
              col = 0;
              row++;
              if (row % yCount)
              {
                DisplayRow(maxrow - EndScan);
                EndScan++;
                pcntr = pbase + (maxrow - EndScan) * xSize + xOffset;
              }
              YieldTime();
              plane = 2;
            }
          }
        }
      }
      break;
  }
  return true;
}

float GIFXPercent, GIFYPercent;

void TPreviewDib::ScaleGIFLogical()
{
  int WLim, HLim;

  WLim = W - 1;
  HLim = H - 1;
  if ((logWidth > WLim) || (logHeight > HLim))
  {
	 GIFXPercent = (float) WLim / logWidth;
	 GIFYPercent = (float) HLim / logHeight;
	 if (GIFXPercent < GIFYPercent)
		GIFYPercent = GIFXPercent;
	 else
		GIFXPercent = GIFYPercent;
	 newLWidth = max(Round(logWidth * GIFXPercent), 1);
	 newLHeight = max(Round(logHeight * GIFYPercent), 1);
	 xLCount = max(Round((float) logWidth / newLWidth), 1);
	 yLCount = max(Round((float) logHeight / newLHeight), 1);
    if (Round((float) logWidth / xLCount) > newLWidth)
    {
		xLCount++;
	   newLWidth = max(Round((float) logWidth / xLCount), 1);
		yLCount++;
	   newLHeight = max(Round((float) logHeight / yLCount), 1);
    }
    else
	   newLWidth = max(Round((float) logWidth / xLCount), 1);
    if (Round((float) logHeight / yLCount) > newLHeight)
    {
		yLCount++;
	   newLHeight = max(Round((float) logHeight / yLCount), 1);
		xLCount++;
	   newLWidth = max(Round((float) logWidth / xLCount), 1);
    }
    else
	   newLHeight = max(Round((float) logHeight / yLCount), 1);
    GIFXPercent = (float) logWidth / logHeight;
    GIFYPercent = (float) newLWidth / newLHeight;
    if (fabs(GIFXPercent - GIFYPercent) > 0.10)
    {
      if (GIFXPercent < GIFYPercent)
      {
        xLCount++;
        newLWidth = max(Round((float) logWidth / xLCount), 1);
      }
      else
      {
        yLCount++;
        newLHeight = max(Round((float) logHeight / yLCount), 1);
      }
    }
  }
  else
  {
	 xLCount = 1;
	 yLCount = 1;
	 newLWidth = logWidth;
	 newLHeight = logHeight;
  }
  if (newLWidth < W)
	 xLOffset = (W - newLWidth) >> 1;
  else
	 xLOffset = 0;
  if (newLHeight < H)
	 yLOffset = (H - newLHeight) >> 1;
  else
	 yLOffset = 0;
}

void TPreviewDib::ScaleGIFImage()
{
  xCount = xLCount;
  yCount = yLCount;
  newWidth = max(Round((float) picWidth / xCount), 1);
  newHeight = max(Round((float) picHeight / yCount), 1);
  xOffset = xLOffset + ceil((float) picLeft / xCount);
  yOffset = (yLOffset + newLHeight) - (newHeight + ceil((float) picTop / yCount));
  xOffsetSave = xOffset;
  yOffsetSave = yOffset;
  xCountSave = xCount;
  yCountSave = yCount;
}

void TPreviewDib::DisposeGIF()
{
  unsigned char huge *pcntr;
  void huge *pdib;
  unsigned char huge *pbase;
  int i, j, k, col;

  pdib = GetBits();
  switch (GIFDisposal)
  {
    case 0:
//      SetPrevBKColor();
      break;
    case 1:
      break;
    case 2:
      pbase = (unsigned char huge *)pdib;
      j = picTop;
      k = yOffset + newHeight - 1;
      while (j < picTop + picHeight)
      {
        if ((j % yCount == 0) && (k >= 0))
        {
          pcntr = pbase + (k * xSize) + xOffset;
          col = 0;
          for (i = picLeft; i < picLeft + picWidth; i++)
          {
            if (i % xCount == 0)
            {
              pcntr[col++] = ColorMap[BackGroundClr].rgbBlue;
              pcntr[col++] = ColorMap[BackGroundClr].rgbGreen;
              pcntr[col++] = ColorMap[BackGroundClr].rgbRed;
            }
          }
          k--;
        }
        j++;
      }
      break;
    case 3:
      memcpy(pdib, GIFSaveBuffer, Info->bmiHeader.biSizeImage);
  }
}

//
// Read a GIF file into a Windows DIB
//

bool TPreviewDib::LoadGIFFile()
{
  int i, j, k;
  unsigned char huge *pcntr;
  void huge *pdib;
  unsigned char huge *pbase;

  if ((ShowAnimGIF) && (AnimatedGIF))
    DisposeGIF();

  if (!ReadGIFHeader())
    return false;

  pdib = GetBits();
  pbase = (unsigned char huge *)pdib;

  ScaleGIFLogical();

  if (GBLColorTable)
  {
    k = xLOffset * 3;
    for (i = yLOffset; i < yLOffset + newLHeight; i++)
    {
      pcntr = pbase + (i * xSize) + k;
      for (j = 0; j < newLWidth; j++)
      {
        *pcntr++ = ColorMap[BackGroundClr].rgbBlue;
        *pcntr++ = ColorMap[BackGroundClr].rgbGreen;
        *pcntr++ = ColorMap[BackGroundClr].rgbRed;
      }
    }
  }

  ScaleGIFImage();
  xOffset = xOffset * 3;

  if ((ShowAnimGIF) && (GIFDisposal == 3))
    memcpy(GIFSaveBuffer, pdib, Info->bmiHeader.biSizeImage);

  if (!ReadGIFFile())
    return false;

  GIFFrameNum = 1;
  if (fgetpos(fpin, &CurGIFPos))
    return true;

  if (ShowAnimGIF)
    AnimatedGIF = CheckGIFAnim();

  return true;
}


bool TPreviewDib::LoadNextGIFFile()
{
  if ((fpin = fopen(fName, "rb")) == NULL)
  {
    AnimatedGIF = false;
	 return false;
  }

  if (fsetpos(fpin, &CurGIFPos))
  {
    fclose(fpin);
    AnimatedGIF = false;
    return false;
  }

  DisposeGIF();

  if (GetGIFImageHeader())
  {
    ScaleGIFImage();
    xOffset = xOffset * 3;

    if (GIFDisposal == 3)
      memcpy(GIFSaveBuffer, GetBits(), Info->bmiHeader.biSizeImage);

    if (ReadGIFFile())
    {
      GIFFrameNum++;
      if (GIFFrameNum > GIFTotalFrames)
        GIFTotalFrames = GIFFrameNum;
      if (!fgetpos(fpin, &CurGIFPos))
      {
        fclose(fpin);
        return true;
      }
    }
  }
  fseek(fpin, 0, SEEK_SET);
  if (LoadGIFFile())
  {
    fclose(fpin);
    return true;
  }
  AnimatedGIF = false;
  fclose(fpin);
  return false;
}


//
// Read a GIF file into a Windows DIB
//

bool TPreviewDib::ReadGIFFile()
{
  int i, j, k, col, irow;
  unsigned char picCol;
  unsigned char huge *pcntr;
  void huge *pdib;
  int rowminus1;
  unsigned char huge *pbase;

  /* Establish the setjmp return context for dib_error_exit to use. */
  if (setjmp(SetJmpBuffer))
    return j != picTop;

  pdib = GetBits();
  pbase = (unsigned char huge *)pdib;

  if ((AnimatedGIF) && (yOffset + newHeight < H))
  {
    for (i = H - 1; i >= yOffset + newHeight; i--)
      DisplayRow(i);
  }
  j = picTop;
  rowminus1 = yOffset + newHeight - 1;
  if (TransparentGIF)
  {
    if (IsInterlaced)
    {
      k = 0;
      while ((j < picTop + picHeight) && (!AbortPreview))
      {
        if (k < GIFPass2Offset)
          irow = k << 3;
        else
          if (k < GIFPass3Offset)
            irow = 4 + ((k - GIFPass2Offset) << 3);
          else
            if (k < GIFPass4Offset)
              irow = 2 + ((k - GIFPass3Offset) << 2);
            else
              irow = 1 + ((k - GIFPass4Offset) << 1);
        EndScan = rowminus1 - (irow / yCount);
        if ((irow % yCount == 0) && (EndScan >= 0))
        {
          pcntr = pbase + (EndScan * xSize) + xOffset;
          col = 0;
          for (i = picLeft; i < picLeft + picWidth; i++)
          {
            picCol = (unsigned char) LZWReadByte();
            if (i % xCount == 0)
            {
              if (picCol != TransparentIdx)
              {
                pcntr[col++] = ColorMap[picCol].rgbBlue;
                pcntr[col++] = ColorMap[picCol].rgbGreen;
                pcntr[col++] = ColorMap[picCol].rgbRed;
              }
              else
                col += 3;
            }
          }
          DisplayRow(EndScan);
        }
        else
          for (i = 0; i < picWidth; i++)
            LZWReadByte();
        j++;
        k++;
        YieldTime();
      }
    }
    else
    {
      EndScan = yOffset + newHeight - 1;
      while ((j < picTop + picHeight) && (!AbortPreview))
      {
        if ((j % yCount == 0) && (EndScan >= 0))
        {
          pcntr = pbase + (EndScan * xSize) + xOffset;
          col = 0;
          for (i = picLeft; i < picLeft + picWidth; i++)
          {
            picCol = (unsigned char) LZWReadByte();
            if (i % xCount == 0)
            {
              if (picCol != TransparentIdx)
              {
                pcntr[col++] = ColorMap[picCol].rgbBlue;
                pcntr[col++] = ColorMap[picCol].rgbGreen;
                pcntr[col++] = ColorMap[picCol].rgbRed;
              }
              else
                col += 3;
            }
          }
          DisplayRow(EndScan);
          EndScan--;
        }
        else
        {
          for (i = 0; i < picWidth; i++)
            LZWReadByte();
        }
        j++;
        YieldTime();
      }
    }
  }
  else
  {
    if (IsInterlaced)
    {
      k = 0;
      while ((j < picTop + picHeight) && (!AbortPreview))
      {
        if (k < GIFPass2Offset)
          irow = k << 3;
        else
          if (k < GIFPass3Offset)
            irow = 4 + ((k - GIFPass2Offset) << 3);
          else
            if (k < GIFPass4Offset)
              irow = 2 + ((k - GIFPass3Offset) << 2);
            else
              irow = 1 + ((k - GIFPass4Offset) << 1);
        EndScan = rowminus1 - (irow / yCount);
        if ((irow % yCount == 0) && (EndScan >= 0))
        {
          pcntr = pbase + (EndScan * xSize) + xOffset;
          col = 0;
          for (i = picLeft; i < picLeft + picWidth; i++)
          {
            picCol = (unsigned char) LZWReadByte();
            if (i % xCount == 0)
            {
              pcntr[col++] = ColorMap[picCol].rgbBlue;
              pcntr[col++] = ColorMap[picCol].rgbGreen;
              pcntr[col++] = ColorMap[picCol].rgbRed;
            }
          }
          DisplayRow(EndScan);
        }
        else
          for (i = 0; i < picWidth; i++)
            LZWReadByte();
        j++;
        k++;
        YieldTime();
      }
    }
    else
    {
      EndScan = yOffset + newHeight - 1;
      while ((j < picTop + picHeight) && (!AbortPreview))
      {
        if ((j % yCount == 0) && (EndScan >= 0))
        {
          pcntr = pbase + (EndScan * xSize) + xOffset;
          col = 0;
          for (i = picLeft; i < picLeft + picWidth; i++)
          {
            picCol = (unsigned char) LZWReadByte();
            if (i % xCount == 0)
            {
              pcntr[col++] = ColorMap[picCol].rgbBlue;
              pcntr[col++] = ColorMap[picCol].rgbGreen;
              pcntr[col++] = ColorMap[picCol].rgbRed;
            }
          }
          DisplayRow(EndScan);
          EndScan--;
        }
        else
        {
          for (i = 0; i < picWidth; i++)
            LZWReadByte();
        }
        j++;
        YieldTime();
      }
    }
  }
  if ((AnimatedGIF) && (yOffset))
  {
    for (i = EndScan; i >= 0; i--)
      DisplayRow(i);
  }
  return true;
}

static const unsigned char c5to8bits[32] = {
	 0,   8,  16,  25,  33,  41,  49,  58,
   66,  74,  82,  90,  99, 107, 115, 123,
  132, 140, 148, 156, 165, 173, 181, 189,
  197, 206, 214, 222, 230, 239, 247, 255
};

//
// Read a TARGA file into a Windows DIB
//

bool TPreviewDib::LoadTGAFile()
{
  unsigned char huge *pcntr;
  unsigned char *buff;
  void huge *pdib;
  int i, col, picCol, picXSize;
  unsigned char huge *pbase;

  if (!ReadTGAHeader())

    return false;


  if (RLECompressed)

    return LoadTGARLEFile();


  pdib = GetBits();

  pbase = (unsigned char huge *)pdib;
  ScalePic();

  switch (BitsPerPixel)
  {
    case 8:
      picXSize = picWidth;
      xOffset = xOffset * 3;
		yCount = picXSize * --yCount;
		buff = new unsigned char[picXSize];
      if (IsBottomUp)
      {
        EndScan = yOffset;
        yOffset = yOffset + newHeight;
		  while ((EndScan < yOffset) && (!AbortPreview))
		  {
			 pcntr = pbase + (EndScan * xSize) + xOffset;

			 if (fread(buff, 1, picXSize, fpin) != picXSize)
          {
            delete[] buff;
            return EndScan != yOffset;
          }

			 if (fseek(fpin, yCount, SEEK_CUR))
          {
            delete[] buff;
            return EndScan != yOffset;
          }

			 col = 0;
			 for (picCol = 0; picCol < picXSize; picCol += xCount)
			 {
				i = buff[picCol];
				pcntr[col++] = ColorMap[i].rgbBlue;
				pcntr[col++] = ColorMap[i].rgbGreen;
				pcntr[col++] = ColorMap[i].rgbRed;
			 }

			 YieldTime();
          DisplayRow(EndScan);
			 EndScan++;
		  }
      }
      else
      {
        EndScan = yOffset + newHeight - 1;
		  while ((EndScan >= yOffset) && (!AbortPreview))
		  {
			 pcntr = pbase + (EndScan * xSize) + xOffset;

			 if (fread(buff, 1, picXSize, fpin) != picXSize)
          {
            delete[] buff;
            return EndScan != yOffset + newHeight - 1;
          }

			 if (fseek(fpin, yCount, SEEK_CUR))
          {
            delete[] buff;
            return EndScan != yOffset + newHeight - 1;
          }

			 col = 0;
			 for (picCol = 0; picCol < picXSize; picCol += xCount)
			 {
				i = buff[picCol];
				pcntr[col++] = ColorMap[i].rgbBlue;
				pcntr[col++] = ColorMap[i].rgbGreen;
				pcntr[col++] = ColorMap[i].rgbRed;
			 }

			 YieldTime();
          DisplayRow(EndScan);
			 EndScan--;
		  }
	   }
		delete[] buff;
      break;
    case 16:
      picXSize = picWidth * 2;
      xOffset = xOffset * 3;
      xCount = xCount * 2;
		yCount = picXSize * --yCount;
		buff = new unsigned char[picXSize];
      if (IsBottomUp)
      {
        EndScan = yOffset;
        yOffset = yOffset + newHeight;
		  while ((EndScan < yOffset) && (!AbortPreview))
		  {
			 pcntr = pbase + (EndScan * xSize) + xOffset;

			 if (fread(buff, 1, picXSize, fpin) != picXSize)
          {
            delete[] buff;
            return EndScan != yOffset;
          }

			 if (fseek(fpin, yCount, SEEK_CUR))
          {
            delete[] buff;
            return EndScan != yOffset;
          }

			 col = 0;
			 for (picCol = 0; picCol < picXSize; picCol += xCount)
			 {
				i = buff[picCol] | (buff[picCol + 1] << 8);
				pcntr[col++] = c5to8bits[i & 0x001F];
				pcntr[col++] = c5to8bits[(i & 0x03E0) >> 5];
				pcntr[col++] = c5to8bits[(i & 0x7C00) >> 10];
			 }

			 YieldTime();
          DisplayRow(EndScan);
			 EndScan++;
		  }
      }
      else
      {
        EndScan = yOffset + newHeight - 1;
		  while ((EndScan >= yOffset) && (!AbortPreview))
		  {
			 pcntr = pbase + (EndScan * xSize) + xOffset;

			 if (fread(buff, 1, picXSize, fpin) != picXSize)
          {
            delete[] buff;
            return EndScan != yOffset + newHeight - 1;
          }

			 if (fseek(fpin, yCount, SEEK_CUR))
          {
            delete[] buff;
            return EndScan != yOffset + newHeight - 1;
          }

			 col = 0;
			 for (picCol = 0; picCol < picXSize; picCol += xCount)
			 {
				i = buff[picCol] | (buff[picCol + 1] << 8);
				pcntr[col++] = c5to8bits[i & 0x001F];
				pcntr[col++] = c5to8bits[(i & 0x03E0) >> 5];
				pcntr[col++] = c5to8bits[(i & 0x7C00) >> 10];
			 }

			 YieldTime();
          DisplayRow(EndScan);
			 EndScan--;
		  }
	   }
		delete[] buff;
      break;
    case 24:
    case 32:
      if (BitsPerPixel == 24)
      {
        picXSize = picWidth * 3;
        xCount = xCount * 3;
      }
      else
      {
        picXSize = picWidth * 4;
        xCount = xCount * 4;
      }
      xOffset = xOffset * 3;
		yCount = picXSize * --yCount;
      buff = new unsigned char[picXSize];
      if (IsBottomUp)
      {
        EndScan = yOffset;
        yOffset = yOffset + newHeight;
		  while ((EndScan < yOffset) && (!AbortPreview))
		  {
			 pcntr = pbase + (EndScan * xSize) + xOffset;

			 if (fread(buff, 1, picXSize, fpin) != picXSize)
          {
            delete[] buff;
            return EndScan != yOffset;
          }

			 if (fseek(fpin, yCount, SEEK_CUR))
          {
            delete[] buff;
            return EndScan != yOffset;
          }

			 col = 0;
			 for (picCol = 0; picCol < picXSize; picCol += xCount)
			 {
				pcntr[col++] = buff[picCol];
				pcntr[col++] = buff[picCol + 1];
				pcntr[col++] = buff[picCol + 2];
			 }

			 YieldTime();
          DisplayRow(EndScan);
			 EndScan++;
		  }
	   }
      else
      {
        EndScan = yOffset + newHeight - 1;
	     while ((EndScan >= yOffset) && (!AbortPreview))
		  {
			 pcntr = pbase + (EndScan * xSize) + xOffset;

			 if (fread(buff, 1, picXSize, fpin) != picXSize)
          {
            delete[] buff;
            return EndScan != yOffset + newHeight - 1;
          }

			 if (fseek(fpin, yCount, SEEK_CUR))
          {
            delete[] buff;
            return EndScan != yOffset + newHeight - 1;
          }

			 col = 0;
			 for (picCol = 0; picCol < picXSize; picCol += xCount)
			 {
				pcntr[col++] = buff[picCol];
				pcntr[col++] = buff[picCol + 1];
				pcntr[col++] = buff[picCol + 2];
			 }

			 YieldTime();
          DisplayRow(EndScan);
			 EndScan--;
		  }
	   }
      delete[] buff;
      break;
  }
  return true;
}


bool TPreviewDib::LoadTGARLEFile()

{
  unsigned char huge *pcntr;
  void huge *pdib;
  int i, j, k, col;
  unsigned char huge *pbase;

  pdib = GetBits();

  pbase = (unsigned char huge *)pdib;
  ScalePic();
  j = 0;

  switch (BitsPerPixel)
  {
    case 8:
      xOffset = xOffset * 3;
      if (IsBottomUp)
      {
        EndScan = yOffset;
		  while ((j < picHeight) && (!AbortPreview))
		  {
	       if ((j % yCount == 0) && (EndScan >= 0))
	       {
		      pcntr = pbase + (EndScan * xSize) + xOffset;
            col = 0;
            for (i = 0; i < picWidth; i++)
            {
	           if (!ReadTGAPixel8())
                return EndScan != yOffset;

		        if (i % xCount == 0)
              {
		          pcntr[col++] = ColorMap[TGAPixel[0]].rgbBlue;
		          pcntr[col++] = ColorMap[TGAPixel[0]].rgbGreen;
                pcntr[col++] = ColorMap[TGAPixel[0]].rgbRed;
              }
            }
            DisplayRow(EndScan);
		      EndScan++;
          }
          else
          {
            for (i = 0; i < picWidth; i++)
	           if (!ReadTGAPixel8())
                return EndScan != yOffset;
          }
		    j++;
		    YieldTime();
	     }
      }
      else
      {
        EndScan = yOffset + newHeight - 1;
		  while ((j < picHeight) && (!AbortPreview))
		  {
	       if ((j % yCount == 0) && (EndScan >= 0))
	       {
		      pcntr = pbase + (EndScan * xSize) + xOffset;
            col = 0;
            for (i = 0; i < picWidth; i++)
            {
	           if (!ReadTGAPixel8())
                return EndScan != yOffset + newHeight - 1;

		        if (i % xCount == 0)
              {
		          pcntr[col++] = ColorMap[TGAPixel[0]].rgbBlue;
		          pcntr[col++] = ColorMap[TGAPixel[0]].rgbGreen;
                pcntr[col++] = ColorMap[TGAPixel[0]].rgbRed;
              }
            }
            DisplayRow(EndScan);
		      EndScan--;
          }
          else
          {
            for (i = 0; i < picWidth; i++)
	           if (!ReadTGAPixel8())
                return EndScan != yOffset + newHeight - 1;
          }
		    j++;
		    YieldTime();
	     }
	   }
      break;
    case 16:
      xOffset = xOffset * 3;
      if (IsBottomUp)
      {
        EndScan = yOffset;
		  while ((j < picHeight) && (!AbortPreview))
		  {
	       if ((j % yCount == 0) && (EndScan >= 0))
	       {
		      pcntr = pbase + (EndScan * xSize) + xOffset;
            col = 0;
            for (i = 0; i < picWidth; i++)
            {
	           if (!ReadTGAPixel16())
                return EndScan != yOffset;

		        if (i % xCount == 0)
              {
				    k = TGAPixel[0] | (TGAPixel[1] << 8);
                pcntr[col++] = c5to8bits[k & 0x001F];
                pcntr[col++] = c5to8bits[(k & 0x03E0) >> 5];
                pcntr[col++] = c5to8bits[(k & 0x7C00) >> 10];
              }
            }
            DisplayRow(EndScan);
		      EndScan++;
          }
          else
          {
            for (i = 0; i < picWidth; i++)
	           if (!ReadTGAPixel16())
                return EndScan != yOffset;
          }
		    j++;
		    YieldTime();
	     }
      }
      else
      {
        EndScan = yOffset + newHeight - 1;
		  while ((j < picHeight) && (!AbortPreview))
		  {
	       if ((j % yCount == 0) && (EndScan >= 0))
	       {
		      pcntr = pbase + (EndScan * xSize) + xOffset;
            col = 0;
            for (i = 0; i < picWidth; i++)
            {
	           if (!ReadTGAPixel16())
                return EndScan != yOffset + newHeight - 1;

		        if (i % xCount == 0)
              {
				    k = TGAPixel[0] | (TGAPixel[1] << 8);
                pcntr[col++] = c5to8bits[k & 0x001F];
                pcntr[col++] = c5to8bits[(k & 0x03E0) >> 5];
                pcntr[col++] = c5to8bits[(k & 0x7C00) >> 10];
              }
            }
            DisplayRow(EndScan);
		      EndScan--;
          }
          else
          {
            for (i = 0; i < picWidth; i++)
	           if (!ReadTGAPixel16())
                return EndScan != yOffset + newHeight - 1;
          }
		    j++;
		    YieldTime();
	     }
	   }
      break;
    case 24:
      xOffset = xOffset * 3;
      if (IsBottomUp)
      {
        EndScan = yOffset;
		  while ((j < picHeight) && (!AbortPreview))
		  {
	       if ((j % yCount == 0) && (EndScan >= 0))
	       {
		      pcntr = pbase + (EndScan * xSize) + xOffset;
            col = 0;
            for (i = 0; i < picWidth; i++)
            {
	           if (!ReadTGAPixel24())
                return EndScan != yOffset;

		        if (i % xCount == 0)
              {
                pcntr[col++] = TGAPixel[0];
                pcntr[col++] = TGAPixel[1];
                pcntr[col++] = TGAPixel[2];
              }
            }
            DisplayRow(EndScan);
		      EndScan++;
          }
          else
          {
            for (i = 0; i < picWidth; i++)
	           if (!ReadTGAPixel24())
                return EndScan != yOffset;
          }
		    j++;
		    YieldTime();
	     }
	   }
      else
      {
        EndScan = yOffset + newHeight - 1;
		  while ((j < picHeight) && (!AbortPreview))
		  {
	       if ((j % yCount == 0) && (EndScan >= 0))
	       {
		      pcntr = pbase + (EndScan * xSize) + xOffset;
            col = 0;
            for (i = 0; i < picWidth; i++)
            {
	           if (!ReadTGAPixel24())
                return EndScan != yOffset + newHeight - 1;

		        if (i % xCount == 0)
              {
                pcntr[col++] = TGAPixel[0];
                pcntr[col++] = TGAPixel[1];
                pcntr[col++] = TGAPixel[2];
              }
            }
            DisplayRow(EndScan);
		      EndScan--;
          }
          else
          {
            for (i = 0; i < picWidth; i++)
	           if (!ReadTGAPixel24())
                return EndScan != yOffset + newHeight - 1;
          }
		    j++;
		    YieldTime();
	     }
	   }
      break;
    case 32:
      xOffset = xOffset * 3;
      if (IsBottomUp)
      {
        EndScan = yOffset;
		  while ((j < picHeight) && (!AbortPreview))
		  {
	       if ((j % yCount == 0) && (EndScan >= 0))
	       {
		      pcntr = pbase + (EndScan * xSize) + xOffset;
            col = 0;
            for (i = 0; i < picWidth; i++)
            {
	           if (!ReadTGAPixel32())
                return EndScan != yOffset;

		        if (i % xCount == 0)
              {
                pcntr[col++] = TGAPixel[0];
                pcntr[col++] = TGAPixel[1];
                pcntr[col++] = TGAPixel[2];
              }
            }
            DisplayRow(EndScan);
		      EndScan++;
          }
          else
          {
            for (i = 0; i < picWidth; i++)
	           if (!ReadTGAPixel32())
                return EndScan != yOffset;
          }
		    j++;
		    YieldTime();
	     }
	   }
      else
      {
        EndScan = yOffset + newHeight - 1;
		  while ((j < picHeight) && (!AbortPreview))
		  {
	       if ((j % yCount == 0) && (EndScan >= 0))
	       {
		      pcntr = pbase + (EndScan * xSize) + xOffset;
            col = 0;
            for (i = 0; i < picWidth; i++)
            {
	           if (!ReadTGAPixel32())
                return EndScan != yOffset + newHeight - 1;

		        if (i % xCount == 0)
              {
                pcntr[col++] = TGAPixel[0];
                pcntr[col++] = TGAPixel[1];
                pcntr[col++] = TGAPixel[2];
              }
            }
            DisplayRow(EndScan);
		      EndScan--;
          }
          else
          {
            for (i = 0; i < picWidth; i++)
	           if (!ReadTGAPixel32())
                return EndScan != yOffset + newHeight - 1;
          }
		    j++;
		    YieldTime();
	     }
	   }
      break;
  }
  return true;
}


void TPreviewDib::DisplayRow(int row)

{

  TClientDC dc(Parent->HWindow);

  TRect tempRect;

  unsigned char *bits = (unsigned char *) GetBits();


  bits += xSize * row;

  tempRect.Set(DrawRect.left, DrawRect.bottom - row - 1,

               DrawRect.right, DrawRect.bottom - row);

  dc.SetDIBitsToDevice(tempRect, TPoint(0, 0), 0, 1, (void huge *) bits, *Info, DIB_RGB_COLORS);

}
