/**********************************************************************
Copyright (c) 1991 MPEG/audio software simulation group, All Rights Reserved
common.c
**********************************************************************/
/**********************************************************************
 * MPEG/audio coding/decoding software, work in progress              *
 *   NOT for public distribution until verified and approved by the   *
 *   MPEG/audio committee.  For further information, please contact   *
 *   Davis Pan, 508-493-2241, e-mail: pan@3d.enet.dec.com             *
 *                                                                    *
 * VERSION 4.0                                                        *
 *   changes made since last update:                                  *
 *   date   programmers         comment                               *
 * 2/25/91  Doulas Wong,        start of version 1.0 records          *
 *          Davis Pan                                                 *
 * 5/10/91  W. Joseph Carter    Created this file for all common      *
 *                              functions and global variables.       *
 *                              Ported to Macintosh and Unix.         *
 *                              Added Jean-Georges Fritsch's          *
 *                              "bitstream.c" package.                *
 *                              Added routines to handle AIFF PCM     *
 *                              sound files.                          *
 *                              Added "mem_alloc()" and "mem_free()"  *
 *                              routines for memory allocation        *
 *                              portability.                          *
 *                              Added routines to convert between     *
 *                              Apple SANE extended floating point    *
 *                              format and IEEE double precision      *
 *                              floating point format.  For AIFF.     *
 * 02jul91 dpwe (Aware Inc)     Moved allocation table input here;    *
 *                              Tables read from subdir TABLES_PATH.  *
 *                              Added some debug printout fns (Write*)*
 * 7/10/91 Earle Jennings       replacement of the one float by FLOAT *
 *                              port to MsDos from MacIntosh version  *
 * 8/ 5/91 Jean-Georges Fritsch fixed bug in open_bit_stream_r()      *
 *10/ 1/91 S.I. Sudharsanan,    Ported to IBM AIX platform.           *
 *         Don H. Lee,                                                *
 *         Peter W. Farrett                                           *
 *10/3/91  Don H. Lee           implemented CRC-16 error protection   *
 *                              newly introduced functions are        *
 *                              I_CRC_calc, II_CRC_calc and           *
 *                              update_CRC. Additions and revisions   *
 *                              are marked with dhl for clarity       *
 *10/18/91 Jean-Georges Fritsch fixed bug in update_CRC(),            *
 *                              II_CRC_calc() and I_CRC_calc()        *
 * 2/11/92  W. Joseph Carter    Ported new code to Macintosh.  Most   *
 *                              important fixes involved changing     *
 *                              16-bit ints to long or unsigned in    *
 *                              bit alloc routines for quant of 65535 *
 *                              and passing proper function args.     *
 *                              Removed "Other Joint Stereo" option   *
 *                              and made bitrate be total channel     *
 *                              bitrate, irrespective of the mode.    *
 *                              Fixed many small bugs & reorganized.  *
 * 3/20/92 Jean-Georges Fritsch  fixed bug in start-of-frame search   *
 * 6/15/92 Juan Pineda          added refill_buffer(bs) "n"           *
 *                              initialization                        *
 * 7/08/92 Susanne Ritscher     MS-DOS, MSC6.0 port fixes             *
 * 7/27/92 Mike Li               (re-)Port to MS-DOS                  *
 * 8/19/92 Soren H. Nielsen     Fixed bug in I_CRC_calc and in        *
 *                              II_CRC_calc.  Added function: new_ext *
 *                              for better MS-DOS compatability       *
 * 3/10/93 Kevin Peterson       changed aiff_read_headers to handle   *
 *                              chunks in any order.  now returns     *
 *                              position of sound data in file.       *
 * 3/31/93 Jens Spille          changed IFF_* string compares to use  *
 *                              strcmp()                              *
 * 5/30/93 Masahiro Iwadare	?? the previous modification does not *
 *				  work. recovered to the original. ?? *
 * 8/27/93 Seymour Shlien,      Fixes in Unix and MSDOS ports,        *
 *         Daniel Lauzon, and                                         *
 *         Bill Truerniet                                             *
 **********************************************************************/
/***********************************************************************
*
*  Global Include Files
*
***********************************************************************/
#include "main.h"
#include "consts1.h"
#include <ctype.h>
/***********************************************************************
*
*  Global Variable Definitions
*
***********************************************************************/

static al_table alloc_0 = {
  {{0, 4, 0, 0}, {3, 5, 1, 0}, {7, 3, 3, 2}, {15, 4, 3, 4}, {31, 5, 3, 5},
  {63, 6, 3, 6}, {127, 7, 3, 7}, {255, 8, 3, 8}, {511, 9, 3, 9}, {1023, 10, 3, 10},
  {2047, 11, 3, 11}, {4095, 12, 3, 12}, {8191, 13, 3, 13}, {16383, 14, 3, 14},
  {32767, 15, 3, 15}, {65535, 16, 3, 16}},
  {{0, 4, 0, 0}, {3, 5, 1, 0}, {7, 3, 3, 2}, {15, 4, 3, 4}, {31, 5, 3, 5}, {63, 6, 3, 6},
  {127, 7, 3, 7}, {255, 8, 3, 8}, {511, 9, 3, 9}, {1023, 10, 3, 10}, {2047, 11, 3, 11},
  {4095, 12, 3, 12}, {8191, 13, 3, 13}, {16383, 14, 3, 14}, {32767, 15, 3, 15},
  {65535, 16, 3, 16}},
  {{0, 4, 0, 0}, {3, 5, 1, 0}, {7, 3, 3, 2}, {15, 4, 3, 4}, {31, 5, 3, 5}, {63, 6, 3, 6},
  {127, 7, 3, 7}, {255, 8, 3, 8}, {511, 9, 3, 9}, {1023, 10, 3, 10}, {2047, 11, 3, 11},
  {4095, 12, 3, 12}, {8191, 13, 3, 13}, {16383, 14, 3, 14}, {32767, 15, 3, 15},
  {65535, 16, 3, 16}},
  {{0, 4, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {63, 6, 3, 6}, {127, 7, 3, 7}, {255, 8, 3, 8}, {511, 9, 3, 9},
  {1023, 10, 3, 10}, {2047, 11, 3, 11}, {4095, 12, 3, 12}, {8191, 13, 3, 13},
  {65535, 16, 3, 16}},
  {{0, 4, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {63, 6, 3, 6}, {127, 7, 3, 7}, {255, 8, 3, 8}, {511, 9, 3, 9},
  {1023, 10, 3, 10}, {2047, 11, 3, 11}, {4095, 12, 3, 12}, {8191, 13, 3, 13},
  {65535, 16, 3, 16}},
  {{0, 4, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {63, 6, 3, 6}, {127, 7, 3, 7}, {255, 8, 3, 8}, {511, 9, 3, 9},
  {1023, 10, 3, 10}, {2047, 11, 3, 11}, {4095, 12, 3, 12}, {8191, 13, 3, 13},
  {65535, 16, 3, 16}},
  {{0, 4, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {63, 6, 3, 6}, {127, 7, 3, 7}, {255, 8, 3, 8}, {511, 9, 3, 9}, {1023, 10, 3, 10},
  {2047, 11, 3, 11}, {4095, 12, 3, 12}, {8191, 13, 3, 13}, {65535, 16, 3, 16}},
  {{0, 4, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {63, 6, 3, 6}, {127, 7, 3, 7}, {255, 8, 3, 8}, {511, 9, 3, 9},
  {1023, 10, 3, 10}, {2047, 11, 3, 11}, {4095, 12, 3, 12}, {8191, 13, 3, 13},
  {65535, 16, 3, 16}},
  {{0, 4, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {63, 6, 3, 6}, {127, 7, 3, 7}, {255, 8, 3, 8}, {511, 9, 3, 9},
  {1023, 10, 3, 10}, {2047, 11, 3, 11}, {4095, 12, 3, 12}, {8191, 13, 3, 13},
  {65535, 16, 3, 16}},
  {{0, 4, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {63, 6, 3, 6}, {127, 7, 3, 7}, {255, 8, 3, 8}, {511, 9, 3, 9},
  {1023, 10, 3, 10}, {2047, 11, 3, 11}, {4095, 12, 3, 12}, {8191, 13, 3, 13},
  {65535, 16, 3, 16}},
  {{0, 4, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {63, 6, 3, 6}, {127, 7, 3, 7}, {255, 8, 3, 8}, {511, 9, 3, 9},
  {1023, 10, 3, 10}, {2047, 11, 3, 11}, {4095, 12, 3, 12}, {8191, 13, 3, 13},
  {65535, 16, 3, 16}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {65535, 16, 3, 16}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {65535, 16, 3, 16}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {65535, 16, 3, 16}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {65535, 16, 3, 16}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {65535, 16, 3, 16}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {65535, 16, 3, 16}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {65535, 16, 3, 16}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {65535, 16, 3, 16}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {65535, 16, 3, 16}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {65535, 16, 3, 16}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {65535, 16, 3, 16}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {65535, 16, 3, 16}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 2, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {65535, 16, 3, 16}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 2, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {65535, 16, 3, 16}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 2, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {65535, 16, 3, 16}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 2, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {65535, 16, 3, 16}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}};
static al_table alloc_1 = {
  {{0, 4, 0, 0}, {3, 5, 1, 0}, {7, 3, 3, 2}, {15, 4, 3, 4}, {31, 5, 3, 5}, {63, 6, 3, 6},
  {127, 7, 3, 7}, {255, 8, 3, 8}, {511, 9, 3, 9}, {1023, 10, 3, 10}, {2047, 11, 3, 11},
  {4095, 12, 3, 12}, {8191, 13, 3, 13}, {16383, 14, 3, 14}, {32767, 15, 3, 15},
  {65535, 16, 3, 16}},
  {{0, 4, 0, 0}, {3, 5, 1, 0}, {7, 3, 3, 2}, {15, 4, 3, 4}, {31, 5, 3, 5}, {63, 6, 3, 6},
  {127, 7, 3, 7}, {255, 8, 3, 8}, {511, 9, 3, 9}, {1023, 10, 3, 10}, {2047, 11, 3, 11},
  {4095, 12, 3, 12}, {8191, 13, 3, 13}, {16383, 14, 3, 14}, {32767, 15, 3, 15},
  {65535, 16, 3, 16}},
  {{0, 4, 0, 0}, {3, 5, 1, 0}, {7, 3, 3, 2}, {15, 4, 3, 4}, {31, 5, 3, 5}, {63, 6, 3, 6},
  {127, 7, 3, 7}, {255, 8, 3, 8}, {511, 9, 3, 9}, {1023, 10, 3, 10}, {2047, 11, 3, 11},
  {4095, 12, 3, 12}, {8191, 13, 3, 13}, {16383, 14, 3, 14}, {32767, 15, 3, 15},
  {65535, 16, 3, 16}},
  {{0, 4, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {63, 6, 3, 6}, {127, 7, 3, 7}, {255, 8, 3, 8}, {511, 9, 3, 9},
  {1023, 10, 3, 10}, {2047, 11, 3, 11}, {4095, 12, 3, 12}, {8191, 13, 3, 13},
  {65535, 16, 3, 16}},
  {{0, 4, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {63, 6, 3, 6}, {127, 7, 3, 7}, {255, 8, 3, 8}, {511, 9, 3, 9},
  {1023, 10, 3, 10}, {2047, 11, 3, 11}, {4095, 12, 3, 12}, {8191, 13, 3, 13},
  {65535, 16, 3, 16}},
  {{0, 4, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {63, 6, 3, 6}, {127, 7, 3, 7}, {255, 8, 3, 8}, {511, 9, 3, 9},
  {1023, 10, 3, 10}, {2047, 11, 3, 11}, {4095, 12, 3, 12}, {8191, 13, 3, 13},
  {65535, 16, 3, 16}},
  {{0, 4, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {63, 6, 3, 6}, {127, 7, 3, 7}, {255, 8, 3, 8}, {511, 9, 3, 9},
  {1023, 10, 3, 10}, {2047, 11, 3, 11}, {4095, 12, 3, 12}, {8191, 13, 3, 13},
  {65535, 16, 3, 16}},
  {{0, 4, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {63, 6, 3, 6}, {127, 7, 3, 7}, {255, 8, 3, 8}, {511, 9, 3, 9},
  {1023, 10, 3, 10}, {2047, 11, 3, 11}, {4095, 12, 3, 12}, {8191, 13, 3, 13},
  {65535, 16, 3, 16}},
  {{0, 4, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {63, 6, 3, 6}, {127, 7, 3, 7}, {255, 8, 3, 8}, {511, 9, 3, 9},
  {1023, 10, 3, 10}, {2047, 11, 3, 11}, {4095, 12, 3, 12}, {8191, 13, 3, 13},
  {65535, 16, 3, 16}},
  {{0, 4, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {63, 6, 3, 6}, {127, 7, 3, 7}, {255, 8, 3, 8}, {511, 9, 3, 9},
  {1023, 10, 3, 10}, {2047, 11, 3, 11}, {4095, 12, 3, 12}, {8191, 13, 3, 13},
  {65535, 16, 3, 16}},
  {{0, 4, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {63, 6, 3, 6}, {127, 7, 3, 7}, {255, 8, 3, 8}, {511, 9, 3, 9},
  {1023, 10, 3, 10}, {2047, 11, 3, 11}, {4095, 12, 3, 12}, {8191, 13, 3, 13},
  {65535, 16, 3, 16}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {65535, 16, 3, 16}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {65535, 16, 3, 16}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {65535, 16, 3, 16}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {65535, 16, 3, 16}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {65535, 16, 3, 16}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {65535, 16, 3, 16}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {65535, 16, 3, 16}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {65535, 16, 3, 16}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {65535, 16, 3, 16}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {65535, 16, 3, 16}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {65535, 16, 3, 16}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {7, 3, 3, 2}, {9, 10, 1, 3}, {15, 4, 3, 4},
  {31, 5, 3, 5}, {65535, 16, 3, 16}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 2, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {65535, 16, 3, 16}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 2, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {65535, 16, 3, 16}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 2, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {65535, 16, 3, 16}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 2, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {65535, 16, 3, 16}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 2, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {65535, 16, 3, 16}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 2, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {65535, 16, 3, 16}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 2, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {65535, 16, 3, 16}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}};
static al_table alloc_2 = {
  {{0, 4, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {9, 10, 1, 3}, {15, 4, 3, 4}, {31, 5, 3, 5},
  {63, 6, 3, 6}, {127, 7, 3, 7}, {255, 8, 3, 8}, {511, 9, 3, 9}, {1023, 10, 3, 10},
  {2047, 11, 3, 11}, {4095, 12, 3, 12}, {8191, 13, 3, 13}, {16383, 14, 3, 14},
  {32767, 15, 3, 15}},
  {{0, 4, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {9, 10, 1, 3}, {15, 4, 3, 4}, {31, 5, 3, 5},
  {63, 6, 3, 6}, {127, 7, 3, 7}, {255, 8, 3, 8}, {511, 9, 3, 9}, {1023, 10, 3, 10},
  {2047, 11, 3, 11}, {4095, 12, 3, 12}, {8191, 13, 3, 13}, {16383, 14, 3, 14},
  {32767, 15, 3, 15}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {9, 10, 1, 3}, {15, 4, 3, 4}, {31, 5, 3, 5},
  {63, 6, 3, 6}, {127, 7, 3, 7}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {9, 10, 1, 3}, {15, 4, 3, 4}, {31, 5, 3, 5},
  {63, 6, 3, 6}, {127, 7, 3, 7}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {9, 10, 1, 3}, {15, 4, 3, 4}, {31, 5, 3, 5},
  {63, 6, 3, 6}, {127, 7, 3, 7}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {9, 10, 1, 3}, {15, 4, 3, 4}, {31, 5, 3, 5},
  {63, 6, 3, 6}, {127, 7, 3, 7}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {9, 10, 1, 3}, {15, 4, 3, 4}, {31, 5, 3, 5},
  {63, 6, 3, 6}, {127, 7, 3, 7}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {9, 10, 1, 3}, {15, 4, 3, 4}, {31, 5, 3, 5},
  {63, 6, 3, 6}, {127, 7, 3, 7}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}};
static al_table alloc_3 = {
  {{0, 4, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {9, 10, 1, 3}, {15, 4, 3, 4}, {31, 5, 3, 5},
  {63, 6, 3, 6}, {127, 7, 3, 7}, {255, 8, 3, 8}, {511, 9, 3, 9}, {1023, 10, 3, 10},
  {2047, 11, 3, 11}, {4095, 12, 3, 12}, {8191, 13, 3, 13}, {16383, 14, 3, 14},
  {32767, 15, 3, 15}},
  {{0, 4, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {9, 10, 1, 3}, {15, 4, 3, 4}, {31, 5, 3, 5},
  {63, 6, 3, 6}, {127, 7, 3, 7}, {255, 8, 3, 8}, {511, 9, 3, 9}, {1023, 10, 3, 10},
  {2047, 11, 3, 11}, {4095, 12, 3, 12}, {8191, 13, 3, 13}, {16383, 14, 3, 14},
  {32767, 15, 3, 15}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {9, 10, 1, 3}, {15, 4, 3, 4}, {31, 5, 3, 5},
  {63, 6, 3, 6}, {127, 7, 3, 7}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {9, 10, 1, 3}, {15, 4, 3, 4}, {31, 5, 3, 5},
  {63, 6, 3, 6}, {127, 7, 3, 7}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {9, 10, 1, 3}, {15, 4, 3, 4}, {31, 5, 3, 5},
  {63, 6, 3, 6}, {127, 7, 3, 7}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {9, 10, 1, 3}, {15, 4, 3, 4}, {31, 5, 3, 5},
  {63, 6, 3, 6}, {127, 7, 3, 7}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {9, 10, 1, 3}, {15, 4, 3, 4}, {31, 5, 3, 5},
  {63, 6, 3, 6}, {127, 7, 3, 7}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {9, 10, 1, 3}, {15, 4, 3, 4}, {31, 5, 3, 5},
  {63, 6, 3, 6}, {127, 7, 3, 7}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {9, 10, 1, 3}, {15, 4, 3, 4}, {31, 5, 3, 5},
  {63, 6, 3, 6}, {127, 7, 3, 7}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {9, 10, 1, 3}, {15, 4, 3, 4}, {31, 5, 3, 5},
  {63, 6, 3, 6}, {127, 7, 3, 7}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {9, 10, 1, 3}, {15, 4, 3, 4}, {31, 5, 3, 5},
  {63, 6, 3, 6}, {127, 7, 3, 7}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
  {{0, 3, 0, 0}, {3, 5, 1, 0}, {5, 7, 1, 1}, {9, 10, 1, 3}, {15, 4, 3, 4}, {31, 5, 3, 5},
  {63, 6, 3, 6}, {127, 7, 3, 7}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
  {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}};

/***********************************************************************
*
*  Global Function Definitions
*
***********************************************************************/

/***********************************************************************
/*
/* Read one of the data files ("alloc_*") specifying the bit allocation/
/* quatization parameters for each subband in layer II encoding
/*
/**********************************************************************/
int read_bit_alloc(        /* read in table, return # subbands */
int table,
al_table **allocptr)
{
  int sblim;
  switch (table)
  {
    case 1:
      *allocptr = (al_table *) &alloc_1[0][0];
      sblim = 30;
      break;
    case 2:
      *allocptr = (al_table *) &alloc_2[0][0];
      sblim = 8;
      break;
    case 3:
      *allocptr = (al_table *) &alloc_3[0][0];
      sblim = 12;
      break;
    default:
      *allocptr = (al_table *) &alloc_0[0][0];
      sblim = 27;
  }
  return sblim;
}

/***********************************************************************
/*
/* Using the decoded info the appropriate possible quantization per
/* subband table is loaded
/*
/**********************************************************************/
int pick_table(   /* choose table, load if necess, return # sb's */
frame_params *fr_ps)
{
        int table, lay, ws, bsp, br_per_ch, sfrq;
        int sblim = fr_ps->sblimit;     /* return current value if no load */
        lay = fr_ps->header->lay - 1;
        bsp = fr_ps->header->bitrate_index;
        br_per_ch = bitrate[lay][bsp] / fr_ps->stereo;
        ws = fr_ps->header->sampling_frequency;
        sfrq = (int)s_freq[ws];
        /* decision rules refer to per-channel bitrates (kbits/sec/chan) */
        if ((sfrq == 48 && br_per_ch >= 56) ||
            (br_per_ch >= 56 && br_per_ch <= 80)) table = 0;
        else if (sfrq != 48 && br_per_ch >= 96) table = 1;
        else if (sfrq != 32 && br_per_ch <= 48) table = 2;
        else table = 3;
        if (fr_ps->tab_num != table)
           sblim = read_bit_alloc(fr_ps->tab_num = table, &fr_ps->alloc);
        return sblim;
}


int js_bound(
int lay, int m_ext)
{
static int jsb_table[3][4] =  { { 4, 8, 12, 16 }, { 4, 8, 12, 16},
                                { 0, 4, 8, 16} };  /* lay+m_e -> jsbound */
    return(jsb_table[lay-1][m_ext]);
}

void hdr_to_frps( /* interpret data in hdr str to fields in fr_ps */
frame_params *fr_ps)
{
layer *hdr = fr_ps->header;     /* (or pass in as arg?) */
    fr_ps->actual_mode = hdr->mode;
    fr_ps->stereo = (hdr->mode == MPG_MD_MONO) ? 1 : 2;
    if (hdr->lay == 2)          fr_ps->sblimit = pick_table(fr_ps);
    else                        fr_ps->sblimit = SBLIMIT;
    if(hdr->mode == MPG_MD_JOINT_STEREO)
        fr_ps->jsbound = js_bound(hdr->lay, hdr->mode_ext);
    else
        fr_ps->jsbound = fr_ps->sblimit;
    /* alloc, tab_num set in pick_table */
}

/*****************************************************************************
*
*  CRC error protection package
*
*****************************************************************************/
void I_CRC_calc(
frame_params *fr_ps,
unsigned int bit_alloc[2][SBLIMIT],
unsigned int *crc)
{
        int i, k;
        layer *info = fr_ps->header;
        int stereo  = fr_ps->stereo;
        int jsbound = fr_ps->jsbound;
        *crc = 0xffff; /* changed from '0' 92-08-11 shn */
        update_CRC(info->bitrate_index, 4, crc);
        update_CRC(info->sampling_frequency, 2, crc);
        update_CRC(info->padding, 1, crc);
        update_CRC(info->extension, 1, crc);
        update_CRC(info->mode, 2, crc);
        update_CRC(info->mode_ext, 2, crc);
        update_CRC(info->copyright, 1, crc);
        update_CRC(info->original, 1, crc);
        update_CRC(info->emphasis, 2, crc);
        for (i=0;i<SBLIMIT;i++)
                for (k=0;k<((i<jsbound)?stereo:1);k++)
                        update_CRC(bit_alloc[k][i], 4, crc);
}

void II_CRC_calc(
frame_params *fr_ps,
unsigned int bit_alloc[2][SBLIMIT], unsigned int scfsi[2][SBLIMIT],
unsigned int *crc)
{
        int i, k;
        layer *info = fr_ps->header;
        int stereo  = fr_ps->stereo;
        int sblimit = fr_ps->sblimit;
        int jsbound = fr_ps->jsbound;
        al_table *alloc = fr_ps->alloc;
        *crc = 0xffff; /* changed from '0' 92-08-11 shn */
        update_CRC(info->bitrate_index, 4, crc);
        update_CRC(info->sampling_frequency, 2, crc);
        update_CRC(info->padding, 1, crc);
        update_CRC(info->extension, 1, crc);
        update_CRC(info->mode, 2, crc);
        update_CRC(info->mode_ext, 2, crc);
        update_CRC(info->copyright, 1, crc);
        update_CRC(info->original, 1, crc);
        update_CRC(info->emphasis, 2, crc);
        for (i=0;i<sblimit;i++)
                for (k=0;k<((i<jsbound)?stereo:1);k++)
                        update_CRC(bit_alloc[k][i], (*alloc)[i][0].bits, crc);
        for (i=0;i<sblimit;i++)
                for (k=0;k<stereo;k++)
                        if (bit_alloc[k][i])
                                update_CRC(scfsi[k][i], 2, crc);
}

void update_CRC(
unsigned int data, unsigned int length, unsigned int *crc)
{
        unsigned int  masking, carry;
        masking = 1 << length;
        while((masking >>= 1)){
                carry = *crc & 0x8000;
                *crc <<= 1;
                if (!carry ^ !(data & masking))
                        *crc ^= CRC16_POLYNOMIAL;
        }
        *crc &= 0xffff;
}
/*****************************************************************************
*
*  End of CRC error protection package
*
*****************************************************************************/

