/**********************************************************************
Copyright (c) 1991 MPEG/audio software simulation group, All Rights Reserved
psy.c
**********************************************************************/
/**********************************************************************
 * MPEG/audio coding/decoding software, work in progress              *
 *   NOT for public distribution until verified and approved by the   *
 *   MPEG/audio committee.  For further information, please contact   *
 *   Davis Pan, 508-493-2241, e-mail: pan@3d.enet.dec.com             *
 *                                                                    *
 * VERSION 3.9                                                        *
 *   changes made since last update:                                  *
 *   date   programmers         comment                               *
 * 2/25/91  Davis Pan           start of version 1.0 records          *
 * 5/10/91  W. Joseph Carter    Ported to Macintosh and Unix.         *
 * 7/10/91  Earle Jennings      Ported to MsDos.                      *
 *                              replace of floats with FLOAT          *
 * 2/11/92  W. Joseph Carter    Fixed mem_alloc() arg for "absthr".   *
 * 7/24/92  M. Iwadare          HANN window coefficients modified.    *
 * 7/27/92  Masahiro Iwadare    Bug fix, FFT modification for Layer 3 *
 * 7/27/92  Masahiro Iwadare    Bug fix, "new", "old", and "oldest"   *
 *                              updates                               *
 * 8/07/92  Mike Coleman        Bug fix, read_absthr()                *
 **********************************************************************/
#include "main.h"
static double absthr_0[HBLKSIZE] = {
  10156347392.00, 33708348.00, 3987838.75, 1269806.88, 614805.19, 372166.75,
  256884.33, 192636.06, 153016.27, 126980.66, 108576.95, 95003.05, 84671.56,
  76513.41, 70103.16, 64824.27, 60358.38, 56720.18, 53424.14, 50668.45, 48276.70,
  46103.89, 44232.10, 42534.13, 40995.63, 39603.86, 38347.55, 37131.08, 36036.08,
  35054.00, 34098.68, 33169.40, 32339.82, 31530.99, 30742.39, 29973.51, 29291.23,
  28624.48, 27972.91, 27336.16, 26652.48, 26045.79, 25452.92, 24873.54, 24307.35,
  23754.04, 23159.95, 22632.76, 21514.81, 21514.81, 20452.08, 20452.08, 19397.13,
  19397.13, 18354.29, 18354.29, 17327.57, 17327.57, 16320.66, 16320.66, 15336.90,
  15336.90, 14412.44, 14412.44, 13481.48, 13481.48, 12610.65, 12610.65, 11796.08,
  11796.08, 10983.42, 10983.42, 10250.32, 10250.32, 9544.16, 9544.16, 8907.13,
  8907.13, 8312.61, 8312.61, 7775.67, 7775.67, 7273.40, 7273.40, 6834.99, 6834.99,
  6452.64, 6452.64, 6105.73, 6105.73, 5804.14, 5804.14, 5542.91, 5542.91, 5330.13,
  5330.13, 5031.96, 5031.96, 5031.96, 5031.96, 4872.34, 4872.34, 4872.34, 4872.34,
  4861.13, 4861.13, 4861.13, 4861.13, 4985.83, 4985.83, 4985.83, 4985.83, 5257.00,
  5257.00, 5257.00, 5257.00, 5685.09, 5685.09, 5685.09, 5685.09, 6262.35, 6262.35,
  6262.35, 6262.35, 6994.19, 6994.19, 6994.19, 6994.19, 7902.01, 7902.01, 7902.01,
  7902.01, 8968.87, 8968.87, 8968.87, 8968.87, 10156.35, 10156.35, 10156.35,
  10156.35, 11474.60, 11474.60, 11474.60, 11474.60, 12874.71, 12874.71, 12874.71,
  12874.71, 14280.31, 14280.31, 14280.31, 14280.31, 15694.14, 15694.14, 15694.14,
  15694.14, 17050.52, 17050.52, 17050.52, 17050.52, 18312.08, 18312.08, 18312.08,
  18312.08, 19486.67, 19486.67, 19486.67, 19486.67, 20546.49, 20546.49, 20546.49,
  20546.49, 21514.81, 21514.81, 21514.81, 21514.81, 22373.69, 22373.69, 22373.69,
  22373.69, 23159.95, 23159.95, 23159.95, 23159.95, 23918.70, 23918.70, 23918.70,
  23918.70, 24645.50, 24645.50, 24645.50, 24645.50, 26105.83, 26105.83, 26105.83,
  26105.83, 26105.83, 26105.83, 26105.83, 26105.83, 27716.45, 27716.45, 27716.45,
  27716.45, 27716.45, 27716.45, 27716.45, 27716.45, 29494.26, 29494.26, 29494.26,
  29494.26, 29494.26, 29494.26, 29494.26, 29494.26, 31676.53, 31676.53, 31676.53,
  31676.53, 31676.53, 31676.53, 31676.53, 31676.53, 34256.07, 34256.07, 34256.07,
  34256.07, 34256.07, 34256.07, 34256.07, 34256.07, 37388.46, 37388.46, 37388.46,
  37388.46, 37388.46, 37388.46, 37388.46, 37388.46, 41184.86, 41184.86, 41184.86,
  41184.86, 41184.86, 41184.86, 41184.86, 41184.86, 45997.86, 45997.86, 45997.86,
  45997.86, 45997.86, 45997.86, 45997.86, 45997.86, 51848.66, 51848.66, 51848.66,
  51848.66, 51848.66, 51848.66, 51848.66, 51848.66, 59120.43, 59120.43, 59120.43,
  59120.43, 59120.43, 59120.43, 59120.43, 59120.43, 68192.65, 68192.65, 68192.65,
  68192.65, 68192.65, 68192.65, 68192.65, 68192.65, 79935.11, 79935.11, 79935.11,
  79935.11, 79935.11, 79935.11, 79935.11, 79935.11, 94784.55, 94784.55, 94784.55,
  94784.55, 94784.55, 94784.55, 94784.55, 94784.55, 114482.10, 114482.10, 114482.10,
  114482.10, 114482.10, 114482.10, 114482.10, 114482.10, 140196.64, 140196.64, 140196.64,
  140196.64, 140196.64, 140196.64, 140196.64, 140196.64, 174476.75, 174476.75, 174476.75,
  174476.75, 174476.75, 174476.75, 174476.75, 174476.75, 220667.11, 220667.11, 220667.11,
  220667.11, 220667.11, 220667.11, 220667.11, 220667.11, 284929.63, 284929.63, 284929.63,
  284929.63, 284929.63, 284929.63, 284929.63, 284929.63, 374746.47, 374746.47, 374746.47,
  374746.47, 374746.47, 374746.47, 374746.47, 374746.47, 503196.50, 503196.50, 503196.50,
  503196.50, 503196.50, 503196.50, 503196.50, 503196.50, 688236.44, 688236.44, 688236.44,
  688236.44, 688236.44, 688236.44, 688236.44, 688236.44, 965467.38, 965467.38, 965467.38,
  965467.38, 965467.38, 965467.38, 965467.38, 965467.38, 1382730.50, 1382730.50, 1382730.50,
  1382730.50, 1382730.50, 1382730.50, 1382730.50, 1382730.50, 2026457.63, 2026457.63, 2026457.63,
  2026457.63, 2026457.63, 2026457.63, 2026457.63, 2026457.63, 3053076.00, 3053076.00, 3053076.00,
  3053076.00, 3053076.00, 3053076.00, 3053076.00, 3053076.00, 4717778.50, 4717778.50, 4717778.50,
  4717778.50, 4717778.50, 4717778.50, 4717778.50, 4717778.50, 7477175.00, 7477175.00, 7477175.00,
  7477175.00, 7477175.00, 7477175.00, 7477175.00, 7477175.00, 12210618.00, 12210618.00, 12210618.00,
  12210618.00, 12210618.00, 12210618.00, 12210618.00, 12210618.00, 20499234.00, 20499234.00, 20499234.00,
  20499234.00, 20499234.00, 20499234.00, 20499234.00, 20499234.00, 35541636.00, 35541636.00,
  35541636.00, 35541636.00, 35541636.00, 35541636.00, 35541636.00, 35541636.00, 63494696.00,
  63494696.00, 63494696.00, 63494696.00, 63494696.00, 63494696.00, 63494696.00, 63494696.00,
  117418800.00, 117418800.00, 117418800.00, 117418800.00, 117418800.00, 117418800.00, 117418800.00,
  117418800.00, 224252560.00, 224252560.00, 224252560.00, 224252560.00, 224252560.00, 224252560.00,
  224252560.00, 224252560.00, 443340800.00, 443340800.00, 443340800.00, 443340800.00, 443340800.00,
  443340800.00, 443340800.00, 443340800.00, 911459584.00, 911459584.00, 911459584.00, 911459584.00,
  911459584.00, 911459584.00, 911459584.00, 911459584.00, 1935251712.00, 1935251712.00, 1935251712.00,
  1935251712.00, 1935251712.00, 1935251712.00, 1935251712.00, 1935251712.00, 60776765194240.00, 60776765194240.00,
  60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
  60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
  60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
  60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
  60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
  60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
  60776765194240.00};
static double absthr_1[HBLKSIZE] = {
  488357088.00, 5898447.00, 1131716.50, 466377.53, 265911.78, 180192.88, 135125.59,
  108078.07, 90518.55, 78295.64, 69141.30, 62335.81, 56981.98, 52569.95, 49061.14, 45997.86,
  43524.88, 41279.80, 39331.23, 37647.63, 36119.16, 34732.62, 33399.32, 32265.44, 31170.05,
  30111.86, 29156.65, 28231.74, 27336.16, 26469.00, 25629.35, 24816.33, 24029.10, 23266.85,
  22476.96, 21713.89, 20976.72, 20264.58, 19531.59, 18781.82, 18102.46, 17367.51, 16700.81,
  16022.77, 15336.90, 14680.39, 14051.98, 13419.54, 12238.76, 12238.76, 11136.21, 11136.21,
  10109.68, 10109.68, 9177.78, 9177.78, 8331.78, 8331.78, 7598.67, 7598.67, 6962.06, 6962.06,
  6408.22, 6408.22, 5953.02, 5953.02, 5581.33, 5581.33, 5293.44, 5293.44, 5078.52, 5078.52,
  4928.76, 4928.76, 4861.13, 4861.13, 4849.95, 4849.95, 4917.42, 4917.42, 5043.56, 5043.56,
  5232.84, 5232.84, 5504.75, 5504.75, 5844.37, 5844.37, 6262.35, 6262.35, 6756.75, 6756.75,
  7323.82, 7323.82, 7975.13, 7975.13, 9500.31, 9500.31, 9500.31, 9500.31, 11239.26, 11239.26,
  11239.26, 11239.26, 13174.60, 13174.60, 13174.60, 13174.60, 15126.47, 15126.47, 15126.47,
  15126.47, 17011.30, 17011.30, 17011.30, 17011.30, 18738.62, 18738.62, 18738.62, 18738.62,
  20264.58, 20264.58, 20264.58, 20264.58, 21614.12, 21614.12, 21614.12, 21614.12, 22789.65,
  22789.65, 22789.65, 22789.65, 23808.80, 23808.80, 23808.80, 23808.80, 24816.33, 24816.33,
  24816.33, 24816.33, 25807.00, 25807.00, 25807.00, 25807.00, 26837.22, 26837.22, 26837.22,
  26837.22, 27972.91, 27972.91, 27972.91, 27972.91, 29223.86, 29223.86, 29223.86, 29223.86,
  30671.68, 30671.68, 30671.68, 30671.68, 32265.44, 32265.44, 32265.44, 32265.44, 34098.68,
  34098.68, 34098.68, 34098.68, 36119.16, 36119.16, 36119.16, 36119.16, 38524.55, 38524.55,
  38524.55, 38524.55, 41279.80, 41279.80, 41279.80, 41279.80, 44436.27, 44436.27, 44436.27,
  44436.27, 48054.89, 48054.89, 48054.89, 48054.89, 52328.41, 52328.41, 52328.41, 52328.41,
  62912.59, 62912.59, 62912.59, 62912.59, 62912.59, 62912.59, 62912.59, 62912.59, 77756.66,
  77756.66, 77756.66, 77756.66, 77756.66, 77756.66, 77756.66, 77756.66, 98568.38, 98568.38,
  98568.38, 98568.38, 98568.38, 98568.38, 98568.38, 98568.38, 128451.02, 128451.02, 128451.02,
  128451.02, 128451.02, 128451.02, 128451.02, 128451.02, 172877.14, 172877.14, 172877.14,
  172877.14, 172877.14, 172877.14, 172877.14, 172877.14, 240291.06, 240291.06, 240291.06,
  240291.06, 240291.06, 240291.06, 240291.06, 240291.06, 346527.44, 346527.44, 346527.44,
  346527.44, 346527.44, 346527.44, 346527.44, 346527.44, 517294.19, 517294.19, 517294.19,
  517294.19, 517294.19, 517294.19, 517294.19, 517294.19, 806747.31, 806747.31, 806747.31,
  806747.31, 806747.31, 806747.31, 806747.31, 806747.31, 1308391.13, 1308391.13, 1308391.13,
  1308391.13, 1308391.13, 1308391.13, 1308391.13, 1308391.13, 2227088.75, 2227088.75, 2227088.75,
  2227088.75, 2227088.75, 2227088.75, 2227088.75, 2227088.75, 3969516.00, 3969516.00, 3969516.00,
  3969516.00, 3969516.00, 3969516.00, 3969516.00, 3969516.00, 7442819.50, 7442819.50, 7442819.50,
  7442819.50, 7442819.50, 7442819.50, 7442819.50, 7442819.50, 14714232.00, 14714232.00, 14714232.00,
  14714232.00, 14714232.00, 14714232.00, 14714232.00, 14714232.00, 30742394.00, 30742394.00,
  30742394.00, 30742394.00, 30742394.00, 30742394.00, 30742394.00, 30742394.00, 68349824.00,
  68349824.00, 68349824.00, 68349824.00, 68349824.00, 68349824.00, 68349824.00, 68349824.00,
  161338400.00, 161338400.00, 161338400.00, 161338400.00, 161338400.00, 161338400.00, 161338400.00,
  161338400.00, 407134048.00, 407134048.00, 407134048.00, 407134048.00, 407134048.00, 407134048.00,
  407134048.00, 407134048.00, 1100874368.00, 1100874368.00, 1100874368.00, 1100874368.00, 1100874368.00,
  1100874368.00, 1100874368.00, 1100874368.00, 3196962048.00, 3196962048.00, 3196962048.00, 3196962048.00,
  3196962048.00, 3196962048.00, 3196962048.00, 3196962048.00, 10016993280.00, 10016993280.00, 10016993280.00,
  10016993280.00, 10016993280.00, 10016993280.00, 10016993280.00, 10016993280.00, 34020253696.00,
  34020253696.00, 34020253696.00, 34020253696.00, 34020253696.00, 34020253696.00, 34020253696.00,
  34020253696.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00,
  124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00,
  124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00,
  124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00,
  124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00,
  124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00,
  124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00,
  124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00,
  124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00,
  124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00,
  124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00,
  124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00,
  124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00,
  124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00,
  124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00,
  124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00,
  124950298624.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
  60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
  60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
  60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
  60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
  60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
  60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
  60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
  60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
  60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00};
static double absthr_2[HBLKSIZE] = {
  247592464.00, 3987838.75, 852584.69, 372166.75, 220667.11, 153016.27, 116879.30, 95003.05,
  80489.19, 70103.16, 62479.50, 56720.18, 52087.99, 48276.70, 45158.30, 42534.13, 40247.38,
  38347.55, 36537.39, 35054.00, 33630.83, 32339.82, 31098.37, 29973.51, 28955.93, 27972.91,
  26961.10, 26045.79, 25161.56, 24307.35, 23428.13, 22632.76, 21814.11, 20976.72, 20171.47,
  19397.13, 18609.62, 17813.02, 17089.82, 16320.66, 15586.10, 14884.61, 14182.00, 13481.48,
  12845.10, 12210.62, 11580.77, 10983.42, 9902.33, 9902.33, 8907.13, 8907.13, 8030.41, 8030.41,
  7273.40, 7273.40, 6633.42, 6633.42, 6105.73, 6105.73, 5672.02, 5672.02, 5330.13, 5330.13,
  5090.23, 5090.23, 4928.76, 4928.76, 4849.95, 4849.95, 4861.13, 4861.13, 4940.12, 4940.12,
  5101.97, 5101.97, 5354.73, 5354.73, 5685.09, 5685.09, 6091.69, 6091.69, 6602.94, 6602.94,
  7206.72, 7206.72, 7902.01, 7902.01, 8684.36, 8684.36, 9544.16, 9544.16, 10489.08, 10489.08,
  11474.60, 11474.60, 13574.93, 13574.93, 13574.93, 13574.93, 15694.14, 15694.14, 15694.14,
  15694.14, 17690.40, 17690.40, 17690.40, 17690.40, 19486.67, 19486.67, 19486.67, 19486.67,
  21025.08, 21025.08, 21025.08, 21025.08, 22373.69, 22373.69, 22373.69, 22373.69, 23536.27,
  23536.27, 23536.27, 23536.27, 24645.50, 24645.50, 24645.50, 24645.50, 25747.65, 25747.65,
  25747.65, 25747.65, 26899.09, 26899.09, 26899.09, 26899.09, 28102.02, 28102.02, 28102.02,
  28102.02, 29494.26, 29494.26, 29494.26, 29494.26, 31098.37, 31098.37, 31098.37, 31098.37,
  32865.30, 32865.30, 32865.30, 32865.30, 34973.38, 34973.38, 34973.38, 34973.38, 37388.46,
  37388.46, 37388.46, 37388.46, 40154.81, 40154.81, 40154.81, 40154.81, 43424.77, 43424.77,
  43424.77, 43424.77, 47286.54, 47286.54, 47286.54, 47286.54, 51848.66, 51848.66, 51848.66,
  51848.66, 57113.34, 57113.34, 57113.34, 57113.34, 63348.68, 63348.68, 63348.68, 63348.68,
  70914.91, 70914.91, 70914.91, 70914.91, 79935.11, 79935.11, 79935.11, 79935.11, 103929.20,
  103929.20, 103929.20, 103929.20, 103929.20, 103929.20, 103929.20, 103929.20, 140196.64,
  140196.64, 140196.64, 140196.64, 140196.64, 140196.64, 140196.64, 140196.64, 195766.14,
  195766.14, 195766.14, 195766.14, 195766.14, 195766.14, 195766.14, 195766.14, 284929.63,
  284929.63, 284929.63, 284929.63, 284929.63, 284929.63, 284929.63, 284929.63, 433249.00,
  433249.00, 433249.00, 433249.00, 433249.00, 433249.00, 433249.00, 433249.00, 688236.44,
  688236.44, 688236.44, 688236.44, 688236.44, 688236.44, 688236.44, 688236.44, 1150105.38,
  1150105.38, 1150105.38, 1150105.38, 1150105.38, 1150105.38, 1150105.38, 1150105.38, 2026457.63,
  2026457.63, 2026457.63, 2026457.63, 2026457.63, 2026457.63, 2026457.63, 2026457.63, 3782140.25,
  3782140.25, 3782140.25, 3782140.25, 3782140.25, 3782140.25, 3782140.25, 3782140.25, 7477175.00,
  7477175.00, 7477175.00, 7477175.00, 7477175.00, 7477175.00, 7477175.00, 7477175.00, 15766581.00,
  15766581.00, 15766581.00, 15766581.00, 15766581.00, 15766581.00, 15766581.00, 15766581.00, 35541636.00,
  35541636.00, 35541636.00, 35541636.00, 35541636.00, 35541636.00, 35541636.00, 35541636.00,
  86047336.00, 86047336.00, 86047336.00, 86047336.00, 86047336.00, 86047336.00, 86047336.00,
  86047336.00, 224252560.00, 224252560.00, 224252560.00, 224252560.00, 224252560.00, 224252560.00,
  224252560.00, 224252560.00, 632029568.00, 632029568.00, 632029568.00, 632029568.00, 632029568.00,
  632029568.00, 632029568.00, 632029568.00, 1939713920.00, 1939713920.00, 1939713920.00, 1939713920.00,
  1939713920.00, 1939713920.00, 1939713920.00, 1939713920.00, 6497371136.00, 6497371136.00, 6497371136.00,
  6497371136.00, 6497371136.00, 6497371136.00, 6497371136.00, 6497371136.00, 23863681024.00, 23863681024.00,
  23863681024.00, 23863681024.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00,
  96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00,
  96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00,
  96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00,
  96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00,
  96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00,
  96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00,
  96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00,
  96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00,
  96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00,
  96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00,
  96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00,
  96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00,
  96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00,
  96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00,
  96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00,
  96324681728.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
  60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
  60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
  60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
  60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
  60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
  60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
  60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
  60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
  60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
  60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
  60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
  60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
  60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
  60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
  60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
  60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00};
static FCB grouped_c;
static FCB grouped_e;
static FCB nb;
static FCB cb;
static FCB ecb;
static FCB bc;
static FBLK wsamp_r;
static FBLK wsamp_i;
static FBLK phi;
static FBLK energy;
static FHBLK c;
static FHBLK fthr;
static F2_32 snrtmp;
static ICB numlines;
static IHBLK partition;
static FCB cbval;
static FCB rnorm;
static FBLK window;
static DCBS tmn;
static FCBCB s;
static F2HBLK lthr;
static F22HBLK r1;
static F22HBLK phi_sav;
/* The static variables "r", "phi_sav", "new", "old" and "oldest" have    */
/* to be remembered for the unpredictability measure.  For "r" and        */
/* "phi_sav", the first index from the left is the channel select and     */
/* the second index is the "age" of the data.                             */
static int neew, old, oldest;
static int init1;

void psy_init()
{
  init1 = 0;
  neew = 0;
  old = 1;
  oldest = 0;
}

void psycho_anal(
short int *buffer,
short int savebuf[1056],
int   chn, int lay,
double snr32[32],
double sfreq)        /* to match prototype : float args are always double */
{
 char tmpStr[80];
 int i, j;
 unsigned int   k;
 double          r_prime, phi_prime;
 double          freq_mult, bval_lo, minthres, sum_energy;
 double         tb, temp1, temp2, temp3;
 static int     flush, sync_flush, syncsize, sfreq_idx;
/* The following static variables are constants.                           */
 static double  nmt = 5.5;
 static double   crit_band[27] = {0,  100,  200, 300, 400, 510, 630,  770,
                               920, 1080, 1270,1480,1720,2000,2320, 2700,
                              3150, 3700, 4400,5300,6400,7700,9500,12000,
                             15500,25000,30000};
 static double   bmax[27] = {20.0, 20.0, 20.0, 20.0, 20.0, 17.0, 15.0,
                            10.0,  7.0,  4.4,  4.5,  4.5,  4.5,  4.5,
                             4.5,  4.5,  4.5,  4.5,  4.5,  4.5,  4.5,
                             4.5,  4.5,  4.5,  3.5,  3.5,  3.5};
 if(init1==0){
     i = (int)(sfreq + 0.5);
     switch(i){
        case 32000: sfreq_idx = 0; break;
        case 44100: sfreq_idx = 1; break;
        case 48000: sfreq_idx = 2; break;
     }
     if (verbose)
     {
       sprintf(tmpStr, "   absthr[][] sampling frequency index: %d.",sfreq_idx);
       DisplayInfo(tmpStr);
     }
     if(lay==1){
        flush = 384;
        syncsize = 1024;
        sync_flush = 576;
     }
     else {
        flush = 576; // 384*3.0/2.0;
        syncsize = 1056;
        sync_flush = syncsize - flush;
     }
/* calculate HANN window coefficients */
/*   for(i=0;i<BLKSIZE;i++)window[i]=0.5*(1-cos(2.0*PI*i/(BLKSIZE-1.0))); */
     for(i=0;i<BLKSIZE;i++)window[i]=0.5*(1-cos(2.0*PI*(i-0.5)/BLKSIZE));
/* reset states used in unpredictability measure */
     for(i=0;i<HBLKSIZE;i++){
        r1[0][0][i]=r1[1][0][i]=r1[0][1][i]=r1[1][1][i]=0;
        phi_sav[0][0][i]=phi_sav[1][0][i]=0;
        phi_sav[0][1][i]=phi_sav[1][1][i]=0;
        lthr[0][i] = 60802371420160.0;
        lthr[1][i] = 60802371420160.0;
     }
/*****************************************************************************
 * Initialization: Compute the following constants for use later             *
 *    partition[HBLKSIZE] = the partition number associated with each        *
 *                          frequency line                                   *
 *    cbval[CBANDS]       = the center (average) bark value of each          *
 *                          partition                                        *
 *    numlines[CBANDS]    = the number of frequency lines in each partition  *
 *    tmn[CBANDS]         = tone masking noise                               *
 *****************************************************************************/
/* compute fft frequency multiplicand */
     freq_mult = sfreq/BLKSIZE;
/* calculate fft frequency, then bval of each line (use fthr[] as tmp storage)*/
     for(i=0;i<HBLKSIZE;i++){
        temp1 = i*freq_mult;
        j = 1;
        while(temp1>crit_band[j])j++;
        fthr[i]=j-1+(temp1-crit_band[j-1])/(crit_band[j]-crit_band[j-1]);
     }
     partition[0] = 0;
/* temp2 is the counter of the number of frequency lines in each partition */
     temp2 = 1;
     cbval[0]=fthr[0];
     bval_lo=fthr[0];
     for(i=1;i<HBLKSIZE;i++){
        if((fthr[i]-bval_lo)>0.33){
           partition[i]=partition[i-1]+1;
           cbval[partition[i-1]] = cbval[partition[i-1]]/temp2;
           cbval[partition[i]] = fthr[i];
           bval_lo = fthr[i];
           numlines[partition[i-1]] = (int)temp2;
           temp2 = 1;
        }
        else {
           partition[i]=partition[i-1];
           cbval[partition[i]] += fthr[i];
           temp2++;
        }
     }
     numlines[partition[i-1]] = (int)temp2;
     cbval[partition[i-1]] = cbval[partition[i-1]]/temp2;
/************************************************************************
 * Now compute the spreading function, s[j][i], the value of the spread-*
 * ing function, centered at band j, for band i, store for later use    *
 ************************************************************************/
     for(j=0;j<CBANDS;j++){
        for(i=0;i<CBANDS;i++){
           temp1 = (cbval[i] - cbval[j])*1.05;
           if(temp1>=0.5 && temp1<=2.5){
              temp2 = temp1 - 0.5;
              temp2 = 8.0 * (temp2*temp2 - 2.0 * temp2);
           }
           else temp2 = 0;
           temp1 += 0.474;
           temp3 = 15.811389+7.5*temp1-17.5*sqrt((double) (1.0+temp1*temp1));
           if(temp3 <= -100) s[i][j] = 0;
           else {
              temp3 = (temp2 + temp3)*LN_TO_LOG10;
              s[i][j] = exp(temp3);
           }
        }
     }
  /* Calculate Tone Masking Noise values */
     for(j=0;j<CBANDS;j++){
        temp1 = 15.5 + cbval[j];
        tmn[j] = (temp1>24.5) ? temp1 : 24.5;
  /* Calculate normalization factors for the net spreading functions */
        rnorm[j] = 0;
        for(i=0;i<CBANDS;i++){
           rnorm[j] += s[j][i];
        }
     }
     init1++;
 }
/************************* End of Initialization *****************************/
 switch(lay) {
  case 1:
  case 2:
     for(i=0; i<lay; i++){
/*****************************************************************************
 * Net offset is 480 samples (1056-576) for layer 2; this is because one must*
 * stagger input data by 256 samples to synchronize psychoacoustic model with*
 * filter bank outputs, then stagger so that center of 1024 FFT window lines *
 * up with center of 576 "new" audio samples.                                *
 *                                                                           *
 * For layer 1, the input data still needs to be staggered by 256 samples,   *
 * then it must be staggered again so that the 384 "new" samples are centered*
 * in the 1024 FFT window.  The net offset is then 576 and you need 448 "new"*
 * samples for each iteration to keep the 384 samples of interest centered   *
 *****************************************************************************/
        for(j=0; j<syncsize; j++){
           if(j<(sync_flush))savebuf[j] = savebuf[j+flush];
           else savebuf[j] = *buffer++;
           if(j<BLKSIZE){
/**window data with HANN window***********************************************/
              wsamp_r[j] = window[j]*((double) savebuf[j]);
              wsamp_i[j] = 0;
           }
        }
/**Compute FFT****************************************************************/
        fft(wsamp_r,wsamp_i,energy,phi,1024);
/*****************************************************************************
 * calculate the unpredictability measure, given energy[f] and phi[f]        *
 *****************************************************************************/
/*only update data "age" pointers after you are done with both channels      */
/*for layer 1 computations, for the layer 2 double computations, the pointers*/
/*are reset automatically on the second pass                                 */
         if(lay==2 || (lay==1 && chn==0) ){
           if(neew==0){neew = 1; oldest = 1;}
           else {neew = 0; oldest = 0;}
           if(old==0)old = 1; else old = 0;
        }
        for(j=0; j<HBLKSIZE; j++){
           r_prime = 2.0 * r1[chn][old][j] - r1[chn][oldest][j];
           phi_prime = 2.0 * phi_sav[chn][old][j] - phi_sav[chn][oldest][j];
           r1[chn][neew][j] = sqrt((double) energy[j]);
           phi_sav[chn][neew][j] = phi[j];
temp1=r1[chn][neew][j] * cos((double) phi[j]) - r_prime * cos((double) phi_prime);
temp2=r1[chn][neew][j] * sin((double) phi[j]) - r_prime * sin((double) phi_prime);
           temp3=r1[chn][neew][j] + fabs((double)r_prime);
           if(temp3 != 0)c[j]=sqrt(temp1*temp1+temp2*temp2)/temp3;
           else c[j] = 0;
        }
/*****************************************************************************
 * Calculate the grouped, energy-weighted, unpredictability measure,         *
 * grouped_c[], and the grouped energy. grouped_e[]                          *
 *****************************************************************************/
        for(j=1;j<CBANDS;j++){
           grouped_e[j] = 0;
           grouped_c[j] = 0;
        }
        grouped_e[0] = energy[0];
        grouped_c[0] = energy[0]*c[0];
        for(j=1;j<HBLKSIZE;j++){
           grouped_e[partition[j]] += energy[j];
           grouped_c[partition[j]] += energy[j]*c[j];
        }
/*****************************************************************************
 * convolve the grouped energy-weighted unpredictability measure             *
 * and the grouped energy with the spreading function, s[j][k]               *
 *****************************************************************************/
        for(j=0;j<CBANDS;j++){
           ecb[j] = 0;
           cb[j] = 0;
           for(k=0;k<CBANDS;k++){
              if(s[j][k] != 0.0){
                 ecb[j] += s[j][k]*grouped_e[k];
                 cb[j] += s[j][k]*grouped_c[k];
              }
           }
           if(ecb[j] !=0)cb[j] = cb[j]/ecb[j];
           else cb[j] = 0;
        }
/*****************************************************************************
 * Calculate the required SNR for each of the frequency partitions           *
 *         this whole section can be accomplished by a table lookup          *
 *****************************************************************************/
        for(j=0;j<CBANDS;j++){
           if(cb[j]<.05)cb[j]=0.05;
           else if(cb[j]>.5)cb[j]=0.5;
           tb = -0.434294482*log((double) cb[j])-0.301029996;
		   cb[j]=tb;
           bc[j] = tmn[j]*tb + nmt*(1.0-tb);
           k = (int)(cbval[j] + 0.5);
           bc[j] = (bc[j] > bmax[k]) ? bc[j] : bmax[k];
           bc[j] = exp((double) -bc[j]*LN_TO_LOG10);
        }
/*****************************************************************************
 * Calculate the permissible noise energy level in each of the frequency     *
 * partitions. Include absolute threshold and pre-echo controls              *
 *         this whole section can be accomplished by a table lookup          *
 *****************************************************************************/
        for(j=0;j<CBANDS;j++)
           if(rnorm[j] && numlines[j])
              nb[j] = ecb[j]*bc[j]/(rnorm[j]*numlines[j]);
           else nb[j] = 0;
        for(j=0;j<HBLKSIZE;j++){
/*temp1 is the preliminary threshold */
           temp1=nb[partition[j]];
           switch(sfreq_idx){
              case 0:
               temp1=(temp1>absthr_0[j])?temp1:absthr_0[j];
                break;
              case 1:
                temp1=(temp1>absthr_1[j])?temp1:absthr_1[j];
                break;
              case 2:
                temp1=(temp1>absthr_2[j])?temp1:absthr_2[j];
                break;
           }
/*do not use pre-echo control for layer 2 because it may do bad things to the*/
/*  MUSICAM bit allocation algorithm                                         */
           if(lay==1){
              fthr[j] = (temp1 < lthr[chn][j]) ? temp1 : lthr[chn][j];
              temp2 = temp1 * 0.00316;
              fthr[j] = (temp2 > fthr[j]) ? temp2 : fthr[j];
           }
           else fthr[j] = temp1;
           lthr[chn][j] = LXMIN*temp1;
        }
/*****************************************************************************
 * Translate the 512 threshold values to the 32 filter bands of the coder    *
 *****************************************************************************/
        for(j=0;j<193;j += 16){
           minthres = 60802371420160.0;
           sum_energy = 0.0;
           for(k=0;k<17;k++){
              if(minthres>fthr[j+k])minthres = fthr[j+k];
              sum_energy += energy[j+k];
           }
           snrtmp[i][j/16] = sum_energy/(minthres * 17.0);
           snrtmp[i][j/16] = 4.342944819 * log((double)snrtmp[i][j/16]);
        }
        for(j=208;j<(HBLKSIZE-1);j += 16){
           minthres = 0.0;
           sum_energy = 0.0;
           for(k=0;k<17;k++){
              minthres += fthr[j+k];
              sum_energy += energy[j+k];
           }
           snrtmp[i][j/16] = sum_energy/minthres;
           snrtmp[i][j/16] = 4.342944819 * log((double)snrtmp[i][j/16]);
        }
/*****************************************************************************
 * End of Psychoacuostic calculation loop                                    *
 *****************************************************************************/
     }
     for(i=0; i<32; i++){
        if(lay==2)
           snr32[i]=(snrtmp[0][i]>snrtmp[1][i])?snrtmp[0][i]:snrtmp[1][i];
        else snr32[i]=snrtmp[0][i];
     }
     break;
 }
}
