/* * * * * * * *
 * Tao Te Ching
 * taoteching.c
 * (C) 2008 Jake Kara
 * Distributed by cDc communications
 * Inspired by JSchrier's work http://homepage.mac.com/jschrier/gameboy/
 * * * * * * * * */


#include <gb/gb.h>
#include <rand.h>
#include <gb/drawing.h>
#include <stdio.h>
#include <gb/cgb.h>
#include "taoteching.h"

#define STATLINE 8


int xmax_max; 
int ymax_max; 
int xmax; 
int ymax;

void invertScreen(UINT8 intcolor){
	color (intcolor, 3-intcolor, XOR);
	box (0,0, 159, 143, M_FILL);
}

void bwInvertScreen(){
	color (WHITE, BLACK, XOR);
	box (0,0, xmax, ymax, M_FILL);
}

void clearScreen(){
	color (WHITE, WHITE, SOLID);
	box (0,0,159,143,M_FILL);
}

void pause(){
	UINT8 j;
       	UWORD seed;
       	INT8 s;

	seed |= (UWORD)DIV_REG << 8;
	initarand(seed);
	s = rand()& (sizeof tao / sizeof tao[0]) - 1;
	gotogxy (0,7);
//        gotogxy (0,STATLINE);
//        gprint ("       HAL_666      ");
        gprint (tao[s]);
	waitpadup();
        for (;;){
                waitpad(0xFF);
                j = joypad();
                if (j == J_A) {
                        bwInvertScreen();
                        waitpadup();
                }
                if (j == J_START) {
                        waitpadup();
                        return;
                }
        }
}

void joy(UINT8 intcolor){
	UINT8 j=joypad();
        if (j==J_START) pause();
        else if (j==J_A) invertScreen(intcolor);
        else if (j==J_B) clearScreen();
	
}

void welcome(){
	clearScreen();
	gotogxy(0,7);
	color (WHITE, BLACK, M_FILL);
	gprint ("       HAL 666      ");
	color (BLACK, WHITE, M_FILL);
	gotogxy(0,8);
	gprint ("PAUSE        <START>");
	gotogxy(0,9);
	gprint ("CATCH  <HOLD SELECT>");
	gotogxy(0,10);
	gprint ("INVERT           <A>");
	gotogxy(0,11);
	gprint ("CLEAR            <B>");
	gotogxy(0,13);
	gprint ("   press a button   ");
	gotogxy(0,17);
	gprint (" (c) 2008 Jake Kara ");
	waitpad(0xFF);
	waitpadup();
	clearScreen();
}

void main(void)
{
        int x;
	int y;
        int xstep = 10;
	int ystep;
	int xstepmin = 1;
	int xstepmax = 40;
	INT8 s;
	INT8 a;
	UINT8 colorint;
	UWORD seed;

        xmax = 159;
        ymax = 143;	

	welcome();
	for (;;){
		if (joypad()==J_SELECT) pause();
		seed |= (UWORD)DIV_REG << 8; 
		initrand(seed); 
		s = rand();
		a = rand();
       		xstep = (s&xstepmax-xstepmin) + xstepmin;
		ystep = xstep;
		colorint = (a&3);		
		color(colorint, 3-colorint, SOLID);	
		for (x=0; x < xmax; x+=xstep){
			joy(colorint);
			color(colorint, 3-colorint, SOLID);
        		line(x,0, xmax-x,ymax);
       		 }
             	for (y=0; y < ymax; y+=ystep){
			joy(colorint);
			color (colorint, 3-colorint, SOLID);
               		line (xmax, y, 0, ymax-y);
           	}
	}
}
