/*  Genetic bruteforcer for crueme.exe
  0                                                                        NELEMS
  <--- SURVIVORS--->  <--- REPRODUCTION OF SURVIVORS ---> <--- MUTATORS --->

some solutions: 
445340531008
752968361941
043907667011
DCIEDHNKGALJ
BZONJSGDHJZE
AQGMPDPNCQD
agstjdpiosau
qtocggrvelho

some working calls: 
crue 10 5 5 <range> seems to work pretty well
crue 10 5 5 09
crue 10 10 10 09
crue 3 20 50 09
crue 10 10 10 AQ
crue 3 10 10 AZ 
crue 3 20 30 AQ
crue 10 5 5 az

details:
crue 3 10 10 AZ
IZOZZPGDHUDE   score: 5, 23 attempts
BZOZJPGJHJZE   score: 3, 83 attempts
BZOZJCGDHJZE   score: 2, 183 attempts
BZOZJSGJHJZE   score: 1, 203 attempts
BZONJSGDHJZE   score: 0, 903 attempts

crue 3 20 50 09
922428202948   score: 5, 73 attempts
752964341041   score: 4, 213 attempts
752968341941   score: 1, 353 attempts
752968361941   score: 0, 563 attempts

*/


typedef struct {
  unsigned char v[12];
  unsigned int score;
} elt;


int NELTS, SURVIVORS, MUTATORS, BYTES_START, BYTES_RANGE;
static elt *SOUP;
static unsigned int attempts=0;
/*-------------------------------------------------------*/
/* this is the translation to C of the crypting function */
/*-------------------------------------------------------*/
static void GetCrypt(unsigned int p1, unsigned int p2, unsigned int p3, unsigned int *esi, unsigned int *edi) {
  unsigned int eax, i, j;
  unsigned int length=12;
  attempts++;
  *esi=0; *edi=0;
  for (i=0;i<0xFF;i++) {
    for (j=0;j<0xFF;j++) {
       eax = (p1+p3+0x0012AB20)*length;
       eax = eax ^ (p2+0x048FF4EA);
       eax = eax ^ (p3-p1-0xBC309A);
       *edi = *edi + (eax | 0x029359E2);
       *edi = *edi & 0x15263748;

       eax = (p1-p3-0x127FB9)/length;
       eax = eax ^ (p2-0x048FF4EA);
       eax = eax ^ (p1+p3+ 0xBC0533);
       *esi= *esi+ (eax & 0x029359E2);
       *esi = *esi | 0x596A7B8C;
    }
    *edi = *edi + 0x911;
    *esi = *esi - 0x911;
  }
}
/*-------------------------------------------------------*/
/* count the number of non-zero bits in a 32 bits number */
/*-------------------------------------------------------*/
static int CountBits(unsigned int v) {
  int res=0;
  while (v!=0) {
    if (v&1 != 0) res++;
    v=v>>1;  
  }
  return(res);
}
/*-------------------------------------*/
/* Compare 2 elements  (48 bits value) */
/*-------------------------------------*/
static int SameElt(elt *E1, elt*E2) {
  if (*((int*)(E1->v))==*((int*)(E2->v))) {
    if (*((int*)(4+E1->v))==*((int*)(4+E2->v))) {
      if (*((int*)(8+E1->v))==*((int*)(8+E2->v))) {
	return(1);
      }
    }
  }
  return(0);
}
/* is this element already in the list ? */
static int IsDupElt(elt *E1) {
  int i;
  elt *E2=SOUP;
  for (i=0;i<NELTS-1;i++) {
    if (E1 != E2) {
      if (SameElt(E1, E2)) {
	return(1);
      }
    }
    E2++;
  }
  return(0);
}
/*------------------------------------------------------------------------*/
/* compute the score of a given element - it's the number of non-zero bits */
/* in the result of the crypting function - how 'far' in number of bits,  */
/* esi and edi are from the desired values                                */
/*------------------------------------------------------------------------*/
static int GetScore(elt *E) {
  unsigned int esi, edi;
  unsigned int p1, p2, p3;
  int res=0;
  p1=*((int*)(E->v));
  p2=*((int*)(4+E->v));
  p3=*((int*)(8+E->v));
  GetCrypt(p1, p2, p3, &esi, &edi);
  esi=esi^0x5b6b72DD; edi=edi^0x10021c51;
  res+=CountBits(esi);
  res+=CountBits(edi);
  return(res);
}
/*----------------------*/
/* print out an element */
/*----------------------*/
static void print_elt(elt *E) {
  int i;
  for(i=0;i<12;i++) {
    printf("%c", E->v[i]);
  }
  printf("   score: %d", E->score);
}

/*---------------------------------------------------------------*/
/* init an element, with a random 12 bytes value                 */
/* allowed bytes start at BYTES_START, within BYTES_RANGE range. */
/*---------------------------------------------------------------*/
static void init_elt(elt *E) {
  unsigned char i;
  do {
    for(i=0;i<12;i++) {
      E->v[i]=BYTES_START+(rand()%(BYTES_RANGE));
    }
  } while (IsDupElt(E)==1);
  E->score=GetScore(E);
}
static void init_elts() {
  int i;
  SOUP=(elt*)malloc(NELTS*sizeof(elt)); 
  for(i=0;i<NELTS;i++) {
    init_elt(&(SOUP[i]));
  }
}
/*--------------------------------------------------------------*/
/* sort elements according to survival criterium (their 'score') */
/*--------------------------------------------------------------*/
static int CmpFunc(const void  *_e1, const void  *_e2) {
  elt* e1=(elt*)_e1;
  elt* e2=(elt*)_e2;
  return(e1->score-e2->score);
}
static void SortSoup() {
  int i;
  qsort(SOUP, NELTS, sizeof(elt), CmpFunc); 
}
/*----------------------------------------------------------------------------------------------*/
/* the actual reproduction process. Keep the best ones, reproduce them, and mutate some of them */
/*----------------------------------------------------------------------------------------------*/
static void Mutate() {
  int i, j, idx1, idx2, bit, mask;
  int count;
  /* we keep only the SURVIVORS first ones for reproduction */
  /*printf("reproducing\n");*/
  for(i=SURVIVORS;i<NELTS-MUTATORS;i++) {
    count=0;
    do {
      count++;
      for(j=0;j<12;j++) {
	/* pick a random byte in a random survivor item */
	idx1=rand()%SURVIVORS;
	SOUP[i].v[j]=SOUP[idx1].v[j];
      }
   } while (IsDupElt(&(SOUP[i]))==1 && count!=SURVIVORS);
   if (count==SURVIVORS) {
     init_elt(&(SOUP[i]));
   } else {
     SOUP[i].score=GetScore(&(SOUP[i]));
   }
  }
  /*printf("mutating\n");*/
  /* last MUTATORS ones are mutations of the best ones - a single byte is randomly changed */
  for(i=NELTS-MUTATORS;i<NELTS; i++) {
    count=0;
    SOUP[i]=SOUP[NELTS-i-1];
    do {
      count++;
      idx2=rand()%12;
      SOUP[i].v[idx2]=BYTES_START +(rand()%(BYTES_RANGE));
    } while (IsDupElt(&(SOUP[i]))==1 && count !=MUTATORS);
    if (count==MUTATORS) {
      init_elt(&(SOUP[i]));
    } else {
      SOUP[i].score=GetScore(&(SOUP[i]));
    }
  }
}
/* show we're still alive and computing :) */
static void PrintProgress() {
  static int prev_score=-1;
  if (prev_score!=SOUP[0].score) {
    prev_score=SOUP[0].score;
    print_elt(&(SOUP[0]));
    printf(", %d attempts\n", attempts);  
  }
}


static void check(unsigned int p1, unsigned int p2, unsigned int p3) {
  unsigned int esi, edi;
  GetCrypt(p1, p2, p3, &esi, &edi);
  printf("%08X %08X %08X -> %08X | %08X\n", p1, p2, p3, edi, esi);
}

int main(int argc, char **argv) {
  int CHILDS;
  /* parse cmd line */	
  if (argc!=5) {
     printf("crue.exe <survivors> <childs> <mutations> <c1cn>\n"); 
     printf("example: crue 10 5 5 09\n");
     exit();
  }
  SURVIVORS=atoi(argv[1]);
  CHILDS=atoi(argv[2]);
  MUTATORS=atoi(argv[3]);
  BYTES_START=argv[4][0];
  BYTES_RANGE=argv[4][1];
  if (BYTES_RANGE<BYTES_START) {
	BYTES_RANGE=BYTES_START;
	BYTES_START=argv[4][1];
  } 
  BYTES_RANGE-=BYTES_START; BYTES_RANGE++;
  NELTS=SURVIVORS+CHILDS+MUTATORS;
  init_elts();
  do {
    SortSoup();
    PrintProgress();
    Mutate();
  } while (SOUP[0].score!=0);
  printf("\n");
}

