typedef struct {
  unsigned char vh;
  unsigned char stype;
  unsigned short length;
  unsigned short ident;
  unsigned short frag;
  unsigned char ttl;
  unsigned char protocol;
  unsigned short cksum;
  struct in_addr sip;
  struct in_addr dip;
} iprec;

typedef struct {
  unsigned short sport;
  unsigned short dport;
  unsigned long seqnum;
  unsigned long acknum;
  unsigned short hrc;
  unsigned short window;
  unsigned short cksum;
  unsigned short urgentptr;
} tcprec;

typedef struct {
  struct in_addr sip;
  struct in_addr dip;
  unsigned char zero;
  unsigned char proto;
  unsigned short tcplen;
} tcpsrec;

typedef struct {
  unsigned char type;
  unsigned char code;
  unsigned short cksum;
  unsigned long zero;
  iprec ip;
  unsigned short sport;
  unsigned short dport;
  unsigned long seq;
} icmprec;

/* #define's for the TCP flags */
#define CF_URG 0x2000
#define CF_ACK 0x1000
#define CF_PSH 0x0800
#define CF_RST 0x0400
#define CF_SYN 0x0200
#define CF_FIN 0x0100

/* Structure for a spoofed connection */
typedef struct {
  struct sockaddr_in from;
  struct sockaddr_in dest;
  unsigned short sport;
  unsigned short dport;
  unsigned long seq;
  unsigned long ack;
} spoofrec;

unsigned short ipident; /* The IP identification, this is random */

struct in_addr getlocalip(unsigned long dest);

