/*************************************************************************/
/*    File:      spipll.h                                                
*/
/*    Purpose:   SPI PLL RAMSEY-FM25 specific defines header file        
*/
/*    Author:    Nox                                                     
*/
/*    Date:      Don Dec 23 02:05:15 EST 2001                            
*/
/*                                                                       
*/
/*-----------------------------------------------------------------------*/
/*                                                                       
*/
/*************************************************************************/

#define RAMSEY_C_REG	(0x68)
#define RAMSEY_R_REG_B1	(0x00)
#define RAMSEY_R_REG_B2	(0x00)
#define RAMSEY_R_REG_B3	(0x3c)
#define RAMSEY_NULL	(0x00)

#define SPI_SI          (1<<0)
#define SPI_SCK         (1<<1)
#define SPI_CS          (1<<2)
#define SPI_WP          (1<<3)
#define SPI_SO          (0x10)

#define CMD_WREN        (0x06)
#define CMD_WRDI        (0x04)
#define CMD_RDSR        (0x05)
#define CMD_WRSR        (0x01)
#define CMD_READ        (0x03)
#define CMD_WRITE       (0x02)

#define SR_WPEN         (1<<7)
#define SR_BL1          (1<<3)
#define SR_BL0          (1<<2)
#define SR_WEL          (1<<1)
#define SR_WIP          (1<<0)

#define min(a, b) (((a) < (b)) ? (a) : (b))
#define max(a, b) (((a) > (b)) ? (a) : (b))

extern int iobase;

void spi_cs(int cs);
void spi_wp(int wp);
void spi_si(int mydata);
int spi_so(void);
void spi_sck(int sck);
void spi_bitdelay(void);
void spi_outb(char mydata);
int spi_inb(void);

void do_iobase(void *arg);
void do_exit(void *arg);
void do_cs(void *arg);
void terminate(void);
void usage(void);
void myusleep(long us);
void probe_loopus(void);

int main(int argc, char **argv);

/* -------------------- end of spi.h -------------------*/
