/******************************************************************************
fgdump - by fizzgig and the foofus.net group
Copyright (C) 2005 by fizzgig
http://www.foofus.net

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
******************************************************************************/
#include "StdAfx.h"
#include "netuse.h"
#include "Process.h"

NetUse::NetUse(void)
{
}

NetUse::~NetUse(void)
{
}

bool NetUse::Connect(const char* lpszMachine, const char* lpszUserName, const char* lpszPassword)
{
	const char* lpszCmdLineFormat = " use \\\\%s\\ipc$ /u:%s \"%s\"";
	const char* lpszStopCmdLine = "c:\\windows\\system32\\net.exe";
	int nArgSize = _scprintf(lpszCmdLineFormat, lpszMachine, lpszUserName, lpszPassword);
	char* lpszParams;
	bool bResult = false;

	lpszParams = new char[nArgSize + 1];
	memset(lpszParams, 0, nArgSize + 1);

	try
	{
		Process p;
		_snprintf(lpszParams, nArgSize, lpszCmdLineFormat, lpszMachine, lpszUserName, lpszPassword);

		HANDLE hProcess = p.CreateProcess(lpszStopCmdLine, lpszParams);
		if (hProcess != 0)
		{
			DWORD dwResult = WaitForSingleObject(hProcess, 10000);	// Wait 10 seconds for process to complete
			if (dwResult != WAIT_OBJECT_0)
			{
				Log.ReportError(CRITICAL, "Warning: net use to server did not complete in a timely manner - exiting");
				bResult = false;
			}
			else
			{
				// Read from process's output
				char* szResult;
				int nSize = 4096;

				szResult = new char[nSize];
				memset(szResult, 0, nSize);
				p.ReadFromPipe(&szResult, nSize);

				// Was it successful?
				if (strstr(szResult, "successfully") != NULL)
				{
					// Success
					Log.ReportError(DEBUG, "Opened IPC$ share on %s successfully\n", lpszMachine);
					bResult = true;
				}
				else
				{
					// Failed
					Log.ReportError(CRITICAL, "Failed to open IPC$: %s\n", szResult);
					//delete [] szResult;
					bResult = false;
				}

				delete [] szResult;
			}
		}
		else
			bResult = false;
	}
	catch(...)
	{
		bResult = false;
	}

	delete [] lpszParams;

	return bResult;
}

bool NetUse::Disconnect(const char* lpszMachine)
{
	const char* lpszCmdLineFormat = " use \\\\%s\\ipc$ /del";
	const char* lpszStopCmdLine = "c:\\windows\\system32\\net.exe";
	int nArgSize = _scprintf(lpszCmdLineFormat, lpszMachine);
	char* lpszParams;
	bool bResult = false;

	lpszParams = new char[nArgSize + 1];
	memset(lpszParams, 0, nArgSize + 1);

	try
	{
		Process p;
		_snprintf(lpszParams, nArgSize, lpszCmdLineFormat, lpszMachine);

		HANDLE hProcess = p.CreateProcess(lpszStopCmdLine, lpszParams);
		if (hProcess != 0)
		{
			DWORD dwResult = WaitForSingleObject(hProcess, 10000);	// Wait 10 seconds for process to complete
			if (dwResult != WAIT_OBJECT_0)
			{
				Log.ReportError(CRITICAL, "Warning: net use to server did not complete in a timely manner - exiting");
				bResult = false;
			}
			else
			{
				// Read from process's output
				char* szResult;
				int nSize = 4096;

				szResult = new char[nSize];
				memset(szResult, 0, nSize);
				p.ReadFromPipe(&szResult, nSize);

				// Was it successful?
				if (strstr(szResult, "successfully") != NULL)
				{
					// Success
					Log.ReportError(INFO, "Closed IPC$ share on %s successfully\n", lpszMachine);
					bResult = true;
				}
				else
				{
					// Failed
					Log.ReportError(CRITICAL, "Failed to close IPC$: %s\n", szResult);
					//delete [] szResult;
					bResult = false;
				}

				delete [] szResult;
			}
		}
		else
			bResult = false;
	}
	catch(...)
	{
		bResult = false;
	}

	delete [] lpszParams;

	return bResult;
}
