/******************************************************************************
fgdump - by fizzgig and the foofus.net group
Copyright (C) 2005 by fizzgig
http://www.foofus.net

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
******************************************************************************/
#include "stdafx.h"
#include "LogWriter.h"

LogWriter::LogWriter()
{
	bEnableFileWrite = false;
	memset(lpszFile, 0, MAX_PATH + 1);
	nVerbosity = 0;
}

LogWriter::~LogWriter()
{

}

void LogWriter::SetLogFile(char* szLogFile)
{
	strncpy(lpszFile, (const char*)szLogFile, MAX_PATH);
	
	// Write the start time to the log
	FILE* hFile = fopen(lpszFile, "a");
	SYSTEMTIME st;

	if (hFile == NULL)
	{
		fprintf(stdout, "Error opening output log file %s, disabling further log writing. Error code returned was %d\n", lpszFile, GetLastError());
		bEnableFileWrite = false;
		return;
	}
	GetLocalTime(&st);
	fprintf(hFile, "\n---fgdump session started on %d/%d/%d at %0.2d:%0.2d:%0.2d  ---\n\n", st.wMonth, st.wDay, st.wYear, st.wHour, st.wMinute, st.wSecond);
	fclose(hFile);

}

void LogWriter::SetWriteToFile(bool bWriteToFile)
{
	bEnableFileWrite = bWriteToFile;
}

void LogWriter::IncreaseVerbosity()
{
	nVerbosity++;
}

void LogWriter::ReportError(ERROR_LEVEL eLevel, char *pMsg, ...) 
{
	va_list ap;
	char* buf;
  
	if (pMsg == NULL) 
	{
		return;
	}
	
	if (eLevel <= nVerbosity)
	{
		va_start(ap, pMsg);
		size_t nLen = _vscprintf(pMsg, ap);
		buf = (char*)malloc(nLen + 1);
		memset(buf, 0, nLen + 1);
		_vsnprintf(buf, nLen, pMsg, ap);

		fprintf(stdout, "%s", buf);
		if (bEnableFileWrite)
		{
			// Also print to file
			FILE* hFile = fopen(lpszFile, "a");
			if (hFile == NULL)
			{
				fprintf(stdout, "Error opening output log file %s, disabling further log writing. Error code returned was %d\n", lpszFile, GetLastError());
				bEnableFileWrite = false;
				return;
			}
			fprintf(hFile, "%s", buf);
			fclose(hFile);
		}
		va_end(ap);
		free(buf);
	}
  
  return;
}

