#include "StdAfx.h"
#include "netuse.h"
#include "Process.h"

NetUse::NetUse(void)
{
}

NetUse::~NetUse(void)
{
}

bool NetUse::Connect(const char* lpszMachine, const char* lpszUserName, const char* lpszPassword)
{
	const char* lpszCmdLineFormat = " use \\\\%s\\ipc$ /u:%s \"%s\"";
	const char* lpszStopCmdLineFormat = "%s\\system32\\net.exe";
	char* lpszParams, *lpszCmdLine;
	bool bResult = false;
	char* szWinDir = getenv("WINDIR");
	if (szWinDir == NULL)
	{
		printf("Error: unable to determine Windows install path - make sure the WINDIR environment variable is set!\n");
		return false;
	}
	int nArgSize = _scprintf(lpszCmdLineFormat, lpszMachine, lpszUserName, lpszPassword);
	int nArgSize2 = _scprintf(lpszStopCmdLineFormat, szWinDir);

	lpszParams = new char[nArgSize + 1];
	memset(lpszParams, 0, nArgSize + 1);
	lpszCmdLine = new char[nArgSize2 + 1];
	memset(lpszCmdLine, 0, nArgSize2 + 1);

	try
	{
		Process p;
		_snprintf(lpszParams, nArgSize, lpszCmdLineFormat, lpszMachine, lpszUserName, lpszPassword);
		_snprintf(lpszCmdLine, nArgSize2, lpszStopCmdLineFormat, szWinDir);

		HANDLE hProcess = p.CreateProcess(lpszCmdLine, lpszParams);
		if (hProcess != 0)
		{
			DWORD dwResult = WaitForSingleObject(hProcess, 10000);	// Wait 10 seconds for process to complete
			if (dwResult != WAIT_OBJECT_0)
			{
				printf("Warning: net use to server did not complete in a timely manner - exiting\n");
				bResult = false;
			}
			else
			{
				// Read from process's output
				char* szResult;
				int nSize = 4096;

				szResult = new char[nSize];
				memset(szResult, 0, nSize);
				p.ReadFromPipe(&szResult, nSize);

				// Was it successful?
				if (strstr(szResult, "successfully") != NULL)
				{
					// Success
					printf("Opened IPC$ share on %s successfully\n", lpszMachine);
					bResult = true;
				}
				else
				{
					// Failed
					printf("Failed to open IPC$: %s\n", szResult);
					//delete [] szResult;
					bResult = false;
				}

				delete [] szResult;
			}
		}
		else
			bResult = false;
	}
	catch(...)
	{
		bResult = false;
	}

	delete [] lpszParams;

	return bResult;
}

bool NetUse::Disconnect(const char* lpszMachine)
{
	const char* lpszCmdLineFormat = " use \\\\%s\\ipc$ /del";
	const char* lpszStopCmdLineFormat = "%s\\system32\\net.exe";
	char* lpszParams, *lpszCmdLine;
	bool bResult = false;
	char* szWinDir = getenv("WINDIR");
	if (szWinDir == NULL)
	{
		printf("Error: unable to determine Windows install path - make sure the WINDIR environment variable is set!\n");
		return false;
	}
	int nArgSize = _scprintf(lpszCmdLineFormat, lpszMachine);
	int nArgSize2 = _scprintf(lpszStopCmdLineFormat, szWinDir);

	lpszParams = new char[nArgSize + 1];
	memset(lpszParams, 0, nArgSize + 1);
	lpszCmdLine = new char[nArgSize2 + 1];
	memset(lpszCmdLine, 0, nArgSize2 + 1);
	try
	{
		Process p;
		_snprintf(lpszParams, nArgSize, lpszCmdLineFormat, lpszMachine);
		_snprintf(lpszCmdLine, nArgSize2, lpszStopCmdLineFormat, szWinDir);

		HANDLE hProcess = p.CreateProcess(lpszCmdLine, lpszParams);
		if (hProcess != 0)
		{
			DWORD dwResult = WaitForSingleObject(hProcess, 10000);	// Wait 10 seconds for process to complete
			if (dwResult != WAIT_OBJECT_0)
			{
				printf("Warning: net use to server did not complete in a timely manner - exiting\n");
				bResult = false;
			}
			else
			{
				// Read from process's output
				char* szResult;
				int nSize = 4096;

				szResult = new char[nSize];
				memset(szResult, 0, nSize);
				p.ReadFromPipe(&szResult, nSize);

				// Was it successful?
				if (strstr(szResult, "successfully") != NULL)
				{
					// Success
					printf("Closed IPC$ share on %s successfully\n", lpszMachine);
					bResult = true;
				}
				else
				{
					// Failed
					printf("Failed to close IPC$: %s\n", szResult);
					//delete [] szResult;
					bResult = false;
				}

				delete [] szResult;
			}
		}
		else
			bResult = false;
	}
	catch(...)
	{
		bResult = false;
	}

	delete [] lpszParams;

	return bResult;
}
