#include "StdAfx.h"
#include ".\stringarray.h"

StringArray::StringArray(void)
{
	pFirstString = NULL;
	pCurrentString = NULL;
	pCurrentIterString = NULL;
}

StringArray::~StringArray(void)
{
	STRINGENTRY* pTemp, *pTemp2;
	pTemp = pFirstString;
	while (pTemp != NULL)
	{
		delete [] pTemp->lpszString;
		pTemp2 = pTemp;
		pTemp = pTemp->pNext;
		delete pTemp2;
	}
}

int StringArray::Add(char* lpszString)
{
	size_t nLen = strlen(lpszString);
	
	if (pFirstString == NULL)
	{
		pFirstString = new STRINGENTRY;
		pFirstString->lpszString = new char[nLen + 1];
		memset(pFirstString->lpszString, 0, nLen + 1);
		strncpy(pFirstString->lpszString, lpszString, nLen);
		pFirstString->pNext = NULL;
		pCurrentString = pFirstString;
	}
	else
	{
		STRINGENTRY* pTemp = new STRINGENTRY;
		pTemp->lpszString = new char[nLen + 1];
		memset(pTemp->lpszString, 0, nLen + 1);
		strncpy(pTemp->lpszString, lpszString, nLen);
		pTemp->pNext = NULL;
		pCurrentString->pNext = pTemp;
		pCurrentString = pTemp;
	}

	return 0;
}


char* StringArray::GetFirstString(void)
{
	if (pFirstString != NULL)
	{
		pCurrentIterString = pFirstString;
		return pFirstString->lpszString;
	}
	else
		return NULL;
}

char* StringArray::GetNextString(void)
{
	if (pCurrentIterString != NULL)
	{
		if (pCurrentIterString->pNext != NULL)
		{
			pCurrentIterString = pCurrentIterString->pNext;
			return pCurrentIterString->lpszString;
		}
		else
			return NULL;
	}
	else
		return NULL;
}
