/******************************************************************************
fgdump - by fizzgig and the foofus.net group
Copyright (C) 2005 by fizzgig
http://www.foofus.net

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
******************************************************************************/
#include "stdafx.h"
#include "McAfeeControl.h"
#include "SymantecAVControl.h"
#include "NetUse.h"
#include "PWDumpControl.h"

typedef struct _tControlObjects
{
	McAfeeControl objMcAfeeService;
	SymantecAVControl objSAVService;
	NetUse objNetUse;
	PWDumpControl objPWDump;
} CONTROL_OBJECTS, *LPCONTROL_OBJECTS;

class FGDump
{
public:
	FGDump();
	~FGDump();

	void SetTestOnlyAV(bool bTestOnly);
	void SetSkipCacheDump(bool bSkip);
	void SetSkipPWDump(bool bSkip);
	void SetSkipProtectedStorageDump(bool bSkip);
	void SetIgnoreExistingFiles(bool bIgnoreExisting);
	void SetHostfileName(char* szFile);
	void SetPerHostFileName(char* szFile);
	void SetServer(char* szServer);
	void SetUser(char* szUsername);
	void SetPassword(char* szPassword);
	void ContinueOnUnknownAV(bool bContinue);
	int Run();

private:
	char* lpszServer;
	char* lpszUser;
	char* lpszPassword;
	char* lpszSuccessfulServers;
	char* lpszFailedServers;
	char lpszTempPath[MAX_PATH];
	char lpszPWServicePath[MAX_PATH + 15];
	char lpszPWDumpPath[MAX_PATH + 15];
	char lpszPSServicePath[MAX_PATH + 15];
	char lpszLSAExtPath[MAX_PATH + 15];
	char lpszCacheDumpPath[MAX_PATH + 15];
	char lpszPStoragePath[MAX_PATH + 15];
	char lpszSourceFile[MAX_PATH + 1];
	char lpszRemotePath[MAX_PATH];
	char* lpszCacheDumpRemotePath;
	char lpszFGExecPath[MAX_PATH + 15];
	char szDriveTemp[3];
	bool bFullRun, bRunPwdump, bRunCachedump, bRunPStgDump, bSkipExisting, bContinueOnUnknownAV;
	bool bUsePerHostCreds;

	int DumpServer(CONTROL_OBJECTS);
	void RunCacheDump(char* lpszTempPath);
	void RunProtectedStorageDump(char* lpszTempPath);
	bool StopAndRemoveFGExec();
	bool InstallAndStartFGExec();
	bool FileExists(char* szFile);
	void ExitApp(int nReturnCode);
};