/******************************************************************************
fgdump - by fizzgig and the foofus.net group
Copyright (C) 2006 by fizzgig
http://www.foofus.net

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
******************************************************************************/
#include "stdafx.h"
#include "McAfeeControl.h"
#include "AVStatus.h"
#include "ServiceControl.h"

McAfeeControl::McAfeeControl(LONG nCacheID)
{
	m_nCacheID = nCacheID;
	m_szServiceName = NULL;
}

McAfeeControl::~McAfeeControl()
{

}

int McAfeeControl::GetServiceState(const char* lpszMachine)
{
	SERVICE_STATUS sStatus;
	ServiceControl sc(m_nCacheID);
	int nResult = AV_UNKNOWN;

	if (sc.QueryServiceStatus(lpszMachine, m_szServiceName, &sStatus) == INSTALLED)
	{
		if (sStatus.dwCurrentState == SERVICE_RUNNING)
			nResult = AV_STARTED;
		else if (sStatus.dwCurrentState == SERVICE_STOPPED)
			nResult = AV_STOPPED;
	}
	else
	{
		nResult = AV_UNKNOWN;
	}

	return nResult;
}

bool McAfeeControl::IsServiceInstalled(const char* lpszMachine)
{
	SERVICE_STATUS sStatus;
	ServiceControl sc(m_nCacheID);

	m_szServiceName = "mcshield";
	if (sc.QueryServiceStatus(lpszMachine, m_szServiceName, &sStatus) == INSTALLED)
	{
		return true;
	}
	else
	{
		m_szServiceName = "Network Associates McShield";
		if (sc.QueryServiceStatus(lpszMachine, m_szServiceName, &sStatus) == INSTALLED)
		{
			return true;
		}
		else
		{
			return false;
		}
	}
}

bool McAfeeControl::StopService(const char* lpszMachine)
{
	ServiceControl sc(m_nCacheID);

	if (sc.StopService(lpszMachine, m_szServiceName, 30))
	{
		Log.CachedReportError(m_nCacheID, INFO, "Stopped McAfee successfully\n");
		return true;
	}
	else
	{
		Log.CachedReportError(m_nCacheID, CRITICAL, "Unable to stop McAfee, see previous errors for details. Stopping pwdump.\n");
		return false;
	}
}

bool McAfeeControl::StartService(const char* lpszMachine)
{
	ServiceControl sc(m_nCacheID);

	if (sc.StartService(lpszMachine, m_szServiceName, 30))
	{
		Log.CachedReportError(m_nCacheID, INFO, "Started McAfee successfully\n");
		return true;
	}
	else
	{
		Log.CachedReportError(m_nCacheID, CRITICAL, "Unable to start McAfee, see previous errors for details.\n");
		return false;
	}
}
