//-------------------------------------------------------------------------------
//
// redirectpoison.h - Command line tool to poison a 
//               a SIP requestor (i.e. UAC) with
//               SIP Redirect response. A Redirect response
//               is a 3xx series response
//               (e.g. 301 moved permanently)
//
//               Please refer to redirectpoison.c for an
//               overview of the functionality of the tool.              
//
//    Copyright (C) 2006  Mark D. Collier/Mark O'Brien
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// Author: Mark D. Collier/Mark O'Brien   10/16/2006   v1.1
//	 Mark D. Collier/Mark O'Brien    09/14/2006  v1.0
//         www.securelogix.com - mark.collier@securelogix.com
//         www.hackingexposedvoip.com
//
//-------------------------------------------------------------------------------

#ifndef __REDIRECTPOISON_H
#define __REDIRECTPOISON_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <libnet.h>
#include <pcap.h>
#include <signal.h>
#include <stdbool.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sched.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <net/if.h> 
#include <unistd.h>

#define __REDIRECTPOISON_VERSION  "redirectpoison - Version 1.1"
#define __REDIRECTPOISON_DATE     "                 October 16, 2006"

#define __REDIRECTPOISON_PROMISCOUS_MODE 1

#define __REDIRECTPOISON_LIBNET_IP         3
#define __REDIRECTPOISON_LIBNET_ETHERNET   2

#define __REDIRECTPOISON_LIBNET_PROTOCOL_LAYER __REDIRECTPOISON_LIBNET_IP

int opt;
int optind;

int sockfd   = 0;
int rc       = 0;

unsigned int numPacketsRead           = 0;
unsigned int numInviteRequestsRead    = 0;
unsigned int numSIPRequestsPoisoned   = 0;

const char  EOL[]            = "\r\n";
const char  EOSIPHDRS[]      = "\r\n\r\n";

char *psContactUserPart      = NULL;

u_int8_t *pSrcMAC            = NULL;
u_int8_t *pDestMAC           = NULL;

bool bVerbose                = false;

//
//  This is the sample INVITE message from RFC 3261. The RFC states
//  these are the minimum headers for a SIP INVITE request. 
//
//  INVITE sip:bob@biloxi.com SIP/2.0
//  Via: SIP/2.0/UDP pc33.atlanta.com;branch=z9hG4bK776asdhds
//  Max-Forwards: 70
//  To: Bob <sip:bob@biloxi.com>
//  From: Alice <sip:alice@atlanta.com>;tag=1928301774
//  Call-ID: a84b4c76e66710@pc33.atlanta.com
//  CSeq: 314159 INVITE
//  Contact: <sip:alice@pc33.atlanta.com>
//  Content-Type: application/sdp
//  Content-Length: 142
//
//  While the absolute minimum length of the content of a SIP message
//  is debatable, we'll presume a size commensurate with non-abbreviated
//  header names, some content for the header values, and the \r\n
//  required at the end of each line.
//
//  INVITE sip:*@*.*** SIP/2.0rn
//  Via: SIP/2.0/UDP *@*.com;branch=*rn
//  Max-Forwards: *rn
//  To: <sip:*@*.***>rn
//  From: <sip:*@*.***>;tag=*rn
//  Call-ID: *@*.***rn
//  CSeq: * INVITErn
//  Contact: <sip:*@*.***>rn
//  Content-Type: application/sdprn
//  Content-Length: *rnrn
//

#define SIP_REQUEST_LEN_MIN             236
#define	SIP_PAYLOAD_LEN_MAX             1400

libnet_t *l              = NULL;
pcap_t *h_pcap_live_sip  = NULL;  //  libpcap "handle"

bool  synthesizeRedirectPoisonResponse ( char *psSniffedSIPMsg,
                                         char *psContactInfo,
                                         char *psRedirectpoisonSIPMsg );

bool  processRequestMethodLine ( char *psSniffedSIPMsg,
                                 char *psEndLine        );

bool  processToHeader ( char *psRedirectpoisonSIPMsg,
                        char *psStartLine,
                        char *psEndLine,
                        char *psHeaderNameEnd,
                        bool *pbCopyHeader           );
                        
char* duplicateUserPartOfUri ( char *psUri );

char* findTagParmName ( char *psScanStart );

void  catch_signals  ( int signo  );

void  CleanupAndExit ( int status );

void  usage          ( int status );

#endif  //  __REDIRECTPOISON_H
