//-----------------------------------------------------------------------------
//
// AttackAudio.h - An instance of this type holds the
//             the audio used to insert or mix into a 
//             conversation. 
//
//    Copyright (C) 2004  Mark D. Collier
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//   Author: Mark D. Collier   - 12/01/2006   v1.1
//                   Mark D. Collier   -  04/26/2004  v1.0
//         www.securelogix.com - mark.collier@securelogix.com
//         www.hackingexposedvoip.com
//
//-----------------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stddef.h>
#include <libnet.h>
#include <pcap.h>

//
//  Need to wrap the include since this is a C++ application
//  accessing a C library.
//

extern "C" {
#include "g711conversions.h"
};

#ifndef ATTACK_AUDIO_H
#define ATTACK_AUDIO_H

#define __ATTACKAUDIO_G711_PAYLOAD_TYPE         0

#define __ATTACKAUDIO_G711_PAYLOAD_LEN          160

#define __ATTACKAUDIO_G711_CODEC_RATE_HZ        50

#define __ATTACKAUDIO_G711_CODEC_INTERVAL_USEC  20000

#define __ATTACKAUDIO_G711_AUDIO_TO_MIX_SEC     30

#define __ATTACKAUDIO_G711_MAX_NUMBER_RTP_MSGS_IN_ATTACK __ATTACKAUDIO_G711_CODEC_RATE_HZ * __ATTACKAUDIO_G711_AUDIO_TO_MIX_SEC

#define __ATTACKAUDIO_PCM_UNCOMPRESSED_COMPRESSION_CODE  1

struct rfc1889_rtp_hdr {
    
    //  byte 0 - uppermost byte of header
    //  bit fields are defined starting from rightmost bits and
    //  encountering higher order bits as you proceed down the page.
    //  for example: cc occupies the low-order 4 bits of the byte.

    unsigned int cc : 4;                    // CSRC Count (i.e. # of CSRC hdrs following fixed hdr)
    unsigned int bExtensionIncluded : 1;    // if RTP hdr includes 1 extension hdr 
    unsigned int bPaddingIncluded : 1;      // if the RTP payload is padded
    unsigned int version : 2;               // should always equal version 2
    
    //  byte 1
    //  bits are defined from rightmost bits first and leftmost bits as you proceed down the page
    
    unsigned int payloadType : 7;
    unsigned int bMarker : 1;               // Mark

    //  bytes 3 & 2 (i.e. network order)
    
    unsigned short sequenceNumber;          // Should inc by 1.
    
    //  bytes 7, 6, 5, 4 (i.e. network order)
    
    unsigned int timestamp;                 // For G.711 should inc by 160.
    
    //  bytes 11, 10, 9, 8 (i.e. network order)
        
    unsigned int ssrc;                      // Synchronization Source - fixed for a stream
};

typedef short pcm_value[ __ATTACKAUDIO_G711_PAYLOAD_LEN ]; 
    
typedef pcm_value pcmSamplesToMix[ __ATTACKAUDIO_G711_MAX_NUMBER_RTP_MSGS_IN_ATTACK ];

typedef unsigned char pcmu_value[ __ATTACKAUDIO_G711_PAYLOAD_LEN ]; 

typedef pcmu_value pcmuSamplesToInsert[ __ATTACKAUDIO_G711_MAX_NUMBER_RTP_MSGS_IN_ATTACK ];

typedef enum
{
    ATTACK_AUDIO_NONE = 0,
    ATTACK_AUDIO_INSERT,
    ATTACK_AUDIO_MIX
}  AttackAudioMethod;                                    

class  AttackAudio
{
    public:
        AttackAudio( AttackAudioMethod attackAudioMethod );
        ~AttackAudio( void );
        
        bool                    PrepAttackAudio( char *  psInputAudioFile );
                                             
        AttackAudioMethod       GetAttackAudioMethod( void );
    
//        const char *            GetNextAttackAudioPacket( void );
    
        unsigned int            GetNumberOfAttackAudioPackets( void );
    
        const char *            GetAttackAudioPacket( unsigned int packetNum );

    private:
        
        //    
        //  16-bit linear PCM is one signed 16-bit word for every G.711 ulaw byte
        //
        
        typedef struct rtp_msg {
            struct rfc1889_rtp_hdr rtp_hdr;
            unsigned char          rtp_payload[ __ATTACKAUDIO_G711_PAYLOAD_LEN ];
        } rtpG711Msg;
        
        struct rfc1889_rtp_hdr *rtp_hdr;
          
        bool  preloadWavAudio ( char *psInputAudioFile );
        
        bool  preloadTCPdumpAudio ( char *psInputAudioFile );
                                    
        void  decodeAndPrintRTPMsg( const u_char *packet );
        
        AttackAudioMethod        mAttackAudioMethod;
        unsigned char *          mAttackAudioBuf;
        unsigned int             mNumG711PacketEquivalents;
//        unsigned int             mNumPacketsRetrieved;
};

#endif  // ATTACK_AUDIO_H

