//-----------------------------------------------------------------------------
//
// ControlMessage.h - Used by ControlPort to store
//                      incoming and outgoing messages.
//
//    Copyright (C) 2004  Mark D. Collier
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//   Author: Mark D. Collier  - 12/01/2006  v1.1
//                   Mark D. Collier  -  04/26/2004  v1.0
//         www.securelogix.com - mark.collier@securelogix.com
//         www.hackingexposedvoip.com
//
//-----------------------------------------------------------------------------

#ifndef CONTROL_MESSAGE_H
#define CONTROL_MESSAGE_H

class ControlPort;

class  ControlMessage
{
    public:
        
        ControlMessage( ControlPort *  aPort,
                        int            aConnectionId,
                        int            aSocketIndex,
                        const char *   aText );
        ~ControlMessage( void );
    
        ControlMessage::ControlMessage( const ControlMessage& controlMessage );
        ControlMessage& ControlMessage::operator=( const ControlMessage& rhs );

        // Caller must free return value.
        char *  GetText( void );
        int     GetTextLength( void );
        void    SetText( char *  aText );
        void    SetText( char *  aText, char *  aAppendedText );

        int     GetConnectionId( void );
        void    SetConnectionId( int  aConnectionId );

        int     GetSocketIndex( void );
        void    SetSocketIndex( int  aSocketIndex );

    private:

        char *         mText;
        ControlPort *  mPort;
        int            mConnectionId;
        int            mSocketIndex;
};

#endif

