//-----------------------------------------------------------------------------
//
// SipUri.h - Functions for working with SIP URIs.
//
//    Copyright (C) 2004  Mark D. Collier
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//   Author: Mark D. Collier   - 12/01/2006   v1.1
//                   Mark D. Collier   -  04/26/2004  v1.0
//         www.securelogix.com - mark.collier@securelogix.com
//         www.hackingexposedvoip.com
//
//-----------------------------------------------------------------------------

#ifndef SIP_URI_H
#define SIP_URI_H

class  SipUri
{
    public:
        SipUri( SipUri *  aCopyFrom );
        // Ensure aFullText is malloced, as it will be freed.
        SipUri( char *  aFullText );
        ~SipUri( void );

        char *  GetFullText( void );
        char *  GetScheme( void );
        char *  GetSchemeValue( void );
        char *  GetAuthority( void );
        char *  GetUser( void );
        char *  GetPassword( void );
        char *  GetHost( void );
        // Returns -1 if not set.
        int     GetPort ( void );
        char *  GetPath( void );
        char *  GetQuery( void );

        int     GetParameterCount( void );
        char *  GetParameterName( int  aIndex );
        char *  GetParameterValue( int  aIndex );
        char *  GetParameterValue( const char *  aName );

        int     GetHeaderCount( void );
        char *  GetHeaderName( int  aIndex );
        char *  GetHeaderValue( int  aIndex );
        char *  GetHeaderValue( const char *  aName );

    private:
        class  nameValueNode
        {
            public:
                char *           Name;
                char *           Value;
                nameValueNode *  Next;
        };

        char *           mFullText;
        char *           mScheme;
        char *           mSchemeValue;
        char *           mAuthority;
        char *           mUser;
        char *           mPassword;
        char *           mHost;
        int              mPort;
        char *           mPath;
        char *           mQuery;
        char *           mStartOfParameters;
        int              mParameterCount;
        nameValueNode *  mParameters;
        char *           mStartOfHeaders;
        int              mHeaderCount;
        nameValueNode *  mHeaders;
};

#endif

