// Derived from http://burtleburtle.net/bob/hash/evahash.html
// Originally by Bob Jenkins, December 1996, Public Domain.
// You can use this free for any purpose.  It has no warranty.

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>

#define mix( a, b, c ) \
{ \
    a -= b;  a -= c;  a ^= ( c >> 13 ); \
    b -= c;  b -= a;  b ^= ( a << 8  ); \
    c -= a;  c -= b;  c ^= ( b >> 13 ); \
    a -= b;  a -= c;  a ^= ( c >> 12 ); \
    b -= c;  b -= a;  b ^= ( a << 16 ); \
    c -= a;  c -= b;  c ^= ( b >> 5  ); \
    a -= b;  a -= c;  a ^= ( c >> 3  ); \
    b -= c;  b -= a;  b ^= ( a << 10 ); \
    c -= a;  c -= b;  c ^= ( b >> 15 ); \
}

unsigned long int  hash( register unsigned char *    aKey,
                         register unsigned long int  aKeyLength,
                         register unsigned long int  aSeed )
{
    register unsigned long int  a;
    register unsigned long int  b;
    register unsigned long int  c;
    register unsigned long int  len;

    len = aKeyLength;
    a   = 0x9e3779b9;
    b   = 0x9e3779b9;
    c   = aSeed;

    while ( len >= 12 )
    {
       a += (  aKey[0]
             + ( ( unsigned long int )aKey[1] << 8 )
             + ( ( unsigned long int )aKey[2] << 16 )
             + ( ( unsigned long int )aKey[3] << 24 ) );
       b += (  aKey[4]
             + ( ( unsigned long int )aKey[5] << 8 )
             + ( ( unsigned long int )aKey[6] << 16 )
             + ( ( unsigned long int )aKey[7] << 24 ) );
       c += (  aKey[8]
             + ( ( unsigned long int )aKey[9] << 8 )
             + ( ( unsigned long int )aKey[10] << 16 )
             + ( ( unsigned long int )aKey[11] << 24 ) );
       mix( a, b, c );
       aKey += 12;
       len  -= 12;
    }

    c += aKeyLength;
    switch ( len )
    {
        case 11: c += ( ( unsigned long int )aKey[10] << 24 );
        case 10: c += ( ( unsigned long int )aKey[9] << 16 );
        case 9 : c += ( ( unsigned long int )aKey[8] << 8 );
        case 8 : b += ( ( unsigned long int )aKey[7] << 24 );
        case 7 : b += ( ( unsigned long int )aKey[6] << 16 );
        case 6 : b += ( ( unsigned long int )aKey[5] << 8 );
        case 5 : b += aKey[4];
        case 4 : a += ( ( unsigned long int )aKey[3] << 24 );
        case 3 : a += ( ( unsigned long int )aKey[2] << 16 );
        case 2 : a += ( ( unsigned long int )aKey[1] << 8 );
        case 1 : a += aKey[0];
    }

    mix( a, b, c );

    return c;
}

