//-----------------------------------------------------------------------------
//
// util.h - Extra functions that are non-VoIP specific.
//
//    Copyright (C) 2004  Mark D. Collier
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//   Author: Mark D. Collier   - 12/01/2006   v1.1
//                   Mark D. Collier   -  04/26/2004  v1.0
//         www.securelogix.com - mark.collier@securelogix.com
//         www.hackingexposedvoip.com
//
//-----------------------------------------------------------------------------

#ifndef UTIL_H
#define UTIL_H

#include <netinet/in.h>

void  ReportError( char *  aMessage, char *  aFile,  int  aLine );

in_addr_t  DetermineLocalAddressFor( in_addr_t  aRemoteAddress );

bool  DetermineLocalAddressAndHardwareAddressFor(
                                             in_addr_t *    aLocalAddress,
                                             unsigned char  aHardwareAddress[6],
                                             in_addr_t      aRemoteAddress );

// Caller must free return value.
char *  GetNextGuid( void );

// Returns a pointer to the next word, which will be null terminated.
// Updates the aCommandLine pointer to point just past this word.
// Modifies data by inserting nulls at the end of words.
// Example to print all words:
// while ( *commandLine )
// {
//     cp = GetNextWord( &commandLine );
//     printf( "%s\n", cp );
// }
char *  GetNextWord( char **  aCommandLine );

void *  mymalloc( size_t  aSize );

void  myfree( void *  aPtr );

char *  mystrdup( const char *  aValue );

char *  mystrndup( const char *  aValue, size_t  aCount );

#endif

