#ifndef __QCDR_PERF_H
#define __QCDR_PERF_H
#include "trailman.h"

class cQCD_PERF_VAL {
    private:
	enum ST_STATE {ST_NEW, ST_OPEN, ST_IDLE, ST_CLOSED };
	
	cSTR		m_objname;
	ST_STATE	m_state;
	struct timeval	m_start_time;
	struct timeval	m_st_time;
	long		m_idle_milsec;
	cQCD_MUTEX	m_mutex;
    public:
	cQCD_PERF_VAL(const cSTR& name);
	
	cSTR GetName() const			{ return m_objname; }
	void Start();
	void Stop();
	void StartIdleTime();
	void StopIdleTime();
	long GetIdleTime();
};

class cQCD_STAT_MON
{
    private:
	cSTR	m_objname;
    public:
	cQCD_STAT_MON(const cSTR& name): m_objname(name) {}
	virtual ~cQCD_STAT_MON() {};
	virtual cSTR StatMon(const char *label) = 0;
	virtual cSTR GetName() { return m_objname; }
};

template <class T>
class cSTAT_MON_0: public cQCD_STAT_MON {
    public:
	typedef cSTR (T::*M0)(const char *);
	
	cSTAT_MON_0(const cSTR& name, T& obj, const M0 func): cQCD_STAT_MON(name), m_obj(obj), m_func(func) {}
    public:
	virtual cSTR StatMon(const char *label)		{ return (m_obj.*m_func)(label); }
    private:
	T&	m_obj;
	M0	m_func;
};

class cQCD_PERF_LOG: public cQTHREAD {
	DclNormalClass(cQCD_PERF_LOG)
    private:
	struct sLONG_VAL{
		const long *m_val;
		cSTR m_name;
		sLONG_VAL(const char *name, const long *val): m_name(name), m_val(val) {}
	};
	static cQCD_PERF_LOG	*m_instance;
	static cQCD_MUTEX	m_mutex;
	cSTR			m_log_file_name;
	int			m_max_log_size;
	
	struct timeval 		m_start_time;
	int			m_proc_fd;
	int			m_log_file_fd;
	FILE	  		*m_log_file;
	list<cQCD_PERF_VAL *>	m_perf_val;
	list<cQCD_STAT_MON *>	m_stat_list;
	volatile bool		m_run;
    private:
	cQCD_PERF_LOG();
	void WriteLogEntry();
	
	void WritePerfValEntry();
	void WriteStatMonEntry();
	void ElapsedTimeEntry();
	void WriteProcEntry();
	void WriteRUsageEntry();
	
	void CheckLogSize();
    public:
	~cQCD_PERF_LOG();
	static cQCD_PERF_LOG *Instance();
	void Start()		{ Resume();}
	virtual void Main();
	
	void InsertPerfVal(cQCD_PERF_VAL *pv);
	void RemovePerfVal(cQCD_PERF_VAL *pv);

	void Register(cQCD_STAT_MON *);
	void Unregister(cQCD_STAT_MON *);
	
	/* formating */
	int SubLabelWidth()	{ return 30;}
	int NumWidth()		{ return 8;}
};


#endif

