unit in5rpfmu;

// Copyright  2000 by Ziff Davis Media, Inc.
// Written by Neil J. Rubenking

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ShDocVw, Grids, StdCtrls, ExtCtrls, ComCtrls;

type
  TReptForm = class(TForm)
    Notebook1      : TNotebook;
      // page 0
        lbRept     : TLabel;
      // page 2
        sgRept     : TStringGrid;
    pnlReptName    : TPanel;
    pnlRept        : TPanel;
      btnLaunch    : TButton;
      btnClose     : TButton;
      rbHTM        : TRadioButton;
      rbTxt        : TRadioButton;
      rbCSV        : TRadioButton;
    sbRept         : TStatusBar;
    reRept: TRichEdit;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnLaunchClick(Sender: TObject);
    procedure rbHTMClick(Sender: TObject);
    procedure rbTxtClick(Sender: TObject);
    procedure rbCSVClick(Sender: TObject);
  private
    { Private declarations }
    wbRept  : TWebBrowser;
    HtmName : String;
    TxtName : String;
    CsvName : String;
    procedure wbReptNavigateComplete2(Sender: TObject;
      const pDisp: IDispatch; var URL: OleVariant);
    procedure InitWBRept;
  public
    { Public declarations }
    procedure SetData(const vHtm, vTxt, vCsv : String;
      vReptFormat : Integer);
    procedure SetDataSingle(const vName : String;
      vReptFormat : Integer);
  end;

var
  ReptForm: TReptForm;

implementation

uses allfuncs, shellapi, in5Repts;

{$R *.DFM}

procedure TReptForm.FormCreate(Sender: TObject);
begin
  GetPosFmExeName(Application.ExeName, Self, True);
  wbRept := nil;
end;

procedure TReptForm.FormDestroy(Sender: TObject);
begin
  SetPosToExeName(Application.ExeName, Self, True);
end;

procedure TReptForm.btnLaunchClick(Sender: TObject);
VAR Rslt : DWORD;
begin
  Rslt :=  ShellExecute(Self.Handle, nil, PChar(pnlReptName.Caption),
    nil, PChar(ExtractFileDir(pnlReptName.Caption)), SW_SHOW);
  IF Rslt < 32 THEN
    sbRept.SimpleText := SysErrorMessage(Rslt)
  ELSE sbRept.SimpleText := 'Launched';
end;

procedure TReptForm.rbHTMClick(Sender: TObject);
begin
  Notebook1.PageIndex := 0;
  pnlReptName.Caption := HtmName;
end;

procedure TReptForm.rbTxtClick(Sender: TObject);
begin
  Notebook1.PageIndex := 1;
  pnlReptName.Caption := TxtName;
end;

procedure TReptForm.rbCSVClick(Sender: TObject);
begin
  Notebook1.PageIndex := 2;
  pnlReptName.Caption := CsvName;
end;

procedure TReptForm.wbReptNavigateComplete2(Sender: TObject;
  const pDisp: IDispatch; var URL: OleVariant);
begin
  wbRept.Visible := True;
end;

procedure TReptForm.InitwbRept;
begin
  try
    wbRept := TWebBrowser.Create(Self);
  except
    ON Exception DO
      wbRept := nil;
  end;
  IF wbRept <> nil THEN
    begin
      lbRept.Parent.InsertControl(wbRept);
      lbRept.Free;
      wbRept.Align := alClient;
      wbRept.OnNavigateComplete2 := wbReptNavigateComplete2;
      wbrept.Visible := False;
    end
  ELSE
    begin
      lbRept.Caption := 'InCtrl5 relies on the Internet Explore'+
        'r ActiveX control to provide a preview of its HTML rep'+
        'ort. This control is installed along with IE4 or highe'+
        'r. If you would like to use the HTML preview feature, '+
        'please install IE4 or higher. Click Launch to display '+
        'the HTML report in your browser';
    end;
end;

procedure TReptForm.SetData(const vHtm, vTxt, vCsv : String;
  vReptFormat : Integer);
begin
  HtmName := vHtm;
  TxtName := vTxt;
  CsvName := vCsv;
  Notebook1.PageIndex := vReptFormat-1;
  InitwbRept;
  IF wbRept <> nil THEN
    wbRept.Navigate('file://'+HtmName);
  reRept.Lines.LoadFromFile(TxtName);
  LoadCsv(sgRept, CsvName);
  CASE vReptFormat OF
    1 : begin
      rbHTM.Checked       := True;
      pnlReptName.Caption := HtmName;
    end;
    2 : begin
      rbTXT.Checked       := True;
      pnlReptName.Caption := TxtName;
    end;
    3 : begin
      rbCSV.Checked       := True;
      pnlReptName.Caption := CsvName;
    end;
  END;
end;

procedure TReptForm.SetDataSingle(const vName: String;
  vReptFormat: Integer);
begin
  HtmName := '';
  TxtName := '';
  CsvName := '';
  rbHTM.Visible := False;
  rbTxt.Visible := False;
  rbCsv.Visible := False;
  Notebook1.PageIndex := vReptFormat-1;
  CASE vReptFormat OF
    1 : begin
      HtmName             := vName;
      pnlReptName.Caption := HtmName;
      InitwbRept;
      IF wbRept <> nil THEN
        wbRept.Navigate('file://'+HtmName);
    end;
    2 : begin
      TxtName             := vName;
      pnlReptName.Caption := TxtName;
      reRept.Lines.LoadFromFile(TxtName);
    end;
    3 : begin
      CsvName             := vName;
      pnlReptName.Caption := CsvName;
      LoadCsv(sgRept, CsvName);
    end;
  END;
end;

end.


