program inctrl5;

// Copyright  2000 by Ziff Davis Media, Inc.
// Written by Neil J. Rubenking

uses
  Forms,
  Windows,
  SysUtils,
  mainu in 'mainu.pas' {MainForm},
  AboutBox in 'Aboutbox.pas' {AboutForm},
  allfuncs in 'AllFuncs.pas',
  in5share in 'in5share.pas',
  pathsu in 'pathsu.pas' {PathsForm},
  pikigkey in 'pikigkey.pas' {RegIgForm},
  optbaseu in 'optbaseu.pas' {OptForm},
  in5obju in 'in5obju.pas',
  in5Strmu in 'in5Strmu.pas',
  in5Repts in 'in5Repts.pas',
  pdthdu in 'PDTHDU.PAS',
  in5rpfmu in 'in5rpfmu.pas' {ReptForm},
  regequiv in 'regequiv.pas';

{$R *.RES}
{$R MORERES.RES}
TYPE
  THandles = Record
    AppHandle : THandle;
    WinHandle : THandle;
  end;
VAR
  hMap : THandle;
  PH   : ^THandles;
CONST
  MainMapName : PChar = 'PC Magazine InCtrl5 Shared';

begin
  hMap := OpenFileMapping(FILE_MAP_ALL_ACCESS, False, MainMapName);
  IF hMap = 0 THEN // first instance
    begin
      hMap := CreateFileMapping($FFFFFFFF, NIL, PAGE_READWRITE, 0,
        2*SizeOf(Integer), MainMapName);
      PH := MapViewOfFile(hMap, FILE_MAP_ALL_ACCESS, 0, 0, 0);
  Application.Initialize;
  Application.Title := 'InCtrl5';
    Application.CreateForm(TMainForm, MainForm);
  MainForm.HandleNeeded;
      PH^.AppHandle := Application.Handle;
      PH^.WinHandle := MainForm.Handle;
      Application.Run;
    end
  ELSE
    begin
      PH := MapViewOfFile(hMap, FILE_MAP_ALL_ACCESS, 0, 0, 0);
      IF IsIconic(PH^.AppHandle) THEN
        ShowWindow(PH^.AppHandle, SW_RESTORE);
      SetForegroundWindow(PH^.AppHandle);
      IF ParamCount > 0 THEN
        MessageBox(PH^.AppHandle, 'InCtrl5 is already running. You '+
          'cannot start a second instance using command-line argume'+
          'nts. Please exit InCtrl5 and re-start using the desired '+
          'command-line arguments.', 'InCtrl5', MB_OK OR MB_ICONSTOP);
    end;
  UnMapViewOfFile(PH);
  CloseHandle(hMap);
end.

