unit mainu;

// Copyright  2000 by Ziff Davis Media, Inc.
// Written by Neil J. Rubenking

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, ActnList, ImgList, ComCtrls, Buttons, StdCtrls;

type
  TMainForm = class(TForm)
    ActionList1        : TActionList;
      acReg            : TAction;
      acINI            : TAction;
      acDsk            : TAction;
      acTxt            : TAction;
    Notebook1          : TNotebook;
    // First page
      gbInst           : TGroupBox;
        btnBrowse      : TButton;
        ebInstallProg  : TEdit;
        ebParams       : TEdit;
        ebName         : TEdit;
        lbExeType      : TLabel;
      gbReports        : TGroupBox;
        btnSelect      : TButton;
        ebReportName   : TEdit;
        btnPath        : TButton;
        btnViewRepts   : TButton;
      gbSettings       : TGroupBox;
        btnDisk        : TBitBtn;
        btnINI         : TBitBtn;
        btnReg         : TBitBtn;
        btnText        : TBitBtn;
      btnCancel        : TButton;
      btnHelp          : TButton;
      btnAbout         : TButton;
      btnGO            : TBitBtn;
    //Second page
      pbMain           : TProgressBar;
      bvPre            : TBevel;
        i1             : TPaintBox;
        i2             : TPaintBox;
        i3             : TPaintBox;
        i4             : TPaintBox;
      bvInstall        : TBevel;
        lbInst         : TLabel;
        lbInst2        : TLabel;
        btnComplete    : TButton;
        btnCancelIns   : TButton;
      bvPost           : TBevel;
        i5             : TPaintBox;
        i6             : TPaintBox;
        i7             : TPaintBox;
        i8             : TPaintBox;
      bvAnaz           : TBevel;
        i9             : TPaintBox;
        i10            : TPaintBox;
        i11            : TPaintBox;
        i12            : TPaintBox;
      pbFocus          : TPaintBox;
    // no page
    sbMain             : TStatusBar;
    odInstall          : TOpenDialog;
    odReport           : TOpenDialog;
    sdReport           : TSaveDialog;
    ilMain             : TImageList;
    tmrGo              : TTimer;
    procedure FormCreate        (Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormActivate       (Sender: TObject);
    procedure acRegExecute       (Sender: TObject);
    procedure acDskExecute       (Sender: TObject);
    procedure acINIExecute       (Sender: TObject);
    procedure acTxtExecute       (Sender: TObject);
    procedure btnBrowseClick     (Sender: TObject);
    procedure ebInstProgChange   (Sender: TObject);
    procedure btnSelectClick     (Sender: TObject);
    procedure btnPathClick       (Sender: TObject);
    procedure btnViewReptsClick  (Sender: TObject);
    procedure btnCancelClick     (Sender: TObject);
    procedure btnHelpClick       (Sender: TObject);
    procedure btnAboutClick      (Sender: TObject);
    procedure btnGOClick         (Sender: TObject);
    procedure pbFocusPaint       (Sender: TObject);
    procedure imgAllPaint        (Sender: TObject);
    procedure btnCompleteClick   (Sender: TObject);
    procedure btnCancelInsClick  (Sender: TObject);
    procedure sdReportShow       (Sender: TObject);
    procedure sdReportTypeChange (Sender: TObject);
    procedure tmrGoTimer         (Sender: TObject);
  private
    { Private declarations }
    OurPath        : String; // program's own path
    InstPath       : String; // path of most recent install
    ReptPath       : String; // folder for reports
    TempPath       : String; // folder for temp files
    HtmName        : String; // name of HTM report
    TxtName        : String; // name of TXT report
    CsvName        : String; // name of CSV report
    DirList        : TStringList; // folders to track
    IniList        : TStringList; // INI files to track
    RegList        : TStringList; // Registry keys to ignore
    RexList        : TStringList; // Registry key equivalents
    TxtList        : TStringList; // Text files to track
    Status         : Integer; // current program status
                     // see stat_xxx constants below
    InstallExeType : Integer; // type of install program
                     // see ET_xxx constants in IN5Share
    ReptFormat     : Integer; // 0=HTM, 1=TXT, 2=CSV
    TwoPhase       : Integer; // 1=two-phase, 2=restart, 0=neither
    AutoGo         : Boolean; // GO automatically at startup
    NoWait         : Boolean; // post-install without waiting
    NoPrevu        : Boolean; // no preview, just terminate
    NoDel          : Boolean; // don't delete temp files
    Pbs            : ARRAY[1..12] OF TPaintBox;
    function  DefaultReportName : String;
    procedure PutShape(J: Integer);
    procedure RefreshShapes;
    procedure Stage_PreProcess;
    procedure Stage_Install;
    procedure Stage_PostProcess;
    procedure Stage_Compare;
    function  StatusMsg : String;
    procedure ThdDone(Sender: TObject);
    procedure UpStatus(const S : String; I : Integer);
    procedure WMQueryEndSession(VAR Msg: TWMQueryEndSession);
      message WM_QUERYENDSESSION;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

uses AboutBox, FileCtrl, Shellapi, Registry, inifiles, allfuncs,
  in5share, pathsu, optbaseu, in5Strmu, in5obju, in5repts, pdthdu,
  in5rpfmu, regequiv;
const
  stat_none     = 0;
  stat_pre      = 1;
  stat_preonly  = 2;
  stat_inst     = 3;
  stat_btwn     = 4;
  stat_btwnonly = 5;
  stat_post     = 6;
  stat_postonly = 7;
  stat_comp     = 8;
  stat_done     = 9;

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);

  procedure InitVariables;
  // Initialize simple variables
  begin
    AutoGo   := False;
    NoWait   := False;
    NoPrevu  := False;
    NoDel    := False;
    Status   := stat_none;
    TwoPhase := 0;
    DirList  := TStringList.Create;
    IniList  := TStringList.Create;
    RegList  := TStringList.Create;
    RexList  := TStringList.Create;
    TxtList  := TStringList.Create;
    OurPath  := FinalSlash(lowercase(ExtractFileDir(
      Application.ExeName)));
  end;

  procedure InitControls;
  // Initialize some specialized control values
  VAR N : Integer;
  begin
    Application.HelpFile := ChangeFileExt(Application.Exename,
      '.HLP');
    FOR N := 1 TO 12 DO
      Pbs[N] := FindComponent('i'+IntToStr(N)) AS TPaintBox;
    Notebook1.PageIndex := 0;
  end;

  procedure InitImageList;
  // Read the ImageList's images from resources (this avoids the
  // problem when the program runs under a different version of
  // comctl32.dll than it was compiled under)
  VAR
    N  : Integer;
    TB : TBitmap;
  begin
    ilMain.Clear;
    TB := TBitmap.Create;
    try
      FOR N := 1 TO 4 DO
        begin
          TB.Handle := LoadImage(hInstance, MakeIntResource(N),
            IMAGE_BITMAP, 32, 32, lr_DefaultColor);
          ilMain.Addmasked(TB, clFuchsia);
        end;
    finally
      TB.Free;
    end;
    ActionList1.Images := ilMain;
  end;

  procedure ReadIniData;
  const ss : ARRAY[1..7] OF String = ('','','s','','s','s','s');
  const hkNames : ARRAY[1..7] OF String = (
    'HKEY_CLASSES_ROOT',
    'HKEY_CURRENT_USER',
    'HKEY_CLASSES_ROOT and HKEY_CURRENT_USER',
    'HKEY_CURRENT_CONFIG',
    'HKEY_CLASSES_ROOT and HKEY_CURRENT_CONFIG',
    'HKEY_CURRENT_USER and HKEY_CURRENT_CONFIG',
    'HKEY_CLASSES_ROOT, HKEY_CURRENT_USER, and HKEY_CURRENT_CONFIG');
  VAR
    temps  : TStringList;
    N      : integer;
    S      : String;
  begin
    N := RootKeyEquivalents(RexList);
    IF N <> 0 THEN
      MessageBox(Handle, PChar(Format('InCtrl5 was unable to correc'+
        'tly determine the equivalent%s for the Registry root key%s'+
        ' %s.'#13#10#13#10'As a result, the reports may contains so'+
        'me duplicate elements.', [ss[N], ss[N], hknames[N]])),
        'InCtrl5', MB_OK OR MB_ICONINFORMATION);
    WITH TIniFile.Create(ininame) DO
    try
      InstPath := ReadString('Settings', 'InstPath', 'c:\');
      ReptPath := ReadString('Settings', 'ReptPath', OurPath);
      TempPath := ReadString('Settings', 'TempPath', OurPath);
      BootDrv  := ReadString('Settings', 'BootDrv', 'C:\');
      InstPath := FinalSlash(InstPath);
      ReptPath := FinalSlash(ReptPath);
      TempPath := FinalSlash(TempPath);
      BootDrv  := FinalSlash(BootDrv);
      ReptFormat  := ReadInteger('Settings', 'ReportFormat', 1);
      ebReportName.Text := DefaultReportName;
      temps       := TStringList.Create;
      try
        // Read drive-tracking info from .INI file, or use default
        IF ReadBool('Settings', 'DrivesInitialized', False) THEN
          begin
            ReadSection('Drives', temps);
            FOR N := 0 TO temps.count-1 DO
              begin
                S := ReadString('Drives', temps[N], '');
                IF (S <> '') AND DirectoryExists(S) THEN
                  AddToHierList(DirList, S);
              end;
          end
        ELSE DefaultDsk(DirList);
        // Read INI file list from .INI file, or use default
        IF ReadBool('Settings', 'INIsInitialized', False) THEN
          begin
            ReadSection('INIs', temps);
            FOR N := 0 TO temps.count-1 DO
              begin
                S := ReadString('INIs', temps[N], '');
                IF (S <> '') AND FileExists(S) AND ValidINI(S) THEN
                  IniList.Add(S);
              end;
          end
        ELSE DefaultIni(IniList);
        ReadSection('Regs', temps);
        FOR N := 0 TO temps.count-1 DO
          begin
            S := UpperCase(ReadString('Regs', temps[N], ''));
            IF (S <> '') AND (ValidReg(S)>=0) THEN
              AddToHierList(RegList, S);
          end;
        // Read text file list from .INI file, or use default
        IF ReadBool('Settings', 'TxtInitialized', False) THEN
          begin
            ReadSection('Txt', temps);
            FOR N := 0 TO temps.count-1 DO
              begin
                S := ReadString('Txt', temps[N], '');
                IF (S <> '') AND FileExists(S) AND
                  (ValidTxt(S) = 0) THEN
                    TxtList.Add(S);
              end;
          end
        ELSE DefaultTxt(TxtList);
      finally
        temps.free;
      end;
      TwoPhase := ReadInteger('TwoPhase', 'TwoPhase', 0);
    finally
      Free;
    end;
  end;

  procedure ReadTwoPhaseData;
  begin
    // Are we restarting in two-phase mode? If so, read
    // and delete data about the restart.
    WITH TIniFile.Create(ininame) DO
    try
      ebName.Text := ReadString('TwoPhase', 'ReportDesc',
        ebName.Text);
      ebReportName.Text := ReadString('TwoPhase', 'ReportName',
        ebReportName.Text);
      ebInstallProg.Text := ReadString('TwoPhase', 'InstallProg',
        ebInstallProg.Text);
      IF twoPhase = 1 THEN
        begin
          lbInst.Caption := 'Two-phase tracking';
          lbInst2.Caption := 'Press the Install complete button to '+
            'finish the analysis';
        end
      ELSE
        lbInst.Caption := 'Windows has restarted';
      pbFocus.Left         := bvInstall.Left + 7;
      pbFocus.Top          := bvInstall.Top + 9;
      pbFocus.Visible      := True;
      Status               := stat_btwnonly;
      btnComplete.Enabled  := True;
      btnCancelIns.Enabled := True;
      Notebook1.PageIndex  := 1;
      Show;
      Application.ProcessMessages;
      EraseSection('TwoPhase');
    finally
      Free;
    end;
  end;

begin
  GetPosFmIni(ininame, self, False);
  InitVariables;
  InitControls;
  InitImageList;
  ReadIniData;
  IF TwoPhase <> 0 THEN
    ReadTwoPhaseData;
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Application.Tag := -1;
  IF TwoPhase <> 0 THEN Exit; // no del temp - it's two-phase
  IF NoDel THEN Exit;         // no del temp - command-line switch
  DeleteFile(TempPath+'\REG$$$.$$1');
  DeleteFile(TempPath+'\DSK$$$.$$1');
  DeleteFile(TempPath+'\INI$$$.$$1');
  DeleteFile(TempPath+'\TXT$$$.$$1');
  DeleteFile(TempPath+'\REG$$$.$$2');
  DeleteFile(TempPath+'\DSK$$$.$$2');
  DeleteFile(TempPath+'\INI$$$.$$2');
  DeleteFile(TempPath+'\TXT$$$.$$2');
end;

procedure TMainForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
VAR Msg : String;
begin
  Msg := StatusMsg;
  IF Msg = '' THEN CanClose := True
  ELSE
    begin
      Msg := Msg + #13#10#13#10 + 'Do you really want to close '+
        'InCtrl5?';
      CanClose := MessageBox(Self.Handle, PChar(Msg), 'InCtrl5',
        MB_YESNO OR MB_ICONQUESTION) = idYes;
    end;
  IF CanClose THEN
    begin
      SetPosToIni(ininame, self, False);
      WITH TIniFile.Create(IniName) DO
      try
        WriteString('Settings', 'InstPath', InstPath);
        WriteInteger('Settings', 'ReportFormat', ReptFormat);
      finally
        Free;
      end;
    end;
end;

procedure TMainForm.FormActivate(Sender: TObject);
VAR
  N      : Integer;
  S, Ext : String;
const Switches = '>/G>/g>/W>/w>/P>/p>/T>/t>';
begin
  IF PlatVer < 0 THEN
    begin
      MessageBox(Handle, PChar('It appears that the current operati'+
        'ng system is ' + PlatVerStr + '.'#13#10#13#10'InCtrl5 supp'+
        'orts Windows 95, Windows 98, Windows ME, Windows NT4, and '+
        'Windows 2000.'), 'InCtrl5', MB_OK OR MB_ICONSTOP);
      FOR N := 0 TO ComponentCount-1 DO
        IF Components[N] IS TWinControl THEN
          TWInControl(Components[N]).Enabled :=False;
    end
  ELSE // read the command line
    begin
      // First get the slash+character switches
      FOR N := 1 TO ParamCount DO
        CASE Pos(ParamStr(N), Switches) OF
          2, 5   : AutoGo  := True;
          8, 11  : NoWait  := True;
          14, 17 : NoPrevu := True;
          20, 23 : NoDel   := True;
        END;
      // Now find the /I: switch; if it's absent or invalid, no auto
      FOR N := 1 TO ParamCount DO
        begin
          S := ParamStr(N);
          IF (Length(S)>3) AND (Pos('/I:', Uppercase(S)) = 1) THEN
            begin
              Delete(S, 1, 3);
              IF NOT FileExists(S) THEN
                begin
                  MessageBox(Handle, PChar(Format('The install prog'+
                    'ram "%s" specified on the command line does no'+
                    't exist.', [S])), 'InCtrl5',
                    MB_OK OR MB_ICONSTOP);
                  AutoGo  := False;
                end
              ELSE
                begin
                  Ext := Uppercase(ExtractFileExt(S));
                  IF (Ext = '.EXE') OR (Ext = '.INF') OR (Ext = '.COM')
                    OR (Ext = '.BAT') THEN
                    ebInstallProg.Text := S
                  ELSE
                    begin
                      MessageBox(Handle, PChar(Format('The install '+
                        'program "%s" specified on the command line'+
                        ' is not a valid file type. Extension must '+
                        'be .EXE, .INF, .COM, or .BAT', [S])),
                        'InCtrl5', MB_OK OR MB_ICONSTOP);
                      AutoGo := False;
                    end;
                end;
              Break;
            end;
        end;
      // Get parameters from the /P: switch if present
      FOR N := 1 TO ParamCount DO
        begin
          S := ParamStr(N);
          IF (Length(S)>3) AND (Pos('/P:', Uppercase(S)) = 1) THEN
            begin
              Delete(S, 1, 3);
              ebParams.Text := S;
            end;
        end;
      // Get description from the /D: switch if present
      FOR N := 1 TO ParamCount DO
        begin
          S := ParamStr(N);
          IF (Length(S)>3) AND (Pos('/D:', Uppercase(S)) = 1) THEN
            begin
              Delete(S, 1, 3);
              ebName.Text := S;
            end;
        end;
      // Get and validate report name from the /R: switch, if
      // present. If invalid, no auto.
      FOR N := 1 TO ParamCount DO
        begin
          S := ParamStr(N);
          IF (Length(S)>3) AND (Pos('/R:', Uppercase(S)) = 1) THEN
            begin
              Delete(S, 1, 3);
              Ext := Uppercase(ExtractFileExt(S));
              IF (Ext = '.HTM') OR (Ext = '.TXT') OR (Ext = '.CSV') THEN
                begin
                  IF ExtractFileDir(S) = '' THEN
                    ebReportName.Text := ReptPath+S
                  ELSE IF DirectoryExists(ExtractFileDir(S)) THEN
                    ebReportName.Text := S
                  ELSE
                    begin
                      MessageBox(Handle, PChar(Format('The report n'+
                         'ame "%s" specified on the command line is'+
                         ' not in an existing folder.', [S])),
                         'InCtrl5', MB_OK OR MB_ICONSTOP);
                      AutoGo := False;
                    end;
                end
              ELSE
                begin
                  MessageBox(Handle, PChar(Format('The report name '+
                    '"%s" specified on the command line is not a va'+
                    'lid type. Extension must be .HTM, .TXT, or .CSV',
                    [S])), 'InCtrl5', MB_OK OR MB_ICONSTOP);
                  AutoGo := False;
                end;
            end;
        end;
      IF NOT AutoGo THEN
        begin
          NoWait  := False;
          NoPrevu := False;
        end;
      // Give the program a moment to "breathe", then GO!
      IF AutoGo AND btnGo.Enabled THEN
        tmrGo.Enabled := True;
    end;
end;

procedure TMainForm.acRegExecute(Sender: TObject);
VAR N : Integer;
begin
  WITH TOptForm.Create(Self) DO
  try
    SetData(optReg, RegList);
    IF ShowModal = mrOK THEN
      begin
        RegList.Assign(lbMain.Items);
        WITH TIniFile.Create(IniName) DO
        try
          WriteBool('Settings', 'RegInitialized', True);
          EraseSection('Regs'); 
          FOR N := 0 TO RegList.Count-1 DO
            WriteString('Regs', IntToStr(N), RegList[N]);
        finally
          Free;
        end;
      end;
  finally
    Free;
  end;
end;

procedure TMainForm.acDskExecute(Sender: TObject);
VAR N : Integer;
begin
  WITH TOptForm.Create(Self) DO
  try
    SetData(optDsk, DirList);
    IF ShowModal = mrOK THEN
      begin
        DirList.Assign(lbMain.Items);
        WITH TIniFile.Create(IniName) DO
        try
          WriteBool('Settings', 'DrivesInitialized', True);
          EraseSection('Drives');
          FOR N := 0 TO DirList.Count-1 DO
            WriteString('Drives', IntToStr(N), DirList[N]);
        finally
          Free;
        end;
      end;
  finally
    Free;
  end;
end;

procedure TMainForm.acINIExecute(Sender: TObject);
VAR N : Integer;
begin
  WITH TOptForm.Create(Self) DO
  try
    SetData(optINI, IniList);
    IF ShowModal = mrOK THEN
      begin
        IniList.Assign(lbMain.Items);
        WITH TIniFile.Create(IniName) DO
        try
          WriteBool('Settings', 'INIsInitialized', True);
          EraseSection('INIs');
          FOR N := 0 TO IniList.Count-1 DO
            WriteString('INIs', IntToStr(N), IniList[N]);
        finally
          Free;
        end;
      end;
  finally
    Free;
  end;
end;

procedure TMainForm.acTxtExecute(Sender: TObject);
VAR N : Integer;
begin
  WITH TOptForm.Create(Self) DO
  try
    SetData(optTXT, TxtList);
    IF ShowModal = mrOK THEN
      begin
        TxtList.Assign(lbMain.Items);
        WITH TIniFile.Create(IniName) DO
        try
          WriteBool('Settings', 'TxtInitialized', True);
          EraseSection('Txt');
          FOR N := 0 TO TxtList.Count-1 DO
            WriteString('Txt', IntToStr(N), TxtList[N]);
        finally
          Free;
        end;
      end;
  finally
    Free;
  end;
end;

procedure TMainForm.btnBrowseClick(Sender: TObject);
begin
  WITH odInstall DO
    begin
      InitialDir := ExtractFilePath(ebInstallProg.Text);
      IF (InitialDir = '') OR (NOT DirectoryExists(InitialDir)) THEN
        InitialDir := InstPath;
      IF Execute THEN
        begin
          ebInstallProg.Text := Filename;
          InstPath := ExtractFilePath(Filename);
        end;
    end;
end;

procedure TMainForm.ebInstProgChange(Sender: TObject);
VAR
  P : Integer;
  S : String;
begin
  InstallExeType := ExeType(ebInstallProg.Text);
  IF InstallExeType = ET_BLANK THEN
    S := '(two-phase mode)'
  ELSE
    begin
      S := ebInstallProg.Text;
      IF (S <> '') AND (InstallExeType > ET_BLANK) THEN
        begin
          S := GetDescriptionEZ(S);
          IF S = '' THEN
            begin
              S := ExtractFileName(ebInstallProg.Text);
              P := LastDelimiter('.', S);
              IF P > 0 THEN SetLength(S, P-1);
            end;
        end;
    end;
  ebName.Text := S;
  lbExeType.Caption := ExeTypeName(InstallExeType);
  IF InstallExeType < ET_BLANK THEN
    btnGo.Enabled := FALSE
  ELSE IF InstallExeType = ET_BLANK THEN
    begin
      btnGo.Enabled := TRUE;
      lbExeType.Caption := '(two-phase mode)';
    end
  ELSE btnGo.Enabled := True;
end;

procedure TMainForm.btnSelectClick(Sender: TObject);
const Exts : String = '^.HTM^.TXT^.CSV^';
VAR Ext : String;
begin
  WITH sdReport DO
    begin
      Filename   := ebReportName.Text;
      InitialDir := ReptPath;
      FilterIndex := ReptFormat;
      IF Execute THEN
        begin
          Ext := Uppercase(ExtractFileExt(Filename));
          CASE Pos(Ext, Exts) OF
            2  : FilterIndex := 1;
            7  : FilterIndex := 2;
            12 : FilterIndex := 3;
            ELSE begin
              MessageBox(Self.Handle, 'The report file extension '+
                'must be .HTM, .TXT, or .CSV', 'InCtrl5',
                MB_OK OR MB_ICONSTOP);
              Exit;
            end;
          end;
          ebReportName.Text := ExpandFilename(Filename);
          ReptFormat := FilterIndex;
        end;
    end;
end;

procedure TMainForm.btnPathClick(Sender: TObject);
VAR WasDef : Boolean;
begin
  WasDef := AnsiCompareText(ebReportName.Text, DefaultReportName)=0;
  WITH TPathsForm.Create(Self) DO
  try
    SetData(ReptPath, TempPath, BootDrv);
    IF ShowModal = mrOK THEN
      begin
        GetData(ReptPath, TempPath, BootDrv);
        IF WasDef THEN
          ebReportName.Text := DefaultReportName;
        WITH TIniFile.Create(ininame) DO
        try
          WriteString('Settings', 'TempPath', TempPath);
          WriteString('Settings', 'ReptPath', ReptPath);
          WriteString('Settings', 'BootDrv',  BootDrv);
        finally
          Free;
        end;
      end;
  finally
    free;
  end;
end;

procedure TMainForm.btnViewReptsClick(Sender: TObject);
const Exts : String = '^.HTM^.TXT^.CSV^';
VAR
  Ext : String;
  theFormat : Integer;
begin
  WITH odReport DO
    begin
      InitialDir := ReptPath;
      Filename := '';
      IF Execute THEN
        begin
          Ext := Uppercase(ExtractFileExt(Filename));
          CASE Pos(Ext, Exts) OF
            2  : theFormat := 1;
            7  : theFormat := 2;
            12 : theFormat := 3;
            ELSE begin
              MessageBox(Self.Handle, 'The report file extension '+
                'must be .HTM, .TXT, or .CSV', 'InCtrl5',
                MB_OK OR MB_ICONSTOP);
              Exit;
            end;
          end;
          WITH TReptForm.Create(Self) DO
          try
            SetDataSingle(Filename, theFormat);
            ShowModal;
          finally
            Free;
          end;
        end;
    end;
end;

procedure TMainForm.btnCancelClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.btnHelpClick(Sender: TObject);
begin
  Application.HelpCommand(HELP_FINDER, 0);
end;

procedure TMainForm.btnAboutClick(Sender: TObject);
begin
  WITH TAboutForm.Create(Self) DO
  try
    ShowModal;
  finally
    Free;
  end;
end;

procedure TMainForm.btnGOClick(Sender: TObject);
begin
  Application.Tag      := 0;
  lbInst.Caption       := '';
  btnCancelIns.Enabled := True;
  Notebook1.PageIndex  := 1;
  Stage_PreProcess;
end;

procedure TMainForm.pbFocusPaint(Sender: TObject);
begin
  WITH Sender AS TPaintBox DO
    begin
      Canvas.Brush.Style := bsClear;
      Canvas.Pen.Width   := 3;
      Canvas.Pen.Color   := clYellow;
      RoundRect(Canvas.Handle, 2, 2, Width-3, Height-3, 8, 8);
    end;
end;

procedure TMainForm.imgAllPaint(Sender: TObject);
begin
  WITH Sender AS TPaintBox DO
    begin
      ilMain.DrawingStyle := dsNormal;
      IF (Tag < 4) AND (Status <> stat_pre) AND
        (Status <> stat_preonly) THEN
          ilMain.DrawingStyle := dsSelected
      ELSE IF (Tag > 3) AND (Tag < 8) AND (Status <> stat_post) AND
        (Status <> stat_postonly) THEN
        ilMain.DrawingStyle := dsSelected
      ELSE IF (Tag > 7) AND (Status <> stat_comp) THEN
        ilMain.DrawingStyle := dsSelected;
      ilMain.BlendColor := clGray;
      ilMain.Draw(Canvas, 0, 0, Tag MOD 4);
    end;
end;

procedure TMainForm.btnCompleteClick(Sender: TObject);
begin
  IF (status <> stat_btwn) AND (status <> stat_btwnonly) THEN
    IF MessageBox(Handle, 'InCtrl5 has launched the install program'+
      ', and it appears to be running still. If you proceed with th'+
      'e next step before the program has finished, you will not ge'+
      't a complete report. '#13#10#13#10'Has the install program r'+
      'eally finished?', 'InCtrl5', MB_YESNO OR
      MB_ICONQUESTION) <> idYes THEN Exit;
  (Sender AS TButton).Enabled := False;
  StopThePresses;
  sbMain.SimpleText := '';
  Stage_PostProcess;
end;

procedure TMainForm.btnCancelInsClick(Sender: TObject);
VAR Msg : String;
begin
  Msg := StatusMsg;
  IF (Msg = '') OR (MessageBox(Self.Handle, PChar(Msg +
      #13#10#13#10 + 'Do you really want start over?'), 'InCtrl5',
       MB_YESNO OR MB_ICONQUESTION) = idYes) THEN
    begin
      Status := stat_none;
      StopThePresses;
      Application.Tag     := -1;
      Notebook1.PageIndex := 0;
      AutoGo              := False;
      NoWait              := False;
      NoPrevu             := False;
    end;
end;

procedure TMainForm.sdReportShow(Sender: TObject);
begin
  (Sender AS TComponent).Tag := 0;
end;

procedure TMainForm.sdReportTypeChange(Sender: TObject);
VAR buff : ARRAY[0..MAX_PATH] OF Char;

  function GetEditH : HWnd;
  VAR DlgH : HWnd;
  begin
    Result := 0;
    DlgH := GetParent((Sender AS TSaveDialog).Handle);
    REPEAT
      Result := FindWindowEx(DlgH, Result, nil, nil);
      IF Result = 0 THEN Break;
      IF NOT IsWindowVisible(Result) THEN Continue;
      GetClassName(Result, Buff, MAX_PATH);
      IF AnsiCompareStr(Buff, 'Edit') = 0 THEN Exit;
    UNTIL False;
  end;
begin
  WITH Sender AS TOpenDialog DO
    begin
      IF Tag = 0 THEN Tag := GetEditH;
      IF Tag = 0 THEN Exit;
      SendMessage(Tag, WM_GETTEXT, MAX_PATH, Integer(@Buff));
      IF StrLen(Buff) = 0 THEN Exit;
      CASE (Sender AS TSaveDialog).FilterIndex OF
        1 : StrPCopy(Buff, ChangeFileExt(StrPas(Buff), '.HTM'));
        2 : StrPCopy(Buff, ChangeFileExt(StrPas(Buff), '.TXT'));
        3 : StrPCopy(Buff, ChangeFileExt(StrPas(Buff), '.CSV'));
      end;
      SendMessage(Tag, WM_SETTEXT, 0, Integer(@Buff));
    end;
end;

procedure TMainForm.tmrGoTimer(Sender: TObject);
begin
  WITH Sender AS TTimer DO Enabled := False;
  AutoGo := False;
  btnGoClick(btnGo);
end;

function TMainForm.DefaultReportName : String;
VAR N : Integer;
begin
  N := 0;
  REPEAT
    Result := Format('%sRPT_%.4d.', [ReptPath, N]);
    Inc(N);
  UNTIL NOT (FileExists(Result+'HTM') OR
             FileExists(Result+'TXT') OR
             FileExists(Result+'CSV'));
  CASE ReptFormat OF
    1 : Result := Result + 'HTM';
    2 : Result := Result + 'TXT';
    3 : Result := Result + 'CSV';
  end;
end;

procedure TMainForm.PutShape(J: Integer);
begin
  IF J < 0 THEN
    pbFocus.Visible := False
  ELSE
    begin
      pbFocus.Visible := True;
      WITH Pbs[J] DO
        begin
          pbFocus.Left := Left - 25;
          pbFocus.Top := Top-6;
        end;
    end;
end;

procedure TMainForm.RefreshShapes;
VAR N : Integer;
begin
  FOR N := 1 TO 12 DO
    Pbs[N].Refresh;
end;

procedure TMainForm.Stage_PreProcess;
VAR
  Stream  : TFileStream;
  RegTemp : TStringList;
begin
  try
    IF ebInstallProg.Text = '' THEN
      begin
        Status := stat_preonly;
        lbInst2.Caption := '';
      end
    ELSE Status := stat_pre;
    RefreshShapes;
    pbMain.Max := 100;
    pbMain.Smooth := False;
    // Save pre-install snapshot for Registry
    pbMain.Position := 0;
    PutShape(1);
    Stream := TFileStream.Create(TempPath+'\REG$$$.$$1',
      fmCreate OR fmShareExclusive);
    try
      RegTemp := TStringList.Create;
      try
        RegTemp.AddStrings(RexList);
        RegTemp.AddStrings(RegList);
        RememberRegistry(Stream, RegTemp, UpStatus);
      finally
        Regtemp.Free;
      end;
    finally
      Stream.Free;
    end;
    IF ProcMsgTerminated THEN Exit;
    // Save pre-install snapshot for disk contente
    pbMain.Position := 0;
    PutShape(2);
    Stream := TFileStream.Create(TempPath+'\DSK$$$.$$1',
      fmCreate OR fmShareExclusive);
    try
      RememberDisk(Stream, DirList, UpStatus);
    finally
      Stream.Free;
    end;
    IF ProcMsgTerminated THEN Exit;
    // Save pre-install snapshot for INI files
    pbMain.Position := 0;
    PutShape(3);
    Stream := TFileStream.Create(TempPath+'\INI$$$.$$1',
      fmCreate OR fmShareExclusive);
    try
      RememberInis(Stream, IniList, UpStatus);
    finally
      Stream.Free;
    end;
    IF ProcMsgTerminated THEN Exit;
    // Save pre-install snapshot for Text files
    pbMain.Position := 0;
    PutShape(4);
    Stream := TFileStream.Create(TempPath+'\TXT$$$.$$1',
      fmCreate OR fmShareExclusive);
    try
      RememberTxt(Stream, TxtList, UpStatus);
    finally
      Stream.Free;
    end;
    IF ProcMsgTerminated THEN Exit;
    pbMain.Position := 0;
    PutShape(-1);
    sbMain.SimpleText := '';
    IF NOT ProcMsgTerminated THEN
      Stage_Install;
  finally
    Application.Tag := 0;
  end;
end;

procedure TMainForm.Stage_Install;
VAR
  Rslt : Bool;
  SEI  : TShellExecuteInfo;
begin
  IF ebInstallProg.Text <> '' THEN
    begin
      FillChar(SEI, SizeOf(SEI), 0);
      SEI.cbSize         := SizeOf(SEI);
      SEI.fMask          := SEE_MASK_NOCLOSEPROCESS;
      SEI.Wnd            := Self.Handle;
      IF InstallExeType = ET_INFFILE THEN
        SEI.lpVerb       := 'Install';
      SEI.lpFile         := PChar(ebInstallProg.Text);
      IF ebParams.Text <> '' THEN
        SEI.lpParameters := PChar(ebParams.Text);
      SEI.lpDirectory    := PChar(ExtractFileDir(ebInstallProg.Text));
      SEI.nShow          := SW_SHOWNORMAL;
      Rslt := ShellExecuteEx(@SEI);
      IF Rslt THEN
        begin
          Status          := stat_Inst;
          lbInst.Caption  := 'Install in progress';
          pbFocus.Left    := bvInstall.Left + 7;
          pbFocus.Top     := bvInstall.Top + 9;
          pbFocus.Visible := True;
          WITH TProcDoneThread.Create(SEI.hProcess, ThdDone) DO
            Resume;
        end
      ELSE // If program-launch fails
        begin
          MessageBox(Self.Handle, 'InCtrl5 finished recording its p'+
            're-installation snapshot. However, its attempt to laun'+
            'ch and track the install program was unsuccessful. InC'+
            'trl5 will now terminate.'#13#10#13#10'When the install'+
            'ation is complete, launch InCtrl5 again to receive a r'+
            'eport.', 'InCtrl5', MB_OK OR MB_ICONINFORMATION);
          Status := stat_done;
          TwoPhase := 1;
          WITH TIniFile.Create(IniName) DO
          try
            WriteInteger('TwoPhase', 'TwoPhase', 1);
            WriteString('TwoPhase', 'ReportDesc', ebName.Text);
            WriteString('TwoPhase', 'ReportName', ebReportName.Text);
            WriteString('TwoPhase', 'InstallProg', '');
          finally
            Free;
          end;
          Close;
        end;
    end
  ELSE
    begin
      MessageBox(Self.Handle, 'InCtrl5 has finished recording its p'+
        're-installation snapshot, and will now terminate.'#13#10+
        #13#10'When the installation or other tracked activity is c'+
        'omplete, launch InCtrl5 again to receive a report.',
        'InCtrl5', MB_OK OR MB_ICONINFORMATION);
      Status := stat_done;
      TwoPhase := 1;
      WITH TIniFile.Create(IniName) DO
      try
        WriteInteger('TwoPhase', 'TwoPhase', 1);
        WriteString('TwoPhase', 'ReportDesc', ebName.Text);
        WriteString('TwoPhase', 'ReportName', ebReportName.Text);
        WriteString('TwoPhase', 'InstallProg', '');
      finally
        Free;
      end;
      Close;
    end;
  sbMain.SimpleText := '';
  btnComplete.Enabled := True;
  btnComplete.SetFocus;
  RefreshShapes;
end;

procedure TMainForm.Stage_PostProcess;
VAR
  Stream  : TFileStream;
  RegTemp : TStringList;
  pbMax   : Integer;
begin
  IF NOT (FileExists(TempPath+'\REG$$$.$$1') AND
    FileExists(TempPath+'\DSK$$$.$$1') AND
    FileExists(TempPath+'\INI$$$.$$1') AND
    FileExists(TempPath+'\TXT$$$.$$1')) THEN
    begin
      MessageBox(Handle, 'At least one of the temporary files from '+
        'InCtrl5''s pre-install snapshot is missing. The program ca'+
        'nnot complete its analysis, and will terminate.', 'InCtrl5',
        MB_OK OR MB_ICONSTOP);
      StopThePresses;
      Status := stat_done;
      Close;
    end;
  IF BadTemp(TempPath+'\REG$$$.$$1', codeReg) OR
    BadTemp(TempPath+'\DSK$$$.$$1', codeDsk) OR
    BadTemp(TempPath+'\INI$$$.$$1', codeINI) OR
    BadTemp(TempPath+'\TXT$$$.$$1', codeTxt) THEN
    begin
      MessageBox(Handle, 'At least one of the temporary files from '+
        'InCtrl5''s pre-install snapshot has been corrupted or over'+
        'written. The program cannot complete its analysis, and wil'+
        'l terminate.', 'InCtrl5',
        MB_OK OR MB_ICONSTOP);
      StopThePresses;
      Status := stat_done;
      Close;
    end;
  TwoPhase := 0;
  try
    IF ProcMsgTerminated THEN Exit;
    IF status = stat_btwnonly THEN
      Status := stat_postonly
    ELSE
      Status := stat_post;
    RefreshShapes;
    // Save post-install snapshot for Registry
    pbMain.Position := 0;
    pbMax := GetStreamCount(TempPath+'\REG$$$.$$1');
    IF pbMax = -1 THEN
      Raise(Exception.Create(TempPath+'\REG$$$.$$1 is incomplete'))
    ELSE
      pbMain.Max := pbMax;
    pbMain.Smooth := pbMain.Max <> 0;
    IF pbMain.Max = 0 THEN pbMain.Max := 100;
    PutShape(5);
    Stream := TFileStream.Create(TempPath+'\REG$$$.$$2',
      fmCreate OR fmShareExclusive);
    try
      RegTemp := TStringList.Create;
      try
        RegTemp.AddStrings(RexList);
        RegTemp.AddStrings(RegList);
        RememberRegistry(Stream, RegTemp, UpStatus);
      finally
        Regtemp.Free;
      end;
    finally
      Stream.Free;
    end;
    IF ProcMsgTerminated THEN Exit;
    // Save post-install snapshot for Disk contents
    pbMain.Position := 0;
    pbMax := GetStreamCount(TempPath+'\DSK$$$.$$1');
    IF pbMax = -1 THEN
      Raise(Exception.Create(TempPath+'\DSK$$$.$$1 is incomplete'))
    ELSE
      pbMain.Max := pbMax;
    pbMain.Smooth := pbMain.Max <> 0;
    IF pbMain.Max = 0 THEN pbMain.Max := 100;
    PutShape(6);
    Stream := TFileStream.Create(TempPath+'\DSK$$$.$$2',
      fmCreate OR fmShareExclusive);
    try
      RememberDisk(Stream, DirList, UpStatus);
    finally
      Stream.Free;
    end;
    IF ProcMsgTerminated THEN Exit;
    // Save post-install snapshot for INI files
    pbMain.Position := 0;
    pbMax := GetStreamCount(TempPath+'\INI$$$.$$1');
    IF pbMax = -1 THEN
      Raise(Exception.Create(TempPath+'\INI$$$.$$1 is incomplete'))
    ELSE
      pbMain.Max := pbMax;
    pbMain.Smooth := pbMain.Max <> 0;
    IF pbMain.Max = 0 THEN pbMain.Max := 100;
    PutShape(7);
    Stream := TFileStream.Create(TempPath+'\INI$$$.$$2',
      fmCreate OR fmShareExclusive);
    try
      RememberInis(Stream, IniList, UpStatus);
    finally
      Stream.Free;
    end;
    IF ProcMsgTerminated THEN Exit;
    // Save post-install snapshot for Text files
    pbMain.Position := 0;
    pbMax := GetStreamCount(TempPath+'\TXT$$$.$$1');
    IF pbMax = -1 THEN
      Raise(Exception.Create(TempPath+'\TXT$$$.$$1 is incomplete'))
    ELSE
      pbMain.Max := pbMax;
    pbMain.Smooth := pbMain.Max <> 0;
    IF pbMain.Max = 0 THEN pbMain.Max := 100;
    PutShape(8);
    Stream := TFileStream.Create(TempPath+'\TXT$$$.$$2',
      fmCreate OR fmShareExclusive);
    try
      RememberTxt(Stream, TxtList, UpStatus);
    finally
      Stream.Free;
    end;
    IF ProcMsgTerminated THEN Exit;
    pbMain.Position := 0;
    PutShape(-1);
    sbMain.SimpleText := '';
    Stage_Compare;
  finally
    Application.Tag := 0;
  end;
end;

function CusSort(List: TStringList; Index1,
  Index2: Integer): Integer;
// Used in sorting text-file lines back into original order
VAR L1, L2 : Integer;
begin
  L1 := TChangeObj(List.Objects[Index1]).Locn1;
  L2 := TChangeObj(List.Objects[Index2]).Locn1;
  IF L1 < L2 THEN Result := -1
  ELSE IF L1 > L2 THEN Result := 1
  ELSE Result := AnsiCompareStr(List[Index1], List[Index2]);
end;

procedure TMainForm.Stage_Compare;
VAR
  fAddNode   : TStringList;
  fDelNode   : TStringList;
  fAddLeaf   : TStringList;
  fDelLeaf   : TStringList;
  fChaLeaf   : TStringList;
  Th, Tt, Tc : TextFile;

  procedure CleanUpDiskLists;
    procedure StripSysFiles(L : TStringList);
    // Ignore certain system files
    VAR
      N : Integer;
      S : String;
    begin
      IF L.Count = 0 THEN Exit;
      FOR N := L.Count-1 DOWNTO 0 DO
        begin
          S := Uppercase(ExtractFileName(L[N]));
          IF S = '386SPART.PAR' THEN L.Delete(N);
          IF S = 'WIN386.SWP' THEN L.Delete(N);
          IF S = 'PAGEFILE.SYS' THEN L.Delete(N);
          IF S = 'USER.DAT' THEN L.Delete(N);
          IF S = 'USER.DA0' THEN L.Delete(N);
          IF S = 'SYSTEM.DAT' THEN L.Delete(N);
          IF S = 'SYSTEM.DA0' THEN L.Delete(N);
        end;
    end;

    procedure StripOurOwn(L : TStringList);
    VAR
      N : Integer;
      S : String;
    begin
      FOR N := L.Count-1 DOWNTO 0 DO
        begin
          S := lowercase(L[N]);
          IF Pos(OurPath, S) <> 0 THEN
            L.Delete(N)
          ELSE IF Pos(TempPath, S) <> 0 THEN
            L.Delete(N)
          ELSE IF Pos(ReptPath, S) <> 0 THEN
            L.Delete(N);
        end;
      end;
  begin
    ReptPath := lowercase(ReptPath);
    TempPath := lowercase(TempPath);
    StripSysFiles(fAddNode); StripOurOwn(fAddNode);
    StripSysFiles(fDelNode); StripOurOwn(fDelNode);
    StripSysFiles(fAddLeaf); StripOurOwn(fAddLeaf);
    StripSysFiles(fDelLeaf); StripOurOwn(fDelLeaf);
    StripSysFiles(fChaLeaf); StripOurOwn(fChaLeaf);
  end;

  procedure DoRegistry;
  VAR
    N          : Integer;
    TFSO, TFSN : TFileStream;
  begin
    try
      pbMain.Position := 0;
      pbMain.Max := GetStreamCount(TempPath+'\REG$$$.$$1');
      pbMain.Smooth := pbMain.Max <> 0;
      IF pbMain.Max = 0 THEN pbMain.Max := 100;
      PutShape(9);
      TFSO := TFileStream.Create(TempPath+'\REG$$$.$$1',
        fmOpenRead OR fmShareExclusive);
      TFSN := TFileStream.Create(TempPath+'\REG$$$.$$2',
        fmOpenRead OR fmShareExclusive);
      try
        CompareStreams(TRegCompObj, codeReg, TFSO, TFSN,
          fAddNode, fDelNode, fAddLeaf, fDelLeaf, fChaLeaf,
          UpStatus);
        ReptLine(Th, Tt, Tc);
        ReptSecHeader(Th, Tt, Tc, 'Registry', 'REG');
        ReptBList(Th, Tt, Tc, 'Keys', 'ignored', RegList);
        ReptMinor(Th, Tt, Tc, 'Keys', 'added', fAddNode.Count);
        ReptListEZ(Th, Tt, Tc, fAddNode);
        ReptMinor(Th, Tt, Tc, 'Keys', 'deleted', fDelNode.Count);
        ReptListEZ(Th, Tt, Tc, fDelNode);
        ReptMinor(Th, Tt, Tc, 'Values', 'added', fAddLeaf.Count);
        IF fAddLeaf.Count > 0 THEN
          begin
            ReptListOn(Th, Tt, Tc);
            FOR N := 0 TO fAddLeaf.Count-1 DO
              WITH TChangeObj(fAddLeaf.Objects[N]) DO
                begin
                  ReptListLine(Th, Tt, Tc, PartPath, JustName, '"');
                  ReptListValue(Th, Tt, Tc, 'Type', RegType1);
                  ReptListValue(Th, Tt, Tc, 'Data', RegData1);
                  ReptListLineDone(Th, Tt, Tc);
                  Free;
                end;
            ReptListOff(Th, Tt, Tc);
          end;
        ReptMinor(Th, Tt, Tc, 'Values', 'deleted', fDelLeaf.Count);
        IF fDelLeaf.Count > 0 THEN
          begin
            ReptListOn(Th, Tt, Tc);
            FOR N := 0 TO fDelLeaf.Count-1 DO
              WITH TChangeObj(fDelLeaf.Objects[N]) DO
                begin
                  ReptListLine(Th, Tt, Tc, PartPath, JustName, '"');
                  ReptListValue(Th, Tt, Tc, 'Type', RegType1);
                  ReptListValue(Th, Tt, Tc, 'Data', RegData1);
                  ReptListLineDone(Th, Tt, Tc);
                  Free;
                end;
            ReptListOff(Th, Tt, Tc);
          end;
        ReptMinor(Th, Tt, Tc, 'Values', 'changed', fChaLeaf.Count);
        IF fChaLeaf.Count > 0 THEN
          begin
            ReptListOn(Th, Tt, Tc);
            FOR N := 0 TO fChaLeaf.Count-1 DO
              WITH TChangeObj(fChaLeaf.Objects[N]) DO
                begin
                  ReptListLine(Th, Tt, Tc, PartPath, JustName, '"');
                  ReptListValue(Th, Tt, Tc, 'Old type', RegType1);
                  ReptListValue(Th, Tt, Tc, 'New type', RegType2);
                  ReptListValue(Th, Tt, Tc, 'Old data', RegData1);
                  ReptListValue(Th, Tt, Tc, 'New data', RegData2);
                  ReptListLineDone(Th, Tt, Tc);
                  Free;
                end;
            ReptListOff(Th, Tt, Tc);
          end;
       ReptSecFooter(Th, Tt, Tc);
      finally
        TFSO.Free;
        TFSN.Free;
      end;
    except
      ON E:Exception DO
        ReptError(Th, Tt, Tc, '*ERROR* ' + E.Message);
    end;
  end;

  procedure DoDisk;
  VAR
    N          : Integer;
    TFSO, TFSN : TFileStream;
  begin
    try
      pbMain.Position := 0;
      pbMain.Max := GetStreamCount(TempPath+'\DSK$$$.$$1');
      pbMain.Smooth := pbMain.Max <> 0;
      IF pbMain.Max = 0 THEN pbMain.Max := 100;
      PutShape(10);
      TFSO := TFileStream.Create(TempPath+'\DSK$$$.$$1',
        fmOpenRead OR fmShareExclusive);
      TFSN := TFileStream.Create(TempPath+'\DSK$$$.$$2',
        fmOpenRead OR fmShareExclusive);
      try
        CompareStreams(TDskCompObj, codeDsk, TFSO, TFSN,
          fAddNode, fDelNode, fAddLeaf, fDelLeaf, fChaLeaf,
          UpStatus);
        CleanUpDiskLists;
        ReptLine(Th, Tt, Tc);
        ReptSecHeader(Th, Tt, Tc, 'Disk contents', 'DSK');
        ReptBList(Th, Tt, Tc, 'Drives', 'tracked', DirList);
        ReptMinor(Th, Tt, Tc, 'Folders', 'added', fAddNode.Count);
        ReptListEZ(Th, Tt, Tc, fAddNode);
        ReptMinor(Th, Tt, Tc, 'Folders', 'deleted', fDelNode.Count);
        ReptListEZ(Th, Tt, Tc, fDelNode);
        ReptMinor(Th, Tt, Tc, 'Files', 'added', fAddLeaf.Count);
        IF fAddLeaf.Count > 0 THEN
          begin
            ReptListOn(Th, Tt, Tc);
            FOR N := 0 TO fAddLeaf.Count-1 DO
              WITH TChangeObj(fAddLeaf.Objects[N]) DO
                begin
                  ReptListLine(Th, Tt, Tc, FinalSlash(PartPath),
                    JustName, '');
                  ReptListValue(Th, Tt, Tc, 'Date', DskDate1);
                  ReptListValue(Th, Tt, Tc, 'Size', DskSize1);
                  ReptListLineDone(Th, Tt, Tc);
                  Free;
                end;
            ReptListOff(Th, Tt, Tc);
          end;
        ReptMinor(Th, Tt, Tc, 'Files', 'deleted', fDelLeaf.Count);
        IF fDelLeaf.Count > 0 THEN
          begin
            ReptListOn(Th, Tt, Tc);
            FOR N := 0 TO fDelLeaf.Count-1 DO
              WITH TChangeObj(fDelLeaf.Objects[N]) DO
                begin
                  ReptListLine(Th, Tt, Tc, FinalSlash(PartPath),
                    JustName, '');
                  ReptListValue(Th, Tt, Tc, 'Date', DskDate1);
                  ReptListValue(Th, Tt, Tc, 'Size', DskSize1);
                  ReptListLineDone(Th, Tt, Tc);
                  Free;
                end;
            ReptListOff(Th, Tt, Tc);
          end;
        ReptMinor(Th, Tt, Tc, 'Files', 'changed', fChaLeaf.Count);
        IF fChaLeaf.Count > 0 THEN
          begin
            ReptListOn(Th, Tt, Tc);
            FOR N := 0 TO fChaLeaf.Count-1 DO
              WITH TChangeObj(fChaLeaf.Objects[N]) DO
                begin
                  ReptListLine(Th, Tt, Tc, FinalSlash(PartPath),
                    JustName, '');
                  ReptListValue(Th, Tt, Tc, 'Old date', DskDate1);
                  ReptListValue(Th, Tt, Tc, 'New date', DskDate2);
                  ReptListValue(Th, Tt, Tc, 'Old size', DskSize1);
                  ReptListValue(Th, Tt, Tc, 'New size', DskSize2);
                  ReptListLineDone(Th, Tt, Tc);
                  Free;
                end;
            ReptListOff(Th, Tt, Tc);
          end;
        ReptSecFooter(Th, Tt, Tc);
      finally
        TFSO.Free;
        TFSN.Free;
      end;
    except
      ON E:Exception DO
        ReptError(Th, Tt, Tc, '*ERROR* ' + E.Message);
    end;
  end;

  procedure DoInis;
  VAR
    N            : Integer;
    TFSO, TFSN   : TFileStream;
  begin
    try
      pbMain.Position := 0;
      pbMain.Max := GetStreamCount(TempPath+'\INI$$$.$$1');
      pbMain.Smooth := pbMain.Max <> 0;
      IF pbMain.Max = 0 THEN pbMain.Max := 100;
      PutShape(11);
      TFSO := TFileStream.Create(TempPath+'\INI$$$.$$1',
        fmOpenRead OR fmShareExclusive);
      TFSN := TFileStream.Create(TempPath+'\INI$$$.$$2',
        fmOpenRead OR fmShareExclusive);
      try
        CompareStreams(TIniCompObj, codeIni, TFSO, TFSN,
          fAddNode, fDelNode, fAddLeaf, fDelLeaf, fChaLeaf,
          UpStatus);
        ReptLine(Th, Tt, Tc);
        ReptSecHeader(Th, Tt, Tc, 'INI file', 'INI');
        ReptBList(Th, Tt, Tc, 'Ini files', 'tracked', IniList);
        ReptMinor(Th, Tt, Tc, 'Sections', 'added', fAddNode.Count);
        ReptListEZ(Th, Tt, Tc, fAddNode);
        ReptMinor(Th, Tt, Tc, 'Sections', 'deleted', fDelNode.Count);
        ReptListEZ(Th, Tt, Tc, fDelNode);
        ReptMinor(Th, Tt, Tc, 'Keys', 'added', fAddLeaf.Count);
        IF fAddLeaf.Count > 0 THEN
          begin
            ReptListOn(Th, Tt, Tc);
            FOR N := 0 TO fAddLeaf.Count-1 DO
              WITH TChangeObj(fAddLeaf.Objects[N]) DO
                begin
                  ReptListLine(Th, Tt, Tc, Path[0] + ', ' + Path[1],
                    JustName, '"');
                  ReptListValue(Th, Tt, Tc, 'Value', IniValu1);
                  ReptListLineDone(Th, Tt, Tc);
                  Free;
                end;
            ReptListOff(Th, Tt, Tc);
          end;
        ReptMinor(Th, Tt, Tc, 'Keys', 'deleted', fDelLeaf.Count);
        IF fDelLeaf.Count > 0 THEN
          begin
            ReptListOn(Th, Tt, Tc);
            FOR N := 0 TO fDelLeaf.Count-1 DO
              WITH TChangeObj(fDelLeaf.Objects[N]) DO
                begin
                  ReptListLine(Th, Tt, Tc, Path[0] + ', ' + Path[1],
                    JustName, '"');
                  ReptListValue(Th, Tt, Tc, 'Value', IniValu1);
                  ReptListLineDone(Th, Tt, Tc);
                  Free;
                end;
            ReptListOff(Th, Tt, Tc);
          end;
        ReptMinor(Th, Tt, Tc, 'Keys', 'changed', fChaLeaf.Count);
        IF fChaLeaf.Count > 0 THEN
          begin
            ReptListOn(Th, Tt, Tc);
            FOR N := 0 TO fChaLeaf.Count-1 DO
              WITH TChangeObj(fChaLeaf.Objects[N]) DO
                begin
                  ReptListLine(Th, Tt, Tc, Path[0] + ', ' + Path[1],
                    JustName, '"');
                  ReptListValue(Th, Tt, Tc, 'Old value', IniValu1);
                  ReptListValue(Th, Tt, Tc, 'New value', IniValu2);
                  ReptListLineDone(Th, Tt, Tc);
                  Free;
                end;
            ReptListOff(Th, Tt, Tc);
          end;
        ReptSecFooter(Th, Tt, Tc);
      finally
        TFSO.Free;
        TFSN.Free;
      end;
    except
      ON E:Exception DO
        ReptError(Th, Tt, Tc, '*ERROR* ' + E.Message);
    end;
  end;

  procedure DoTexts;
  VAR
    N : Integer;
    TFSO, TFSN : TFileStream;

    procedure ReOrder(TS : TStrings);
    VAR TempS : TStringList;
    begin
      TempS := TStringList.Create;
      try
        TempS.Assign(TS);
        TempS.CustomSort(CusSort);
        TS.Assign(TempS);
      finally
        TempS.Free;
      end;
    end;

  begin
    try
      pbMain.Position := 0;
      pbMain.Max := GetStreamCount(TempPath+'\TXT$$$.$$1');
      pbMain.Smooth := pbMain.Max <> 0;
      IF pbMain.Max = 0 THEN pbMain.Max := 100;
      PutShape(12);
      TFSO := TFileStream.Create(TempPath+'\TXT$$$.$$1',
        fmOpenRead OR fmShareExclusive);
      TFSN := TFileStream.Create(TempPath+'\TXT$$$.$$2',
        fmOpenRead OR fmShareExclusive);
      try
        CompareStreams(TTxtCompObj, codeTxt, TFSO, TFSN,
          fAddNode, fDelNode, fAddLeaf, fDelLeaf, fChaLeaf,
          UpStatus);
        ReOrder(fAddLeaf);
        ReOrder(fDelLeaf);
        ReOrder(fChaLeaf);
        ReptLine(Th, Tt, Tc);
        ReptSecHeader(Th, Tt, Tc, 'Text file', 'TXT');
        ReptBList(Th, Tt, Tc, 'Text files', 'tracked', TxtList);
        ReptMinor(Th, Tt, Tc, 'Text files', 'deleted', fDelNode.Count);
        ReptListEZ(Th, Tt, Tc, fDelNode);
        ReptMinor(Th, Tt, Tc, 'Lines', 'added', fAddLeaf.Count);
        IF fAddLeaf.Count > 0 THEN
          begin
            ReptListOn(Th, Tt, Tc);
            FOR N := 0 TO fAddLeaf.Count-1 DO
              WITH TChangeObj(fAddLeaf.Objects[N]) DO
                begin
                  ReptListLine(Th, Tt, Tc, Path[0], JustName, '"');
                  ReptListValue(Th, Tt, Tc, 'Locn', TxtLocn1);
                  ReptListLineDone(Th, Tt, Tc);
                  Free;
                end;
            ReptListOff(Th, Tt, Tc);
          end;
        ReptMinor(Th, Tt, Tc, 'Lines', 'deleted', fDelLeaf.Count);
        IF fDelLeaf.Count > 0 THEN
          begin
            ReptListOn(Th, Tt, Tc);
            FOR N := 0 TO fDelLeaf.Count-1 DO
              WITH TChangeObj(fDelLeaf.Objects[N]) DO
                begin
                  ReptListLine(Th, Tt, Tc, Path[0], JustName, '"');
                  ReptListValue(Th, Tt, Tc, 'Locn', TxtLocn1);
                  ReptListLineDone(Th, Tt, Tc);
                  Free;
                end;
            ReptListOff(Th, Tt, Tc);
          end;
        ReptMinor(Th, Tt, Tc, 'Lines', 'moved', fChaLeaf.Count);
        IF fChaLeaf.Count > 0 THEN
          begin
            ReptListOn(Th, Tt, Tc);
            FOR N := 0 TO fChaLeaf.Count-1 DO
              WITH TChangeObj(fChaLeaf.Objects[N]) DO
                begin
                  ReptListLine(Th, Tt, Tc, Path[0], JustName, '"');
                  ReptListValue(Th, Tt, Tc, 'Old Locn', TxtLocn1);
                  ReptListValue(Th, Tt, Tc, 'New Locn', TxtLocn2);
                  ReptListLineDone(Th, Tt, Tc);
                  Free;
                end;
            ReptListOff(Th, Tt, Tc);
          end;
        ReptSecFooter(Th, Tt, Tc);
      finally
        TFSO.Free;
        TFSN.Free;
      end;
    except
      ON E:Exception DO
        ReptError(Th, Tt, Tc, '*ERROR* ' + E.Message);
    end;
  end;

begin
  try
    IF ProcMsgTerminated THEN Exit;
    Status := stat_comp;
    RefreshShapes;
    fAddNode := TStringList.Create;
    fDelNode := TStringList.Create;
    fAddLeaf := TStringList.Create;
    fDelLeaf := TStringList.Create;
    fChaLeaf := TStringList.Create;
    HtmName  := NoFinalSlash(ReptPath)+'\EXTRARPT.HTM';
    TxtName  := NoFinalSlash(ReptPath)+'\EXTRARPT.TXT';
    CsvName  := NoFinalSlash(ReptPath)+'\EXTRARPT.CSV';
    CASE ReptFormat OF
      1 : HtmName := ebReportName.Text;
      2 : TxtName := ebReportName.Text;
      3 : CsvName := ebReportName.Text;
    end;
    AssignFile(Th, HtmName);
    AssignFile(Tt, TxtName);
    AssignFile(Tc, CsvName);
    ReptHeader(Th, Tt, Tc, ebName.Text, ebInstallprog.Text + ' ' +
      ebParams.Text, GetVersionString(Application.ExeName,
      'FileVersion'));
    try
      DoRegistry;
      IF ProcMsgTerminated THEN Exit;
      DoDisk;
      IF ProcMsgTerminated THEN Exit;
      DoInis;
      IF ProcMsgTerminated THEN Exit;
      DoTexts;
      IF ProcMsgTerminated THEN Exit;
      pbMain.Position := 0;
      PutShape(-1);
    finally
      ReptLine(Th, Tt, Tc);
      ReptFooter(Th, Tt, Tc);
      fAddNode.Free;
      fDelNode.Free;
      fAddLeaf.Free;
      fDelLeaf.Free;
      fChaLeaf.Free;
      status := stat_done;
      btnCancelIns.Enabled := False;
      Refresh;
      Application.ProcessMessages;
      IF NoPrevu THEN Close
      ELSE
        WITH TReptForm.Create(Self) DO
        try
          sbMain.SimpleText := '';
          SetData(HtmName, TxtName, Csvname, ReptFormat);
          ShowModal;
        finally
          Free;
          Self.Notebook1.PageIndex := 0;
          ebInstallProg.Text       := '';
          ebParams.Text            := '';
          ebName.Text              := '(two-phase mode)';
          ebReportName.Text        := DefaultReportName;
        end;
    end;
  finally
    Application.Tag := 0;
  end;
end;

function TMainForm.StatusMsg: String;
// This function is used in processing the Cancel tracking button
// and in handling a CloseQuery while the program is active
const IfYou = #13#10#13#10'If you stop now, you will not get a repo'+
  'rt on this installation.';
begin
  CASE Status OF
    stat_none  : Result := '';
    stat_pre   : Result := 'InCtrl5 is recording a pre-install snap'+
      'shot of your system, in preparation for analyzing an install'+
      ' program.'#13#10#13#10'If you stop now, this information wil'+
      'l be discarded and the install program will not be launched.';
    stat_preonly   : Result := 'InCtrl5 is recording a pre-install '+
      'snapshot of your system, after which it will terminate.'#13+
      #10#13#10'If you stop now, this information will be discarded.';
    stat_inst  : Result := 'InCtrl5 has launched the install progra'+
      'm, and it is now running. '+IfYou;
    stat_btwnonly : IF TwoPhase = 1 THEN
        Result := 'InCtrl5 stored pre-install data the last time yo'+
          'u ran it. Now it is ready to finish analyzing the instal'+
          'lation. '+IfYou
      ELSE
        Result := 'Windows has restarted, and InCtrl5 is ready to f'+
          'inish analyzing the installation. '+IfYou;
    stat_btwn : Result := 'InCtrl5 has launched the install program'+
      ', and it appears to have finished. ' + IfYou;
    stat_postonly,
    stat_post  : Result := 'InCtrl5 is recording a post-install sna'+
      'pshot of your system. '+IfYou;
    stat_comp  : Result := 'InCtrl5 is busy comparing the pre-insta'+
      'll and post-install snapshots, to see what was changed by th'+
      'e install program. '+IfYou;
    stat_done  : Result := '';
  end;
end;

procedure TMainForm.ThdDone(Sender: TObject);
begin
  status         := stat_btwn;
  lbInst.Caption := 'Install may be complete';
  SetForegroundWindow(Self.Handle);
  IF NoWait THEN
    begin
      btnCompleteClick(btnComplete);
      NoWait := False;
    end;
end;

procedure TMainForm.UpStatus(const S: String; I: Integer);
begin
  IF pbMain.Smooth THEN
    pbMain.Position := I
  ELSE
    begin
      pbMain.Position := (pbMain.Position + 1) MOD pbMain.Max;
      IF S <> '' THEN
        sbMain.SimpleText := S;
    end;
end;

procedure TMainForm.WMQueryEndSession(VAR Msg: TWMQueryEndSession);
begin
  IF (status = stat_Inst) OR (status = stat_btwn) THEN
    begin
      StopThePresses;
      WITH TRegIniFile.Create(CurVerKey) DO
      try
        WriteString('RunOnce', 'INCTRL5', Application.ExeName);
      finally
        Free;
      end;
      WITH TIniFile.Create(IniName) DO
      try
        WriteInteger('TwoPhase', 'TwoPhase', 2);
        WriteString('TwoPhase', 'ReportDesc', ebName.Text);
        WriteString('TwoPhase', 'ReportName', ebReportName.Text);
        WriteString('TwoPhase', 'InstallProg', ebInstallProg.Text);
      finally
        Free;
      end;
    end;
  Msg.Result := 1;
end;

end.


