unit optbaseu;

// Copyright  2000 by Ziff Davis Media, Inc.
// Written by Neil J. Rubenking

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  StdCtrls, ExtCtrls, Dialogs;

type
  TOptForm = class(TForm)
    lbMain       : TListBox;
    Panel1       : TPanel;
      btnAdd     : TButton;
      btnRemove  : TButton;
      btnOK      : TButton;
      btnCancel  : TButton;
      btnHelp    : TButton;
      btnRestore : TButton;
    odINI        : TOpenDialog;
    odTXT        : TOpenDialog;
    procedure FormCreate      (Sender: TObject);
    procedure FormDestroy     (Sender: TObject);
    procedure FormActivate    (Sender: TObject);
    procedure lbMainClick     (Sender: TObject);
    procedure btnAddClick     (Sender: TObject);
    procedure btnRemoveClick  (Sender: TObject);
    procedure btnHelpClick    (Sender: TObject);
    procedure btnRestoreClick (Sender: TObject);
  private
    { Private declarations }
    FormType   : Integer;
    procedure doReg;
    procedure DoDisk;
    procedure DoIni;
    procedure DoText;
  public
    { Public declarations }
    procedure SetData(I : Integer; TS : TStringList);
  end;

var
  OptForm: TOptForm;
const
  optReg = 1;
  optDsk = 2;
  optIni = 3;
  optTxt = 4;

implementation
uses shlobj, activeX, AllFuncs, in5Share, pikigkey;

{$R *.DFM}

procedure TOptForm.FormCreate(Sender: TObject);
begin
  GetPosFmIni(Ininame, Self, True);
end;

procedure TOptForm.FormDestroy(Sender: TObject);
begin
  SetPosToIni(Ininame, Self, True);
end;

procedure TOptForm.FormActivate(Sender: TObject);
begin
  lbMain.Perform(LB_SETCURSEL, 0, 0);
end;

procedure TOptForm.lbMainClick(Sender: TObject);
begin
  WITH Sender AS TListBox DO
    btnRemove.Enabled := (ItemIndex >= 0);
end;

procedure TOptForm.btnAddClick(Sender: TObject);
begin
  CASE FormType OF
    optReg : doReg;
    optDsk : DoDisk;
    optIni : DoIni;
    optTxt : DoText;
  END;
end;

procedure TOptForm.btnRemoveClick(Sender: TObject);
VAR idx : Integer;
begin
  WITH lbMain DO
    begin
      IF ItemIndex = Items.Count - 1 THEN
        Idx := Items.Count-2
      ELSE Idx := ItemIndex;
      IF ItemIndex > -1 THEN
        Items.Delete(ItemIndex);
      ItemIndex := Idx;
      lbMain.Perform(LB_SETCURSEL, Idx, 0);
    end;
end;

procedure TOptForm.btnRestoreClick(Sender: TObject);
begin
  CASE FormType OF
    optReg : DefaultReg(lbMain.Items);
    optDsk : DefaultDsk(lbMain.Items);
    optIni : DefaultIni(lbMain.Items);
    optTxt : DefaultTxt(lbMain.Items);
  END;
end;

procedure TOptForm.btnHelpClick(Sender: TObject);
begin
  Application.HelpContext((Sender AS TButton).Tag);
end;

procedure TOptForm.doReg;
begin
  WITH TRegIgForm.Create(Self) DO
  try
    IF ShowModal = mrOK THEN
      CASE AddToHierList(lbMain.Items, Key) OF
        ADL_OK    :;
        ADL_BELOW : MessageBox(Handle, PChar(Format('The key "%s" w'+
          'as not added, because it is a subkey of another key that'+
          ' is already present in the list.', [Key])), 'InCtrl5',
            MB_OK OR MB_ICONINFORMATION);
        ADL_ABOVE : MessageBox(Handle, PChar(Format('The key "%s" w'+
          'as added, replacing one or more of its own subkeys in th'+
          'e list.', [key])), 'InCtrl5',MB_OK OR MB_ICONINFORMATION);
        ADL_DUPE  : MessageBox(Handle, PChar(Format('The key "%s" i'+
          's already present in the list.', [key])), 'InCtrl5',
          MB_OK OR MB_ICONINFORMATION);
      END;
  finally
    free;
  end;
end;

procedure BrowseCallBackProc(hWindow : HWND; uMsg : Integer;
  lParam : LPARAM; lpData : Integer); stdCall;
VAR buffer : ARRAY[0..MAX_PATH] OF Char;
  Drv : ARRAY[0..4] OF Char;
begin
  IF uMsg = BFFM_SELCHANGED THEN
    begin
      SHGetPathFromIDList(PItemIDList(lParam), buffer);
      // Display the current selection
      SendMessage(hWindow, BFFM_SETSTATUSTEXT, 0, Integer(@buffer));
      StrLCopy(Drv, Buffer, 3);
      // Enable the OK button only if this is a local or remote
      // hard disk
      CASE GetDriveType(Drv) OF
        DRIVE_FIXED,
        DRIVE_REMOTE : SendMessage(hWindow, BFFM_ENABLEOK, 0, 1);
        ELSE SendMessage(hWindow, BFFM_ENABLEOK, 0, 0);
      END;
    end;
end;

procedure TOptForm.DoDisk;
VAR
  TB     : TBrowseInfo;
  IDL    : PItemIdList;
  buffer : ARRAY[0..MAX_PATH] OF Char;
begin
  inherited;
  FillChar(TB, SizeOf(TB), 0);
  WITH TB DO
    begin
      SHGetSpecialFolderLocation(Handle, CSIDL_DRIVES, pIdlRoot);
      lpszTitle := 'Select a drive or folder for tracking';
      ulFlags := BIF_RETURNONLYFSDIRS OR BIF_DONTGOBELOWDOMAIN OR
        BIF_STATUSTEXT;
      lpfn := @BrowseCallBackProc;
    end;
  IDL := SHBrowseForFolder(TB);
  try
    IF IDL <> nil THEN
      begin
        SHGetPathFromIDList(IDL, Buffer);
        CASE AddToHierList(lbMain.Items, StrPas(Buffer)) OF
          ADL_OK    :;
          ADL_BELOW : MessageBox(Handle, PChar(Format('The folder "'+
            '%s" was not added, because it is a subfolder of anothe'+
            'r folder that is already present in the list.',
            [Buffer])), 'InCtrl5', MB_OK OR MB_ICONINFORMATION);
          ADL_ABOVE : MessageBox(Handle, PChar(Format('The folder "'+
            '%s" was added, replacing one or more of its own subfol'+
            'ders in the list.', [Buffer])), 'InCtrl5',
            MB_OK OR MB_ICONINFORMATION);
          ADL_DUPE  : MessageBox(Handle, PChar(Format('The folder "'+
            '%s" is already present in the list.', [Buffer])),
            'InCtrl5', MB_OK OR MB_ICONINFORMATION);
        END;
      end;
  finally
    CoTaskMemFree(TB.pIdlRoot);
    CoTaskMemFree(IDL);
  end;
end;

procedure TOptForm.DoText;
VAR Why : Integer;
const exp : ARRAY[1..5] OF String = (
  'does not exist.',
  'is over 64KB in size.',
  'contains non-text characters.',
  'contains more than 255 lines.',
  'contains lines over 255 characters long.');
begin
  WITH odTXT DO
    begin
      InitialDir := BootDrv;
      IF NOT Execute THEN Exit;
      IF lbMain.Items.IndexOf(lowercase(Filename)) >= 0 THEN
        MessageBox(Self.Handle, PChar(Format('"%s" is already prese'+
          'nt on the list.', [Filename])), 'InCtrl5',
          MB_OK OR MB_ICONSTOP)
      ELSE
        begin
          Why := ValidTxt(Filename);
          IF Why <> 0 THEN
            MessageBox(Self.Handle, PChar(Format('"%s" %s',
              [Filename, exp[Why]])), 'InCtrl5', MB_OK OR MB_ICONSTOP)
          ELSE lbMain.Items.Add(lowercase(Filename));
        end;
    end;
end;

procedure TOptForm.DoIni;
begin
  WITH odINI DO
    begin
      InitialDir := windir;
      Options := Options - [ofExtensionDifferent];
      IF NOT Execute THEN Exit;
      IF ofExtensionDifferent IN Options THEN
        IF MessageBox(Self.Handle, PChar(Format('"%s" does not have'+
          ' the .INI file extension. Add it anyway?',[Filename])),
          'InCtrl5', MB_YESNO OR MB_ICONQUESTION) <> idYes THEN
            Exit;
      IF lbMain.Items.IndexOf(lowercase(Filename)) >= 0 THEN
        MessageBox(Self.Handle, PChar(Format('"%s" is already prese'+
          'nt on the list.', [Filename])), 'InCtrl5',
          MB_OK OR MB_ICONSTOP)
      ELSE IF NOT ValidINI(Filename) THEN
        MessageBox(Self.Handle, PChar(Format('"%s" does not have th'+
          'e internal structure of an .INI file. You may want to tr'+
          'ack it as a text file.', [Filename])), 'InCtrl5',
          MB_OK OR MB_ICONSTOP)
      ELSE lbMain.Items.Add(lowercase(Filename));
    end;
end;

procedure TOptForm.SetData(I : Integer; TS : TStringList);
begin
  FormType := I;
  lbMain.Items.Assign(TS);
  CASE I OF
    optReg : Caption := 'InCtrl5 - registry keys to ignore';
    optDsk : Caption := 'InCtrl5 - disks / folders to track';
    optIni : Caption := 'InCtrl5 - INI files to track';
    optTxt : Caption := 'InCtrl5 - text files to track';
  END;
  WITH lbMain DO
    HelpContext := HelpContext - 1 + I;
  WITH btnAdd DO
    HelpContext := HelpContext - 1 + I;
  WITH btnRemove DO
    HelpContext := HelpContext - 1 + I;
  WITH btnHelp DO
    Tag := Tag - 1 + I;
end;

end.


