unit pathsu;

// Copyright  2000 by Ziff Davis Media, Inc.
// Written by Neil J. Rubenking

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls;

type
  TPathsForm = class(TForm)
    Label1       : TLabel;
    btnReports   : TButton;
    ebReportPath : TEdit;
    btnTemp      : TButton;
    ebTempPath   : TEdit;
    btnHelp      : TButton;
    btnCancel    : TButton;
    btnOK        : TButton;
    cbBoot       : TComboBox;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ebReportPathChange(Sender: TObject);
    procedure btnReportsClick(Sender: TObject);
    procedure btnTempClick(Sender: TObject);
    procedure btnHelpClick(Sender: TObject);
  private
    { Private declarations }
    procedure GetFolder(eb : TEdit; const S : String);
  public
    { Public declarations }
    procedure SetData(const ReptPath, TempPath, BootDrv : String);
    procedure GetData(VAR ReptPath, TempPath, BootDrv : String);
  end;

var
  PathsForm: TPathsForm;

implementation
uses IniFiles, shlobj, FileCtrl, AllFuncs, ActiveX;

{$R *.DFM}

procedure TPathsForm.FormCreate(Sender: TObject);
begin
  GetPosFmExeName(Application.Exename, Self, True);
  // These controls are anchored so they grow or move as the
  // form resizes. However, the GetPos... call goofs them up.
  // We initialize them to the correct size and position
  ebReportPath.Width := Width - ebReportPath.Left - 11;
  ebTempPath.Width   := Width - ebTempPath.Left - 11;
  btnOK.Left         := Width - btnOK.Width - 11;
  btnCancel.Left     := btnOK.Left - btnCancel.Width - 6;
  cbBoot.Items.Text  := LocalDrives(':\', #13#10, False);
end;

procedure TPathsForm.FormDestroy(Sender: TObject);
begin
  SetPosToExeName(Application.Exename, Self, True);
end;

procedure TPathsForm.ebReportPathChange(Sender: TObject);
begin
  btnOk.Enabled := DirectoryExists(ebReportPath.Text) AND
    DirectoryExists(ebTempPath.Text);
end;

procedure BrowseCallBackProc(hWindow : HWND; uMsg : Integer;
  lParam : LPARAM; lpData : Integer); stdCall;
VAR buffer : ARRAY[0..MAX_PATH] OF Char;
begin
  IF uMsg = BFFM_INITIALIZED THEN
    begin
      StrCopy(Buffer, PChar(lpData));
      StrPCopy(Buffer, NoFinalSlash(StrPas(Buffer)));
      // Set the starting directory
      SendMessage(hWindow, BFFM_SETSELECTION, 1, Integer(@buffer));
    end
  ELSE IF uMsg = BFFM_SELCHANGED THEN
    begin
      SHGetPathFromIDList(PItemIDList(lParam), buffer);
      // Display the current selection
      SendMessage(hWindow, BFFM_SETSTATUSTEXT, 0, Integer(@buffer));
    end;
end;

procedure TPathsForm.GetFolder(eb : TEdit; const S : String);
VAR
  TB     : TBrowseInfo;
  IDL    : PItemIdList;
  buffer : ARRAY[0..MAX_PATH] OF Char;
begin
  FillChar(TB, SizeOf(TB), 0);
  WITH TB DO
    begin
      SHGetSpecialFolderLocation(Handle, CSIDL_DRIVES, pIdlRoot);
      lpszTitle := PChar('InCtrl5 - Select default folder for '+ S);
      ulFlags := BIF_RETURNONLYFSDIRS OR BIF_DONTGOBELOWDOMAIN OR
        BIF_STATUSTEXT;
      lpfn   := @BrowseCallBackProc;
      StrPCopy(Buffer, eb.Text);
      lparam := Integer(@Buffer);
    end;
  IDL := SHBrowseForFolder(TB);
  try
    IF IDL <> nil THEN
      begin
        SHGetPathFromIDList(IDL, Buffer);
        eb.Text := StrPas(Buffer);
        CoTaskMemFree(IDL);
      end;
  finally
    CoTaskMemFree(TB.pIdlRoot);
  end;
end;

procedure TPathsForm.btnReportsClick(Sender: TObject);
begin
  GetFolder(ebReportPath, 'reports');
end;

procedure TPathsForm.btnTempClick(Sender: TObject);
begin
  GetFolder(ebTempPath, 'temp files');
end;

procedure TPathsForm.btnHelpClick(Sender: TObject);
begin
  Application.HelpContext(26);
end;

procedure TPathsForm.GetData(var ReptPath, TempPath, BootDrv: String);
begin
  ReptPath := FinalSlash(ebReportPath.Text);
  TempPath := FinalSlash(ebTempPath.Text);
  BootDrv  := cbBoot.Items[cbBoot.ItemIndex];
end;

procedure TPathsForm.SetData(const ReptPath, TempPath,
  BootDrv: String);
VAR Idx : Integer;
begin
  ebReportPath.Text := ReptPath;
  ebTempPath.Text   := TempPath;
  Idx := cbBoot.Items.IndexOf(Uppercase(BootDrv));
  IF Idx < 0 THEN Idx := 0;
  cbBoot.ItemIndex := Idx;
end;

end.

