unit pdthdu;

// Copyright  2000 by Ziff Davis Media, Inc.
// Written by Neil J. Rubenking

interface
uses Windows, Classes;
type
  //  Simple thread to wait for process's termination
  TProcDoneThread = class(TThread)
  private
    fProcHandle : THandle;
  public
    Constructor Create(vProcHandle: THandle;
      OnTerm: TNotifyEvent);
    procedure Execute; override;
  end;

procedure StopThePresses;

implementation
USES in5Share;

VAR AllStopEvent : THandle;

procedure StopThePresses;
begin
  SetEvent(AllStopEvent);
end;

constructor TProcDoneThread.Create(vProcHandle: THandle;
  OnTerm: TNotifyEvent);
begin
  Inherited Create(True);
  fProcHandle     := vProcHandle;
  OnTerminate     := OnTerm;
  FreeOnTerminate := True;
end;

procedure TProcDoneThread.Execute;
VAR Waits : ARRAY[0..1] OF THandle;
begin
  Waits[0] := fProcHandle;
  Waits[1] := AllStopEvent;
  WaitForMultipleObjects(2, @Waits, False, INFINITE);
  CloseHandle(fProcHandle);
end;

initialization
  AllStopEvent := CreateEvent(nil, True, False,
    'PC Magazine INCTRL5 AllStop Event');
  ResetEvent(AllStopEvent);
finalization
  ResetEvent(AllStopEvent);
  CloseHandle(AllStopEvent);
end.
