unit pikigkey;

// Copyright  2000 by Ziff Davis Media, Inc.
// Written by Neil J. Rubenking

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls;

type
  TRegIgForm = class(TForm)
    btnRegEdit  : TButton;
    btnGetKey   : TButton;
    ebKey       : TEdit;
    lbValid     : TStaticText;
    btnValidate : TButton;
    btnHelp     : TButton;
    btnOK       : TButton;
    btnCancel   : TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FlyoverMouseMove(Sender: TObject;
      Shift: TShiftState; X, Y: Integer);
    procedure btnRegEditClick(Sender: TObject);
    procedure btnGetKeyClick(Sender: TObject);
    procedure ebKeyChange(Sender: TObject);
    procedure btnValidateClick(Sender: TObject);
    procedure btnHelpClick(Sender: TObject);
  private
    { Private declarations }
    fKey        : String;
  public
    { Public declarations }
    property Key : String read fKey;
  end;

var
  RegIgForm: TRegIgForm;

implementation
USES ShellApi, in5Share, AllFuncs;

{$R *.DFM}

procedure TRegIgForm.FormCreate(Sender: TObject);
begin
  GetPosFmIni(Ininame, Self, True);
  // These components are "anchored" at the left, and they get
  // goofed up when the form's size is adjusted in OnCreate.
  // So, we set their initial position correctly
  ebkey.Left     := 4;
  lbValid.Left   := 4;
  ebKey.Width    := ClientWidth - 7;
  lbValid.Width  := ClientWidth - 7;
  btnOK.Left     := ClientWidth - 3 - btnOK.Width;
  btnCancel.Left := btnOK.Left - 10 - btnCancel.Width;
  btnHelp.Left   := btnCancel.Left - 10 - btnHelp.Width;
end;

procedure TRegIgForm.FormDestroy(Sender: TObject);
begin
  SetPosToIni(Ininame, Self, True);
end;

procedure TRegIgForm.FlyoverMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
// This method exists to enable flyover help for controls
// that are disabled
VAR
  P : TPoint;
  N : Integer;
begin
  P := Point(X,Y);
  WITH Sender AS TWinControl DO
    begin
      Hint := '';
      FOR N := 0 TO ControlCount-1 DO
        IF Controls[N] IS TWinControl THEN
          IF PtInRect(TWinControl(Controls[N]).BoundsRect, P) THEN
            Hint := TWinControl(Controls[N]).Hint;
      IF Hint = '' THEN
        Application.CancelHint;
    end;
end;

procedure TRegIgForm.btnRegEditClick(Sender: TObject);
VAR
  Buffer : ARRAY[0..MAX_PATH] OF Char;
  REH    : HWnd;
begin
  REH := FindWindow('RegEdit_RegEdit', nil);
  IF REH <> 0 THEN
    begin
      BringWindowToTop(REH);
      IF IsIconic(REH) THEN
        ShowWindow(REH, SW_RESTORE);
    end
  ELSE
    begin
      IF (FindExecutable('REGEDIT.EXE', nil, Buffer) <= 32) OR
        (WinExec(Buffer, SW_SHOWNORMAL) <= 32) THEN
        MessageBox(Handle, 'Please launch REGEDIT manually.',
          'InCtrl5', MB_OK OR MB_ICONINFORMATION);
    end;
end;

procedure TRegIgForm.btnGetKeyClick(Sender: TObject);
VAR
  REH    : HWnd;
  SBH    : HWnd;
  Buffer : ARRAY[0..2*MAX_PATH] OF Char;
  S      : String;
  P      : Integer;
begin
  REH := FindWindow('RegEdit_RegEdit', nil);
  IF REH > 0 THEN
    begin
      SBH := FindWindowEx(REH, 0, 'msctls_statusbar32', nil);
      IF SBH <> 0 THEN
        begin
          GetWindowText(SBH, Buffer, 2*MAX_PATH);
          SendMessage(SBH, WM_GETTEXT, 2*MAX_PATH, Integer(@Buffer));
          S := Strpas(Buffer);
          P := Pos('\', S);
          Delete(S, 1, P);
          ebKey.Text := S;
          btnValidateClick(btnValidate);
        end
      ELSE MessageBox(Handle, 'Unable to extract the key. Please co'+
        'py the key manually.', 'InCtrl5', MB_OK OR MB_ICONSTOP);
    end
  ELSE MessageBox(Handle, 'Unable to locate REGEDIT. Please be sure'+
    ' REGEDIT is running, or copy the key manually.', 'InCtrl5',
    MB_OK OR MB_ICONSTOP);
end;

procedure TRegIgForm.ebKeyChange(Sender: TObject);
begin
  lbValid.Caption     := '';
  btnOK.Enabled       := False;
  btnValidate.Enabled := True;
end;

procedure TRegIgForm.btnValidateClick(Sender: TObject);
VAR
  S     : String;
  P     : Integer;
begin
  S := trim(ebKey.Text);
  P := ValidReg(S);
  CASE P OF
    -1 : begin
      lbValid.Caption := 'Non-existent key, or access denied';
      btnOK.Enabled := False;
    end;
    0  : begin
          lbValid.Caption := 'Enter a non-empty subkey.';
          btnOK.Enabled := False;
    end;
    ELSE begin
      lbValid.Caption := 'Valid key';
      btnOK.Enabled := True;
      fKey := S;
    end;
  end;
  btnValidate.Enabled := False;
end;

procedure TRegIgForm.btnHelpClick(Sender: TObject);
begin
  Application.HelpContext(21);
end;


end.

