unit in5Repts;

// Copyright  2000 by Ziff Davis Media, Inc.
// Written by Neil J. Rubenking

interface

USES Windows, SysUtils, Classes, Grids;

// Each function writes a particular element of the program's
// output to each of the three different reports. This ensures
// that the contents of the reports are always consistent with
// each other.

procedure ReptHeader(VAR Th, Tt, Tc : TextFile; const reptName,
  progName, sVersion : String);
procedure ReptFooter(VAR Th, Tt, Tc : TextFile);
procedure ReptSecFooter(VAR Th, Tt, Tc : TextFile);
procedure ReptLine(VAR Th, Tt, Tc : TextFile);
procedure ReptSecHeader(VAR Th, Tt, Tc : TextFile;
  const S, link : String);
procedure ReptError(VAR Th, Tt, Tc : TextFile; const S : String);
procedure ReptMinor(VAR Th, Tt, Tc : TextFile; const Thing,
  Action : String; Num : Integer);
procedure ReptListEZ(VAR Th, Tt, Tc : TextFile; TS : TStringList);
procedure ReptBList(VAR Th, Tt, Tc : TextFile; const Thing,
  Action : String; TS : TStringList);
procedure ReptListOn(VAR Th, Tt, Tc : TextFile);
procedure ReptListLine(VAR Th, Tt, Tc : TextFile;
 const S, S1, Sep : String);
procedure ReptListValue(VAR Th, Tt, Tc : TextFile;
 const S, S1 : String);
procedure ReptListLineDone(VAR Th, Tt, Tc : TextFile);
procedure ReptListOff(VAR Th, Tt, Tc : TextFile);
procedure LoadCsv(SG : TStringGrid; const Nc : String);

implementation

VAR
  csv_Col1 : String;
  csv_Col2 : String;
  csv_Col3 : String;
  csv_Col4 : String;
  csv_Col5 : String;
  csv_Col6 : String;
  csv_Col7 : String;
  csv_Col8 : String;
  csv_Col9 : String;
  csv_ColN : Integer;

function CsvOut(S : ARRAY of String) : String;
VAR N : Integer;
begin
  Result := '';
  FOR N := 0 TO High(S)-1 DO
    Result := Result + AnsiQuotedStr(S[N],'"') + ListSeparator;
  Result := Result + AnsiQuotedStr(S[High(S)], '"');
end;

procedure ReptHeader(VAR Th, Tt, Tc  : TextFile; const reptName,
  progName, sVersion: String);
  procedure HTMLHeader(const progName : String);
  begin
    ReWrite(Th);
    try
      Write(Th, '<HTML><HEAD><TITLE> Installation Report: ');
      WriteLn(Th, reptName, '</TITLE></HEAD>');
      Write(Th, '<BODY><H1>Installation Report: ');
      WriteLn(Th, reptName, '</H1><P><I><FONT SIZE="+2">');
      WriteLn(Th, 'Generated by InCtrl5, version ',sVersion, '<BR>');
      WriteLn(Th, 'Install program: ', progName, '<BR>');
      Write(Th, FormatDateTime('m/d/yyyy h:nn AM/PM', Now));
      WriteLn(Th,'</FONT></I></P>');
      WriteLn(Th,'<H3><a name="TOC"></a>Contents</H3>');
      WriteLn(Th,'<UL><LI><a href="#REG">Registry</a>');
      WriteLn(Th,'<LI><a href="#DSK">Disk Contents</a>');
      WriteLn(Th,'<LI><a href="#INI">Ini Files</a>');
      WriteLn(Th,'<LI><a href="#TXT">Text Files</a></UL>');
    finally
      CloseFile(Th);
    end;
  end;

  procedure TxtHeader(const progName : String);
  begin
    ReWrite(Tt);
    try
      WriteLn(Tt, 'Installation Report: ', reptName);
      WriteLn(Tt, 'Generated by InCtrl5, version ', sVersion);
      WriteLn(Tt, 'Install program: ', progName);
      WriteLn(Tt, FormatDateTime('m/d/yyyy h:nn AM/PM', Now));
      WriteLn(Tt);
    finally
      CloseFile(Tt);
    end;
  end;

  procedure CsvHeader(const progName : String);
  begin
    ReWrite(Tc);
    try
      WriteLn(Tc, CsvOut(['Type', 'Thing', 'Action', 'Node',
        'Leaf', 'Data 1', 'Data 2', 'New data 1', 'New data 2']));
      WriteLn(Tc, CsvOut(['Header', 'Installation report',
        reptName]));
      WriteLn(Tc, CsvOut(['Header', 'Generated by', 'InCtrl5',
        'version '+sVersion]));
      WriteLn(Tc, CsvOut(['Header', 'Install program', progName]));
      WriteLn(Tc, CsvOut(['Header', FormatDateTime('mm/dd/yyyy',Now),
        FormatDateTime('hh:mm AM/PM', Now)]));
    finally
      CloseFile(Tc);
    end;
  end;

begin
  IF ProgName = '' THEN
    begin
      HTMLHeader('(none)');
      TxtHeader( '(none)');
      CsvHeader( '(none)');
    end
  ELSE
    begin
      HTMLHeader(progName);
      TxtHeader (progName);
      CsvHeader (progName);
    end;
end;

procedure ReptLine(VAR Th, Tt, Tc : TextFile);
  procedure HTMLLine;
  begin
    Append(Th);
    try     WriteLn(Th, '<HR SIZE="3">');
    finally CloseFile(Th);
    end;
  end;

  procedure TxtLine;
  begin
    Append(Tt);
    try     WriteLn(Tt, StringOfChar('-', 60));
    finally CloseFile(Tt);
    end;
  end;

  procedure CsvLine;
  VAR S : String;
  begin
    S := StringOfChar('-', 12);
    Append(Tc);
    try     WriteLn(Tc, CsvOut(['', S, S, S, S, S, S, S, S]));
    finally CloseFile(Tc);
    end;
  end;

begin
  HTMLLine;
  TxtLine ;
  CsvLine ;
end;

procedure ReptSecHeader(VAR Th, Tt, Tc : TextFile;
  const S, link : String);
  procedure HTMLMajor;
  begin
    Append(Th);
    try
      WriteLn(Th, '<H2><a name="', link, '"></a>', S, '</H2>');
    finally
      CloseFile(Th);
    end;
  end;

  procedure TxtMajor;
  begin
    Append(Tt);
    try
      WriteLn(Tt, S);
      WriteLn(Tt, StringOfChar('*', Length(S)));
    finally
      CloseFile(Tt);
    end;
  end;

  procedure CsvMajor;
  begin
    csv_Col1 := S;
    Append(Tc);
    try
      CASE S[1] OF
        'R' : WriteLn(Tc, CsvOut(['', 'Thing', 'Action',
          'Key name', 'Value name', 'Value type', 'New value type',
          'Value data', 'New value data']));
        'D' : WriteLn(Tc, CsvOut(['', 'Thing', 'Action',
          'Folder name', 'File name', 'File date', 'New file date',
          'File size', 'New file size']));
        'I' : WriteLn(Tc, CsvOut(['', 'Thing', 'Action',
          'File name ([section])', 'Section or key name',
          'Key value', 'New key value']));
        'T' : WriteLn(Tc, CsvOut(['', 'Thing', 'Action',
          'File name', 'Line of text', 'Position',
          'New position']));
        '*' : WriteLn(Tc, CsvOut([S]));
        ELSE Raise(Exception.Create('SQUAWK!'));
      end;
    finally
      CloseFile(Tc);
    end;
  end;
begin
  HTMLMajor;
  TxtMajor;
  CsvMajor;
end;

procedure ReptError(VAR Th, Tt, Tc : TextFile; const S : String);
  procedure HTMLError;
  begin
    Append(Th);
    try     WriteLn(Th, '<H2>', S, '</H2>');
    finally CloseFile(Th);
    end;
  end;

  procedure TxtError;
  begin
    Append(Tt);
    try
      WriteLn(Tt, S);
      WriteLn(Tt, StringOfChar('*', Length(S)));
    finally
      CloseFile(Tt);
    end;
  end;

  procedure CsvError;
  begin
    Append(Tc);
    try
      WriteLn(Tc, CsvOut([S]));
    finally
      CloseFile(Tc);
    end;
  end;
begin
  HTMLError;
  TxtError;
  CsvError;
end;

procedure ReptMinor(VAR Th, Tt, Tc : TextFile; const Thing,
  Action : String; Num : Integer);
  procedure HTMLMinor;
  begin
    Append(Th);
    try
      WriteLn(Th, '<H3><U>', thing, ' ', action, ': ',
        Num, '</U></H3>');
    finally
      CloseFile(Th);
    end;
  end;

  procedure TxtMinor;
  VAR S : String;
  begin
    Append(Tt);
    try
      WriteLn(Tt);
      S := Format('%s %s: %d', [thing, action, Num]);
      WriteLn(Tt, S);
      WriteLn(Tt, StringOfChar('-', Length(S)));
    finally
      CloseFile(Tt);
    end;
  end;

  procedure CsvMinor;
  begin
    csv_Col2 := Thing;
    csv_Col3 := Action;
  end;

begin
  IF Num = 0 THEN Exit; 
  HTMLMinor;
  TxtMinor;
  CsvMinor;
end;

procedure ReptFooter(VAR Th, Tt, Tc : TextFile);
  procedure HTMLFooter;
  begin
    Append(Th);
    try
      WriteLn(Th, '<P><FONT SIZE="2">');
      WriteLn(Th, 'InCtrl5, Copyright &copy;&nbsp;2000 ');
      WriteLn(Th, 'by Ziff Davis Media, Inc.<BR> </FONT>');
      WriteLn(Th, '<FONT SIZE="1">Written by Neil J. Rubenking<BR>');
      Write  (Th, 'First published in PC Magazine, ');
      WriteLn(Th, 'December 5, 2000.');
      WriteLn(Th, '</FONT> </P> <P></P> </BODY> </HTML>');
    finally
      CloseFile(Th);
    end;
  end;

  procedure TxtFooter;
  begin
    Append(Tt);
    try
      Write(Tt, #9'InCtrl5, Copyright  2000 ');
      WriteLn(Tt, 'by Ziff Davis Media, Inc.');
      WriteLn(Tt, #9'Written by Neil J. Rubenking');
      Write  (Tt, #9'First published in PC Magazine, ');
      WriteLn(Tt, 'December 5, 2000.');
    finally
      CloseFile(Tt);
    end;
  end;

  procedure CsvFooter;
  begin
    Append(Tc);
    try
      WriteLn(Tc, CsvOut(['Header', 'InCtrl5, Copyright  2000 '+
        'by Ziff Davis Media, Inc.']));
      WriteLn(Tc, CsvOut(['Header','Written by Neil J. Rubenking']));
      WriteLn(Tc, CsvOut(['Header', 'First published in PC '+
        'Magazine, December 5, 2000.']));
    finally
      CloseFile(Tc);
    end;
  end;
begin
  HTMLFooter;
  TxtFooter;
  CsvFooter;
end;

procedure ReptSecFooter(VAR Th, Tt, Tc : TextFile);
  procedure HTMLSecFooter;
  begin
    Append(Th);
    try
      WriteLn(Th, '<P><a href="#TOC">To Contents</a></P>');
    finally
      CloseFile(Th);
    end;
  end;
begin
  HTMLSecFooter;
end;

procedure ReptListEZ(VAR Th, Tt, Tc : TextFile; TS : TStringList);
  procedure HTMLListEZ;
  VAR N : Integer;
  begin
    Append(Th);
    try
      WriteLn(Th, '<DL>');
      FOR N := 0 TO TS.Count-1 DO WriteLn(Th, '<DT>', TS[N],'</DT>');
      WriteLn(Th, '</DL>');
    finally
      CloseFile(Th);
    end;
  end;

  procedure TxtListEZ;
  VAR N : Integer;
  begin
    Append(Tt);
    try
      FOR N := 0 TO TS.Count-1 DO WriteLn(Tt, #9, TS[N]);
    finally
      CloseFile(Tt);
    end;
  end;

  procedure CsvListEZ;
  VAR N : Integer;
  begin
    Append(Tc);
    try
      FOR N := 0 TO TS.Count-1 DO
        WriteLn(Tc, CsvOut([csv_Col1, csv_Col2, csv_Col3, TS[N]]));
    finally
      CloseFile(Tc);
    end;
  end;
begin
  IF TS.Count = 0 THEN Exit;
  HTMLListEZ;
  TxtListEZ;
  CsvListEZ;
end;

procedure ReptBList(VAR Th, Tt, Tc : TextFile; const Thing,
  Action : String; TS : TStringList);

  procedure HTMLBList;
  VAR N : Integer;
  begin
    Append(Th);
    try
      WriteLn(Th, '<H3><U>', thing, ' ', action, ': ',
        TS.Count, '</U></H3>');
      WriteLn(Th, '<UL>');
      IF TS.Count = 0 THEN
        WriteLn(Th, '<LI>(none)</LI>');
      FOR N := 0 TO TS.Count-1 DO
        WriteLn(Th, '<LI>', TS[N], '</LI>');
      WriteLn(Th, '</UL>');
    finally
      CloseFile(Th);
    end;
  end;

  procedure TxtBList;
  VAR
    N : Integer;
    S : String;
  begin
    Append(Tt);
    try
      WriteLn(Tt);
      S := Format('%s %s: %d', [thing, action, TS.Count]);
      WriteLn(Tt, S);
      WriteLn(Tt, StringOfChar('-', Length(S)));
      IF TS.Count = 0 THEN
        WriteLn(Tt, #9'* (none)');
      FOR N := 0 TO TS.Count-1 DO
        WriteLn(Tt, #9'* ', TS[N]);
    finally
      CloseFile(Tt);
    end;
  end;

  procedure CsvBList;
  VAR N : Integer;
  begin
    csv_Col2 := Thing;
    csv_Col3 := Action;
    Append(Tc);
    try
      IF TS.Count = 0 THEN
        WriteLn(Tc, CsvOut([csv_Col1, csv_Col2, csv_Col3,
          '(none)']));
      FOR N := 0 TO TS.Count-1 DO
        WriteLn(Tc, CsvOut([csv_Col1, csv_Col2, csv_Col3,
          TS[N]]));
    finally
      CloseFile(Tc);
    end;
  end;
begin
  HTMLBList;
  TxtBList;
  CsvBList;
end;

procedure ReptListOn(VAR Th, Tt, Tc : TextFile);
// Applies only to HTML report
begin
  Append(Th);
  try     WriteLn(Th, '<DL>');
  finally CloseFile(Th);
  end;
end;

procedure ReptListLine(VAR Th, Tt, Tc : TextFile;
 const S, S1, Sep : String);
  procedure HTMLListLine;
  begin
    Append(Th);
    try
      IF S1 = '' THEN
        WriteLn(Th, '<DT>', S,'</DT>')
      ELSE IF Sep = '"' THEN
        WriteLn(Th, '<DT>', S, ' <I>"', S1, '"</I></DT>')
      ELSE
        WriteLn(Th, '<DT>', S, Sep, '<I>', S1, '</I></DT>');
    finally
      CloseFile(Th);
    end;
  end;

  procedure TxtListLine;
  begin
    Append(Tt);
    try
      IF S1 = '' THEN
        WriteLn(Tt, #9, S)
      ELSE IF Sep = '"' THEN
        WriteLn(Tt, #9, S, ' "', S1, '"')
      ELSE
        WriteLn(Tt, #9, S, Sep, S1);
    finally
      CloseFile(Tt);
    end;
  end;

  procedure CsvListLine;
  begin
    csv_Col4 := S;
    csv_Col5 := S1;
    csv_Col6 := '';
    csv_Col7 := '';
    csv_Col8 := '';
    csv_Col9 := '';
    csv_ColN := 6;
  end;
begin
  HTMLListLine;
  TxtListLine;
  CsvListLine;
end;

procedure ReptListValue(VAR Th, Tt, Tc : TextFile;
 const S, S1 : String);
  procedure HTMLListValue;
  begin
    Append(Th);
    try
      WriteLn(Th, '<DD><TT>', S, ': <I>', S1, '</I></DD></TT>');
    finally
      CloseFile(Th);
    end;
  end;

  procedure TxtListValue;
  begin
    Append(Tt);
    try
      WriteLn(Tt, #9#9, S, ': ', S1);
    finally
      CloseFile(Tt);
    end;
  end;

  procedure CsvListValue;
  begin
    CASE csv_ColN OF
      6 : csv_Col6 := S1;
      7 : csv_Col7 := S1;
      8 : csv_Col8 := S1;
      9 : csv_Col9 := S1;
    END;
    Inc(csv_ColN);
  end;
begin
  HTMLListValue;
  TxtListValue;
  CsvListValue;
end;

procedure ReptListLineDone(VAR Th, Tt, Tc : TextFile);
// Applies only to CSV report
begin
  Append(Tc);
  try
    WriteLn(Tc, CsvOut([csv_Col1, csv_Col2, csv_Col3, csv_Col4,
      csv_Col5, csv_Col6, csv_Col7, csv_Col8, csv_Col9]));
  finally
    CloseFile(Tc);
  end;
end;

procedure ReptListOff(VAR Th, Tt, Tc : TextFile);
begin
  Append(Th);
  try     WriteLn(Th, '</DL>');
  finally CloseFile(Th);
  end;
end;

procedure LoadCsv(SG : TStringGrid; const Nc : String);
// Load a file of comma-separated-values lines into a string grid
VAR
  T : TextFile;
  S : String;
  ro : Integer;
begin
  AssignFile(T, Nc);
  Reset(T);
  try
    ReadLn(T, S);
    SG.Rows[0].CommaText := S;
    ReadLn(T, S);
    SG.Rows[1].CommaText := S;
    ro := 2;
    WHILE NOT EoF(T) DO
      begin
        ReadLn(T, S);
        IF S = '' THEN Continue;
        SG.RowCount := ro+1;
        SG.Rows[ro].CommaText := S;
        Inc(ro);
      end;
  finally
    CloseFile(T);
  end;
end;

end.
