
;-*- Quadrocopter (Quadrotor) Controller V2 -*-
;-*-     All Code And Hardware Design       -*-
;-*-      By Rolf R Bakke,  Feb 2010        -*-

; (I have not peeked in others projects or code :-)

; Code is best viewed in monospace font and tab = 8




;   View from above

;      Forward

;       M1,CW
;         *
;         |
; M2,CCW  |   M3,CCW
;   *-----+-----*
;         |
;         |
;         *
;       M4,CW






.include "m48def.inc"

;---  16.16 bit signed registers ---

.equ	temp				=0

.equ	rxin_roll			=1
.equ	rxin_pitch			=2
.equ	rxin_yaw			=3
.equ	rxin_collective			=4
.equ	rxin_aux			=5

.equ	gyro_in_roll			=6
.equ	gyro_in_pitch			=7
.equ	gyro_in_yaw			=8

.equ	gyrozero_roll			=9
.equ	gyrozero_pitch			=10
.equ	gyrozero_yaw			=11

.equ	motor_out_1			=12
.equ	motor_out_2			=13
.equ	motor_out_3			=14
.equ	motor_out_4			=15

.equ	gyro_zero_set_delay		=16

.equ	gyro_calibrate_lowpass_roll	=17
.equ	gyro_calibrate_lowpass_pitch	=18
.equ	gyro_calibrate_lowpass_yaw	=19

.equ	lowpassfilter_in		=20
.equ	lowpassfilter_out		=21

.equ	lowpassfilter_time_constant 	=22

.equ	gyro_in_lowpass_roll		=23
.equ	gyro_in_lowpass_pitch		=24
.equ	gyro_in_lowpass_yaw		=25

.equ	gain_in_roll			=26
.equ	gain_in_pitch			=27
.equ	gain_in_yaw			=28


.equ	b16_regadd=0x0100	;base address for the math library



.def	t=r16

.def	op1=r17
.def	op2=r18

.def	a=r19

.def	counterl=r20
.def	counterh=r21

.def	gyro_calibrated=r22
	


.macro led0_on			;macros for the LED's
	sbi portb,6
.endmacro
.macro led0_off
	cbi portb,6
.endmacro
.macro led1_on
	sbi portb,7
.endmacro
.macro led1_off
	cbi portb,7
.endmacro
.macro led2_on
	sbi portd,5
.endmacro
.macro led2_off
	cbi portd,5
.endmacro
.macro led3_on
	sbi portd,6
.endmacro
.macro led3_off
	cbi portd,6
.endmacro

#define rx_channel1 pind,0	;receiver channel pin assignments
#define rx_channel2 pind,1
#define rx_channel3 pind,2
#define rx_channel4 pind,3
#define rx_channel5 pind,4

#define motor_out_pin_1 portb,2	;motor output pin assignments
#define motor_out_pin_2 portb,1
#define motor_out_pin_3 portb,0
#define motor_out_pin_4 portd,7


.include "math_macros.asm"

.org 0

	ldi t,low(ramend)	;initalize stack pointer
	out spl,t
	ldi t,high(ramend)
	out sph,t

	
;--- setup IO ---

	;       76543210
	ldi t,0b11111111
	out ddrb,t

	;       76543210
	ldi t,0b11000000
	out ddrc,t
	
	;       76543210
	ldi t,0b11100000
	out ddrd,t


;---- Initalize variables ---

	clr gyro_calibrated		;gyro_calibrated = false	


	b16ldi temp, 0		

	b16mov gyro_zero_set_delay, temp

	b16mov gyro_calibrate_lowpass_roll, temp
	b16mov gyro_calibrate_lowpass_pitch, temp
	b16mov gyro_calibrate_lowpass_yaw, temp

	b16mov gyro_in_lowpass_roll, temp
	b16mov gyro_in_lowpass_pitch, temp
	b16mov gyro_in_lowpass_yaw, temp


;----

	led0_off

;lala: 	rcall read_adc_inputs
;	b16load gain_in_yaw
;	rcall output
;	ldi zl,100
;	rcall waitms
;	rcall lala


;---- ESC Throttle range calibration. This outputs collective input to all motor outputs ---
;---- This mode is entered by turning yaw gain pot to zero and turning on the flight controller. ---

	rcall read_adc_inputs
	rcall read_adc_inputs		
	
	b16ldi temp, 10
	b16cmp gain_in_yaw,temp
	brge ma1			;enter ESC throttle range calibration?

	ldi counterl,10			;yes, flash led 10 times
ca2:	led0_on
	ldi zl,0
	rcall waitms
	led0_off
	ldi zl,0
	rcall waitms
	dec counterl
	brne ca2

ca3:	rcall read_rx				;output collective to all ESC's
	b16mov motor_out_1,rxin_collective
	b16mov motor_out_2,rxin_collective
	b16mov motor_out_3,rxin_collective
	b16mov motor_out_4,rxin_collective
	rcall output_motor_ppm
	rjmp ca3 				;do until the cows come home.


;--- Main ---

ma1:	led3_off	
	
	rcall read_rx
	
	rcall read_adc_inputs


	;--- Calibrate gyro after 2s of collective below 1% ---
	;--- and then countinally as long as collective stays below 1%  ---

	b16ldi lowpassfilter_time_constant, 0.1		;long time constant

	b16mov lowpassfilter_in, gyro_in_roll		;lowpass filter on output from gyro (to be used for calibration, not stabilization)
	b16mov lowpassfilter_out, gyro_calibrate_lowpass_roll
	rcall lowpass
	b16mov gyro_calibrate_lowpass_roll, lowpassfilter_out

	b16mov lowpassfilter_in, gyro_in_pitch		;lowpass filter on output from gyro (to be used for calibration, not stabilization)
	b16mov lowpassfilter_out, gyro_calibrate_lowpass_pitch
	rcall lowpass
	b16mov gyro_calibrate_lowpass_pitch, lowpassfilter_out

	b16mov lowpassfilter_in, gyro_in_yaw		;lowpass filter on output from gyro (to be used for calibration, not stabilization)
	b16mov lowpassfilter_out, gyro_calibrate_lowpass_yaw
	rcall lowpass
	b16mov gyro_calibrate_lowpass_yaw, lowpassfilter_out


	b16ldi temp, 1
	b16cmp rxin_collective,temp
	brlt ma12					;collective below 1% ?
	rjmp ma3

ma12:	b16ldi temp, 1					;yes
	b16add gyro_zero_set_delay,temp
	b16ldi temp, 125
	b16cmp gyro_zero_set_delay,temp
	brlt ma4					;delay reached 125 tics? (2s)

	b16mov gyrozero_roll, gyro_calibrate_lowpass_roll 	;yes, set gyro zero value
	b16mov gyrozero_pitch, gyro_calibrate_lowpass_pitch
	b16mov gyrozero_yaw, gyro_calibrate_lowpass_yaw

	ser gyro_calibrated				;gyro_calibrated = true	

	led0_on						;turn on "ready for flight" led

	b16ldi gyro_zero_set_delay, 125			;preset delay for continually updating
	rjmp ma4

ma3:	b16ldi gyro_zero_set_delay, 0			;no, reset gyro zero delay
			
ma4:							;no




	;--- Start mixing by setting collective to motor input 1,2,3 and 4 ---

	b16mov motor_out_1,rxin_collective
	b16mov motor_out_2,rxin_collective
	b16mov motor_out_3,rxin_collective
	b16mov motor_out_4,rxin_collective



	;--- lowpass filter the gyro output ---

	b16ldi lowpassfilter_time_constant, 0.9		;short time constant

	b16mov lowpassfilter_in, gyro_in_roll	
	b16mov lowpassfilter_out, gyro_in_lowpass_roll
	rcall lowpass
	b16mov gyro_in_lowpass_roll, lowpassfilter_out

	b16mov lowpassfilter_in, gyro_in_pitch	
	b16mov lowpassfilter_out, gyro_in_lowpass_pitch
	rcall lowpass
	b16mov gyro_in_lowpass_pitch, lowpassfilter_out

	b16mov lowpassfilter_in, gyro_in_yaw	
	b16mov lowpassfilter_out, gyro_in_lowpass_yaw
	rcall lowpass
	b16mov gyro_in_lowpass_yaw, lowpassfilter_out



	;--- Calculate roll gyro output ---

	b16mov gyro_in_roll, gyro_in_lowpass_roll

	b16sub gyro_in_roll, gyrozero_roll		;remove offset from gyro output


	b16ldi temp, -0.001				;roll gyro gain scaling, make negative to reverse gyro direction.
	b16mul temp, gain_in_roll
	b16mul gyro_in_roll, temp				
	
	b16ldi temp, 0.2				;scale stick output
	b16mul rxin_roll, temp	

	b16add rxin_roll, gyro_in_roll			;add gyro output to stick output


	
	;--- Add roll gyro output to motor 2 and 3 ---

	b16add motor_out_2, rxin_roll
	b16sub motor_out_3, rxin_roll



	;--- Calculate pitch gyro output ---

	b16mov gyro_in_pitch, gyro_in_lowpass_pitch

	b16sub gyro_in_pitch, gyrozero_pitch		;remove offset from gyro output

	b16ldi temp, -0.001				;pitch gyro gain scaling, make negative to reverse gyro direction.
	b16mul temp, gain_in_pitch
	b16mul gyro_in_pitch, temp				
	
	b16ldi temp, 0.2				;scale stick output
	b16mul rxin_pitch, temp	

	b16add rxin_pitch, gyro_in_pitch		;add gyro output to stick output
	

	
	;--- Add pitch gyro output to motor 1 and 4 ---

	b16add motor_out_1, rxin_pitch
	b16sub motor_out_4, rxin_pitch



	;--- Calculate yaw gyro output ---

	b16mov gyro_in_yaw, gyro_in_lowpass_yaw

	b16sub gyro_in_yaw, gyrozero_yaw		;remove offset from gyro output

	b16ldi temp, -0.001				;yaw gyro gain scaling, make negative to reverse gyro direction.
	b16mul temp, gain_in_yaw
	b16mul gyro_in_yaw, temp				
	
	b16ldi temp, 0.5				;scale stick output
	b16mul rxin_yaw, temp	

	b16add rxin_yaw, gyro_in_yaw			;add gyro output to stick output

	

	;--- Add yaw gyro output to motor 1,2,3 and 4 ---

	b16sub motor_out_1, rxin_yaw
	b16add motor_out_2, rxin_yaw
	b16add motor_out_3, rxin_yaw
	b16sub motor_out_4, rxin_yaw



	;--- Output to motor ESC's ---

	b16ldi temp, 1				;turn off motors if collective below 1%
	b16cmp rxin_collective, temp
	brlt ma13

	tst gyro_calibrated			;turn off motors if gyros not calibrated
	brne ma6

ma13:	b16ldi temp, 0				;not calibrated, set motor 1-4 to zero
	b16mov motor_out_1,temp
	b16mov motor_out_2,temp
	b16mov motor_out_3,temp
	b16mov motor_out_4,temp

ma6:	rcall output_motor_ppm			;output ESC signal

	rjmp ma1




;--- Subroutines ---

output:			;Debug: Output xh:xl:yh:yl serial stream to led3
	led3_on

	rcall aou7

	led3_off

	rcall aou7
	
	ldi t,32
aou4:	lsl yl
	rol yh
	rol xl
	rol xh

	brcs aou1
	led3_off
	rjmp aou2

aou1:	led3_on
	nop

aou2:	rcall aou7
	
	dec t
	brne aou4
	
	led3_on
	rcall aou7

	led3_off
	
	ret

aou7: 	ldi a,10
aou5:	dec a
	brne aou5
	ret


;--- Lowpassfilter ---
lowpass:
	b16sub lowpassfilter_in, lowpassfilter_out
	b16mul lowpassfilter_in, lowpassfilter_time_constant
	b16add lowpassfilter_out, lowpassfilter_in

	ret


;--- Output motor ppm channels 1-4 in parallell ---
; Input is 0 to 100

output_motor_ppm:

	b16ldi temp, 0			;limit to zero
	b16cmp motor_out_1,temp
	brge ou1
	b16mov motor_out_1,temp
ou1:
	b16cmp motor_out_2,temp
	brge ou2
	b16mov motor_out_2,temp
ou2:
	b16cmp motor_out_3,temp
	brge ou3
	b16mov motor_out_3,temp
ou3:
	b16cmp motor_out_4,temp
	brge ou4
	b16mov motor_out_4,temp
ou4:

	b16ldi temp, 100		;limit to 100
	b16cmp motor_out_1,temp
	brlt ou5
	b16mov motor_out_1,temp
ou5:
	b16cmp motor_out_2,temp
	brlt ou6
	b16mov motor_out_2,temp
ou6:
	b16cmp motor_out_3,temp
	brlt ou7
	b16mov motor_out_3,temp
ou7:
	b16cmp motor_out_4,temp
	brlt ou8
	b16mov motor_out_4,temp
ou8:

	
	b16ldi temp, 100		;add 1ms to all channels
	b16add motor_out_1,temp
	b16add motor_out_2,temp
	b16add motor_out_3,temp
	b16add motor_out_4,temp


	b16ldi temp, 4			;scale from 0-200 to 0-800 (multiply by 4)
	b16mul motor_out_1,temp
	b16mul motor_out_2,temp
	b16mul motor_out_3,temp
	b16mul motor_out_4,temp


	b16load motor_out_4		;transfer to 16bit counters
	push xl
	push xh
	b16load motor_out_3		
	push xl
	push xh
	b16load motor_out_2		
	push xl
	push xh
	b16load motor_out_1		
	movw r25:r24,xh:xl

	pop r27
	pop r26

	pop r29
	pop r28

	pop r31
	pop r30

	sbi motor_out_pin_1		;turn on pins
	sbi motor_out_pin_2
	sbi motor_out_pin_3
	sbi motor_out_pin_4

	clr t

	ldi counterl,low(801)
	ldi counterh,high(801)


ou13:	subi r24,1			;20 cycles (1ms = 400 counts)
	sbc r25,t
	brcc ou9
	cbi motor_out_pin_1
ou9:	
	subi r26,1
	sbc r27,t
	brcc ou10
	cbi motor_out_pin_2
ou10:
	subi r28,1
	sbc r29,t
	brcc ou11
	cbi motor_out_pin_3
ou11:	
	subi r30,1
	sbc r31,t
	brcc ou12
	cbi motor_out_pin_4
ou12:	
	subi counterl,1
	sbc counterh,t
	brcc ou13

	ret	




;--- Read RX channels 1-5 ---

read_rx:

	clr xl
	clr xh
	clr yl
	clr yh

rx1:	sbis rx_channel1		;wait until high
	rjmp rx1

	led3_on

rx2:	adiw xh:xl,1			;measure lenght   (5 cycles resolution)
	sbic rx_channel1		;1ms = 1600 counts
	rjmp rx2

	b16store rxin_roll		;store in rxin_roll


	clr xl
	clr xh
	clr yl
	clr yh

rx9:	sbis rx_channel2		;wait until high
	rjmp rx9

rx3:	adiw xh:xl,1			;measure lenght
	sbic rx_channel2
	rjmp rx3

	b16store rxin_pitch		;store in rxin_pitch


	clr xl
	clr xh
	clr yl
	clr yh

rx10:	sbis rx_channel3		;wait until high
	rjmp rx10

rx4:	adiw xh:xl,1			;measure lenght
	sbic rx_channel3
	rjmp rx4

	b16store rxin_collective	;store in rxin_collective


	clr xl
	clr xh
	clr yl
	clr yh

rx11:	sbis rx_channel4		;wait until high
	rjmp rx11

rx5:	adiw xh:xl,1			;measure lenght
	sbic rx_channel4
	rjmp rx5

	b16store rxin_yaw		;store in rxin_yaw


	clr xl
	clr xh
	clr yl
	clr yh

rx12:	sbis rx_channel5		;wait until high
	rjmp rx12

rx6:	adiw xh:xl,1			;measure lenght
	sbic rx_channel5
	rjmp rx6

	b16store rxin_aux		;store in rxin_aux



	b16ldi temp, 2400		;subtract 1.5ms from roll channel
	b16sub rxin_roll,temp


	b16sub rxin_pitch,temp		;subtract 1.5ms from pitch channel


	b16sub rxin_yaw,temp		;subtract 1.5ms from yaw channel


	b16ldi temp, 1600		;subtract 1ms from aux channel
	b16sub rxin_aux,temp
	brcc rx8			;negative?
	b16ldi rxin_aux, 0		;yes, set to zero
rx8:

	b16sub rxin_collective,temp	;subtract 1ms from collective channel
	brcc rx7			;negative?
	b16ldi rxin_collective, 0	;yes, set to zero
rx7:

	b16ldi temp, 8			;scale roll,pitch and yaw to the -100 to 100 range
	b16div rxin_roll,temp
	b16div rxin_pitch,temp
	b16div rxin_yaw,temp

	b16ldi temp, 16			;scale collective and aux to the 0 to 100 range
	b16div rxin_collective,temp
	b16div rxin_aux,temp

	ret
	


;--- Read ADC's ---

read_adc_inputs:
	;       76543210
	ldi t,0b00000111
	sts didr0,t

	;       76543210
	ldi t,0b00000000
	sts adcsrb,t



	;       76543210	;read roll
	ldi t,0b00000010
	rcall read_adc
	b16store gyro_in_roll

	;       76543210	;read pitch
	ldi t,0b00000001
	rcall read_adc
	b16store gyro_in_pitch

	;       76543210	;read yaw
	ldi t,0b00000000
	rcall read_adc
	b16store gyro_in_yaw



	;       76543210	;read roll gain
	ldi t,0b00000011
	rcall read_adc
	b16store gain_in_roll

	;       76543210	;read pitch gain
	ldi t,0b00000100
	rcall read_adc
	b16store gain_in_pitch

	;       76543210	;read yaw gain
	ldi t,0b00000101
	rcall read_adc
	b16store gain_in_yaw


	
	ret







read_adc:			;x = adc    y = 0

	sts admux,t		;set ADC channel
	;       76543210
	ldi t,0b11000110	;start ADC
	sts adcsra,t

re1:	lds t,adcsra		;wait for ADC to complete
	sbrc t,6
	rjmp re1

	lds xl,adcl		;read ADC
	lds xh,adch

	clr yl
	clr yh

	ret






waitms:			;wait zl * 0.1ms
	ldi t,199
wa1:	nop
	dec t
	brne wa1
	dec zl
	brne waitms
	ret



.include "math_macros_code.asm"

.include "1616binmathlib.asm"

