/* askhandle.c - gets NFS file handles
 *
 * version 1.1 4-5-1995
 * (c) Bastiaan Bakker           Bastiaan.Bakker@twi.TUDelft.NL
 *
 */

#include <stdio.h>
#include <rpc/rpc.h>
#include <netdb.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <string.h>
#include "mount.h"
#include "nfs_prot.h"

extern char *nfs_error();

struct timeval TIMEOUT = {30, 0};
char *program;

void usage()
{
   fprintf(stderr, "Usage: %s [-p port] [-t timeout] host dir\n", program);
   exit(1);
}
 
void main(int argc, char *argv[])
{
   char *host, *dir;
   CLIENT *client;
   struct hostent *hostent;
   struct sockaddr_in address;
   char localhost[MAX_MACHINE_NAME + 1];
#ifdef sun4
   int gidlist[1];
#else
   gid_t gidlist[1];
#endif
   fhstatus res;
   int i, opt, port = 0;
   extern int optind;
   extern char *optarg;
   int socktype = RPC_ANYSOCK;

   program = argv[0];
   while ((opt = getopt(argc, argv, "p:t:")) != EOF)
   {
      switch(opt) {
      case 'p':
         port = atoi(optarg);
         break;
      case 't':
         TIMEOUT.tv_sec = atoi(optarg);
         break;
      default:
         usage();
      }
   }   
   if (argc < optind + 2) 
      usage();

   host = argv[optind];
   dir = argv[optind + 1];

   memset(&address, 0 ,sizeof(address));
   if (isdigit(*host))
   {
      if ((long int)(address.sin_addr.s_addr = inet_addr(host)) == -1)
      {
         fprintf(stderr, "%s: %s: invalid address\n", program, host);
         exit(1);
      }
   }
   else 
   {
      if (!(hostent = (struct hostent *)gethostbyname(host)))
      {
         fprintf(stderr, "%s: %s: unknown host\n", program, host);
         exit(1);
      }
      memcpy((char *)&address.sin_addr.s_addr, hostent->h_addr,   
         hostent->h_length);
   }
   address.sin_family = AF_INET;
   address.sin_port = port;

   if (!(client = clntudp_create(&address, MOUNTPROG, MOUNTVERS, 
      TIMEOUT, &socktype)))
   {
      clnt_pcreateerror(host);
      exit(1);
   }
   
   memset(localhost, 0, MAX_MACHINE_NAME + 1);
   gethostname(localhost, MAX_MACHINE_NAME);
   gidlist[0] = 0;
   if (!(client->cl_auth = authunix_create(localhost, 0, 0, 1, &(gidlist[0]))))
   {
      clnt_destroy(client);
      exit(1);
   }

   memset((char *)&res, 0, sizeof(res));
   if (clnt_call(client, MOUNTPROC_MNT, xdr_dirpath, &dir, xdr_fhstatus,
      &res, TIMEOUT) != RPC_SUCCESS) {
      fprintf(stderr, "%s: mount failed\n", program);
      clnt_destroy(client);
      exit(1);
   }
   if (res.fhs_status != 0) {
      fprintf(stderr, "%s: mount failed: %s\n", program, 
         nfs_error(res.fhs_status));
      clnt_destroy(client);
      exit(1);
   }

   printf("%s %s", host, dir);

   for(i=0; i < FHSIZE; i++) {
      printf(" %02x", (unsigned char)res.fhstatus_u.fhs_fhandle[i]);
   }
   printf("\n");
  
   if (clnt_call(client, MOUNTPROC_UMNT, xdr_dirpath, &dir, xdr_void,
       NULL, TIMEOUT) != RPC_SUCCESS)
       fprintf(stderr,"%s: unmount failed\n", program);
   clnt_destroy(client);
   exit(0);
}

