#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <strings.h>

#include <sys/socket.h>
#include <sys/ioctl.h>
#include <signal.h>

#include <netinet/in.h>
#include <linux/if.h>
#include <linux/if_ether.h>
#include <linux/ip.h>
#include <linux/udp.h>

#include <rpc/rpc.h>

void pr_frame (unsigned char buf[], int length);

main (int argc, char *argv[])
{
  int sd, op;
  struct ifreq ifr, oldifr;
  char *device = "lo";
  unsigned char buf[1600];
  int length;


  /* OPEN SOCKET */

   if (argc > 1)
      device = argv[1];

  if ((sd = socket (AF_INET, SOCK_PACKET, htons (ETH_P_IP))) < 0)
    {
      perror ("Can't get socket: ");
      exit (1);
    }

  /* SET PROMISC */

  strcpy (oldifr.ifr_name, device);
  if (ioctl (sd, SIOCGIFFLAGS, &oldifr) < 0)
    {
      close (sd);
      perror ("Can't get flags: ");
      exit (2);
    }

  ifr = oldifr;
  ifr.ifr_flags |= IFF_PROMISC;

  if (ioctl (sd, SIOCSIFFLAGS, &ifr) < 0)
    {
      close (sd);
      perror ("Can't set flags: ");
      exit (3);
    }

  /* END OF INITIALISATiON */

  while (1 )
    {
      length = recv (sd, buf, 1600, 0);
      if (length == -1)
	continue;
      pr_frame (buf, length);
    }


    /* TERMINATE    */

  if (ioctl (sd, SIOCSIFFLAGS, &oldifr) < 0)
    {
      close (sd);
      perror ("Can't set flags: ");
      exit (4);
    }

  close (sd);
  printf("Exit..\n");
  exit (0);
}

void pr_frame(u_char *buf, int buflen)
{
   int i;
   u_short ihl;
   u_char *udphdr, *rpcmsg, *callbody;
   u_char *data;

      /* Discard non IP packets */
   if ((buf[12] != 0x08) || (buf[13] != 0x00))
      return;
 
      /* Discard non UDP packets */
   if (buf[23] != 0x11)
      return;

   ihl = (buf[14] & 0x0f) * 4;
   udphdr = buf + 14 + ihl;

       /* Discard non NFS packets */
  if ((udphdr[2] != 0x08) || (udphdr[3] != 0x01))
      return;

   rpcmsg = udphdr + sizeof(struct udphdr);
   callbody = rpcmsg + 8;

      /* Discard non READDIR calls */
   if ((callbody[12] != 0) || (callbody[13] != 0) || 
       (callbody[14] != 0) || (callbody[15] != 0x10))
      return;

   data = (u_char *)callbody + 0x40; 

      /* Discard requests that have cookie != 0 */
   if ((data[32] != 0) || (data[33] != 0) || 
       (data[34] != 0) || (data[35] != 0))
      return;

   printf("%d.%d.%d.%d -> %d.%d.%d.%d : ", buf[26], buf[27], buf[28], buf[29],
      buf[30], buf[31], buf[32], buf[33]);
  
   for(i=0; i < 0x20; i++) {
      printf("%02x ", data[i]);
      /* if ((i % 16) == 15) printf("\n"); */
   }
   printf("\n");
} 
 
