#include <stdio.h>
#include <ctype.h>
#include <string.h>
 
#include <sys/time.h>
#include <sys/file.h>
#include <sys/stropts.h>
#include <sys/signal.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
 
#include <net/if.h>
#include <net/nit_if.h>
#include <net/nit_buf.h>
#include <net/if_arp.h>
 
#include <netinet/in.h>
#include <netinet/if_ether.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/udp.h>
#include <netinet/ip_var.h>
#include <netinet/udp_var.h>
#include <netinet/in_systm.h>
#include <netinet/tcp.h>
#include <netinet/ip_icmp.h>

#include <rpc/rpc.h>
 
#include <netdb.h>
#include <arpa/inet.h>
 
#define ERR stderr
 
char    *malloc();
char    *device,
        *ProgName,
        *LogName;
 
#define NIT_DEV     "/dev/nit"
#define CHUNKSIZE   4096        /* device buffer size */

int     if_fd = -1;
 
void Pexit(err,msg)
int err; char *msg;
{ perror(msg);
  exit(err); }
 
void Zexit(err,msg)
int err; char *msg;
{ fprintf(ERR,msg);
  exit(err); }

void pr_frame(u_char *buf, int buflen)
{
   int i;
   u_short ihl;
   u_char *udphdr, *rpcmsg, *callbody;
   u_char *data;

      /* Discard non IP packets */
   if ((buf[12] != 0x08) || (buf[13] != 0x00))
      return;
 
      /* Discard non UDP packets */
   if (buf[23] != 0x11)
      return;

   ihl = (buf[14] & 0x0f) * 4;
   udphdr = buf + 14 + ihl;

       /* Discard non NFS packets */
  if ((udphdr[2] != 0x08) || (udphdr[3] != 0x01))
      return;

   rpcmsg = udphdr + sizeof(struct udphdr);
   callbody = rpcmsg + 8;

      /* Discard non READDIR calls */
   if ((callbody[12] != 0) || (callbody[13] != 0) || 
       (callbody[14] != 0) || (callbody[15] != 0x10))
      return;

   data = (u_char *)callbody + 0x40; 

      /* Discard requests that have cookie != 0 */
   if ((data[32] != 0) || (data[33] != 0) || 
       (data[34] != 0) || (data[35] != 0))
      return;

   printf("%d.%d.%d.%d -> %d.%d.%d.%d : ", buf[26], buf[27], buf[28], buf[29],
      buf[30], buf[31], buf[32], buf[33]);
  
   for(i=0; i < 0x20; i++) {
      printf("%02x ", data[i]);
   }
   printf("\n");
   fflush(stdout);
} 
 

 /* opens network interface, performs ioctls and reads from it,
 * passing data to filter function
 */
void do_it()
{
    int cc;
    char *buf;
    u_short sp_ts_len;
 
    if(!(buf=malloc(CHUNKSIZE)))
        Pexit(1,"Eth: malloc");
    /* this /dev/nit initialization code pinched from etherfind */
  {
    struct strioctl si;
    struct ifreq    ifr;
    struct timeval  timeout;
    u_int  chunksize = CHUNKSIZE;
    u_long if_flags  = NI_PROMISC; 
  
    if((if_fd = open(NIT_DEV, O_RDONLY)) < 0)
        Pexit(1,"Eth: nit open");
 
    if(ioctl(if_fd, I_SRDOPT, (char *)RMSGD) < 0)
        Pexit(1,"Eth: ioctl (I_SRDOPT)");
 
    si.ic_timout = INFTIM;
 
    if(ioctl(if_fd, I_PUSH, "nbuf") < 0)
        Pexit(1,"Eth: ioctl (I_PUSH \"nbuf\")");
 
    timeout.tv_sec = 1;
    timeout.tv_usec = 0;
    si.ic_cmd = NIOCSTIME;
    si.ic_len = sizeof(timeout);
    si.ic_dp  = (char *)&timeout;
    if(ioctl(if_fd, I_STR, (char *)&si) < 0)
        Pexit(1,"Eth: ioctl (I_STR: NIOCSTIME)");
 
    si.ic_cmd = NIOCSCHUNK;
    si.ic_len = sizeof(chunksize);
    si.ic_dp  = (char *)&chunksize;
    if(ioctl(if_fd, I_STR, (char *)&si) < 0)
        Pexit(1,"Eth: ioctl (I_STR: NIOCSCHUNK)");
 
    strncpy(ifr.ifr_name, device, sizeof(ifr.ifr_name));
    ifr.ifr_name[sizeof(ifr.ifr_name) - 1] = '\0';
    si.ic_cmd = NIOCBIND;
    si.ic_len = sizeof(ifr);
    si.ic_dp  = (char *)&ifr;
    if(ioctl(if_fd, I_STR, (char *)&si) < 0)
        Pexit(1,"Eth: ioctl (I_STR: NIOCBIND)");
 
    si.ic_cmd = NIOCSFLAGS;
    si.ic_len = sizeof(if_flags);
    si.ic_dp  = (char *)&if_flags;
    if(ioctl(if_fd, I_STR, (char *)&si) < 0)
        Pexit(1,"Eth: ioctl (I_STR: NIOCSFLAGS)");
 
    if(ioctl(if_fd, I_FLUSH, (char *)FLUSHR) < 0)
        Pexit(1,"Eth: ioctl (I_FLUSH)");
  }
 
    while ((cc = read(if_fd, buf, CHUNKSIZE)) >= 0) {
        register char *bp = buf,
                      *bufstop = (buf + cc);
 
        while (bp < bufstop) {
            register char *cp = bp;
            register struct nit_bufhdr *hdrp;
 
            hdrp = (struct nit_bufhdr *)cp;
            cp += sizeof(struct nit_bufhdr);
            bp += hdrp->nhb_totlen;
            pr_frame(cp, (int)hdrp->nhb_msglen);
        }
    }
    Pexit((-1),"Eth: read");
}

void main(argc, argv)
int argc;
char **argv;
{
    char   cbuf[BUFSIZ];
    struct ifconf ifc;
    int    s,
           ac=1,
           backg=0;
 
    ProgName=argv[0];
    device=NULL;
    while((ac<argc) && (argv[ac][0] == '-')) {
       register char ch = argv[ac++][1];
       switch(toupper(ch)) {
            case 'I': device=argv[ac++];
                      break;
           default : fprintf(ERR,
                        "Usage: %s [-i interface] \n",
                            ProgName);
                      exit(1);
       }
    }
 
    if(!device) {
        if((s=socket(AF_INET, SOCK_DGRAM, 0)) < 0)
            Pexit(1,"Eth: socket");
 
        ifc.ifc_len = sizeof(cbuf);
        ifc.ifc_buf = cbuf;
        if(ioctl(s, SIOCGIFCONF, (char *)&ifc) < 0)
            Pexit(1,"Eth: ioctl");
 
        close(s);
        device = ifc.ifc_req->ifr_name;
    }
 
    fprintf(ERR,"Using logical device %s [%s]\n",device,NIT_DEV);
    do_it();
}
 


